/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestOutputStream
extends OutputStream {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$RequestOutputStream != null ? class$org$apache$commons$httpclient$RequestOutputStream : (class$org$apache$commons$httpclient$RequestOutputStream = RequestOutputStream.class$("org.apache.commons.httpclient.RequestOutputStream"))));
    private boolean closed = false;
    private OutputStream stream = null;
    private boolean useChunking = false;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] ENDCHUNK = CRLF;
    private static final byte[] ZERO = new byte[]{48};
    private static final byte[] ONE = new byte[]{49};
    static /* synthetic */ Class class$org$apache$commons$httpclient$RequestOutputStream;

    public RequestOutputStream(OutputStream stream) {
        this(stream, false);
    }

    public RequestOutputStream(OutputStream stream, boolean useChunking) {
        if (stream == null) {
            throw new NullPointerException("stream parameter is null");
        }
        this.stream = stream;
        this.useChunking = useChunking;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws IOException {
        LOG.trace((Object)"enter RequestOutputStream.close()");
        if (!this.closed) {
            try {
                try {
                    if (this.useChunking) {
                        this.stream.write(ZERO, 0, ZERO.length);
                        this.stream.write(CRLF, 0, CRLF.length);
                        this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
                    }
                }
                catch (IOException ioe) {
                    LOG.debug((Object)"Unexpected exception caught when closing output  stream", (Throwable)ioe);
                    throw ioe;
                }
                Object var2_2 = null;
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.closed = true;
                super.close();
                throw throwable;
            }
            super.close();
        }
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public void print(String s) throws IOException {
        LOG.trace((Object)"enter RequestOutputStream.print(String)");
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.write(s.charAt(i));
            ++i;
        }
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void setUseChunking(boolean useChunking) {
        this.useChunking = useChunking;
    }

    public void write(int b) throws IOException {
        if (this.useChunking) {
            this.stream.write(ONE, 0, ONE.length);
            this.stream.write(CRLF, 0, CRLF.length);
            this.stream.write(b);
            this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
        } else {
            this.stream.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        LOG.trace((Object)"enter RequestOutputStream.write(byte[], int, int)");
        if (this.useChunking) {
            byte[] chunkHeader = HttpConstants.getBytes(String.valueOf(Integer.toHexString(len)) + "\r\n");
            this.stream.write(chunkHeader, 0, chunkHeader.length);
            this.stream.write(b, off, len);
            this.stream.write(ENDCHUNK, 0, ENDCHUNK.length);
        } else {
            this.stream.write(b, off, len);
        }
    }
}

