/*
 * Decompiled with CFR 0.152.
 */
package de.his.net;

import de.his.tools.SystemUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public class TCPConnectionTester {
    private static Logger logger = Logger.getLogger(TCPConnectionTester.class);
    private Socket socket = null;
    protected InputStream is = null;
    protected String error = null;

    public TCPConnectionTester(String host, int port, int timeout) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            this.socket = new Socket();
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
            this.socket.connect(socketAddress, timeout);
            this.is = this.socket.getInputStream();
        }
        catch (IOException e) {
            this.error = "Verbindungsaufbau fehlgeschlagen: " + e.toString();
        }
    }

    public void waitForData(int size, int timeout) {
        if (this.is == null) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            while (start + (long)timeout > System.currentTimeMillis()) {
                int available = this.is.available();
                if (available > size) {
                    return;
                }
                if (available < 0) {
                    this.error = "Verbindung geschlossen, bevor der Server geantwortet hat.";
                    return;
                }
                SystemUtil.sleep(100);
            }
            this.error = "Timeout beim Warten auf Daten vom Server.";
        }
        catch (IOException e) {
            this.error = "Lesen von Serverdaten fehlgeschlagen: " + e.toString();
        }
    }

    public String getError() {
        return this.error;
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            logger.debug((Object)e, (Throwable)e);
        }
    }
}

