/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesetFilter
implements HasMetricsFilter {
    private final Set<File> files = new HashSet<File>();
    private final Map<String, Set<String>> fileNamesToPaths = new HashMap<String, Set<String>>();

    public FilesetFilter(Project p, List<FileSet> fileSets) {
        for (FileSet fileset : fileSets) {
            File baseDir = fileset.getDir(p);
            Logger.getInstance().verbose("Scanning files to filter in " + baseDir + " ; exists = " + baseDir.exists() + " ; is directory = " + baseDir.isDirectory());
            String[] includedFiles = fileset.getDirectoryScanner(p).getIncludedFiles();
            for (int j = 0; j < includedFiles.length; ++j) {
                File file = new File(baseDir, includedFiles[j]);
                Logger.getInstance().verbose("Adding to fileset filter: " + file.getPath());
                Set<String> paths = this.fileNamesToPaths.get(file.getName());
                if (paths == null) {
                    paths = new HashSet<String>();
                    this.fileNamesToPaths.put(file.getName(), paths);
                }
                paths.add(file.getAbsolutePath());
                this.files.add(file);
            }
        }
    }

    @Override
    public boolean accept(HasMetrics hm) {
        if (hm instanceof FullFileInfo) {
            FullFileInfo fileInfo = (FullFileInfo)hm;
            if (this.exactMatch(fileInfo) || this.fuzzyMatch(fileInfo)) {
                Logger.getInstance().verbose("Including file " + fileInfo.getPhysicalFile().getPath());
                return true;
            }
            Logger.getInstance().verbose("Excluding file " + fileInfo.getPhysicalFile().getPath());
            return false;
        }
        return true;
    }

    private boolean exactMatch(FullFileInfo fileInfo) {
        boolean matches = this.files.contains(fileInfo.getPhysicalFile());
        Logger.getInstance().debug("Exact filter matching on " + fileInfo.getPhysicalFile().getPath() + ": " + matches);
        return matches;
    }

    private boolean fuzzyMatch(FullFileInfo fileInfo) {
        Logger.getInstance().debug("Fuzzy: trying to matching " + fileInfo.getPhysicalFile().getPath() + " with fuzzy matching");
        Set<String> paths = this.fileNamesToPaths.get(fileInfo.getName());
        if (paths != null) {
            Logger.getInstance().debug("Fuzzy: paths for " + fileInfo.getName() + ": " + paths);
            String packagePath = fileInfo.getPackagePath();
            for (String path : paths) {
                String normalizedPath = FileUtils.getNormalizedPath(path);
                if (normalizedPath.endsWith(packagePath)) {
                    Logger.getInstance().debug("Fuzzy: normalized path " + normalizedPath + " ends with packagePath " + packagePath);
                    return true;
                }
                Logger.getInstance().debug("Fuzzy: normalized path " + normalizedPath + " does not end with packagePath " + packagePath);
            }
            Logger.getInstance().debug("Fuzzy: no matching paths");
        } else {
            Logger.getInstance().debug("Fuzzy: no paths to match on for " + fileInfo.getName());
        }
        return false;
    }
}

