/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import clover.it.unimi.dsi.fastutil.longs.Long2ReferenceSortedMap;
import clover.it.unimi.dsi.fastutil.longs.LongComparator;
import clover.it.unimi.dsi.fastutil.longs.LongSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Long2ReferenceSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Long2ReferenceSortedMaps() {
    }

    public static Long2ReferenceSortedMap singleton(long key, Object value) {
        return new Singleton(key, value);
    }

    public static Long2ReferenceSortedMap singleton(long key, Object value, LongComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Long2ReferenceSortedMap singleton(Object key, Object value) {
        return new Singleton((Long)key, value);
    }

    public static Long2ReferenceSortedMap singleton(Object key, Object value, LongComparator comparator) {
        return new Singleton((Long)key, value, comparator);
    }

    public static Long2ReferenceSortedMap synchronize(Long2ReferenceSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Long2ReferenceSortedMap synchronize(Long2ReferenceSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Long2ReferenceSortedMap unmodifiable(Long2ReferenceSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Long2ReferenceMaps.UnmodifiableMap
    implements Long2ReferenceSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Long2ReferenceSortedMap sortedMap;

        protected UnmodifiableSortedMap(Long2ReferenceSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Long2ReferenceSortedMap subMap(long from, long to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Long2ReferenceSortedMap headMap(long to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Long2ReferenceSortedMap tailMap(long from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public long firstLongKey() {
            return this.sortedMap.firstLongKey();
        }

        public long lastLongKey() {
            return this.sortedMap.lastLongKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Long2ReferenceSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Long2ReferenceSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Long2ReferenceSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Long2ReferenceMaps.SynchronizedMap
    implements Long2ReferenceSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Long2ReferenceSortedMap sortedMap;

        protected SynchronizedSortedMap(Long2ReferenceSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Long2ReferenceSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Long2ReferenceSortedMap subMap(long from, long to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Long2ReferenceSortedMap headMap(long to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Long2ReferenceSortedMap tailMap(long from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long firstLongKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstLongKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long lastLongKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastLongKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Long2ReferenceSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Long2ReferenceSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Long2ReferenceSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Long2ReferenceMaps.Singleton
    implements Long2ReferenceSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final LongComparator comparator;

        protected Singleton(long key, Object value, LongComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(long key, Object value) {
            this(key, value, null);
        }

        final int compare(long k1, long k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = LongSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Long2ReferenceSortedMap subMap(long from, long to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Long2ReferenceSortedMap headMap(long to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Long2ReferenceSortedMap tailMap(long from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public long firstLongKey() {
            return this.key;
        }

        public long lastLongKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Long)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Long)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Long)ofrom, (Long)oto);
        }

        public Object firstKey() {
            return new Long(this.firstLongKey());
        }

        public Object lastKey() {
            return new Long(this.lastLongKey());
        }
    }

    public static class EmptySortedMap
    extends Long2ReferenceMaps.EmptyMap
    implements Long2ReferenceSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Long2ReferenceSortedMap subMap(long from, long to) {
            return EMPTY_MAP;
        }

        public Long2ReferenceSortedMap headMap(long to) {
            return EMPTY_MAP;
        }

        public Long2ReferenceSortedMap tailMap(long from) {
            return EMPTY_MAP;
        }

        public long firstLongKey() {
            throw new NoSuchElementException();
        }

        public long lastLongKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Long)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Long)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Long)ofrom, (Long)oto);
        }

        public Object firstKey() {
            return new Long(this.firstLongKey());
        }

        public Object lastKey() {
            return new Long(this.lastLongKey());
        }
    }
}

