/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.his.utils.string.parser.RightsParser;
import de.memtext.db.DBAccess;
import de.memtext.db.NichtAngemeldetException;
import de.superx.servlet.SxPools;
import de.superx.servlet.TokenChecker;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.apache.tools.ant.util.StringUtils;

class UserAndRightsStreamliner {
    private static final String RECHTEPARAMNAME = "edustore.topic_area";
    private String mandantenID = "default";
    private String rights = "";
    private static final String ADMIN = "CS_BIA_STANDARDREPORTS_ADMIN";
    private boolean isLogWanted = false;

    UserAndRightsStreamliner(String mandantenID) {
        this.mandantenID = mandantenID;
    }

    private boolean hasAdminRights() {
        boolean result = false;
        RightsParser p = new RightsParser(this.rights);
        Map rightsmap = p.parse();
        Map parameters = (Map)rightsmap.get("RIGHT_CS_BIA_STANDARDREPORTS_ADMIN");
        if (rightsmap != null && rightsmap.containsKey("RIGHT_CS_BIA_STANDARDREPORTS_ADMIN") && parameters == null) {
            result = true;
        }
        return result;
    }

    void streamline(Connection con, TokenChecker tc) throws SQLException, NichtAngemeldetException {
        if (con == null) {
            con = SxPools.get(this.mandantenID).getConnection();
        }
        this.rights = tc.getRights();
        if (this.rights == null) {
            this.rights = "";
        }
        int userid = this.streamlineUserId(tc, con);
        if (this.hasAdminRights()) {
            this.setAdminRights(userid, con);
        } else {
            this.removePossibleAdminRight(userid, con);
            this.streamlineInstitution(userid, tc.getInst(), con);
            this.streamlineSachgebiete(userid, this.rights, con);
        }
    }

    private void streamlineInstitution(int userid, String orgunitStr, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        String del = "delete from  user_institution  where userid=" + userid + " and external_entry=1";
        stmt.executeUpdate(del);
        stmt.close();
        String inst = "";
        DBAccess.addConnection("superx", con);
        DBAccess.get("superx").setThrowRuntimeExceptionsActive(true);
        inst = DBAccess.get("superx").getString("select apnr from cifx where key=110 and sourcesystem_id='" + orgunitStr + "'");
        if (inst != null && !inst.trim().equals("")) {
            int vorhanden = DBAccess.get("superx").getInt("select count(*) from user_institution where ch110_institut='" + inst + "' and userid=" + userid);
            if (inst.equals("1")) {
                inst = "0";
            }
            if (vorhanden == 0) {
                PreparedStatement pst = con.prepareStatement("INSERT INTO user_institution \n(userid, name, ch110_institut, hierarchie, gueltig_seit, gueltig_bis, lehre, externalid,external_entry) \nVALUES \n(?, '--', ?, 0, '1900-01-01', '3000-01-01', 0, ?,1)");
                pst.setInt(1, userid);
                pst.setString(2, inst);
                pst.setString(3, orgunitStr);
                pst.execute();
                pst.close();
            }
            this.log(Level.FINE, "Instrecht eintragen: " + orgunitStr);
        }
    }

    private void streamlineSachgebiete(int userid, String rights, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("delete from  user_sachgeb_bez  where userinfo_id=" + userid + " and external_entry=1");
        stmt.close();
        RightsParser p = new RightsParser(rights);
        Map rightsmap = p.parse();
        for (String right : rightsmap.keySet()) {
            HashMap rechteparams = (HashMap)rightsmap.get(right);
            right = StringUtils.replace((String)right, (String)"RIGHT_", (String)"");
            this.log(Level.FINE, "Recht gefunden: " + right);
            if (rechteparams == null) {
                this.setRightForAllSachgebiete(userid, con, right);
                continue;
            }
            this.setRightForSomeSachgebiete(userid, con, right, rechteparams);
        }
    }

    private void setRightForSomeSachgebiete(int userid, Connection con, String right, HashMap rechteparams) throws SQLException {
        String topic_area = (String)rechteparams.get(RECHTEPARAMNAME);
        if (topic_area == null) {
            throw new IllegalArgumentException("Ungueltige RechteParamter edustore.topic_area bei Recht " + right + " nicht refunden");
        }
        topic_area = StringUtils.replace((String)topic_area, (String)"edustore.topic_area=", (String)"").toLowerCase();
        StringTokenizer st = new StringTokenizer(topic_area, ",");
        PreparedStatement pst = con.prepareStatement("insert into user_sachgeb_bez (userinfo_id,sachgebiete_id,external_entry)  select " + userid + ",tid,1 from sachgebiete where rightname=? and tid not in (select sachgebiete_id from user_sachgeb_bez where userinfo_id=" + userid + ")");
        while (st.hasMoreTokens()) {
            String sachgebiet = st.nextToken().toUpperCase();
            this.log(Level.FINE, "Recht eintragen: " + right + " Sachgebiet " + sachgebiet);
            pst.setString(1, String.valueOf(right) + "[" + sachgebiet + "]");
            pst.execute();
        }
        pst.close();
    }

    private void setRightForAllSachgebiete(int userid, Connection con, String right) throws SQLException {
        this.log(Level.FINE, "Recht eintragen: " + right + " fuer alle Sachgebiete");
        PreparedStatement pst = con.prepareStatement("insert into user_sachgeb_bez (userinfo_id,sachgebiete_id,external_entry)  select " + userid + ",tid,1 from sachgebiete where rightname " + (right.equals(ADMIN) ? "" : "not") + " like '%" + ADMIN + "%' and " + "tid not in (select sachgebiete_id from user_sachgeb_bez where userinfo_id=" + userid + ")");
        pst.execute();
        pst.close();
    }

    private void log(Level l2, String what) {
        if (this.isLogWanted) {
            System.out.println(what);
        }
    }

    private void removePossibleAdminRight(int userid, Connection con) throws SQLException {
        PreparedStatement pst = con.prepareStatement("update userinfo set administration=0 where tid=?");
        pst.setInt(1, userid);
        pst.executeUpdate();
        pst.close();
        pst = con.prepareStatement("delete from user_group_bez where external_entry=1 and userinfo_id=? and  groupinfo_id=(select tid from groupinfo where name='Administratoren')");
        pst.setInt(1, userid);
        pst.executeUpdate();
        pst.close();
    }

    private void setAdminRights(int userid, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        String del = "delete from  user_institution  where userid=" + userid + " and external_entry=1";
        stmt.executeUpdate(del);
        stmt.close();
        PreparedStatement pst = con.prepareStatement("update userinfo set administration=1 where tid=?");
        pst.setInt(1, userid);
        pst.executeUpdate();
        if (pst.getUpdateCount() != 1) {
            throw new SQLException("Fehler beim Setzen von Adminrechten f\u00fcr  Benutzer " + userid + " in Superx.userinfo (updatecount!=1)");
        }
        int adminGroupId = this.streamlineGroupId("Administratoren", con);
        this.checkUserGroupBez(userid, adminGroupId, con);
        pst = con.prepareStatement("select count(*) from user_institution where userid=? and ch110_institut='0'");
        pst.setInt(1, userid);
        int count = 0;
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            count = rs.getInt(1);
        }
        if (count == 0) {
            pst = con.prepareStatement("insert into user_institution (userid,name,ch110_institut,hierarchie,gueltig_seit,gueltig_bis,lehre,external_entry) values (?,'Alle','0',0,date_val('1.1.1900'),date_val('1.1.3000'),0,1) ");
            pst.setInt(1, userid);
            int resultcount = pst.executeUpdate();
            if (resultcount != 1) {
                throw new SQLException("Einf\u00fcgen von Kostenstellenrechten f\u00fcr admin fehlgeschlagen");
            }
        }
        Statement stmt2 = con.createStatement();
        stmt2.executeUpdate("delete from  user_sachgeb_bez  where userinfo_id=" + userid + " and external_entry=1");
        stmt2.executeUpdate("insert into user_sachgeb_bez (userinfo_id,sachgebiete_id,external_entry)  select " + userid + ",tid,1 from sachgebiete where tid not in (select sachgebiete_id from user_sachgeb_bez where userinfo_id=" + userid + ")");
        stmt2.close();
    }

    private void checkUserGroupBez(int userid, int groupid, Connection con) throws SQLException {
        PreparedStatement pst = con.prepareStatement("delete from user_group_bez where external_entry=1 and userinfo_id=?");
        pst.setInt(1, userid);
        pst.executeUpdate();
        pst.close();
        pst = con.prepareStatement("select count(*) from user_group_bez where userinfo_id=? and groupinfo_id=?");
        pst.setInt(1, userid);
        pst.setInt(2, groupid);
        ResultSet rs = pst.executeQuery();
        int count = 0;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        if (count == 0) {
            UserAndRightsStreamliner.insertUserGroupBez(con, userid, groupid);
        }
        pst.close();
    }

    private int streamlineUserId(TokenChecker tc, Connection con) throws SQLException, NichtAngemeldetException {
        PreparedStatement pst = con.prepareStatement("select count(*) from userinfo where benutzer=?");
        pst.setString(1, tc.getKennung());
        ResultSet rs = pst.executeQuery();
        int count = 0;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        if (count > 1) {
            throw new SQLException("Mehr als ein Eintrag f\u00fcr benutzer " + tc.getKennung() + " in SuperX.userinfo gefunden");
        }
        if (count == 0) {
            UserAndRightsStreamliner.insertUser(con, tc.getKennung());
        }
        pst = con.prepareStatement("select tid from userinfo where benutzer=?");
        pst.setString(1, tc.getKennung());
        rs = pst.executeQuery();
        int usertid = -999;
        while (rs.next()) {
            usertid = rs.getInt(1);
        }
        rs.close();
        pst.close();
        if (usertid == -999) {
            throw new SQLException("Kein Eintrag in userinfo gefunden f\u00fcr " + tc.getKennung());
        }
        pst = con.prepareStatement("update userinfo set extern_person_id=?,extern_account_id=? where tid=" + usertid);
        pst.setString(1, tc.getExternPersonID());
        pst.setString(2, tc.getExternAccountID());
        pst.execute();
        pst.close();
        return usertid;
    }

    private int streamlineGroupId(String group, Connection con) throws SQLException {
        PreparedStatement pst = con.prepareStatement("select count(*) from groupinfo where name=?");
        pst.setString(1, group);
        ResultSet rs = pst.executeQuery();
        int count = 0;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        if (count > 1) {
            throw new SQLException("Mehr als ein Eintrag f\u00fcr Gruppe " + group + " in SuperX.groupinfo gefunden");
        }
        if (count == 0) {
            UserAndRightsStreamliner.insertGroup(con, group);
        }
        pst = con.prepareStatement("select tid from groupinfo where name=?");
        pst.setString(1, group);
        rs = pst.executeQuery();
        int groupid = -999;
        while (rs.next()) {
            groupid = rs.getInt(1);
        }
        rs.close();
        pst.close();
        if (groupid == -999) {
            throw new SQLException("Kein Eintrag in groupinfo gefunden f\u00fcr " + group);
        }
        return groupid;
    }

    private static synchronized void insertUser(Connection con, String user) throws SQLException {
        PreparedStatement pst = con.prepareStatement("select max(tid) from userinfo");
        ResultSet rs = pst.executeQuery();
        rs.next();
        int tid = rs.getInt(1) + 1;
        pst = con.prepareStatement("insert into userinfo (tid,benutzer,max_versuch,akt_versuch,administration,archiv_recht,passwd_sha,info)values (?,?,999,0,0,0,'extern verwaltet','extern')");
        pst.setInt(1, tid);
        pst.setString(2, user);
        pst.execute();
        if (pst.getUpdateCount() != 1) {
            throw new SQLException("Einf\u00fcgen von Benutzer " + user + " in Superx.userinfo fehlgeschlagen");
        }
        pst.close();
    }

    private static synchronized void insertGroup(Connection con, String group) throws SQLException {
        PreparedStatement pst = con.prepareStatement("select max(tid) from groupinfo");
        ResultSet rs = pst.executeQuery();
        rs.next();
        int tid = rs.getInt(1) + 1;
        rs.close();
        pst = con.prepareStatement("insert into groupinfo (tid,name) values (?,?)");
        pst.setInt(1, tid);
        pst.setString(2, group);
        pst.execute();
        if (pst.getUpdateCount() != 1) {
            throw new SQLException("Einf\u00fcgen von Gruppe " + group + " in Superx.groupinfo fehlgeschlagen");
        }
        pst.close();
    }

    private static synchronized void insertUserGroupBez(Connection con, int userid, int groupid) throws SQLException {
        PreparedStatement pst = con.prepareStatement("insert into user_group_bez (userinfo_id,groupinfo_id,external_entry) values (?,?,1)");
        pst.setInt(1, userid);
        pst.setInt(2, groupid);
        pst.execute();
        if (pst.getUpdateCount() != 1) {
            throw new SQLException("Einf\u00fcgen von user_group_bez " + userid + " - " + groupid + " " + " in Superx. fehlgeschlagen");
        }
        pst.close();
    }

    public static void main(String[] a2) {
        Connection con = null;
        try {
            Class.forName("org.postgresql.Driver");
            con = DriverManager.getConnection("jdbc:postgresql://localhost:5433/eduetl_dummy", "superx", "password");
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Couldn't find driver class:");
            cnfe.printStackTrace();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        String user = null;
        String token = "1.0/1310722422/superx/studadmin/studadminrole/9/RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS,RIGHT_CS_BIA_STANDARDREPORTS_ADMIN[edustore.topic_area=stu]/6fcf981a308d475b16b1290754dd8f3e";
        try {
            TokenChecker.checkingActive = false;
            TokenChecker tc = new TokenChecker(token);
            UserAndRightsStreamliner str = new UserAndRightsStreamliner("default");
            str.streamline(con, tc);
            user = tc.getKennung();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }
}

