/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.superx.common.DBServletException;
import de.superx.common.SuperX_el;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SuperXmlAbmeldung
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle rb;
    private String alternativeRedirectUrl;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        rb = ResourceBundle.getBundle("LocalStrings");
        this.alternativeRedirectUrl = config.getInitParameter("alt_redirect_url");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(true);
        String mandantenID = "default";
        if (session.getAttribute("MandantenID") != null) {
            mandantenID = (String)session.getAttribute("MandantenID");
        }
        if (SxPools.get(mandantenID).isErweitertesProtokollWanted()) {
            this.protokollieren(request, mandantenID);
        }
        SuperXServletHelper.removeCookie(request, response);
        session.invalidate();
        System.gc();
        if (this.alternativeRedirectUrl != null && !this.alternativeRedirectUrl.equals("")) {
            response.sendRedirect(this.alternativeRedirectUrl);
        } else {
            String redirect = "";
            if (!mandantenID.equals("default")) {
                redirect = String.valueOf(mandantenID) + "/";
            }
            response.sendRedirect("/superx/" + redirect);
        }
    }

    private void protokollieren(HttpServletRequest request, String mandantenID) {
        String userid = "-1";
        HttpSession session = request.getSession(true);
        if (session.getAttribute("UserID") != null) {
            userid = session.getAttribute("UserID").toString();
        }
        SuperX_el aSuperX_el = new SuperX_el();
        SxSQL_Server aQuery = null;
        String client_ip = request.getRemoteAddr();
        String client_dns = request.getRemoteHost();
        Connection dbConnection = null;
        try {
            aQuery = new SxSQL_Server(mandantenID);
            dbConnection = SxPools.getConnection(mandantenID);
            String sql = "insert into protokoll (proto_fkt_id, userinfo_id, ";
            sql = String.valueOf(sql) + "ip_adresse, client_name, zeitpunkt) values (";
            sql = String.valueOf(sql) + "4, " + userid + ", '" + client_ip;
            sql = String.valueOf(sql) + "', '" + client_dns + "'";
            sql = SxPools.get(mandantenID).getSqlDialect().equals("Postgres") ? String.valueOf(sql) + ", now());" : String.valueOf(sql) + ", current);";
            aQuery.execute(sql, dbConnection, aSuperX_el);
            dbConnection.close();
        }
        catch (SQLException e2) {
            try {
                SxPools.invalidate(mandantenID, dbConnection);
            }
            catch (DBServletException e1) {
                Logger.getLogger("superx_" + mandantenID).log(Level.SEVERE, e1.toString());
                aSuperX_el.setError_String(e2.getSQLState());
            }
            Logger.getLogger("superx_" + mandantenID).log(Level.SEVERE, e2.getSQLState());
            aSuperX_el.setError_String(e2.getSQLState());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public String getServletInfo() {
        return "<i>SuperXmlAnmeldung-Servlet, v4</i>";
    }
}

