/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.User;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.CryptUtils;
import de.memtext.util.DateUtils;
import de.superx.common.DBServletException;
import de.superx.common.DatenblattFields;
import de.superx.common.DatenblattTables;
import de.superx.common.IsUserInAtLeastOneGroup;
import de.superx.common.IsUserInGroup;
import de.superx.common.IsUserInGroupWithName;
import de.superx.common.Sichten;
import de.superx.common.SxFinRechte;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.ThemenbaumI;
import de.superx.common.UserHasMaskRight;
import de.superx.common.UserHasSachgebRight;
import freemarker.template.TemplateBooleanModel;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SxUser
extends User
implements Serializable {
    private ThemenbaumI themenbaum;
    private static final Class[] NOCLASS = new Class[0];
    private static final Object[] NOOBJECTS = new Object[0];
    private Sichten sichten = new Sichten();
    private Collection erlaubteMaskenTids = new TreeSet();
    private Collection groups = new LinkedList();
    private Collection groupnames = new LinkedList();
    private Collection sachgebiete = new LinkedList();
    private String mandantenID = "default";
    private String[] oldShas = new String[7];
    private String currentSha;
    private SxFinRechte finRechte = new SxFinRechte();
    private Object fieldElementCache;
    private HashMap basicMap = new HashMap();
    private Collection hiddenFields = new LinkedList();
    private static final long serialVersionUID = 5L;

    private void init() {
        this.sichten.setUser(this);
        this.basicMap.put("SxFinRechte", this.finRechte);
        this.basicMap.put("Username", this.getName());
        this.basicMap.put("today", DateUtils.getTodayString());
        this.basicMap.put("yeartoday", DateUtils.getYear(new Date(new java.util.Date().getTime())));
        this.basicMap.put("databaseMajorVersion", new Integer(0));
        this.basicMap.put("databaseMinorVersion", new Integer(0));
        this.basicMap.put("DatenblattTables", new DatenblattTables());
        this.basicMap.put("DatenblattFields", new DatenblattFields());
    }

    public SxUser() {
        this.init();
    }

    public SxUser(String username, String passwd) {
        super(username, passwd);
        this.init();
    }

    public SxUser(String username, Integer userid) throws SQLException, DBServletException, TransformerException {
        super(username, userid);
        this.init();
    }

    @Override
    public void setAdmin(boolean isAdmin) {
        this.basicMap.put("UserIsAdmin", this.isAdmin() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
        super.setAdmin(isAdmin);
        this.finRechte.setHasAllRights(isAdmin);
    }

    public void initThemenbaum(Class themenbaumClass) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, TransformerConfigurationException, KeyParentEqualException, SQLException, DBServletException {
        this.themenbaum = (ThemenbaumI)themenbaumClass.getConstructor(NOCLASS).newInstance(NOOBJECTS);
        this.themenbaum.init((Integer)this.getId(), this.getName(), this.getMandantenID());
    }

    public HashMap getBasicMap() {
        return this.basicMap;
    }

    public SxUser(String username) {
        super(username);
    }

    public ThemenbaumI getThemenbaum() {
        return this.themenbaum;
    }

    public Sichten getSichten() {
        return this.sichten;
    }

    public void setUserid(Integer id) {
        super.setId(id);
    }

    public void clearCache() {
        this.sichten.clear();
    }

    public void initErlaubteMasken(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.erlaubteMaskenTids.add(row.get(0));
        }
        this.basicMap.put("UserMaskRights", this.getMaskRights());
        this.basicMap.put("UserHasMaskRight", new UserHasMaskRight(this));
    }

    public String getMaskRights() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.erlaubteMaskenTids.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public void checkAuthentificationForMask(String tidStr) {
        if (tidStr == null) {
            throw new IllegalStateException("Cannot open mask because tid parameter was null");
        }
        if (!this.isMaskAllowed(tidStr)) {
            throw new IllegalArgumentException("You have no permission to open mask " + tidStr);
        }
    }

    boolean isMaskAllowed(String tidStr) {
        boolean result = false;
        if (this.isAdmin()) {
            result = true;
        } else {
            try {
                result = this.erlaubteMaskenTids.contains(new Integer(tidStr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isPWUsedBefore(String check) {
        boolean result = false;
        String sha1 = CryptUtils.encodeSHA(check);
        String sha2 = CryptUtils.encodeSHA(String.valueOf(check) + CryptUtils.geheimnis1);
        int i2 = 0;
        while (i2 < 7) {
            if (this.oldShas[i2] != null && (sha1.equals(this.oldShas[i2]) || sha2.equals(this.oldShas[i2]))) {
                result = true;
            }
            ++i2;
        }
        return result;
    }

    public boolean isPWSHAUsedBefore(String sha) {
        boolean result = false;
        int i2 = 0;
        while (i2 < 7) {
            if (this.oldShas[i2] != null && sha.equals(this.oldShas[i2])) {
                result = true;
            }
            ++i2;
        }
        return result;
    }

    public void setOldSha(int pos, String oldsha) {
        this.oldShas[pos] = oldsha;
    }

    public String getMandantenID() {
        return this.mandantenID;
    }

    public void setMandantenID(String mandantenID) {
        this.mandantenID = mandantenID;
    }

    public void rememberOldSHA(String oldsha) {
        int i2 = 6;
        while (i2 > 0) {
            this.oldShas[i2] = this.oldShas[i2 - 1];
            --i2;
        }
        this.oldShas[0] = oldsha;
    }

    public String getUser_PW_Command(int gueltigkeit) {
        String gueltig = "'1.1.3000'";
        if (gueltigkeit > 0) {
            gueltig = "'" + DateUtils.formatGerman(DateUtils.makeFutureDate(new Date(new java.util.Date().getTime()), gueltigkeit)) + "'";
        }
        String result = "delete from user_pw where userinfo_id='" + this.getId() + "'; insert into user_pw (userinfo_id,pw_gueltig_bis,old_sha1,old_sha2,old_sha3,old_sha4,old_sha5,old_sha6,old_sha7) values ('" + this.getId() + "',date_val(" + gueltig + ")";
        int i2 = 0;
        while (i2 < 7) {
            result = this.oldShas[i2] == null ? String.valueOf(result) + ",null" : String.valueOf(result) + ",'" + this.oldShas[i2] + "'";
            ++i2;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public String getCurrentSha() {
        return this.currentSha;
    }

    public void setCurrentSha(String sha) {
        this.currentSha = sha;
    }

    public void initFinRechte(SxResultSet rs, int finRightVariant, SxResultSet rsProjToInst, boolean is0FINJoker) {
        this.finRechte.setVariant(finRightVariant);
        this.finRechte.set0FINJoker(is0FINJoker);
        if (this.isAdmin()) {
            this.finRechte.setHasAllRights(true);
        }
        for (SxResultRow row : rs) {
            this.finRechte.createAndAddEntry(row);
        }
        for (SxResultRow row : rsProjToInst) {
            this.finRechte.addProj((String)row.get(0));
        }
    }

    public Object getFieldElementCache() {
        return this.fieldElementCache;
    }

    public void setFieldElementCache(Object fieldElementCache) {
        this.fieldElementCache = fieldElementCache;
    }

    public void setGroups(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.groups.add(row.get(0).toString());
            this.groupnames.add(row.get(1));
        }
        this.basicMap.put("UserGroups", this.getGroups());
        this.basicMap.put("UserGroupnames", this.getGroupnames());
        this.basicMap.put("IsUserInGroup", new IsUserInGroup(this));
        this.basicMap.put("IsUserInGroupWithName", new IsUserInGroupWithName(this));
        this.basicMap.put("IsUserInAtLeastOneGroup", new IsUserInAtLeastOneGroup(this));
    }

    public String getGroups() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.groups.iterator();
        while (it.hasNext()) {
            result.append(it.next());
        }
        return result.toString();
    }

    public String getGroupnames() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.groupnames.iterator();
        while (it.hasNext()) {
            result.append(it.next());
        }
        return result.toString();
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public boolean isInGroupWithName(String group) {
        return this.groupnames.contains(group);
    }

    public void setDBVersion(int databaseMajorVersion, int databaseMinorVersion) {
        this.basicMap.put("databaseMajorVersion", new Integer(databaseMajorVersion));
        this.basicMap.put("databaseMinorVersion", new Integer(databaseMinorVersion));
    }

    public void setHiddenFields(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.hiddenFields.add(row.get(0));
        }
    }

    public boolean isFieldHidingWanted(Object id) {
        return this.hiddenFields.contains(id);
    }

    public void setSachgebiete(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.sachgebiete.add(row.get(0).toString());
            this.basicMap.put("UserHasSachgebRight", new UserHasSachgebRight(this.sachgebiete));
        }
    }
}

