/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import proguard.io.DataEntry;

public class ZipDataEntry
implements DataEntry {
    private final DataEntry parent;
    private final ZipEntry zipEntry;
    private ZipInputStream zipInputStream;

    public ZipDataEntry(DataEntry dataEntry, ZipEntry zipEntry, ZipInputStream zipInputStream) {
        this.parent = dataEntry;
        this.zipEntry = zipEntry;
        this.zipInputStream = zipInputStream;
    }

    public String getName() {
        String string = this.zipEntry.getName().replace(File.separatorChar, '/');
        int n = string.length();
        return n > 0 && string.charAt(n - 1) == '/' ? string.substring(0, n - 1) : string;
    }

    public boolean isDirectory() {
        return this.zipEntry.isDirectory();
    }

    public InputStream getInputStream() throws IOException {
        return this.zipInputStream;
    }

    public void closeInputStream() throws IOException {
        this.zipInputStream.closeEntry();
        this.zipInputStream = null;
    }

    public DataEntry getParent() {
        return this.parent;
    }

    public String toString() {
        return this.parent.toString() + ':' + this.getName();
    }
}

