/*
 * Decompiled with CFR 0.152.
 */
package de.superx.stat.pl;

import com.google.common.base.Joiner;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.MaterialDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzFilter;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import de.statspez.pleditor.generator.runtime.refdat.csv.CSVReferenzDateiVerwaltung;
import de.statspez.pleditor.generator.runtime.refdat.csv.EinfacherEFSatz;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperxReferenzDateiZugriff
extends CSVReferenzDateiVerwaltung {
    private static Logger logger = LoggerFactory.getLogger(SuperxReferenzDateiZugriff.class);

    public SuperxReferenzDateiZugriff(String dir) {
        super(dir);
        this.refdatFileExtension = ".csv";
    }

    public String getAktuelleVersion(String refDatName) {
        String version = super.getAktuelleVersion(refDatName);
        logger.debug("Get aktuelle Version: {} = {}", (Object)refDatName, (Object)version);
        return version;
    }

    public String[] getReferenzdateien() {
        Object[] refDateien = super.getReferenzdateien();
        logger.debug("Get Referenzdateien: {}", (Object)Joiner.on((char)',').join(refDateien));
        return refDateien;
    }

    public SatzInterface[] gibSaetzeGefiltert(FeldDeskriptorInterface[] felder, SatzFilter filter, MaterialDeskriptorInterface material) throws NoSuchFieldException {
        logger.debug("Gib S\u00e4tze gefiltert:");
        for (FeldDeskriptorInterface feld : felder) {
            logger.debug("Felddeskriptor: {}", (Object)feld.getFeldNameDSB());
        }
        logger.debug("Satzfilter: {}", (Object)filter.getFilterBedingungen().length);
        logger.debug("MaterialDeskriptor: {}", (Object)material.getMaterialDSBName());
        Vector<EinfacherEFSatz> referenzDatei = this.getReferenzDatei(material);
        Vector<EinfacherEFSatz> saetzeGefiltert = null;
        FeldDeskriptorInterface feld = felder[0];
        if (filter == null || filter.getFilterBedingungen() == null || filter.getFilterBedingungen().length == 0) {
            saetzeGefiltert = referenzDatei;
        } else {
            saetzeGefiltert = new Vector<EinfacherEFSatz>();
            for (int i = 0; i < referenzDatei.size(); ++i) {
                EinfacherEFSatz satz = (EinfacherEFSatz)referenzDatei.get(i);
                boolean aufnehmen = true;
                SatzFilter.FilterBedingung[] bedingungen = null;
                if (filter != null) {
                    bedingungen = filter.getFilterBedingungen();
                }
                if (bedingungen != null && bedingungen.length > 0) {
                    for (int j = 0; j < bedingungen.length && aufnehmen; ++j) {
                        if (feld instanceof FeldDeskriptorImpl) {
                            FeldDeskriptorImpl refdatFeldDeskriptor = (FeldDeskriptorImpl)feld;
                            Value refdatWert = refdatFeldDeskriptor.getValueFrom((SatzInterface)satz);
                            Value vergleichsWert = bedingungen[j].vergleichsWert;
                            int operator = bedingungen[j].operator;
                            switch (operator) {
                                case 1: {
                                    aufnehmen = refdatWert.eq(vergleichsWert);
                                    break;
                                }
                                case 3: {
                                    aufnehmen = refdatWert.gt(vergleichsWert);
                                    break;
                                }
                                case 6: {
                                    aufnehmen = refdatWert.ge(vergleichsWert);
                                    break;
                                }
                                case 2: {
                                    aufnehmen = refdatWert.lt(vergleichsWert);
                                    break;
                                }
                                case 5: {
                                    aufnehmen = refdatWert.le(vergleichsWert);
                                    break;
                                }
                                case 4: {
                                    aufnehmen = refdatWert.ne(vergleichsWert);
                                }
                            }
                            continue;
                        }
                        throw new NoSuchFieldException("Felddeskriptor f\u00fcr Referenzdateifeld \"" + feld.getFeldNameTB() + "\" nicht FeldDeskriptorImpl.");
                    }
                }
                if (!aufnehmen) continue;
                saetzeGefiltert.addElement(satz);
            }
        }
        return saetzeGefiltert.toArray(new EinfacherEFSatz[0]);
    }

    public boolean liefertDenZugriffAuf(MaterialDeskriptorInterface material) {
        boolean liefert = true;
        logger.debug("Liefert den Zugriff auf? {}", (Object)material.getMaterialDSBName());
        return liefert;
    }

    protected String getMaterialBezeichner(MaterialDeskriptorInterface material) {
        String retVal = material.getMaterialName().substring(0, material.getMaterialName().indexOf("_"));
        logger.debug("Dateiname: " + retVal);
        return retVal;
    }

    private Vector getReferenzDatei(MaterialDeskriptorInterface material) throws NoSuchFieldException {
        Vector<EinfacherEFSatz> referenzDatei = (Vector<EinfacherEFSatz>)this.referenzDateiHashMap.get(this.getMaterialBezeichner(material));
        if (referenzDatei == null) {
            referenzDatei = new Vector<EinfacherEFSatz>();
            try {
                BufferedReader in = new BufferedReader(new FileReader(new File(this.resourcePath + this.getMaterialBezeichner(material) + this.refdatFileExtension)));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String[] werte = line.split(this.csvSplitString);
                    if (werte == null || werte.length <= 0 || werte[0] == null || werte[0].length() <= 0) continue;
                    referenzDatei.addElement(new EinfacherEFSatz(werte));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchFieldException("Referenzdatei \"" + this.getMaterialBezeichner(material) + "\" konnte im Ressource-Pfad " + this.resourcePath + " nicht gelesen werden: " + e.getMessage());
            }
            this.referenzDateiHashMap.put(this.getMaterialBezeichner(material), referenzDatei);
        }
        return referenzDatei;
    }

    private HashSet getAlleFeldwerte(MaterialDeskriptorInterface material, FeldDeskriptorInterface feld) throws NoSuchFieldException {
        HashSet<String> referenzDateiFeldwerte;
        HashMap referenzDateiWerte = (HashMap)this.referenzDateiFeldwerteHashMap.get(this.getMaterialBezeichner(material));
        if (referenzDateiWerte == null) {
            referenzDateiWerte = new HashMap();
            this.referenzDateiFeldwerteHashMap.put(this.getMaterialBezeichner(material), referenzDateiWerte);
        }
        if ((referenzDateiFeldwerte = (HashSet<String>)referenzDateiWerte.get(feld.getFeldNameTB())) == null) {
            referenzDateiFeldwerte = new HashSet<String>();
            Vector referenzDatei = this.getReferenzDatei(material);
            if (referenzDatei != null) {
                for (int i = 0; i < referenzDatei.size(); ++i) {
                    EinfacherEFSatz satz = (EinfacherEFSatz)referenzDatei.get(i);
                    try {
                        String wert = satz.getString(feld);
                        if (wert == null || referenzDateiFeldwerte.contains(wert)) continue;
                        referenzDateiFeldwerte.add(wert);
                        continue;
                    }
                    catch (WertNichtTypgerechtException e) {
                        e.printStackTrace();
                    }
                }
            }
            referenzDateiWerte.put(feld.getFeldNameTB(), referenzDateiFeldwerte);
        }
        return referenzDateiFeldwerte;
    }

    public boolean wertKombinationGueltig(Value[] werte, FeldDeskriptorInterface[] felder, SatzFilter filter, MaterialDeskriptorInterface material) throws NoSuchFieldException {
        logger.debug("Wertkombination g\u00fcltig?:");
        for (Value value : werte) {
            logger.debug("Value: {}", (Object)value);
        }
        for (Value value : felder) {
            logger.debug("Felddeskriptor: {}", (Object)value.getFeldNameDSB());
        }
        logger.debug("Satzfilter: {}", (Object)filter.toString());
        logger.debug("MaterialDeskriptor: {}", (Object)material.getMaterialDSBName());
        boolean wertKombinationGueltig = false;
        if (this.pr\u00fcfeParameterWertKombinationGueltig(werte, felder, filter, material)) {
            if (werte.length == 1 && (filter == null || filter.getFilterBedingungen() == null || filter.getFilterBedingungen().length == 0)) {
                HashSet referenzDateiFeldwerte = this.getAlleFeldwerte(material, felder[0]);
                String wert = werte[0].asString();
                wertKombinationGueltig = referenzDateiFeldwerte != null && referenzDateiFeldwerte.contains(wert);
            } else {
                EinfacherEFSatz[] saetzeGefiltert = (EinfacherEFSatz[])this.gibSaetzeGefiltert(felder, filter, material);
                for (int i = 0; i < saetzeGefiltert.length; ++i) {
                    boolean bl = true;
                    EinfacherEFSatz satz = saetzeGefiltert[i];
                    for (int j = 0; j < felder.length; ++j) {
                        if (felder[j] instanceof FeldDeskriptorImpl) {
                            Value vergleichsWert;
                            FeldDeskriptorImpl refdatFeldDeskriptor = (FeldDeskriptorImpl)felder[j];
                            Value refdatWert = refdatFeldDeskriptor.getValueFrom((SatzInterface)satz);
                            if (!refdatWert.ne(vergleichsWert = werte[j])) continue;
                            bl = false;
                            break;
                        }
                        throw new NoSuchFieldException("Felddeskriptor f\u00fcr Feld \"" + felder[j].getFeldNameTB() + "\" nicht FeldDeskriptorImpl.");
                    }
                    if (!bl) continue;
                    wertKombinationGueltig = true;
                    break;
                }
            }
        }
        return wertKombinationGueltig;
    }
}

