/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.google.common.base.Joiner;
import de.his.tools.MDFiveHash;
import de.memtext.db.NichtAngemeldetException;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXmlAnmeldung;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TokenChecker {
    private List<String> toks = new ArrayList<String>(15);
    public static boolean checkingActive = true;
    Logger logger = Logger.getLogger(SuperXmlAnmeldung.class);

    public static void main(String[] a) {
        Object t;
        String token = "1.0/1319735296/superx/admin/bi_admin/1/RIGHT_CS_BIA_STANDARDREPORTS_ADMIN/1/3/45ae5984bf81f73f7d320d8fc4190689";
        SuperXManager.sharedSecret = "rdfS3Y4Cx5Pb9gVxTOoZUT2TvnaOEKRNu";
        while (token.indexOf("//") > -1) {
            token = token.replace("//", "/ /");
        }
        System.out.println(token);
        StringTokenizer st = new StringTokenizer(token, "/");
        int i = 0;
        while (st.hasMoreTokens()) {
            t = st.nextToken();
            System.out.println(++i + ":" + (String)t);
        }
        try {
            t = new TokenChecker(token);
        }
        catch (NichtAngemeldetException e) {
            e.printStackTrace();
        }
    }

    public TokenChecker(String token) throws NichtAngemeldetException {
        if (token == null) {
            this.logger.error((Object)"Kein Token gefunden");
            throw new NichtAngemeldetException("Kein Token gefunden");
        }
        if (!token.startsWith("1.0") && !token.startsWith("2.0")) {
            this.logger.error((Object)"Falsche Tokenversion");
            throw new NichtAngemeldetException("Falsche Tokenversion");
        }
        int len = token.length();
        StringBuffer part = new StringBuffer();
        boolean insideBrackets = false;
        for (int i = 0; i < len; ++i) {
            char lookingAt = token.charAt(i);
            if (lookingAt == '[') {
                insideBrackets = true;
                part.append(lookingAt);
                continue;
            }
            if (lookingAt == ']') {
                insideBrackets = false;
                part.append(lookingAt);
                continue;
            }
            if (lookingAt == '/' && !insideBrackets) {
                this.toks.add(part.toString());
                part = new StringBuffer();
                continue;
            }
            part.append(lookingAt);
        }
        this.toks.add(part.toString());
        if (this.toks.size() < 10) {
            this.logger.error((Object)"Fehlerhaftes Token  DETAILS:- moeglicherweise ein Wert leer , im Token //");
            throw new IllegalArgumentException("Fehlerhaftes Token  DETAILS:- moeglicherweise ein Wert leer , im Token //");
        }
        if (checkingActive) {
            this.testAll();
        } else {
            this.logger.info((Object)"TOKENTEST DEAKTIVIERT");
        }
    }

    public void testAll() throws NichtAngemeldetException {
        this.logger.debug((Object)"Running TokenChecker.testAll()");
        this.testTime();
        this.testApp();
        this.testHash();
    }

    void testTime() throws NichtAngemeldetException {
        long time = 0L;
        try {
            time = Long.parseLong(this.toks.get(1).toString()) * 1000L;
            this.logger.debug((Object)("Tokentimestamp: " + time));
        }
        catch (Exception e) {
            this.logger.error((Object)"Unpassender Tokentimestamp");
            throw new NichtAngemeldetException("Unpassender Tokentimestamp");
        }
        long aminago = new Date().getTime() - 60000L;
        long aminahead = new Date().getTime() + 60000L;
        if (time < aminago || time > aminahead) {
            this.logger.error((Object)"Tokentimestamp ung\u00fcltig: Zeit auf den tomcats/apache abgleichen!");
            throw new NichtAngemeldetException("Tokentimestamp ung\u00fcltig: Zeit auf den tomcats/apache abgleichen!");
        }
    }

    void testApp() throws NichtAngemeldetException {
        if (this.toks.size() < 3 || this.toks.get(2) == null || !this.toks.get(2).toString().equalsIgnoreCase("superx")) {
            this.logger.error((Object)"falsche Webapp im Token");
            throw new NichtAngemeldetException("falsche Webapp im Token");
        }
        this.logger.debug((Object)("Webapp im Token: " + this.toks.get(2).toString()));
    }

    String getKennung() throws NichtAngemeldetException {
        if (this.toks.size() < 4) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.toks.get(3).toString();
    }

    String getRole() throws NichtAngemeldetException {
        if (this.toks.size() < 5) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return "ROLE_" + this.toks.get(4).toString().trim().toUpperCase();
    }

    String getInst() throws NichtAngemeldetException {
        if (this.toks.size() < 6) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.toks.get(5).toString().trim();
    }

    String getRights() throws NichtAngemeldetException {
        if (this.toks.size() < 7) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.toks.get(6).toString().trim();
    }

    String getExternAccountID() throws NichtAngemeldetException {
        if (this.toks.size() < 8) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.toks.get(7).toString().trim();
    }

    String getExternPersonID() throws NichtAngemeldetException {
        if (this.toks.size() < 9) {
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        return this.toks.get(8).toString().trim();
    }

    private String getHash() throws NichtAngemeldetException {
        if (this.toks.size() < 10) {
            this.logger.error((Object)"Token < 10 Zeichen.");
            throw new NichtAngemeldetException("Fehlerhaftes Token");
        }
        this.logger.debug((Object)("Toks: " + this.toks.toString()));
        String hash = this.toks.get(this.toks.size() - 1).toString().trim();
        return hash;
    }

    void testHash() throws NichtAngemeldetException {
        if (SuperXManager.sharedSecret == null || SuperXManager.sharedSecret.trim().equals("")) {
            this.logger.error((Object)"Kein Shared secret hinterlegt");
            throw new NichtAngemeldetException("Kein Shared secret hinterlegt");
        }
        Joiner joiner = Joiner.on((char)'/');
        String tokprefix = joiner.join(this.toks.subList(0, this.toks.size() - 1));
        boolean isHashCorrect = this.checkHash(this.toks.get(0), this.getHash(), tokprefix, SuperXManager.sharedSecret);
        if (!isHashCorrect) {
            this.logger.error((Object)"Token ungueltig");
            throw new NichtAngemeldetException("Token ungueltig");
        }
    }

    boolean checkHash(String version, String hash, String toHash, String confSharedSecret) {
        String sharedSecret = confSharedSecret;
        if (sharedSecret == null || sharedSecret.trim().equals("")) {
            this.logger.error((Object)"shared-secret ist nicht definiert");
            return false;
        }
        String myHash = null;
        if (version.startsWith("1.0")) {
            myHash = MDFiveHash.hash((String)(toHash + "/" + sharedSecret));
        } else {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-512");
                md.update((toHash + "/" + sharedSecret).getBytes("UTF-8"));
                byte[] mb = md.digest();
                myHash = MDFiveHash.getHex((byte[])mb);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error((Object)e, (Throwable)e);
                return false;
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error((Object)e, (Throwable)e);
                return false;
            }
        }
        boolean retVal = myHash.equals(hash);
        if (!retVal) {
            this.logger.warn((Object)("Ungueltiges Auth-Token: Angegebener Hashwert und berechneter Hashwert stimmen nicht ueberein: " + hash + " (berechnet: " + myHash + ")"));
        }
        return retVal;
    }
}

