/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.NamedObjectI;
import de.memtext.baseobjects.coll.IdObjectCollection;
import de.memtext.baseobjects.coll.NamedIdObjectSet;
import de.memtext.baseobjects.coll.NamedObjectList;
import de.memtext.baseobjects.coll.NamedObjectSet;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.rights.NewPasswordChecker;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.DSAHandler;
import de.memtext.util.DateUtils;
import de.memtext.util.LogUtils;
import de.memtext.util.MemoryUtils;
import de.memtext.util.StringUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.common.GraphicFormat;
import de.superx.common.MacroFieldSelection;
import de.superx.common.Maske;
import de.superx.common.RepositoryItemCollection;
import de.superx.common.SichtException;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.common.TemplateProcessor;
import de.superx.common.TranslationContainer;
import de.superx.servlet.ExternalPool;
import de.superx.servlet.FieldElementCache;
import de.superx.servlet.ServletTemplateProcessor;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SichtartRechteDefinition;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXmlAnmeldung;
import de.superx.servlet.SxMail;
import de.superx.servlet.SxPools;
import de.superx.servlet.UserInitializer;
import de.superx.util.PathAndFileUtils;
import de.superx.util.PropsReader;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.pentaho.di.core.database.DatabaseMeta;

public class SxPool
extends GenericObjectPool
implements NamedObjectI {
    private String name;
    private int dummy = 0;
    private int finRightVariant = 0;
    private NamedObjectList sichtartRechteDefinitionen = new NamedObjectList();
    private boolean isErweitertesProtokollWanted = false;
    private static boolean isPwLogWanted = false;
    private int passwortG\u00fcltigkeit = 0;
    private Properties props = new Properties();
    private static boolean isDebugLogsWanted;
    private FieldElementCache fieldElementCache = new FieldElementCache();
    private IdObjectCollection graphicformats = new IdObjectCollection();
    private IdObjectCollection translations = new IdObjectCollection();
    private Collection makroFieldSelections = new LinkedList();
    public NamedIdObjectSet userpool = new NamedIdObjectSet();
    private NamedIdObjectSet maskenpool = new NamedIdObjectSet();
    private ServletTemplateProcessor templateProcessor;
    private HashMap repositoryMap = new HashMap();
    private String privateKeyEncoded = null;
    private String publicKeyEncoded = null;
    private boolean isRestrictedConnection = false;
    private DSAHandler dsaHandler;
    private NewPasswordChecker newPasswordChecker;
    private boolean is0FINJoker = true;
    private boolean hasKontierungsrechte = false;
    private String excelVorlage;
    private boolean hasCustomPdfFile = false;
    private NamedObjectSet externalPools = new NamedObjectSet();
    private boolean hasFinUserKamRestrictionFields = false;
    private DatabaseMeta kettleDatabaseMeta;
    private List<SxMail> sxmails = new LinkedList<SxMail>();

    public boolean hasFinUserKamRestrictionFields() {
        return this.hasFinUserKamRestrictionFields;
    }

    SxPool(String name) throws SQLException, IOException, DBServletException {
        String urlpart;
        this.setName(name);
        try {
            this.readPropertiesAndUrl();
            System.out.print(" (" + this.props.getProperty("connectionURL") + ") ..");
        }
        catch (Exception e) {
            System.out.println("Konnte properties / Passwort nicht lesen. " + e);
            e.printStackTrace();
            throw new DBServletException("Konnte properties / Passwort nicht lesen. " + e.getMessage());
        }
        this.templateProcessor = new ServletTemplateProcessor(name);
        try {
            Class.forName(this.props.getProperty("driverName"));
        }
        catch (ClassNotFoundException e1) {
            throw new DBServletException("Treiber " + this.props.getProperty("driverName") + " nicht gefunden. Ggfs. nach tomcat/common/lib kopieren.");
        }
        this.initLogging(true);
        this.setTestOnBorrow(true);
        String devMode = this.props.getProperty("developmentMode");
        SuperXManager.isDevelopmentMode = devMode == null || devMode.equals("true");
        this.setMinIdle(NumberUtils.toInt((String)this.props.getProperty("minIdle"), (int)5));
        this.setMaxIdle(NumberUtils.toInt((String)this.props.getProperty("maxIdle"), (int)-1));
        this.setMaxActive(NumberUtils.toInt((String)this.props.getProperty("maxActive"), (int)-1));
        this.setMaxWait(NumberUtils.toLong((String)this.props.getProperty("maxWait"), (long)-1L));
        this.setTimeBetweenEvictionRunsMillis(NumberUtils.toInt((String)this.props.getProperty("timeBetweenEvictionRunsMillis"), (int)-1));
        String url = this.props.getProperty("connectionURL");
        if (url.indexOf("postgres") > -1 && (urlpart = url.substring(18)).indexOf(58) == -1) {
            url = "jdbc:postgresql://" + StringUtils.replace(urlpart, "/", ":5432/");
        }
        Pattern pattern = Pattern.compile("(jdbc.*://)([^:^/]*)(:\\d*)?(.*)?");
        Matcher matcher = pattern.matcher(url);
        matcher.find();
        String protocol = matcher.group(1);
        String host = StringUtils.replace(matcher.group(2), "\\", "");
        String port = matcher.group(3).replaceAll(":", "");
        String lastpart = StringUtils.replace(matcher.group(4), "\\", "");
        lastpart = StringUtils.replace(lastpart, "/", "");
        lastpart = lastpart.replaceAll("\\?ApplicationName.*", "");
        String type = this.getDatabaseAbbr().equals("PG") ? "POSTGRESQL" : "INFORMIX";
        try {
            this.kettleDatabaseMeta = new DatabaseMeta("eduetl", type, "Native", host, lastpart, port, this.props.getProperty("connectionName"), this.props.getProperty("password"));
            if (lastpart.indexOf(":INFORMIXSERVER") > -1) {
                String ixServer = lastpart.substring(lastpart.indexOf(":INFORMIXSERVER") + 16);
                String dbname = lastpart.replaceAll(":INFORMIXSERVER=.*", "");
                this.kettleDatabaseMeta.setDBName(dbname);
                this.kettleDatabaseMeta.setServername(ixServer);
            }
        }
        catch (Exception e1) {
            System.err.println("Fehler bei Kettle DB Einrichtung: " + e1.toString());
            e1.printStackTrace();
        }
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.props.getProperty("connectionURL"), this.props);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)this, null, "select count(*) from xdummy;", false, true);
        this.setFactory((PoolableObjectFactory)poolableConnectionFactory);
        try {
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (ClassNotFoundException e2) {
            throw new DBServletException("ConnectionPool Klasse org.apache.commons.dbcp.PoolingDriver nicht gefunden.\ncommons-dbcp nach tomcat/common/lib stellen.");
        }
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(this.getName(), (ObjectPool)this);
        try {
            this.initFromDB();
        }
        catch (SQLException e) {
            String msg = "Fehler beim Aufbau des ConnectionPools ";
            if (!this.getName().equals("default")) {
                msg = msg + " f\u00fcr Mandant: " + this.getName();
            }
            msg = msg + "\nKonnte keine Connection aus dem Pool holen.DETAILS:\n" + e;
            e.printStackTrace();
            throw new SQLException(msg);
        }
        if (this.privateKeyEncoded != null) {
            this.initDSAHandler();
        }
    }

    public DatabaseMeta getKettleDatabaseMeta() {
        return this.kettleDatabaseMeta;
    }

    private void setKernMaskHtmlXsl(Statement st) throws SQLException {
        int count = 0;
        ResultSet rs = st.executeQuery("select count(*) from konstanten where beschreibung='KernMaskHtmlXsl' ");
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        if (count == 0) {
            rs = st.executeQuery("select max(tid) from konstanten");
            int newtid = 999;
            while (rs.next()) {
                newtid = rs.getInt(1);
            }
            rs.close();
            st.executeUpdate("insert into konstanten (tid,beschreibung,apnr) values (" + ++newtid + ", 'KernMaskHtmlXsl',0)");
        }
        int tablehtml = 1;
        if (!SuperXManager.defaultMaskXsl.equals("maske_html.xsl")) {
            tablehtml = 2;
        }
        st.executeUpdate("update konstanten set apnr=" + tablehtml + " where beschreibung='KernMaskHtmlXsl' ");
    }

    private void initHeaderFooterDB() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select id from sx_repository where art='HEADER_FOOTER'");
        HashMap<String, String> ids = new HashMap<String, String>();
        while (rs.next()) {
            String id = rs.getString(1);
            ids.put(id.trim(), "found");
        }
        rs.close();
        rs = stmt.executeQuery("select max(tid) from sx_repository ");
        int tid = 0;
        while (rs.next()) {
            tid = rs.getInt(1) + 1;
        }
        PreparedStatement pst = con.prepareStatement("insert into sx_repository(tid,id,caption,sachgebiete_id,art,aktiv,gueltig_seit,gueltig_bis)\tvalues (?,?,?,0,'HEADER_FOOTER',1,date_val('1.1.1900'),date_val('1.1.3000'))");
        if (!ids.containsKey("HTML_HEADER")) {
            pst.setInt(1, tid++);
            pst.setString(2, "HTML_HEADER");
            pst.setString(3, "HTML Kopfzeile");
            pst.execute();
        }
        if (!ids.containsKey("HTML_FOOTER")) {
            pst.setInt(1, tid++);
            pst.setString(2, "HTML_FOOTER");
            pst.setString(3, "HTML Fu\u00dfzeile");
            pst.execute();
        }
        if (!ids.containsKey("CUSTOM_PDF")) {
            pst.setInt(1, tid++);
            pst.setString(2, "CUSTOM_PDF");
            pst.setString(3, "individuelle PDF Anpassung");
            pst.execute();
        }
        if (this.getDatabaseAbbr().equals("PG")) {
            stmt.executeQuery("select sp_update_sequence('sx_repository')");
        }
        stmt.close();
        con.close();
    }

    private void initFromDB() throws SQLException {
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();){
            this.setKernMaskHtmlXsl(st);
            ResultSet rs = st.executeQuery("select content from sx_repository where id='privatekey'");
            while (rs.next()) {
                this.privateKeyEncoded = rs.getString(1);
            }
            rs = st.executeQuery("select content from sx_repository where id='publickey'");
            while (rs.next()) {
                this.publicKeyEncoded = rs.getString(1);
            }
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwortg\u00fcltigkeit (Tage)'");
            while (rs.next()) {
                this.passwortG\u00fcltigkeit = rs.getInt(1);
            }
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwort Gro\u00df- u. Kleinb.'");
            int gro\u00dfklein = 0;
            while (rs.next()) {
                gro\u00dfklein = rs.getInt(1);
            }
            int ziffern\u00f6tig = 0;
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwort erfordert Ziffer'");
            while (rs.next()) {
                ziffern\u00f6tig = rs.getInt(1);
            }
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwortl\u00e4nge (Minimum)'");
            int minL\u00e4nge = 0;
            while (rs.next()) {
                minL\u00e4nge = rs.getInt(1);
            }
            this.newPasswordChecker = new NewPasswordChecker(minL\u00e4nge, gro\u00dfklein, ziffern\u00f6tig);
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Erweitertes Protokoll'");
            int loginP = 0;
            while (rs.next()) {
                loginP = rs.getInt(1);
            }
            this.isErweitertesProtokollWanted = loginP == 1;
            String myWEBINFFilePath = SuperXManager.getWEB_INFPfad();
            if (myWEBINFFilePath == null || myWEBINFFilePath.equals(".")) {
                myWEBINFFilePath = PathAndFileUtils.getWebinfDirectory();
            }
            if (myWEBINFFilePath.equals(".")) {
                myWEBINFFilePath = System.getProperty("user.dir");
            }
            rs = st.executeQuery("select tid from sx_repository where id='WEBINFDIR'");
            int tid = 0;
            while (rs.next()) {
                tid = rs.getInt(1);
            }
            if (tid == 0) {
                st.executeUpdate("insert into sx_repository  (id,caption,aktiv,gueltig_seit,gueltig_bis) values ('WEBINFDIR','WEB-INF Directory',1,date_val('1.1.1900'),date_val('1.1.3000'))");
            }
            try (PreparedStatement pst = con.prepareStatement("update sx_repository set content=? where id='WEBINFDIR'");){
                pst.setString(1, myWEBINFFilePath);
                pst.execute();
            }
        }
    }

    public int getPasswortG\u00fcltigkeit() {
        return this.passwortG\u00fcltigkeit;
    }

    public boolean isErweitertesProtokollWanted() {
        return this.isErweitertesProtokollWanted;
    }

    public void initLogging(boolean append) throws IOException {
        String msg;
        LogUtils.initRawFile("superx_" + this.getName(), SxPool.getLogDir() + "/superx_" + this.name + ".log", 20000, 1, true, true);
        LogUtils.initRawFile("superx_" + this.getName() + "_xml", SxPool.getLogDir() + "/superx_" + this.name + "_xml.log", 20000, 1, true, true);
        Level lev = Level.SEVERE;
        try {
            if (this.props.getProperty("logLevelSQL") != null) {
                lev = Level.parse(this.props.getProperty("logLevelSQL"));
            }
        }
        catch (IllegalArgumentException e) {
            msg = "Ung\u00fcltiger Level f\u00fcr sqlLogger ";
            if (!this.getName().equals("default")) {
                msg = msg + "(Mandant :" + this.getName() + ") ";
            }
            msg = msg + " :" + this.props.getProperty("logLevelSQL");
            System.out.println(msg);
        }
        Logger.getLogger("superx_" + this.getName()).setLevel(lev);
        System.out.println("\nLoglevel SQL:" + lev);
        lev = Level.SEVERE;
        try {
            if (this.props.getProperty("logLevelXML") != null) {
                lev = Level.parse(this.props.getProperty("logLevelXML"));
            }
        }
        catch (IllegalArgumentException e) {
            msg = "Ung\u00fcltiger Level f\u00fcr XMLLogger ";
            if (!this.getName().equals("default")) {
                msg = msg + "(Mandant :" + this.getName() + ") ";
            }
            msg = msg + " :" + this.props.getProperty("logLevelXML");
            System.out.println(msg);
        }
        Logger.getLogger("superx_" + this.getName() + "_xml").setLevel(lev);
        System.out.println("\nLoglevel XML:" + lev);
    }

    private static boolean logsExists(String base) {
        return new File(base + File.separator + "logs").exists();
    }

    public static String getLogDir() {
        String base = System.getProperty("catalina.base");
        if (base == null || !SxPool.logsExists(base)) {
            base = System.getProperty("catalina.home");
        }
        if (base == null || !SxPool.logsExists(base)) {
            base = System.getProperty("tomcat.home");
        }
        if (base == null || !SxPool.logsExists(base)) {
            base = ".";
        }
        String targetDir = "";
        targetDir = PathAndFileUtils.getWebinfDirectory() + File.separator + "logs";
        File f = new File(targetDir);
        if (!f.exists()) {
            f.mkdir();
        }
        if (System.getProperty("SX_LOG_TO_TMP") != null && System.getProperty("SX_LOG_TO_TMP").equalsIgnoreCase("true")) {
            targetDir = System.getProperty("java.io.tmpdir");
        }
        return targetDir;
    }

    private void readPropertiesAndUrl() throws Exception {
        this.props = PropsReader.prepareProps(new File(this.getDbPropertyFilePath()));
        if (this.props.getProperty("restrictedConnectionName") != null && !this.props.getProperty("restrictedConnectionName").trim().equals("") && this.props.getProperty("restrictedConnectionPassword") != null && !this.props.getProperty("restrictedConnectionPassword").trim().equals("")) {
            this.props.put("user", this.props.getProperty("restrictedConnectionName"));
            this.props.put("password", PropsReader.check(this.props.getProperty("restrictedConnectionPassword")));
            this.isRestrictedConnection = true;
        } else {
            this.props.put("user", this.props.getProperty("connectionName"));
            this.props.put("password", PropsReader.check(this.props.getProperty("connectionPassword")));
        }
    }

    private String getDbPropertyFilePath() {
        String myWEBINFFilePath;
        String propname = "db_" + this.getName() + ".properties";
        if (this.getName().equals("default")) {
            propname = "db.properties";
        }
        if ((myWEBINFFilePath = SuperXManager.getWEB_INFPfad()) == null || myWEBINFFilePath.equals(".")) {
            myWEBINFFilePath = PathAndFileUtils.getWebinfDirectory();
        }
        return myWEBINFFilePath + File.separator + propname;
    }

    public String getSqlDialect() {
        String result = "Informix";
        if (this.props.getProperty("driverName").indexOf("postgres") > -1) {
            result = "Postgres";
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void close() throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.closePool(this.getName());
        this.closeLoggers();
        this.shutdownSxmailThreads();
    }

    private void shutdownSxmailThreads() {
        for (SxMail sxmail : this.sxmails) {
            sxmail.shutdownDaemons();
        }
    }

    private void closeLoggers() {
        int i;
        for (i = 0; i < Logger.getLogger("superx_" + this.name).getHandlers().length; ++i) {
            Logger.getLogger("superx_" + this.name).getHandlers()[i].close();
        }
        for (i = 0; i < Logger.getLogger("superx_" + this.name + "_xml").getHandlers().length; ++i) {
            Logger.getLogger("superx_" + this.name + "_xml").getHandlers()[i].close();
        }
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.getName());
    }

    public boolean hasMaske(Integer tid) {
        return this.maskenpool.containsItemWithId(tid);
    }

    public Maske getMaskenclone(Integer tid) throws CloneNotSupportedException {
        return (Maske)((Maske)this.maskenpool.getById(tid)).clone();
    }

    private void clearAll() {
        this.graphicformats.clear();
        this.translations.clear();
        this.makroFieldSelections.clear();
        for (SxUser sxUser : this.userpool) {
        }
        this.userpool.clear();
    }

    private void initTranslations() throws SQLException, DBServletException {
        this.translations = new IdObjectCollection();
        SxResultSet rs = ServletUtils.execute("Einlesen von \u00dcbersetzungen", "select id,locale,contents_short,contents_long from sx_captions where id is not null", this.getName());
        for (SxResultRow row : rs) {
            Object id = row.get(0);
            String loc = (String)row.get(1);
            String contentsShort = (String)row.get(2);
            String contentsLong = (String)row.get(3);
            if (!this.translations.containsItemWithId(id)) {
                this.translations.add(new TranslationContainer(this.getName(), id, loc, contentsShort, contentsLong));
                continue;
            }
            TranslationContainer tc = (TranslationContainer)this.translations.getById(id);
            tc.addLocalizedItem(loc, contentsShort, contentsLong);
        }
    }

    private void initRepository() throws SQLException, DBServletException {
        this.repositoryMap.clear();
        SxResultSet rs = ServletUtils.execute("Einlesen von Sx_repository Eintr\u00e4gen", "select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1", this.getName());
        TemplateProcessor.repositoryToMap(rs, this.repositoryMap);
        rs = ServletUtils.execute("Einlesen von hochschulinfo f\u00fcr repository", "select name,adresse,hs_nr,kapitel from hochschulinfo", this.getName());
        for (SxResultRow zeile : rs) {
            this.repositoryMap.put("K_Name", zeile.get(0));
            this.repositoryMap.put("K_Adresse", zeile.get(1));
            this.repositoryMap.put("K_hs_nr", zeile.get(2));
            this.repositoryMap.put("K_Kapitel", zeile.get(3));
        }
        rs = ServletUtils.execute("Einlesen von konstanten f\u00fcr repository", "select trim(beschreibung),apnr from konstanten", this.getName());
        for (SxResultRow row : rs) {
            String beschreibung = (String)row.get(0);
            this.repositoryMap.put("K_" + beschreibung, row.get(1));
        }
    }

    public String localize(StringBuffer text, Locale l) {
        return this.localize(text.toString(), l);
    }

    public String localize(String text, Locale l) {
        for (TranslationContainer tc : this.translations) {
            if (text.indexOf("@@@" + tc.getId() + "@@@") <= -1) continue;
            text = StringUtils.replace(text, "@@@" + tc.getId() + "@@@", tc.getContentsLong(l));
        }
        for (TranslationContainer tc : this.translations) {
            if (text.indexOf("@@" + tc.getId() + "@@") <= -1) continue;
            text = StringUtils.replace(text, "@@" + tc.getId() + "@@", tc.getContentsShort(l));
        }
        return text;
    }

    public String getTranslationShort(String id, Locale l) {
        String result = "";
        if (this.translations.containsItemWithId(id)) {
            TranslationContainer tc = (TranslationContainer)this.translations.getById(id);
            result = tc.getContentsShort(l);
        }
        return result;
    }

    private void initGraphicsFormats() throws SQLException, DBServletException {
        SxResultSet rs = ServletUtils.execute("Einlesen von Grafikformaten", "select id,charttype,caption,width,height,captionx,captiony,linex,liney,showvalues,moreattribs from graphicformat", this.getName());
        this.graphicformats.clear();
        for (SxResultRow row : rs) {
            this.graphicformats.add(new GraphicFormat(row));
        }
    }

    private void initMacroFieldSelections() throws SQLException, DBServletException {
        SxResultSet makroFieldRs = ServletUtils.execute("Einlesen von speziellen Auswahlwerten f\u00fcr makros aus macro_feld_wert", "select macro,sortnr,feldname,value,feldsicht from macro_feld_wert where active=1", this.getName());
        this.makroFieldSelections.clear();
        for (SxResultRow aRow : makroFieldRs) {
            MacroFieldSelection m = new MacroFieldSelection(aRow);
            if (m.getWert() != null && m.getWert().startsWith("<<SQL>>")) {
                SxResultSet result = ServletUtils.execute("Wert f\u00fcr hinterlegten makro_feld_wert " + m.getMakroid() + ", sortnr " + m.getSortnr() + " holen", m.getWert().substring(7), this.getName());
                if (result.size() == 0) {
                    throw new IllegalArgumentException("Kein Makro_feld_wert f\u00fcr makro " + m.getMakroid() + " sortnr " + m.getSortnr() + " per " + m.getWert() + " gefunden.");
                }
                SxResultRow row = (SxResultRow)result.first();
                Object o = row.get(0);
                if (o == null) {
                    throw new IllegalArgumentException("Makro_feld_wert f\u00fcr makro " + m.getMakroid() + " sortnr " + m.getSortnr() + " darf nicht null sein.");
                }
                m.setWert(o.toString());
            }
            this.makroFieldSelections.add(m);
        }
    }

    public boolean hasMakroFieldSelection(Object makroid, Integer sortNr) {
        boolean result = false;
        for (MacroFieldSelection makroFieldSelection : this.makroFieldSelections) {
            if (!makroFieldSelection.getMakroid().toString().equals(makroid.toString()) || !makroFieldSelection.getSortnr().equals(sortNr)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void applyMacroFieldSelectionTo(Object makroid, Maske maske, Hashtable formular, HashMap map, FieldContainer fc, SxUser user) {
        for (MacroFieldSelection makroFieldSelection : this.makroFieldSelections) {
            Field f;
            if (!makroFieldSelection.getMakroid().toString().equals(makroid.toString()) || !makroFieldSelection.getSortnr().equals(maske.getSortNr())) continue;
            SuperXManager.logActivity(Level.FINE, "Setze speziellen Auswahlwert           ein f\u00fcr Makro " + makroid + " Submaske: " + maske.getName() + "          sortnr=" + makroFieldSelection.getSortnr() + "          Feld:" + makroFieldSelection.getFeldername() + "          Wert:" + makroFieldSelection.getWert() + "     Sicht:" + makroFieldSelection.getFeldsicht());
            try {
                if (makroFieldSelection.getFeldsicht() != null && !makroFieldSelection.getFeldsicht().equals("")) {
                    f = maske.getField(makroFieldSelection.getFeldername());
                    SxResultSet rs = ServletUtils.execute("Suchen der Sicht mit name_intern=" + makroFieldSelection.getFeldsicht(), "select tid from sichten where name_intern='" + makroFieldSelection.getFeldsicht() + "'", this.getName());
                    Integer sichttid = new Integer(-1);
                    for (SxResultRow row : rs) {
                        sichttid = (Integer)row.get(0);
                    }
                    if (sichttid == null || sichttid == -1) {
                        throw new IllegalArgumentException("F\u00fcr Makro " + makroid + " Feld:" + makroFieldSelection.getFeldername() + " Sortnr:" + makroFieldSelection.getSortnr() + " wurde eine Sicht mit name_intern=" + makroFieldSelection.getFeldsicht() + " angegeben, die nicht gefunden wurde");
                    }
                    f.setSicht(formular, map, fc, sichttid, user);
                    f.setMacroMaskenSichtSet(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("F\u00fcr Makro " + makroid + " Feld:" + makroFieldSelection.getFeldername() + " Sortnr:" + makroFieldSelection.getSortnr() + " konnte eine Sicht mit name_intern=" + makroFieldSelection.getFeldsicht() + " nicht gesetzt werden");
            }
            try {
                if (makroFieldSelection.getWert() == null || makroFieldSelection.getWert().equals("")) continue;
                f = maske.getField(makroFieldSelection.getFeldername());
                f.initIfNeeded(formular, map, fc, user);
                maske.setSpecialFieldSelection(makroFieldSelection.getFeldername(), makroFieldSelection.getWert());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Konnte f\u00fcr Maske " + maske.getName() + " (" + maske.getId() + ") den gew\u00fcnschten Wert :\"" + makroFieldSelection.getWert() + "\" f\u00fcr das Feld " + makroFieldSelection.getFeldername() + " nicht eintragen.\n" + e);
            }
        }
    }

    public void init() throws TransformerConfigurationException, SQLException, DBServletException, IOException {
        try {
            SuperXmlAnmeldung.waitForPoolInit = true;
            this.initSichtartRechteDefinition();
            this.initFinRights();
            this.initFMTemplates();
            this.initRepository();
            this.initTranslations();
            this.initHeaderFooterDB();
            this.initMacroFieldSelections();
            this.initGraphicsFormats();
            this.initFieldElementCache();
            this.initHeaderFooter();
            this.initExternalPools();
            this.initHasKontierungsrechte();
            this.initJasper();
            this.initSxMail();
            this.deleteMaskenProtokoll();
            SuperXmlAnmeldung.waitForPoolInit = false;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            SuperXmlAnmeldung.waitForPoolInit = false;
        }
    }

    private void deleteMaskenProtokoll() throws SQLException {
        if (this.getRepository().containsKey("K_Nutzungsstatistiken loeschen nach Tagen") && Integer.parseInt(this.getRepository().get("K_Nutzungsstatistiken loeschen nach Tagen").toString()) > 0) {
            Connection con = this.getConnection();
            PreparedStatement pst = con.prepareStatement("delete from masken_protokoll where CURRENT_DATE - Zeitpunkt::date>=?");
            pst.setInt(1, Integer.parseInt(this.getRepository().get("K_Nutzungsstatistiken loeschen nach Tagen").toString()));
            pst.executeUpdate();
            pst.close();
            con.close();
        }
    }

    private void initJasper() throws SQLException {
        boolean useJaxen = true;
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select count(*) from konstanten where beschreibung='KERN_JASPER_USE_JAXEN' and apnr=0");
        while (rs.next()) {
            if (rs.getInt(1) == 0) continue;
            useJaxen = false;
        }
        rs.close();
        stmt.close();
        con.close();
        Logger.getLogger("superx_" + this.getName()).info("JASPER Jaxen Nutzung steht auf " + useJaxen);
        if (useJaxen) {
            DefaultJasperReportsContext context = DefaultJasperReportsContext.getInstance();
            JRPropertiesUtil.getInstance((JasperReportsContext)context).setProperty("net.sf.jasperreports.xpath.executer.factory", "net.sf.jasperreports.engine.util.xml.JaxenXPathExecuterFactory");
        }
    }

    public boolean hasKontierungsrechte() {
        return this.hasKontierungsrechte;
    }

    private void initHasKontierungsrechte() throws SQLException {
        Connection dbConnection = SxPools.getConnection(this.getName());
        this.hasKontierungsrechte = false;
        Statement stm = dbConnection.createStatement();
        DatabaseMetaData md = dbConnection.getMetaData();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = md.getTables(null, null, "gxstage_user_rights", types);
        if (rs.next()) {
            this.hasKontierungsrechte = true;
        } else {
            Logger.getLogger("superx_" + this.getName()).info("Keine Sx_Kontierung (gxstage_user_rights) gefunden");
        }
        rs.close();
        stm.close();
    }

    private void initSxMail() throws SQLException, DBServletException {
        this.shutdownSxmailThreads();
        this.sxmails.clear();
        Connection dbConnection = SxPools.getConnection(this.getName());
        Statement stm = dbConnection.createStatement();
        DatabaseMetaData md = dbConnection.getMetaData();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = md.getTables(null, null, "sx_mail", types);
        boolean hasSxMail = false;
        if (rs.next()) {
            hasSxMail = true;
        } else {
            Logger.getLogger("superx_" + this.getName()).info("Keine Sx_mail Tabelle gefunden");
        }
        rs.close();
        stm.close();
        if (hasSxMail) {
            SxResultSet rs2 = ServletUtils.execute("Einlesen von sx_mail", "select pop3_host,       pop3_port,       pop3_starttls_enable,       smtp_host,       smtp_port,       smtp_auth,       smtp_starttls_enable,       username,       password,       daemon1,       daemon1_interval,       daemon2,       daemon2_interval,       daemon3,       daemon3_interval FROM sx_mail;", this.getName());
            String wtfai = null;
            RepositoryItemCollection r = (RepositoryItemCollection)this.getRepository().get("WTFAI");
            if (r != null) {
                wtfai = r.getContent();
            }
            for (SxResultRow row : rs2) {
                String pop3_host = (String)row.get(0);
                Integer pop3_port = (Integer)row.get(1);
                Integer pop3_starttls_enable = (Integer)row.get(2);
                String smtp_host = (String)row.get(3);
                Integer smtp_port = (Integer)row.get(4);
                Integer smtp_auth = (Integer)row.get(5);
                Integer smtp_starttls_enable = (Integer)row.get(6);
                String username = (String)row.get(7);
                String password = (String)row.get(8);
                String daemon1 = (String)row.get(9);
                Integer daemon1_interval = (Integer)row.get(10);
                String daemon2 = (String)row.get(11);
                Integer daemon2_interval = (Integer)row.get(12);
                String daemon3 = (String)row.get(13);
                Integer daemon3_interval = (Integer)row.get(14);
                SxMail s = new SxMail(this.getName(), wtfai, pop3_host, pop3_port == null ? 0 : pop3_port, pop3_starttls_enable == null ? 0 : pop3_starttls_enable, smtp_host, smtp_port == null ? 0 : smtp_port, smtp_auth == null ? 0 : smtp_auth, smtp_starttls_enable == null ? 0 : smtp_starttls_enable, username, password, daemon1, daemon1_interval == null ? 0 : daemon1_interval, daemon2, daemon2_interval == null ? 0 : daemon2_interval, daemon3, daemon3_interval == null ? 0 : daemon3_interval);
                this.sxmails.add(s);
                if (this.sxmails.size() <= 1) continue;
                throw new IllegalStateException("Bisher nur ein Konto unterst\u00fctzt");
            }
        }
    }

    private void initHeaderFooter() throws IOException {
        File customPdfFile;
        File f;
        String pfad = SuperXManager.getWEB_INFPfad() + File.separator + ".." + File.separator + this.getName() + File.separator + "custom";
        File excelVorlageFile = new File(pfad + File.separator + "vorlage.xlsx");
        if (excelVorlageFile.exists()) {
            this.excelVorlage = excelVorlageFile.getAbsolutePath();
        }
        if (!(f = new File(pfad)).exists()) {
            f.mkdirs();
        }
        if ((customPdfFile = new File(pfad + File.separator + "custom_pdf.xsl")).exists()) {
            customPdfFile.delete();
        }
        if (this.repositoryMap.get("CUSTOM_PDF") != null && !((RepositoryItemCollection)this.repositoryMap.get("CUSTOM_PDF")).getContent().equals("")) {
            StringUtils.write(customPdfFile, ((RepositoryItemCollection)this.repositoryMap.get("CUSTOM_PDF")).getContent());
        }
        this.hasCustomPdfFile = customPdfFile.exists();
    }

    public boolean hasCustomPDFFile() {
        return this.hasCustomPdfFile;
    }

    private void initFieldElementCache() {
        SxResultSet rs;
        MemoryUtils m = new MemoryUtils();
        if (SuperXManager.isSichtenCachingWanted) {
            System.out.print("  Caching von Sichten mit statischem SQL (Mandant:" + this.getName() + ")...");
            rs = null;
            try {
                rs = ServletUtils.execute("potentielle zu cachende Sichtenquellen lesen", "select name_intern,art,quelle,cacheapplet,cachexml from sichten where tid>10 and type!=20 and aktiv=1 and substring(quelle from 7 for (length(quelle)-7)) not like '%<<%'  and quelle not like '%${%' and quelle not like '%--freemarker%' and quelle not like '%<@%' ", this.getName());
            }
            catch (Exception e) {
                System.out.println("Error beim Einlesen potentielle zu cachende Sichtenquellen " + e);
            }
            if (rs != null) {
                for (SxResultRow row : rs) {
                    if (!this.fieldElementCache.isSichtCachingWanted((String)row.get(2))) continue;
                    try {
                        String sqlQuery = (String)row.get(2);
                        if (row.get(3) != null) {
                            sqlQuery = sqlQuery + " " + row.get(3);
                        }
                        if (row.get(4) != null) {
                            sqlQuery = sqlQuery + " " + row.get(4);
                        }
                        Logger.getLogger("superx_" + this.getName()).log(Level.FINER, " Cache Sicht:  " + row.get(0));
                        SxResultSet items = ServletUtils.executeALL_el(null, null, "Elemente f\u00fcr zu cachende Sicht " + row.get(0), this.fieldElementCache.generateSQL(sqlQuery, this.getSqlDialect()), this.getName(), false).getResultSet();
                        boolean isOrganigramm = false;
                        if (row.get(1).toString().equals("Organigramm-Sicht")) {
                            isOrganigramm = true;
                        }
                        this.fieldElementCache.addSicht(this.getName(), (String)row.get(0), items, isOrganigramm);
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.getName()).log(Level.INFO, "Problem bei Caching der Sicht " + row.get(0) + " " + e);
                    }
                }
            }
            System.out.println("OK");
        } else {
            System.out.println("Caching von Sichten mit statischem SQL deaktiviert");
        }
        if (SuperXManager.field1Cache == null || SuperXManager.field1Cache.equals("") || this.getDatabaseAbbr().equals("IDS")) {
            System.out.println("  kein Feldart 1-caching aktiviert");
        } else {
            System.out.print("  Feldart 1-caching (" + SuperXManager.field1Cache + ")...");
            m.measureBefore();
            rs = null;
            try {
                rs = ServletUtils.execute("potentielle zu cachende Felderquellen lesen", "select relation from felderinfo where " + SuperXManager.field1Cache + " and art=1 and substring(relation from 7 for (length(relation)-7)) not like '%<<%' and relation not like '%${%' and relation not like '%--freemarker%' and relation not like '%<@%' and relation not like '%#dbid:%' and tid!=23541", this.getName());
            }
            catch (Exception e) {
                System.out.println("Error beim Einlesen potentielle zu cachende Felderquellen " + e);
            }
            if (rs != null) {
                TreeSet<String> sqls = new TreeSet<String>();
                String haushaltsjahr = DateUtils.getYear(new java.sql.Date(new Date().getTime()));
                Hashtable<String, String> formular = new Hashtable<String, String>();
                formular.put("Haushaltsjahr", haushaltsjahr);
                for (SxResultRow row : rs) {
                    String sql = (String)row.get(0);
                    if (sql.trim().indexOf("<<SQL>>") == -1) continue;
                    sql = SqlStringUtils.generateSQL("PG", formular, sql);
                    if ((sql = AbstractSicht.getStrippedSQL(sql)).indexOf("<<") != -1) continue;
                    sqls.add(sql);
                }
                for (String sql : sqls) {
                    Logger.getLogger("superx_" + this.getName()).log(Level.FINER, " Cache Feld-SQL:  " + sql);
                    try {
                        rs = ServletUtils.executeALL_el(null, null, "Felder-SQL cachen", sql, this.getName(), false).getResultSet();
                        this.fieldElementCache.add(sql, rs);
                    }
                    catch (Exception e) {
                        Logger.getLogger("superx_" + this.getName()).log(Level.INFO, "Problem bei Caching des Feld-SQLs " + sql + " " + e);
                    }
                }
            }
            System.out.println("OK");
        }
    }

    private void initSichtartRechteDefinition() throws SQLException, DBServletException {
        Connection con = this.getConnection();
        if (SqlStringUtils.tableExists(con, "sichtart_rechttabelle", this.getName())) {
            SxResultSet rs = ServletUtils.execute("Einlesen von sichtartRechttable (ab 4.5)", "select art,tabelle,feldname,additionalkeyssql,fallback_user_inst from sichtart_rechttabelle", this.getName());
            for (SxResultRow row : rs) {
                String sichtart = (String)row.get(0);
                String tabelle = (String)row.get(1);
                String feldname = (String)row.get(2);
                String additionalKeys = (String)row.get(3);
                boolean fallback_user_inst = false;
                if (row.get(4) != null && row.get(4).toString().equals("1")) {
                    fallback_user_inst = true;
                }
                SichtartRechteDefinition sd = new SichtartRechteDefinition();
                sd.setName(sichtart);
                sd.setTabelle(tabelle);
                sd.setFeld(feldname);
                sd.setFallback_user_inst(fallback_user_inst);
                if (additionalKeys != null && additionalKeys.startsWith("sp_")) {
                    additionalKeys = this.getDatabaseAbbr().equals("PG") ? "select " + additionalKeys : "execute procedure " + additionalKeys;
                }
                sd.setAdditionalKeys(additionalKeys);
                this.sichtartRechteDefinitionen.add(sd);
            }
        }
        con.close();
    }

    public NamedObjectList getSichtartRechteDefinitionen() {
        return this.sichtartRechteDefinitionen;
    }

    private void initExternalPools() throws SQLException, DBServletException {
        String sql = "SELECT id, \n       driver, \n       url, \n       username, \n       passwort, \n       minidle, \n       maxidle, \n       maxactive, \n       testsql \nFROM dbconnections";
        this.closeExternalPools();
        this.externalPools.clear();
        Connection dbConnection = SxPools.getConnection(this.getName());
        try {
            Statement stm = dbConnection.createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                String externalid = rs.getString(1);
                String driver = rs.getString(2);
                String url = rs.getString(3);
                String username = rs.getString(4);
                String password = rs.getString(5);
                int minidle = rs.getInt(6);
                int maxidle = rs.getInt(7);
                int maxactive = rs.getInt(8);
                String testsql = rs.getString(9);
                ExternalPool pool = new ExternalPool(this.name, this.name + "-" + externalid, driver, url, username, password, minidle, maxidle, maxactive, testsql);
                this.externalPools.add(pool);
            }
            rs.close();
            stm.close();
            dbConnection.close();
        }
        catch (SQLException e) {
            Logger.getLogger("superx_" + this.getName()).log(Level.SEVERE, e.toString());
            SxPools.invalidate(this.getName(), dbConnection);
        }
    }

    private void closeExternalPools() throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        for (ExternalPool pool : this.externalPools) {
            if (!pool.isOK()) continue;
            driver.closePool(pool.getName());
        }
    }

    private void initFinRights() throws SQLException, DBServletException {
        this.finRightVariant = 0;
        Connection dbConnection = SxPools.getConnection(this.getName());
        try {
            boolean isFinFound = false;
            Statement stm = dbConnection.createStatement();
            DatabaseMetaData md = dbConnection.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet rs = md.getTables(null, null, "fin_user_kam", types);
            if (rs.next()) {
                isFinFound = true;
                this.finRightVariant = 1;
            } else {
                System.out.println("Kein Fin-Modul gefunden (fin_user_kam)");
            }
            rs.close();
            if (isFinFound) {
                rs = md.getColumns(null, null, "fin_user_kam", null);
                while (rs.next()) {
                    if (rs.getString(4).equals("kapitel")) {
                        this.finRightVariant = 2;
                        System.out.println("erweiterte FIN_user_kam gefunden - OK");
                    }
                    if (!rs.getString(4).equals("restrict_konten")) continue;
                    this.hasFinUserKamRestrictionFields = true;
                }
                rs.close();
                int k3count = 1;
                if (this.finRightVariant == 2 && k3count > 0) {
                    this.finRightVariant = 3;
                    System.out.println("erweiterte FIN_user_kam inkl. ins2/3 gefunden - OK");
                }
            }
            stm.close();
            dbConnection.close();
        }
        catch (SQLException e) {
            Logger.getLogger("superx_" + this.getName()).log(Level.SEVERE, e.toString());
            SxPools.invalidate(this.getName(), dbConnection);
        }
        SxResultSet rs2 = ServletUtils.execute("", "select apnr from konstanten where beschreibung='FIN_RECHTE_0_JOKER'", this.getName());
        for (SxResultRow r : rs2) {
            System.out.println(r.get(0) + " " + r.get(0).toString().equals("0"));
            if (r.get(0) == null || !r.get(0).toString().equals("0")) continue;
            this.is0FINJoker = false;
        }
        System.out.println(DateUtils.getNowString() + " finrights fertig");
    }

    public boolean is0FINJoker() {
        return this.is0FINJoker;
    }

    public int getFinRightVariant() {
        return this.finRightVariant;
    }

    private void initCachedUsers() throws SQLException, DBServletException {
        this.userpool.clear();
        String userImCacheSql = this.props.getProperty("userCache");
        if (userImCacheSql != null && !userImCacheSql.equals("")) {
            SxResultSet rs = ServletUtils.execute("user  f\u00fcr Cache holen", userImCacheSql, this.getName());
            MemoryUtils m = new MemoryUtils();
            for (SxResultRow row : rs) {
                try {
                    this.initUser(row);
                }
                catch (Exception e) {
                    String msg = "User " + row.get(0) + " konnte nicht aufgebaut werden. " + e;
                    Logger.getLogger("superx_" + this.getName()).log(Level.SEVERE, msg);
                    System.err.println(msg);
                }
            }
            m.print("alle " + rs.size() + " User");
        }
    }

    private void initCachedMasks() throws SQLException, DBServletException {
        this.maskenpool.clear();
        String maskenImCacheSql = this.props.getProperty("maskCache");
        if (maskenImCacheSql != null && !maskenImCacheSql.equals("")) {
            SxResultSet rs = ServletUtils.execute("Maskentids f\u00fcr Cache holen", maskenImCacheSql, this.getName());
            MemoryUtils m = new MemoryUtils();
            for (SxResultRow row : rs) {
                try {
                    this.initMask((Integer)row.get(0));
                }
                catch (Exception e) {
                    String msg = "Maske " + row.get(0) + " konnte nicht aufgebaut werden. " + e;
                    Logger.getLogger("superx_" + this.getName() + "_xml").log(Level.SEVERE, msg);
                    System.err.println(msg);
                }
            }
            m.print("alle " + rs.size() + " Masken");
        }
    }

    private void initUser(SxResultRow row) throws IllegalArgumentException, SecurityException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException, NichtAngemeldetException {
        Integer userid = (Integer)row.get(0);
        String login_name = (String)row.get(1);
        String adminUser = row.get(2).toString();
        try {
            UserInitializer.initUser(this.getName(), login_name, userid, adminUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    private void initMask(Integer tid) throws TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, NoMainEntryException {
        System.out.println("adding " + tid + " to Maskenpool");
        this.maskenpool.add(new Maske(this.getName(), null, tid, TranslationContainer.defaultLocale));
    }

    private void initFMTemplates() throws SQLException, DBServletException {
        SxResultSet rawFmTemplates = ServletUtils.execute("Hole allg. FreeMarker Templates aus der DB", "select trim(id),content from fm_templates", this.getName());
        this.templateProcessor.setTemplates(rawFmTemplates);
    }

    public GraphicFormat getGraphicFormat(String graphicFormat) {
        GraphicFormat result = null;
        try {
            this.initGraphicsFormats();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        catch (DBServletException e1) {
            e1.printStackTrace();
        }
        try {
            Integer graphicFormatNr = new Integer(graphicFormat);
            result = (GraphicFormat)this.graphicformats.getById(graphicFormatNr);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Kein GraphicFormat mit id " + graphicFormat + " in der Datenbank gefunden.");
        }
        return result;
    }

    public GraphicFormat getGraphicFormat2(String graphicFormat) {
        GraphicFormat result = null;
        try {
            this.initGraphicsFormats();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        catch (DBServletException e1) {
            e1.printStackTrace();
        }
        try {
            result = (GraphicFormat)this.graphicformats.getById(graphicFormat);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Kein GraphicFormat mit id " + graphicFormat + " in der Datenbank gefunden.");
        }
        return result;
    }

    public ServletTemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public static void main(String[] args) {
    }

    public String getDatabaseAbbr() {
        String result = "IDS";
        if (this.props.getProperty("driverName").indexOf("postgres") > -1) {
            result = "PG";
        }
        return result;
    }

    public HashMap getRepository() {
        return this.repositoryMap;
    }

    public void clearLogFiles() throws IOException {
        this.closeLoggers();
        this.initLogging(false);
    }

    private void initDSAHandler() throws DBServletException {
        if (this.privateKeyEncoded == null) {
            throw new IllegalStateException("privatekey war null - sx_repository auf Eintrag \u00fcberpr\u00fcfen");
        }
        if (this.publicKeyEncoded == null) {
            throw new IllegalStateException("publickey war null -  sx_repository auf Eintrag pr\u00fcfen");
        }
        try {
            this.dsaHandler = new DSAHandler(this.privateKeyEncoded, this.publicKeyEncoded);
        }
        catch (Exception e) {
            throw new DBServletException(e.toString());
        }
    }

    public boolean hasDSAHandler() {
        return this.dsaHandler != null;
    }

    public boolean verifiy(String data, String signature) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException {
        if (this.dsaHandler == null) {
            throw new IllegalStateException("DSAHandler ist null, public und private key definition pr\u00fcfen");
        }
        return this.dsaHandler.verify(data, signature);
    }

    public String getPrivateKey() {
        return this.privateKeyEncoded;
    }

    public boolean isRestrictedConnection() {
        return this.isRestrictedConnection;
    }

    public NewPasswordChecker getNewPWChecker() {
        return this.newPasswordChecker;
    }

    public FieldElementCache getFieldElementCache() {
        return this.fieldElementCache;
    }

    public String getFinRightVariantName() {
        String result = "einfach";
        if (this.finRightVariant == 2) {
            result = "erweitert ohne ins2/ins3";
        }
        if (this.finRightVariant == 3) {
            result = "erweitert inkl. ins2/3";
        }
        return result;
    }

    public String customHTMLHeaderFooter(String result) {
        if (this.repositoryMap.get("HTML_HEADER") != null && !((RepositoryItemCollection)this.repositoryMap.get("HTML_HEADER")).getContent().equals("")) {
            Pattern customheadertablePattern = Pattern.compile("<table .* id=\"customheader\".*?</table>", 32);
            Matcher action = customheadertablePattern.matcher(result);
            String newstuff = ((RepositoryItemCollection)this.repositoryMap.get("HTML_HEADER")).getContent();
            result = action.replaceAll(newstuff);
        }
        if (this.repositoryMap.get("HTML_FOOTER") != null && !((RepositoryItemCollection)this.repositoryMap.get("HTML_FOOTER")).getContent().equals("")) {
            result = StringUtils.replace(result, "<!--customfooter-->", ((RepositoryItemCollection)this.repositoryMap.get("HTML_FOOTER")).getContent());
        }
        return result;
    }

    public String getExcelVorlage() {
        return this.excelVorlage;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        int version = 0;
        Connection con = this.getConnection();
        version = con.getMetaData().getDatabaseMinorVersion();
        con.close();
        return version;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        int version = 0;
        Connection con = this.getConnection();
        version = con.getMetaData().getDatabaseMajorVersion();
        con.close();
        return version;
    }

    public boolean hasExternalPool(String epName) {
        return this.externalPools.containsItemWithName(epName);
    }

    public ExternalPool getExternalPool(String epName) {
        return (ExternalPool)this.externalPools.getByName(epName);
    }

    public String checkImports(String input, String maskentid) throws SQLException {
        String result = null;
        if (input != null) {
            boolean importsFounds;
            input = input.replaceAll("<<Maskennummer>>", maskentid);
            StringBuffer work = new StringBuffer(input);
            boolean bl = importsFounds = input.indexOf("<sximport>") > -1;
            if (importsFounds) {
                Connection dbConnection = SxPools.getConnection(this.getName());
                Statement stm = dbConnection.createStatement();
                while (work.indexOf("<sximport") > -1) {
                    int posstart = work.indexOf("<sximport>");
                    int posende = work.indexOf("</sximport>", posstart);
                    if (posende == -1) {
                        throw new IllegalArgumentException("Tag sximport nicht ordentlich beendet");
                    }
                    String importInstruction = work.substring(posstart + 10, posende);
                    String importInstructionReplacedMaskenTid = importInstruction.replaceAll("<<Maskennummer>>", maskentid);
                    ResultSet rs = stm.executeQuery(importInstructionReplacedMaskenTid);
                    boolean validReplaceText = false;
                    while (rs.next()) {
                        validReplaceText = true;
                        String replaceText = rs.getString(1);
                        if (replaceText == null) {
                            StringUtils.replace(work, "<sximport>" + importInstruction + "</sximport>", "");
                            continue;
                        }
                        StringUtils.replace(work, "<sximport>" + importInstruction + "</sximport>", replaceText);
                    }
                    rs.close();
                    if (validReplaceText) continue;
                    break;
                }
                stm.close();
                dbConnection.close();
            }
            result = work.toString();
        }
        return result;
    }
}

