/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.HtmlUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.TimeUtils;
import de.superx.common.DBServletException;
import de.superx.common.Maske;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.servlet.MaskenContainer;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

class SichtChanger
extends SuperXServletHelper {
    TimeUtils tutil = new TimeUtils();
    private static final String AKTUALISIEREN = "-aktualisieren";
    private boolean isSendBackWanted = false;
    private Maske maske;

    SichtChanger(HttpServletRequest request, HttpServletResponse response, boolean isSendBackWanted) throws IOException {
        super(request, response);
        this.isSendBackWanted = isSendBackWanted;
    }

    @Override
    protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, SichtException, NoMainEntryException {
        String tidString = ServletHelper.getParameter(this.request, "tid");
        MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
        this.maske = mc.getMaske(tidString);
        Enumeration en = this.request.getParameterNames();
        while (en.hasMoreElements()) {
            String aName = (String)en.nextElement();
            if (!aName.endsWith(AKTUALISIEREN)) continue;
            this.feldAktualisieren(aName);
        }
        if (this.isSendBackWanted) {
            this.sendBackMask();
        }
    }

    private void sendBackMask() throws TransformerConfigurationException, TransformerException, DBServletException, IOException {
        SxUser user = (SxUser)this.request.getSession().getAttribute("user");
        String returnText = this.maske.getMaskHtml(user, this.getJSessionId(), false);
        returnText = SxPools.get(this.getMandantenID()).localize(returnText, this.getDesiredLocale());
        this.tutil.start();
        this.sendBackHtml(returnText);
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " schicken der Ergebnisseite an Client " + this.tutil.getSinceStart());
    }

    private void feldAktualisieren(String aName) throws TransformerException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, TransformerConfigurationException, SichtException, TemplateException, IOException, NoMainEntryException {
        String feldname = aName.substring(0, aName.length() - AKTUALISIEREN.length());
        if (ServletHelper.getParameter(this.request, feldname + "-Stand") != null) {
            this.standAktualisieren(feldname);
        }
        if (ServletHelper.getParameter(this.request, feldname + "-Sicht") != null) {
            this.gew\u00e4hlteSichtAktualisieren(feldname);
        }
    }

    private void gew\u00e4hlteSichtAktualisieren(String feldname) throws TransformerConfigurationException, TransformerException, DBServletException, SQLException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        String sichttidStr = ServletHelper.getParameter(this.request, feldname + "-Sicht");
        if (sichttidStr == null) {
            sichttidStr = ServletHelper.getParameter(this.request, HtmlUtils.adapt(feldname) + "-Stand");
        }
        if (sichttidStr == null) {
            throw new IllegalStateException("Erwarteter Parameter " + feldname + "-Sicht nicht gefunden");
        }
        SxUser sxuser = (SxUser)this.request.getSession().getAttribute("user");
        if (sxuser == null) {
            throw new IllegalStateException("Kein user (SxUser-Objekt) in der Session gefunden!");
        }
        this.maske.setSelectedFeldSicht(feldname, sichttidStr, sxuser);
    }

    private void standAktualisieren(String feldname) throws TransformerException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        String standStr = ServletHelper.getParameter(this.request, feldname + "-Stand");
        if (standStr == null) {
            standStr = ServletHelper.getParameter(this.request, HtmlUtils.adapt(feldname) + "-Stand");
        }
        if (standStr == null) {
            throw new IllegalStateException("Erwarteter Parameter " + feldname + "-Stand nicht gefunden");
        }
        SxUser sxuser = (SxUser)this.request.getSession().getAttribute("user");
        if (sxuser == null) {
            throw new IllegalStateException("Kein user (SxUser-Objekt) in der Session gefunden!");
        }
        this.maske.setFeldStand(feldname, standStr, sxuser);
    }

    static boolean isSichtChangeWanted(HttpServletRequest request) {
        boolean result = false;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String aName = (String)en.nextElement();
            if (!aName.endsWith(AKTUALISIEREN)) continue;
            result = true;
        }
        return result;
    }
}

