/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.ServletHelper;
import de.superx.common.SxUser;
import de.superx.servlet.ServletBasics;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.UserInitializer;
import de.superx.util.SqlStringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class AbstractSuperXServlet
extends HttpServlet {
    static Logger logger = Logger.getLogger(AbstractSuperXServlet.class);
    private static final long serialVersionUID = 1L;

    public String getTid(HttpServletRequest request) {
        String tidString = ServletHelper.getParameter(request, "tid");
        if (tidString == null || tidString.equals("")) {
            throw new IllegalArgumentException("tid Argument fehlt");
        }
        return tidString;
    }

    public boolean getShowNavigation(HttpServletRequest request) {
        String naviParam = ServletHelper.getParameter(request, "navi");
        String naviAttr = (String)request.getAttribute("navi");
        if (naviAttr != null && !naviAttr.isEmpty()) {
            naviParam = naviAttr;
        }
        boolean showNavi = naviParam != null && naviParam.equals("true");
        return showNavi;
    }

    public void checkCacheClearing(HttpServletRequest request) throws ServletException {
        String p = ServletHelper.getParameter(request, "cachingcontrol");
        if (p != null) {
            if (p.equalsIgnoreCase("clearstylesheets") || p.equalsIgnoreCase("s")) {
                try {
                    SuperXManager.clearTransletStylesheets();
                }
                catch (Exception e) {
                    throw new ServletException(e.toString());
                }
            }
            if (p.equalsIgnoreCase("clearall") || p.equalsIgnoreCase("a")) {
                try {
                    SuperXManager.initPool(request, ServletUtils.getMandantenID(request));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Kann Cache nicht neu laden:" + e);
                }
            }
        }
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String uri) throws IOException, ServletException {
        String url = response.encodeRedirectURL("/servlet/" + uri);
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(url);
        if (rd == null) {
            throw new IOException("Konnte keinen RequestDispatch aufbauen f\u00fcr /servlet/" + uri);
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void erstmalAnmelden(String servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/servlet/de.superx.servlet.SuperXmlAnmeldung?requestedServlet=" + servlet);
        if (rd == null) {
            throw new IOException("Konnte keinen RequestDispatch aufbauen f\u00fcr /servlet/de.superx.servlet.SuperXmlAnmeldung");
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void infoNeuAnmelden(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.append("<html><body>Bitte melden Sie sich (neu) am System an</body></html>");
        writer.flush();
    }

    protected boolean hasProperSession(HttpServletRequest request) {
        boolean result = false;
        HttpSession s = request.getSession(false);
        if (s != null) {
            logger.debug((Object)("** Checking Session: ** -> " + s.getId()));
            String type = (String)s.getAttribute("sessiontype");
            logger.debug((Object)("Session Type: " + type));
            SxUser user = (SxUser)s.getAttribute("user");
            logger.debug((Object)("Session User: " + user));
            result = type != null && type.equals("superx") && user != null;
        }
        return result;
    }

    public boolean checkAnmeldungImRequest(HttpServletRequest request) throws IOException, ServletException {
        boolean created = false;
        if (!(ServletBasics.getParameter(request, "token") == null && ServletBasics.getParameter(request, "kennung") == null || this.hasProperSession(request))) {
            UserInitializer ui = new UserInitializer(request, false);
            try {
                ui.perform();
                created = true;
            }
            catch (Exception e) {
                throw new ServletException("Authentifizierung f\u00fcr " + ServletBasics.getParameter(request, "kennung") + " fehlgeschlagen DETAILS: (" + e.getMessage() + ")");
            }
        }
        return created;
    }

    protected boolean isJSONRequest(HttpServletRequest request) {
        boolean result = false;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String aName = (String)en.nextElement();
            if (!aName.startsWith("getJSON")) continue;
            result = true;
        }
        return result;
    }

    protected static void setEncoding(HttpServletRequest request) throws UnsupportedEncodingException {
        String ie = SqlStringUtils.getEncoding();
        request.setCharacterEncoding(ie);
    }
}

