/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin.fm;

import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateTransformModel;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.pentaho.di.core.JndiUtil;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.metastore.DatabaseMetaStoreUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.memory.MemoryMetaStore;

public class EtlStarter
implements TemplateTransformModel {
    public static final String PARAM_KEY_COMP = "component";
    public static final String PARAM_KEY_STEP = "etl_step";
    public static final String PARAM_LOGLEVEL = "log_level";
    private static Logger logger = Logger.getLogger(EtlStarter.class);
    private String mandantenId = "default";
    private LogLevel logLevel = LogLevel.BASIC;

    public EtlStarter(String mandantenId) {
        this.mandantenId = mandantenId;
    }

    public Writer getWriter(Writer paramWriter, Map paramMap) throws TemplateModelException, IOException {
        logger.info((Object)"**EtlStarter**");
        SimpleScalar componentSc = (SimpleScalar)paramMap.get(PARAM_KEY_COMP);
        SimpleScalar etl_stepSc = (SimpleScalar)paramMap.get(PARAM_KEY_STEP);
        SimpleScalar log_levelSc = (SimpleScalar)paramMap.get(PARAM_LOGLEVEL);
        String component = componentSc.getAsString();
        String etl_step = etl_stepSc.getAsString();
        if (component == null || component.isEmpty()) {
            throw new TemplateModelException("Missing parameter component");
        }
        if (etl_step == null || etl_step.isEmpty()) {
            throw new TemplateModelException("Missing parameter etl_step");
        }
        paramMap.remove(PARAM_KEY_COMP);
        paramMap.remove(PARAM_KEY_STEP);
        paramMap.remove(PARAM_LOGLEVEL);
        if (log_levelSc != null) {
            this.logLevel = LogLevel.valueOf((String)log_levelSc.getAsString());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Object key : paramMap.keySet()) {
            SimpleScalar value = (SimpleScalar)paramMap.get(key);
            params.put((String)key, value.getAsString());
            logger.info((Object)("PARAM: " + key + " -> " + value.getAsString()));
        }
        String moduleDir = SuperXManager.getModuleDir();
        if (moduleDir == null || moduleDir.equals("")) {
            if (System.getProperty("MODULE_PFAD") != null && !System.getProperty("MODULE_PFAD").toString().equals("")) {
                moduleDir = System.getProperty("MODULE_PFAD").toString();
            } else {
                throw new IOException("Module-Pfad kann nicht ermittelt werden, bitte setzen Sie den JVM Parameter -DMODULE_PFAD=...");
            }
        }
        String jobFilePath = null;
        jobFilePath = component.contentEquals("manual") ? this.getFilePathFromDatabase(etl_step, moduleDir) : this.getFilePathFromModule(component, etl_step, moduleDir);
        logger.info((Object)("Kettle job: " + jobFilePath));
        this.kettleCallEmbedded(jobFilePath, params);
        return null;
    }

    private String getFilePathFromDatabase(String etl_step, String moduleDir) throws IOException {
        String jobFilePath = null;
        try (Connection con = SxPools.get(this.mandantenId).getConnection();
             PreparedStatement pst = con.prepareStatement("select filepath from sx_jobs where uniquename=?");){
            pst.setString(1, etl_step);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                jobFilePath = rs.getString(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IOException("Fehler beim Auslesen von sx_jobs mit uniquename " + etl_step + " " + e);
        }
        if (jobFilePath == null) {
            throw new IOException("Fehler beim Auslesen von sx_jobs mit uniquename " + etl_step + " Kein Eintrag gefunden");
        }
        return moduleDir + File.separator + jobFilePath;
    }

    private String getFilePathFromModule(String component, String etl_step, String moduleDir) throws TemplateModelException {
        Element etl;
        if (!new File(moduleDir = moduleDir + File.separator + component + File.separator).exists()) {
            throw new TemplateModelException("Component not found: " + component);
        }
        File componentXml = new File(moduleDir + File.separator + "conf" + File.separator + component + ".xml");
        if (!componentXml.canRead()) {
            throw new TemplateModelException("Cannot read component xml for " + component);
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(componentXml);
            etl = (Element)document.selectSingleNode("//module/etl/etl-step[@id='" + etl_step + "']/action/kettle-job-embedded");
        }
        catch (DocumentException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
        if (etl == null) {
            throw new TemplateModelException("Didn't find kettle-job-embedded in etl-step with id " + etl_step + " for component " + component);
        }
        String fileAttr = etl.attributeValue("file");
        String jobFilePath = moduleDir + fileAttr.substring(fileAttr.indexOf(47) + 1);
        return jobFilePath;
    }

    final StringBuffer kettleCallEmbedded(String jobfile, Map<String, String> jobParams) {
        return this.kettleCallEmbedded("default", jobfile, jobParams, true);
    }

    public final StringBuffer kettleCallEmbedded(String mandantenID, String jobfile, Map<String, String> jobParams, boolean isPostgres) {
        StringWriter writer = new StringWriter();
        WriterAppender appender = new WriterAppender((Layout)new SimpleLayout(), (Writer)writer);
        Level oldLevel = logger.getLevel();
        logger.setLevel(Level.ALL);
        logger.addAppender((Appender)appender);
        try {
            if (!KettleEnvironment.isInitialized()) {
                try {
                    KettleEnvironment.init();
                }
                catch (KettleException e) {
                    logger.error((Object)"Couldn't initialize KettleEnvironment!", (Throwable)e);
                }
            }
            JndiUtil.initJNDI();
            MemoryMetaStore metastore = new MemoryMetaStore();
            List<String> dbNames = Arrays.asList("eduetl");
            for (String dbName : dbNames) {
                DatabaseMeta dbmeta = SxPools.get(mandantenID).getKettleDatabaseMeta();
                DatabaseMetaStoreUtil.createDatabaseElement((IMetaStore)metastore, (DatabaseMeta)dbmeta);
                logger.info((Object)("Init pdi database connection " + dbName + " (DBName:" + dbmeta.getDatabaseName() + ")"));
            }
            JobMeta jobMeta = new JobMeta(null, jobfile, null, (IMetaStore)metastore, null);
            Job job = new Job(null, jobMeta);
            job.setLogLevel(this.logLevel);
            String[] params = jobMeta.listParameters();
            for (String param : params) {
                logger.info((Object)("Job-Param: " + param));
                logger.info((Object)("  -> defaults to " + jobMeta.getParameterDefault(param)));
            }
            job.copyParametersFrom((NamedParams)jobMeta);
            job.setInteractive(true);
            if (jobParams != null) {
                for (String param : jobParams.keySet()) {
                    String value = jobParams.get(param);
                    logger.info((Object)("PARAM " + param + " = " + value));
                    jobMeta.setParameterValue(param, value);
                }
            }
            job.activateParameters();
            job.start();
            job.waitUntilFinished();
            Result result = job.getResult();
            String outcome = "\nJob " + jobfile + " executed with result: " + result.getResult() + " and " + result.getNrErrors() + " errors\n";
            logger.info((Object)outcome);
            if (result.getNrErrors() > 0L) {
                logger.info((Object)(result.getNrErrors() + " Errors executing Kettle job " + jobfile));
                String logText = result.getLogText();
                logger.error((Object)logText);
                throw new RuntimeException("Errors in Kettle job " + jobfile + ":\n" + logText);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error executing Kettle job " + jobfile), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            logger.removeAppender((Appender)appender);
            logger.setLevel(oldLevel);
        }
        return writer.getBuffer();
    }

    public static void main(String[] args) {
        String jobfile = "file:///home/superx/data-integration/exceltest.kjb";
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("PATH_TO_EXCELFILE", "/home/superx/tmp/testexcel2.xlsx");
        EtlStarter es = new EtlStarter("default");
        es.kettleCallEmbedded("default", jobfile, jobParams, false);
    }
}

