/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import de.superx.bin.SxConnection;
import de.superx.bin.SxTransformer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebserviceClientSummendaten
extends AbstractWebserviceClient {
    private Collection<String> finanzstellen = new LinkedList<String>();
    private Document resultDocument;
    private Document configDocument;
    private String hsnr;
    private String xmlConfig;
    private String datentyp;
    private String url;
    private String data;
    private String soap;
    private String replaceNodeName;
    private String xslpfad;
    private String outfile;
    private boolean isDeleteTmpXmlFileWanted = true;
    private String jahr;
    private boolean isDBConnectionPossible = true;
    private String dbpropfile;
    private static final Logger log = Logger.getLogger("wc");

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientSummendaten Version 0.9.3");
        WebserviceClientSummendaten tc = new WebserviceClientSummendaten();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            XMLUtils.getExceptionHandler().setWithGui(false);
            XMLUtils.getExceptionHandler().setExitWanted(true);
            LogUtils.initRawFileDateTime("wc", "WebserviceClient.log", 100000, 1, true, false);
            log.setLevel(Level.FINEST);
            log.getHandlers()[0].setLevel(Level.FINEST);
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent("-xmlconfig,-xslpfad,-hsnr,-jahr,-out,-datentyp");
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.readFinanzstellen();
            this.perform();
            String msg = "    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            log.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void readFinanzstellen() throws Exception {
        if (this.isDBConnectionPossible) {
            SxConnection myConnection = new SxConnection();
            myConnection.setPropfile(this.dbpropfile);
            Connection con = myConnection.getConnection();
            Statement stm = con.createStatement();
            ResultSet rs = stm.executeQuery("select distinct fmfctr_fictr from gxstage_sap_sc11 -- where csks_kostl in ('8056100000','8056410000','8056121002')");
            while (rs.next()) {
                String instnr = rs.getString(1);
                this.finanzstellen.add(instnr);
            }
            rs.close();
            stm.close();
            con.close();
        }
        String msg = this.finanzstellen.size() + " Finanzstellen gefunden";
        log.log(Level.INFO, msg);
        System.out.println(msg);
    }

    private void perform() throws Exception {
        Node n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "sumurl");
        this.url = XMLUtils.getTheValue(n);
        this.url = this.adaptURL(this.url);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "sumsoap");
        this.soap = XMLUtils.getTheValue(n);
        this.soap = this.soap.replace("XXHSNRXX", this.hsnr);
        this.soap = this.soap.replace("XXJAHRXX", this.jahr);
        System.out.println(this.datentyp + "\n" + this.soap);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "sumreplacenode");
        this.replaceNodeName = XMLUtils.getAttribValue(n, "from");
        log.fine(this.datentyp + "\nSOAP Aufruf:\n" + this.soap);
        StringBuffer data1 = new StringBuffer();
        Iterator<String> it = this.finanzstellen.iterator();
        int i = 0;
        while (it.hasNext()) {
            String fistl = it.next();
            if (++i % 10 == 0) {
                System.out.print(i + " ");
            }
            String tmpsoap = this.soap.replace("XXFISTLXX", fistl);
            String result = this.readSOAP(tmpsoap, this.url).toString();
            this.resultDocument = XMLUtils.buildDocumentFromString(result, false);
            if (!this.isReplyOk()) {
                String msg = "Error: Aufruf von Webservice fuer Summendaten " + this.datentyp + " (" + this.xmlConfig + ") FISTL:" + fistl + " fehlgeschlagen" + result;
                System.out.println(msg);
                log.severe(msg);
                LogUtils.close("wc");
                System.exit(-1);
            }
            if (result.indexOf("Es wurden 0000 S\u00e4tze gefunden!") > -1 || result.indexOf("Es wurden 0000 Belege gefunden!") > -1 || result.indexOf("Es wurden 00000 Belege gefunden!") > -1 || result.indexOf("<EX_FMIOI/>") > -1 || result.indexOf("<EX_FMBDT/>") > -1 || result.indexOf("<EX_FMIT/>") > -1) continue;
            data1.append(result);
        }
        System.out.println("");
        this.data = data1.toString();
        this.data = this.data.replaceAll("<\\?xml version=\"1.0\" encoding=\".*>", "");
        this.data = WebserviceClientSummendaten.purge(this.data);
        this.data = StringUtils.replace(this.data, this.replaceNodeName, "response");
        this.writeChangeXml();
    }

    private void readConfig() {
        this.xmlConfig = GetOpts.getValue("-xmlconfig");
        this.outfile = GetOpts.getValue("-out");
        this.xslpfad = GetOpts.getValue("-xslpfad");
        this.hsnr = GetOpts.getValue("-hsnr");
        this.jahr = GetOpts.getValue("-jahr");
        this.datentyp = GetOpts.getValue("-datentyp");
        this.dbpropfile = GetOpts.getValue("-dbproperties");
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        log.info("\nHochschulnummer " + this.hsnr);
        if (GetOpts.isPresent("-nodelete")) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        log.log(Level.INFO, "Geschaeftsjahr " + this.jahr);
        System.out.println("Geschaeftsjahr " + this.jahr);
        log.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        this.configDocument = XMLUtils.buildDocument(new File(this.xmlConfig));
    }

    private void writeChangeXml() throws Exception {
        File f = File.createTempFile("webservicedata", ".xml");
        if (!this.isDeleteTmpXmlFileWanted) {
            System.out.println("Temp Datei: " + f.getAbsolutePath());
            log.info("Temp Datei: " + f.getAbsolutePath());
        }
        if (f.exists()) {
            f.delete();
        }
        PrintWriter fw = new PrintWriter(f, "UTF-8");
        BufferedWriter bfw = new BufferedWriter(fw);
        bfw.write("<newdata>\n");
        bfw.write(this.data);
        bfw.write("\n</newdata>\n");
        bfw.close();
        fw.close();
        SxTransformer sxTrans = new SxTransformer(log, this.outfile);
        sxTrans.quellstring = f.getAbsolutePath();
        sxTrans.stylesheet = this.xslpfad + File.separator + "sum_soap_to_csv_" + this.datentyp + ".xsl";
        sxTrans.params = "ignoreElements=EX_JEST";
        sxTrans.transformFile("text");
        if (this.isDeleteTmpXmlFileWanted) {
            f.delete();
        }
    }

    private boolean isReplyOk() {
        boolean result = false;
        if (!XMLUtils.hasANodeWithName(this.resultDocument, "TYPE")) {
            System.out.println(this.data);
            log.severe(this.data);
        } else {
            Node type = XMLUtils.getFirstNode(this.resultDocument, "TYPE");
            if (XMLUtils.getTheValue(type).equals("I")) {
                result = true;
            }
        }
        return result;
    }
}

