/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.ExceptionHandler;
import de.memtext.util.GetOpts;
import de.memtext.util.XMLUtils;
import de.superx.bin.SxDBUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnlFileConverter {
    private static String _dateiPfad = "";
    private static String DELIMITER = "^";
    private static String _outDateiPfad = "";
    private static String _tabelle = "";
    private static String _indescr = "";
    private static String _outdescr = "";
    private static String logfile = "../conf/logging.properties";
    private static String dbpropfile = "";
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin.UnlFileConverter -logger:<Pfad zu logging.properties> -IN:<Pfad zur unl-Datei> -OUT:<Pfad zur Ausgabedatei> -INDESCR:<Pfad zum Eingabe-Descriptor> -OUTDESCR:<Pfad zum Ausgabe-Descriptor> -dbproperties:<Pfad zu db.properties> -table:<Tabellenname (wenn auch die Tabelle auf Typkompatitibilit\u00e4t gechekct werden soll>.\n---------------------------------------------------";
    private static String indescr_name = "";
    private static String indescr_dbsystem = "";
    private static String indescr_app = "";
    private static String indescr_cmd = "";
    private static String in_rec_sep = "";
    private static String in_line_sep = "";
    private static String in_rec_header = "";
    private static String in_rec_footer = "";
    private static String in_header = "";
    private static String in_header_delim = "";
    private static boolean in_fixedwidth = false;
    private static String in_escapemode = "";
    private static String in_chmod = "";
    private static String out_rec_sep = "";
    private static String out_line_sep = "";
    private static String out_rec_header = "";
    private static String out_rec_footer = "";
    private static String out_header = "";
    private static String out_header_delim = "";
    private static boolean out_fixedwidth = false;
    private static String out_escapemode = "";
    private static String out_chmod = "";
    private static int plaintextcount = 0;
    private static Document inDocument;
    private static Document outDocument;
    private static String plaintextTag;
    private static String[] searchtext;
    private static String[] replacetext;
    private static final String newline = "{newline}";
    private static final String tab = "{tab}";
    Logger logger = Logger.getLogger(UnlFileConverter.class.toString());
    private ExceptionHandler exceptionHandler = new ExceptionHandler(false);

    public static void main(String[] args) throws FileNotFoundException, IOException {
        File f;
        UnlFileConverter r = new UnlFileConverter();
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-logger,-IN,-I_DESCR");
        if (isdrin != null) {
            System.err.println("Datei-Pfade werden als Parameter erwartet. Folgende Optionen fehlen: " + isdrin);
            r.zeige_hilfe();
            System.exit(1);
        }
        if (GetOpts.isPresent("-logger")) {
            logfile = GetOpts.getValue("-logger");
        }
        if (!(f = new File(logfile)).exists()) {
            throw new IOException("Datei nicht gefunden: " + logfile);
        }
        FileInputStream ins = new FileInputStream(logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        logfile = MyLogManager.getProperty(".level");
        if (GetOpts.isPresent("-IN")) {
            _dateiPfad = GetOpts.getValue("-IN");
        }
        if (GetOpts.isPresent("-OUT")) {
            _outDateiPfad = GetOpts.getValue("-OUT");
        }
        if (GetOpts.isPresent("-I_DESCR")) {
            _indescr = GetOpts.getValue("-I_DESCR");
        }
        if (GetOpts.isPresent("-O_DESCR")) {
            _outdescr = GetOpts.getValue("-O_DESCR");
        }
        if (GetOpts.isPresent("-dbproperties")) {
            dbpropfile = GetOpts.getValue("-dbproperties");
        }
        if (GetOpts.isPresent("-table")) {
            if (dbpropfile.equals("")) {
                System.err.println("Wenn auch die Ziel-Tabelle gepr\u00fcft werden soll, dann muss dbproperties gesetzt sein.");
                System.err.println(usage);
                System.exit(1);
            } else {
                _tabelle = GetOpts.getValue("-table");
            }
        }
        if (args[0].toString().equals("?") || args[0].toString().equals("/?") || args[0].toString().equals("\\?") || args[0].toString().toLowerCase().equals("-h") || args[0].toString().toLowerCase().equals("--h")) {
            r.zeige_hilfe();
            System.exit(1);
        }
        UnlFileConverter.init_descr();
        try {
            r.updateFile(_dateiPfad, _outDateiPfad);
            System.out.println("Datei: " + _dateiPfad + " nach " + _outDateiPfad + " umgesetzt");
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    private void updateFile(String inDateiPfad, String outDateiPfad) throws IOException, Exception {
        File f = new File(inDateiPfad);
        if (!f.exists()) {
            throw new Exception("Datei nicht gefunden: " + inDateiPfad);
        }
        File out_tmp = inDateiPfad.equals(outDateiPfad) ? new File(inDateiPfad + ".tmp2") : new File(outDateiPfad);
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(out_tmp)));
        String text = in.readLine();
        while (text != null) {
            if (text.startsWith(in_rec_header)) {
                text = StringUtils.substringAfter((String)text, (String)in_rec_header);
            }
            text = this.createRow(in, text + out_rec_header);
            text = StringUtils.chomp((String)text, (String)in_rec_footer);
            text = text + out_rec_footer;
            text = this.replacePlainText(text);
            this.checkTable(text);
            out.write(text, 0, text.length());
            out.write(out_rec_sep);
            out.flush();
            text = in.readLine();
        }
        in.close();
        out.close();
        if (inDateiPfad.equals(outDateiPfad)) {
            File neuFile = new File(outDateiPfad);
            if (neuFile.isFile()) {
                neuFile.delete();
            }
            if (!out_tmp.renameTo(neuFile)) {
                this.logger.severe("Kann " + outDateiPfad + " nicht erzeugen! Existiert die Datei bereits? Die umgesetzte Datei befindet sich in " + out_tmp.getPath() + System.getProperty("file.separator") + out_tmp.getName());
            } else {
                out_tmp.delete();
            }
        }
        if (!out_chmod.equals("") && !this.chmode(out_chmod, outDateiPfad)) {
            this.logger.severe("Kann Berechtigung nicht \u00e4ndern " + outDateiPfad);
        }
        in.close();
        out.close();
    }

    private String createRow(BufferedReader in, String text) throws IOException {
        try {
            if (text.endsWith(in_line_sep) && !in_line_sep.equals("")) {
                text = StringUtils.chomp((String)text, (String)in_line_sep);
                text = text + out_line_sep;
                String tt = in.readLine();
                if (tt != null) {
                    text = text + StringUtils.chomp((String)tt, (String)in_line_sep);
                    while (tt.endsWith(in_line_sep)) {
                        tt = in.readLine();
                        if (tt == null) continue;
                        text = text + out_line_sep + StringUtils.chomp((String)tt, (String)in_line_sep);
                    }
                }
            } else {
                text = SxDBUtils.replaceString(text, in_line_sep, out_line_sep);
            }
        }
        catch (Exception e) {
            this.logger.severe("Fehler beim Umsetzen: " + e.toString() + "\n" + text);
            throw new IOException();
        }
        return text;
    }

    private void checkTable(String text) throws Exception {
        if (!_tabelle.equals("") && !_tabelle.equals("null")) {
            int numFelder = 0;
            try {
                numFelder = SxDBUtils.fieldCount(_tabelle);
            }
            catch (Exception e) {
                System.err.println("Fehler beim Abfragen der Tabellen-Metadaten: " + e.toString());
            }
            int k = 0;
            int i = 0;
            int p = 0;
            do {
                if ((p = text.indexOf(DELIMITER, i)) <= 0) continue;
                ++k;
                i = p + 1;
            } while (p > 0);
            if (k != numFelder) {
                throw new Exception("unl-Datei entspricht nicht der Tabelle in der Datenbank;\nDie Tabelle hat " + numFelder + " Felder, die unl-Datei hat " + k + " Felder ");
            }
        }
    }

    private boolean chmode(String inBerechtigung, String inDat) {
        String befehl = "chmod " + inBerechtigung + " " + inDat;
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(befehl);
            int n = p.waitFor();
        }
        catch (Exception e) {
            this.logger.severe("Error: " + e.toString());
            return false;
        }
        return true;
    }

    private String replacePlainText(String inS) {
        String outS = "";
        for (int i = 0; i <= plaintextcount - 1; ++i) {
            outS = searchtext[i].equals("") && replacetext[i].equals("") || searchtext[i].equals(replacetext[i]) ? inS : SxDBUtils.replaceString(inS, searchtext[i], replacetext[i]);
            inS = outS;
        }
        return outS;
    }

    private String reorgString(String inS) throws Exception {
        int ldPos = inS.lastIndexOf(DELIMITER);
        if (ldPos + 1 < inS.length() || ldPos == -1) {
            return inS;
        }
        return inS.substring(0, ldPos);
    }

    public boolean check_param_ok(String[] inTab) {
        if (inTab.length < 2) {
            System.out.println("Mindestens 2 Parameter erwartet! Mit -h oder ? rufen sie Hilfe auf.");
            return false;
        }
        _dateiPfad = inTab[0].trim();
        _outDateiPfad = inTab[1].trim();
        if (inTab.length >= 3) {
            DELIMITER = inTab[2].trim();
        }
        if (inTab.length > 3) {
            _tabelle = inTab[3].toString().trim();
        }
        return true;
    }

    private boolean check_Directory(File inFile) {
        if (inFile.exists()) {
            if (!inFile.isDirectory()) {
                System.out.println(inFile + " ist kein Verzeichnis!");
                return false;
            }
        } else {
            System.out.println(inFile + " Verzeichniss nicht gefunden!");
            return false;
        }
        return true;
    }

    private void progEnde() {
        System.runFinalization();
        System.exit(0);
    }

    private static void init_descr() {
        Node myNode;
        Node myNode2;
        XMLUtils.getExceptionHandler().setWithGui(false);
        XMLUtils.getExceptionHandler().setExitWanted(true);
        inDocument = XMLUtils.buildDocument(new File(_indescr), false);
        NodeList myInNodes = inDocument.getElementsByTagName(plaintextTag);
        outDocument = XMLUtils.buildDocument(new File(_outdescr), false);
        NodeList myOutNodes = outDocument.getElementsByTagName(plaintextTag);
        int i = 0;
        for (i = 0; i < myInNodes.getLength(); ++i) {
            Node myInNode = myInNodes.item(i);
            if (myInNode.getNodeType() == 3) continue;
            String plaintexttype = XMLUtils.getAttribValue(myInNode, "type");
            try {
                UnlFileConverter.searchtext[i] = XMLUtils.getTheValue(myInNode);
            }
            catch (IllegalArgumentException e) {
                UnlFileConverter.searchtext[i] = "";
            }
            UnlFileConverter.searchtext[i] = SxDBUtils.replaceString(searchtext[i], tab, "\t");
            UnlFileConverter.searchtext[i] = SxDBUtils.replaceString(searchtext[i], newline, "\n");
            for (int k = 0; k < myOutNodes.getLength(); ++k) {
                Node myOutNode = myOutNodes.item(k);
                if (!XMLUtils.getAttribValue(myOutNode, "type").equals(plaintexttype)) continue;
                try {
                    UnlFileConverter.replacetext[i] = XMLUtils.getTheValue(myOutNode);
                }
                catch (IllegalArgumentException e) {
                    UnlFileConverter.replacetext[i] = "";
                }
                UnlFileConverter.replacetext[i] = SxDBUtils.replaceString(replacetext[i], tab, "\t");
                UnlFileConverter.replacetext[i] = SxDBUtils.replaceString(replacetext[i], newline, "\n");
            }
        }
        plaintextcount = i;
        try {
            myNode2 = XMLUtils.getFirstNode(inDocument, "record-separator");
            in_rec_sep = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            in_rec_sep = newline;
        }
        if (in_rec_sep.endsWith(newline)) {
            in_rec_sep = StringUtils.chomp((String)in_rec_sep, (String)newline);
        }
        try {
            myNode2 = XMLUtils.getFirstNode(outDocument, "record-separator");
            out_rec_sep = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            out_rec_sep = newline;
        }
        if (out_rec_sep.endsWith(newline)) {
            out_rec_sep = StringUtils.chomp((String)out_rec_sep, (String)newline) + "\n";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(inDocument, "line-separator");
            in_line_sep = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            in_line_sep = newline;
        }
        if (in_line_sep.endsWith(newline)) {
            in_line_sep = StringUtils.chomp((String)in_line_sep, (String)newline) + "\n";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(outDocument, "line-separator");
            out_line_sep = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            out_line_sep = newline;
        }
        if (out_line_sep.endsWith(newline)) {
            out_line_sep = StringUtils.chomp((String)out_line_sep, (String)newline) + "\n";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(inDocument, "record-header");
            in_rec_header = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            in_rec_header = "";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(outDocument, "record-header");
            out_rec_header = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            out_rec_header = "";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(inDocument, "record-footer");
            in_rec_footer = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            in_rec_footer = "";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(outDocument, "record-footer");
            out_rec_footer = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            out_rec_footer = "";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(inDocument, "header");
            in_header = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            in_header = "";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(outDocument, "header");
            out_header = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            out_header = "";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(inDocument, "header-delim");
            in_header_delim = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            in_header_delim = "^";
        }
        try {
            myNode2 = XMLUtils.getFirstNode(outDocument, "header-delim");
            out_header_delim = XMLUtils.getTheValue(myNode2);
        }
        catch (IllegalArgumentException e) {
            out_header_delim = "^";
        }
        String s = "";
        try {
            myNode = XMLUtils.getFirstNode(inDocument, "fixedwidth");
            s = XMLUtils.getTheValue(myNode);
        }
        catch (IllegalArgumentException e) {
            s = "";
        }
        in_fixedwidth = s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes");
        try {
            myNode = XMLUtils.getFirstNode(outDocument, "fixedwidth");
            s = XMLUtils.getTheValue(myNode);
        }
        catch (IllegalArgumentException e) {
            s = "";
        }
        out_fixedwidth = s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes");
        try {
            myNode = XMLUtils.getFirstNode(inDocument, "escapemode");
            in_escapemode = XMLUtils.getTheValue(myNode);
        }
        catch (IllegalArgumentException e) {
            in_escapemode = "";
        }
        try {
            myNode = XMLUtils.getFirstNode(inDocument, "chmod");
            in_chmod = XMLUtils.getTheValue(myNode);
        }
        catch (IllegalArgumentException e) {
            in_chmod = "";
        }
        try {
            myNode = XMLUtils.getFirstNode(outDocument, "escapemode");
            out_escapemode = XMLUtils.getTheValue(myNode);
        }
        catch (IllegalArgumentException e) {
            out_escapemode = "";
        }
        try {
            myNode = XMLUtils.getFirstNode(outDocument, "chmod");
            out_chmod = XMLUtils.getTheValue(myNode);
        }
        catch (IllegalArgumentException e) {
            out_chmod = "";
        }
    }

    private void zeige_hilfe() {
        System.out.println("\n Diese Klasse bereinigt die Zeilen der angegebenen ASCII-Dateien.");
        System.out.println(" Es wird der letzte Delimeter-Zeichen aus jeder Zeile entfernt.");
        System.out.println("\n Parameter: ");
        System.out.println("1. Eingabe-Dateiname mit Pfadangabe ");
        System.out.println("2. Ausgabe-Dateiname mit Pfadangabe");
        System.out.println("3. Delimiter-Zeichen(optional)");
        System.out.println("4. Tabellenname in der Datenbank, der auf \u00dcbereistimmung der Felderanzahl gepr\u00fcft werden soll (optional, wenn keine \u00dcberpr\u00fcfung, dann 'none').");
        System.out.println(" Defaultwert fuer Delimiter ist ^. \n");
    }

    static {
        plaintextTag = "plaintext";
        searchtext = new String[10];
        replacetext = new String[10];
    }
}

