/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import de.memtext.widgets.ScrollableTextArea;
import de.memtext.widgets.TitledContainerDec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;

public class TitledTextScrollArea
extends JPanel {
    private TitledContainerDec titleCont;
    private ScrollableTextArea scrollableTextArea;

    public TitledTextScrollArea(String title) {
        this(title, 70);
    }

    public TitledTextScrollArea(String title, int maxHeight) {
        super(new BorderLayout());
        this.scrollableTextArea = new ScrollableTextArea(maxHeight);
        this.titleCont = new TitledContainerDec(this.scrollableTextArea, title);
        this.add((Component)this.titleCont, "Center");
        this.scrollableTextArea.setEditable(true);
        this.scrollableTextArea.setLineWrap(true);
        this.scrollableTextArea.setWrapStyleWord(true);
    }

    public void setTitleFont(Font f) {
        this.titleCont.setTitleFont(f);
    }

    public void setTitleText(String title) {
        this.titleCont.setTitleText(title);
    }

    public void setText(String txt) {
        this.scrollableTextArea.setText(txt);
    }

    public String getText() {
        return this.scrollableTextArea.getText();
    }

    public void setTitleBackground(Color c) {
        if (this.titleCont != null) {
            this.titleCont.setTitleBackground(c);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.scrollableTextArea != null) {
            this.scrollableTextArea.setBackground(c);
        }
        if (this.titleCont != null) {
            this.titleCont.setBackground(c);
        }
    }

    public void setEditable(boolean b) {
        this.scrollableTextArea.setEditable(b);
    }

    public void setColumns(int cols) {
        this.scrollableTextArea.setColumns(cols);
    }
}

