/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.icons;

import de.memtext.icons.ArrowRight;
import de.memtext.widgets.MBFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;

public abstract class BasicIcon
implements Icon {
    private int iconWidth = 16;
    private int iconHeight = 16;
    private Color color = Color.black;

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(x, y);
        if (c.isEnabled()) {
            g.setColor(this.color);
        } else {
            g.setColor(Color.GRAY);
        }
        this.myPaint(g);
        g.translate(-x, -y);
    }

    abstract void myPaint(Graphics var1);

    void drawDoubleLine(Graphics g, int y) {
        if (y > this.getIconHeight() - 2) {
            throw new IllegalArgumentException("can't draw that low");
        }
        g.drawLine(0, y, this.getIconWidth(), y);
        g.drawLine(0, y + 1, this.getIconWidth(), y + 1);
    }

    void drawArrowRight(Graphics g) {
        int midx = (int)Math.floor(this.getIconWidth() / 2);
        int midy = (int)Math.floor(this.getIconHeight() / 2);
        g.drawLine(0, midy - 1, this.getIconWidth(), midy - 1);
        g.drawLine(0, midy, this.getIconWidth(), midy);
        g.drawLine(0, midy + 1, this.getIconWidth(), midy + 1);
        g.drawLine(midx + 1, 1, this.getIconWidth(), midy - 1);
        g.drawLine(midx + 1, 2, this.getIconWidth(), midy);
        g.drawLine(midx + 1, this.getIconHeight() - 1, this.getIconWidth(), midy + 1);
        g.drawLine(midx + 1, this.getIconHeight() - 2, this.getIconWidth(), midy);
    }

    void drawArrowUp(Graphics g, int y) {
        int midx = (int)Math.floor(this.getIconWidth() / 2);
        int midy = (int)Math.floor(this.getIconHeight() / 2);
        g.drawLine(0, y + midy, midx, y);
        g.drawLine(midx, y, this.getIconWidth(), y + midy);
        g.drawLine(0, y + midy + 1, midx, y + 1);
        g.drawLine(midx, y + 1, this.getIconWidth(), y + midy + 1);
    }

    void drawArrowDown(Graphics g, int y) {
        int midx = (int)Math.floor(this.getIconWidth() / 2);
        int midy = (int)Math.floor(this.getIconHeight() / 2);
        g.drawLine(0, y, midx, midy + y);
        g.drawLine(midx, y + midy, this.getIconWidth(), y);
        g.drawLine(0, y + 1, midx, midy + y + 1);
        g.drawLine(midx, y + midy + 1, this.getIconWidth(), y + 1);
    }

    public static void main(String[] args) {
        MBFrame f = new MBFrame("test");
        f.setCenter(new JButton("test", new ArrowRight()));
        f.pack();
        f.show();
    }

    public void setIconHeight(int i) {
        this.iconHeight = i;
    }

    public void setIconWidth(int i) {
        this.iconWidth = i;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

