/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.baseobjects.NamedIdObject;
import de.memtext.baseobjects.NamedIdObjectWithParent;
import de.memtext.baseobjects.coll.NamedIdObjectList;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentList;
import de.memtext.db.DbUtils;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.ExceptionHandler;
import de.memtext.util.StringUtils;
import de.memtext.widgets.WarningMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBAccess {
    private String name;
    private Connection con = null;
    private Statement stmt = null;
    private boolean isInJar = false;
    private int updateCount;
    private List loggerList = new LinkedList();
    private static IllegalStateException illegalStateEx = new IllegalStateException("DBAccess not inited - connection is null");
    private boolean isThrowRuntimeExceptionsActive;
    private static Map<String, DBAccess> entries = new HashMap<String, DBAccess>();
    private ExceptionHandler exceptionHandler = new ExceptionHandler(true);

    public static DBAccess get(String name) {
        DBAccess one = entries.get(name);
        if (one != null) {
            Connection con = one.getConnection();
            try {
                if (con.isClosed()) {
                    throw new RuntimeException("DBAccess: Connection already closed!");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("DBAccess: Cannot check for closed connection.", e);
            }
        }
        return one;
    }

    public Connection getConn() {
        return this.con;
    }

    public static boolean hasConnection(String name) {
        return entries.containsKey(name);
    }

    public static void addConnection(String name, Connection con) throws SQLException {
        DBAccess dba = DBAccess.get(name);
        if (dba == null || dba.getConnection().isClosed()) {
            entries.put(name, new DBAccess(name, con));
        }
    }

    public static void removeConnection(String name) throws SQLException {
        DBAccess dba = DBAccess.get(name);
        if (dba != null && !dba.getConnection().isClosed()) {
            dba.closeConnection();
            entries.remove(name);
        }
    }

    private DBAccess(String name, Connection con) throws SQLException {
        this.name = name;
        this.con = con;
        if (con.getMetaData().getDriverName().equals("HSQL Database Engine Driver") && con.getMetaData().getURL().indexOf("res:") > 0) {
            this.isInJar = true;
        }
        this.stmt = con.createStatement();
    }

    public Connection getConnection() {
        return this.con;
    }

    public boolean isInJar() {
        return this.isInJar;
    }

    public String getName() {
        return this.name;
    }

    public void setDatabase(String datenbank) {
        throw new UnsupportedOperationException();
    }

    public static void closeConnection(String name) {
        DBAccess.get(name).closeConnection();
    }

    public void closeConnection() {
        try {
            this.stmt.close();
            this.con.close();
            this.con = null;
        }
        catch (Exception e) {
            this.handle("Couldn't close database connection", e);
        }
        entries.remove(this);
    }

    public String getTableNames() {
        StringBuffer result = new StringBuffer("Tabellen in der Datenbank:");
        try {
            DatabaseMetaData meta = this.con.getMetaData();
            ResultSet rs = null;
            rs = meta.getTables(null, null, null, null);
            while (rs.next()) {
                result.append(rs.getObject(3) + "  ");
            }
            rs.close();
        }
        catch (Exception e) {
            this.handle("", e);
        }
        return result.toString();
    }

    public boolean hasTable(String tablename) {
        boolean result = false;
        try {
            ResultSet rs = this.con.getMetaData().getTables(null, null, null, null);
            while (rs.next()) {
                if (!tablename.equalsIgnoreCase(rs.getObject(3).toString())) continue;
                result = true;
                break;
            }
            rs.close();
        }
        catch (Exception e) {
            this.handle("", e);
        }
        return result;
    }

    public StringBuffer getSeperatedString(String sql) {
        return this.getSeperatedString(sql, ",");
    }

    public StringBuffer getSeperatedString(String sql, String separator) {
        StringBuffer erg = new StringBuffer();
        try {
            ResultSet result = this.stmt.executeQuery(sql);
            this.logFine(sql);
            while (result.next()) {
                Object value = result.getObject(1);
                if (value == null) {
                    erg.append("null" + separator);
                    continue;
                }
                erg.append("'" + value + "'" + separator);
            }
            result.close();
        }
        catch (Exception e) {
            this.handle("", e);
        }
        if (erg.length() > 0) {
            StringUtils.deleteLastChar(erg);
        }
        return erg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String pstSql, Object ... args) {
        String erg = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = this.con.prepareStatement(pstSql);
            int paramPos = 1;
            for (Object arg : args) {
                pst.setObject(paramPos, arg);
                ++paramPos;
            }
            rs = pst.executeQuery();
            this.logFine(pstSql);
            if (rs.next()) {
                erg = rs.getString(1);
            }
        }
        catch (Exception e) {
            this.handle("sql:" + pstSql, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (SQLException sex) {
                this.handle("sql:" + pstSql, sex);
            }
        }
        return erg;
    }

    private void logFine(String txt) {
        for (Logger logger : this.loggerList) {
            logger.fine(txt);
        }
    }

    private void logInfo(String txt) {
        for (Logger logger : this.loggerList) {
            logger.info(txt);
        }
    }

    public Vector getStringVector(String sql) {
        Vector<String> v = new Vector<String>();
        ResultSet rs = null;
        try {
            rs = this.stmt.executeQuery(sql);
            this.logFine(sql);
            while (rs.next()) {
                String item = rs.getString(1);
                v.add(item);
            }
            rs.close();
        }
        catch (Exception e) {
            this.handle("", e);
        }
        return v;
    }

    public int execute(String sql) {
        try {
            if (this.con == null) {
                throw illegalStateEx;
            }
            this.logInfo(sql);
            this.updateCount = this.stmt.executeUpdate(sql);
        }
        catch (Exception e) {
            this.handle("", e);
        }
        return this.updateCount;
    }

    public int executeFineLog(String sql) {
        try {
            if (this.con == null) {
                throw illegalStateEx;
            }
            this.logFine(sql);
            this.updateCount = this.stmt.executeUpdate(sql);
        }
        catch (Exception e) {
            this.handle("", e);
        }
        return this.updateCount;
    }

    public void log(Level level, String text) {
        for (Logger logger : this.loggerList) {
            logger.log(level, text);
        }
    }

    public void checkIfOneRowWasUpdated() {
        if (this.getUpdateCount() != 1) {
            this.handle("", new Exception(this.getUpdateCount() + " row(s) changed, 1 expected"));
        }
    }

    private int getUpdateCount() {
        return this.updateCount;
    }

    public void insert(String sql, Object o1) {
        StringBuffer sqlbuf = new StringBuffer(sql);
        this.insertAppend(sqlbuf, o1);
        StringUtils.deleteLastChar(sqlbuf);
        sqlbuf.append(")");
        this.execute(sqlbuf.toString());
    }

    public void insert(String sql, Object o1, Object o2) {
        StringBuffer sqlbuf = new StringBuffer(sql);
        this.insertAppend(sqlbuf, o1);
        this.insertAppend(sqlbuf, o2);
        StringUtils.deleteLastChar(sqlbuf);
        sqlbuf.append(")");
        this.execute(sqlbuf.toString());
    }

    public void insert(String sql, Object o1, Object o2, Object o3) {
        StringBuffer sqlbuf = new StringBuffer(sql);
        this.insertAppend(sqlbuf, o1);
        this.insertAppend(sqlbuf, o2);
        this.insertAppend(sqlbuf, o3);
        StringUtils.deleteLastChar(sqlbuf);
        sqlbuf.append(")");
        this.execute(sqlbuf.toString());
    }

    public void insert(String sql, Object o1, Object o2, Object o3, Object o4) {
        StringBuffer sqlbuf = new StringBuffer(sql);
        this.insertAppend(sqlbuf, o1);
        this.insertAppend(sqlbuf, o2);
        this.insertAppend(sqlbuf, o3);
        this.insertAppend(sqlbuf, o4);
        StringUtils.deleteLastChar(sqlbuf);
        sqlbuf.append(")");
        this.execute(sqlbuf.toString());
    }

    public void insert(String sql, Object o1, Object o2, Object o3, Object o4, Object o5) {
        StringBuffer sqlbuf = new StringBuffer(sql);
        this.insertAppend(sqlbuf, o1);
        this.insertAppend(sqlbuf, o2);
        this.insertAppend(sqlbuf, o3);
        this.insertAppend(sqlbuf, o4);
        this.insertAppend(sqlbuf, o5);
        StringUtils.deleteLastChar(sqlbuf);
        sqlbuf.append(")");
        this.execute(sqlbuf.toString());
    }

    public void insert(String sql, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        StringBuffer sqlbuf = new StringBuffer(sql);
        this.insertAppend(sqlbuf, o1);
        this.insertAppend(sqlbuf, o2);
        this.insertAppend(sqlbuf, o3);
        this.insertAppend(sqlbuf, o4);
        this.insertAppend(sqlbuf, o5);
        this.insertAppend(sqlbuf, o6);
        StringUtils.deleteLastChar(sqlbuf);
        sqlbuf.append(")");
        this.execute(sqlbuf.toString());
    }

    private void insertAppend(StringBuffer buf, Object x) {
        if (x != null) {
            if (x instanceof String) {
                String txt = x.toString();
                int len = txt.length();
                if (len == 0 || txt.charAt(0) != '\'') {
                    buf.append("'");
                }
                buf.append(x);
                if (len == 0 || txt.charAt(txt.length() - 1) != '\'') {
                    buf.append("'");
                }
                int n = 1242;
            } else {
                buf.append(x);
            }
        } else {
            buf.append("null");
        }
        buf.append(",");
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.con == null) {
            throw illegalStateEx;
        }
        this.logFine(sql);
        this.stmt.close();
        this.stmt = this.con.createStatement();
        ResultSet rs = this.stmt.executeQuery(sql);
        return rs;
    }

    public void executeIgnoreExceptions(String sql) {
        try {
            this.logInfo(sql);
            this.stmt.execute(sql);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DatabaseMetaData getDatabaseMetaData() {
        if (this.con == null) {
            throw illegalStateEx;
        }
        DatabaseMetaData m = null;
        try {
            m = this.con.getMetaData();
        }
        catch (Exception e) {
            this.handle("Couldn't get database metadata", e);
        }
        return m;
    }

    public List getObjectList(String sql) {
        LinkedList<Object> result = new LinkedList<Object>();
        try {
            ResultSet rs = this.stmt.executeQuery(sql);
            this.logFine(sql);
            while (rs.next()) {
                result.add(rs.getObject(1));
            }
            rs.close();
        }
        catch (Exception e) {
            this.handle("", e);
        }
        return result;
    }

    public Object[] getTablesStartingWith(String prefix) {
        if (this.con == null) {
            throw illegalStateEx;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            ResultSet rs = this.con.getMetaData().getTables(null, null, prefix + "%", null);
            while (rs.next()) {
                list.add(rs.getString(3));
            }
            rs.close();
        }
        catch (Exception e) {
            this.handle("", e);
        }
        Object[] result = list.toArray();
        Arrays.sort(result);
        return result;
    }

    public Double getDoubleValue(String sql) {
        Double val = null;
        try {
            ResultSet rs = this.executeQuery(sql);
            this.logFine(sql);
            rs.next();
            Object o = rs.getObject(1);
            rs.close();
            if (o instanceof Double) {
                val = (Double)o;
            } else if (o instanceof BigDecimal) {
                BigDecimal merk = (BigDecimal)o;
                val = new Double(merk.doubleValue());
            } else if (o != null) {
                val = new Double(o.toString());
            }
        }
        catch (SQLException e) {
            this.handle("sql was:" + sql, e);
        }
        return val;
    }

    public Double getDoubleValueOld(String sql) {
        Object erg = null;
        Double val = null;
        erg = this.getValue(sql);
        if (erg != null) {
            val = erg instanceof Double ? (Double)erg : new Double(erg.toString());
        }
        return val;
    }

    public Object getValue(String sql) {
        Double erg = null;
        try {
            List resultvector = this.getResultList(sql);
            List row1 = (List)resultvector.get(0);
            erg = (Double)row1.get(0);
            if (erg instanceof BigDecimal) {
                Double merk2;
                BigDecimal merk = (BigDecimal)((Object)erg);
                erg = merk2 = new Double(merk.doubleValue());
            }
        }
        catch (Exception e) {
            this.handle("", e);
        }
        return erg;
    }

    public Integer getIntegerIncremented(String query) {
        Double read = this.getDoubleValue(query);
        Integer erg = null;
        erg = read == null ? new Integer(1) : new Integer(read.intValue() + 1);
        return erg;
    }

    public static void main(String[] arg) {
    }

    public boolean hasColumn(String aTablename, String colname) {
        if (this.con == null) {
            throw illegalStateEx;
        }
        boolean result = false;
        try {
            if (!this.hasTable(aTablename)) {
                throw new IllegalArgumentException("Database doesn't contain table " + aTablename);
            }
            ResultSet rs = this.con.getMetaData().getColumns(null, null, aTablename.toUpperCase(), colname.toUpperCase());
            while (rs.next()) {
                result = true;
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            result = false;
        }
        catch (IllegalArgumentException e) {
            result = false;
        }
        return result;
    }

    public Date getDate(String query) {
        Date erg = null;
        Object o = null;
        try {
            ResultSet rs = this.stmt.executeQuery(query);
            this.logInfo(query);
            while (rs.next()) {
                if (!rs.isFirst()) continue;
                o = rs.getObject(1);
            }
            if (o != null) {
                erg = (Date)o;
            }
            rs.close();
        }
        catch (Exception e) {
            this.handle(query, e);
        }
        return erg;
    }

    public int getInt(String query, Object ... args) {
        Integer result = this.getInteger(query, args);
        if (result == null) {
            throw new RuntimeException("nothing or null found");
        }
        return result;
    }

    public Integer getInteger(String pstSQL, Object ... args) {
        Integer erg = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = this.con.prepareStatement(pstSQL);
            int paramPos = 1;
            for (Object arg : args) {
                pst.setObject(paramPos, arg);
                ++paramPos;
            }
            rs = pst.executeQuery();
            this.logFine(pstSQL);
            Object o = null;
            boolean isFirst = true;
            while (rs.next()) {
                if (!isFirst) continue;
                o = rs.getObject(1);
                isFirst = false;
            }
            if (o != null) {
                if (o instanceof Integer) {
                    erg = (Integer)o;
                } else if (o instanceof Long) {
                    erg = new Integer(((Long)o).intValue());
                } else if (o instanceof Short) {
                    erg = new Integer(((Short)o).intValue());
                } else {
                    throw new IllegalArgumentException("Unbekannter Datentyp in DBAccess getInteger:" + o.getClass() + " - " + pstSQL);
                }
            }
            rs.close();
        }
        catch (Exception e) {
            this.handle("", e);
        }
        return erg;
    }

    public void addLogger(Logger logger) {
        this.loggerList.add(logger);
    }

    public void removeLogger(Logger logger) {
        this.loggerList.remove(logger);
    }

    public static void createQuitOnException(String name, Connection connection) {
        try {
            DBAccess.addConnection(name, connection);
        }
        catch (Exception e) {
            System.out.println("Couldn't create database connection " + name + "\n" + e.toString());
            System.exit(-1);
        }
    }

    public List getTableList() {
        if (this.con == null) {
            throw illegalStateEx;
        }
        LinkedList<String> result = new LinkedList<String>();
        try {
            ResultSet rs = this.con.getMetaData().getTables(null, null, null, null);
            while (rs.next()) {
                result.add(rs.getObject(3).toString());
            }
            rs.close();
        }
        catch (SQLException e) {
            this.handle("", e);
        }
        return result;
    }

    public List getResultList(String sql) {
        List result = new LinkedList();
        try {
            ResultSet rs = this.executeQuery(sql);
            this.logFine(sql);
            result = DbUtils.toResultList(rs);
            rs.close();
        }
        catch (SQLException e) {
            this.handle("sql was:" + sql, e);
        }
        return result;
    }

    public int getColumnType(String tablename, String colname) {
        int result = -9999;
        try {
            if (!this.hasTable(tablename)) {
                throw new RuntimeException("Database doesn't contain table " + tablename);
            }
            if (!this.hasColumn(tablename, colname)) {
                throw new RuntimeException("Table " + tablename + " doesn't have column:" + colname);
            }
            ResultSet rs = this.con.getMetaData().getColumns(null, null, tablename.toUpperCase(), colname.toUpperCase());
            while (rs.next()) {
                result = rs.getInt(5);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.handle("", e);
        }
        catch (RuntimeException e) {
            this.handle("", e);
        }
        return result;
    }

    public int getColumnCount(String tablename) {
        int result = 0;
        try {
            if (!this.hasTable(tablename)) {
                throw new RuntimeException("Database doesn't contain table " + tablename);
            }
            ResultSet rs = this.con.getMetaData().getColumns(null, null, tablename.toUpperCase(), null);
            while (rs.next()) {
                ++result;
            }
            rs.close();
        }
        catch (SQLException e) {
            this.handle("", e);
        }
        catch (RuntimeException e) {
            this.handle("", e);
        }
        return result;
    }

    public List getColumnNames(String tablename) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            if (!this.hasTable(tablename)) {
                throw new RuntimeException("Database doesn't contain table " + tablename);
            }
            ResultSet rs = this.con.getMetaData().getColumns(null, null, tablename.toUpperCase(), null);
            while (rs.next()) {
                result.add(rs.getObject(4).toString());
            }
            rs.close();
        }
        catch (SQLException e) {
            this.handle("", e);
        }
        catch (RuntimeException e) {
            this.handle("", e);
        }
        return result;
    }

    public boolean isThrowRuntimeExceptionsActive() {
        return this.isThrowRuntimeExceptionsActive;
    }

    public void setThrowRuntimeExceptionsActive(boolean isThrowRuntimeExceptionsActive) {
        this.isThrowRuntimeExceptionsActive = isThrowRuntimeExceptionsActive;
    }

    public void handle(String txt, Exception e) {
        System.out.println(e);
        if (this.isThrowRuntimeExceptionsActive) {
            throw new RuntimeException(txt + " " + e.toString());
        }
        this.exceptionHandler.handle(txt, e);
    }

    public void handle(Exception e) {
        this.handle(null, e);
    }

    public void executeAndCheckUpdate1Row(String sql) {
        this.execute(sql);
        this.checkIfOneRowWasUpdated();
    }

    public void setProperty(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("no nulls allowed in properties table");
        }
        this.execute("delete from properties where name='key';insert into properties (name,value) values('" + key + "','" + value + "');");
    }

    public String getProperty(String key) {
        return this.getString("select value from properties where name='" + key + "'", new Object[0]);
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public NamedIdObjectList getNamedIdObjectList(String tablename, String idColName, String nameColName, String restriction, String orderby, Class targetClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        NamedIdObjectList result = new NamedIdObjectList();
        if (restriction == null) {
            restriction = "";
        }
        List rawList = this.getResultList("select " + idColName + "," + nameColName + " from " + tablename + " " + restriction + " " + orderby);
        Class[] constparams = new Class[]{Object.class, String.class};
        Object[] data = new Object[2];
        Constructor constr = targetClass.getConstructor(constparams);
        for (List row : rawList) {
            Object id = row.get(0);
            String name = "";
            if (row.get(1) != null) {
                name = row.get(1).toString();
            }
            data[0] = id;
            data[1] = name;
            Object o = constr.newInstance(data);
            result.add(o);
        }
        return result;
    }

    public NamedIdObjectList getNamedIdObjectList(String tablename, String idColName, String nameColName, String restriction, String orderby) {
        NamedIdObjectList result = null;
        try {
            result = this.getNamedIdObjectList(tablename, idColName, nameColName, restriction, orderby, NamedIdObject.class);
        }
        catch (SecurityException e) {
            WarningMessage.show(null, "Reflectionproblem bei DBAccess.getNamedIdObjectList", "");
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            WarningMessage.show(null, "Reflectionproblem bei DBAccess.getNamedIdObjectList", "");
            e.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException e) {
            WarningMessage.show(null, "Reflectionproblem bei DBAccess.getNamedIdObjectList", "");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            WarningMessage.show(null, "Reflectionproblem bei DBAccess.getNamedIdObjectList", "");
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            WarningMessage.show(null, "Reflectionproblem bei DBAccess.getNamedIdObjectList", "");
            e.printStackTrace();
            System.exit(1);
        }
        return result;
    }

    public NamedIdObjectWithParentList getNamedIdObjectWithParentList(String tablename, String idColName, String nameColName, String restriction) {
        NamedIdObjectWithParentList result = new NamedIdObjectWithParentList();
        if (restriction == null) {
            restriction = "";
        }
        List rawList = this.getResultList("select " + idColName + "," + nameColName + ",parent from " + tablename + " " + restriction);
        for (List row : rawList) {
            Object id = row.get(0);
            String name = "";
            if (row.get(1) != null) {
                name = row.get(1).toString();
            }
            Object parentKey = row.get(2);
            try {
                NamedIdObjectWithParent one = new NamedIdObjectWithParent(id, name, parentKey);
                result.add(one);
            }
            catch (KeyParentEqualException e) {
                this.handle(e);
            }
        }
        return result;
    }

    public void execute(StringBuffer sql) {
        this.execute(sql.toString());
    }
}

