/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog(DefaultLdapAuthoritiesPopulator.class);
    private GrantedAuthority defaultRole;
    private SpringSecurityLdapTemplate ldapTemplate;
    private SearchControls searchControls = new SearchControls();
    private String groupRoleAttribute = "cn";
    private String groupSearchBase;
    private String groupSearchFilter = "(member={0})";
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;

    public DefaultLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        this.ldapTemplate = new SpringSecurityLdapTemplate(contextSource);
        this.ldapTemplate.setSearchControls(this.searchControls);
        this.setGroupSearchBase(groupSearchBase);
    }

    protected Set<GrantedAuthority> getAdditionalRoles(DirContextOperations user, String username) {
        return null;
    }

    @Override
    public final Collection<GrantedAuthority> getGrantedAuthorities(DirContextOperations user, String username) {
        String userDn = user.getNameInNamespace();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting authorities for user " + userDn));
        }
        Set<GrantedAuthority> roles = this.getGroupMembershipRoles(userDn, username);
        Set<GrantedAuthority> extraRoles = this.getAdditionalRoles(user, username);
        if (extraRoles != null) {
            roles.addAll(extraRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        ArrayList<GrantedAuthority> result = new ArrayList<GrantedAuthority>(roles.size());
        result.addAll(roles);
        return result;
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        if (this.getGroupSearchBase() == null) {
            return Collections.emptySet();
        }
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for roles for user '" + username + "', DN = " + "'" + userDn + "', with filter " + this.groupSearchFilter + " in search base '" + this.getGroupSearchBase() + "'"));
        }
        Set<String> userRoles = this.ldapTemplate.searchForSingleAttributeValues(this.getGroupSearchBase(), this.groupSearchFilter, new String[]{userDn, username}, this.groupRoleAttribute);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Roles from search: " + userRoles));
        }
        for (String role : userRoles) {
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            authorities.add((GrantedAuthority)new GrantedAuthorityImpl(this.rolePrefix + role));
        }
        return authorities;
    }

    protected ContextSource getContextSource() {
        return this.ldapTemplate.getContextSource();
    }

    private void setGroupSearchBase(String groupSearchBase) {
        Assert.notNull((Object)groupSearchBase, (String)"The groupSearchBase (name to search under), must not be null.");
        this.groupSearchBase = groupSearchBase;
        if (groupSearchBase.length() == 0) {
            logger.info((Object)"groupSearchBase is empty. Searches will be performed from the context source base");
        }
    }

    protected String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new GrantedAuthorityImpl(defaultRole);
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        Assert.notNull((Object)groupRoleAttribute, (String)"groupRoleAttribute must not be null");
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        Assert.notNull((Object)groupSearchFilter, (String)"groupSearchFilter must not be null");
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        this.rolePrefix = rolePrefix;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.ldapTemplate.setIgnorePartialResultException(ignore);
    }
}

