/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CipherExtractor;
import de.werum.sis.crypt.CryptProperties;
import de.werum.sis.trace.ConsoleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TripleDESCipherExtractor
implements CipherExtractor {
    private ConsoleLogger lg = ConsoleLogger.getInstance();
    private CryptProperties properties;

    public TripleDESCipherExtractor(CryptProperties properties) {
        this.properties = properties;
    }

    public Cipher extractCipher(InputStream inputStream, boolean encrypt) throws GeneralSecurityException, IOException {
        return this.loadTripleDESKey(inputStream, encrypt);
    }

    protected Cipher loadTripleDESKey(InputStream inputStream, boolean encrypt) throws GeneralSecurityException, IOException {
        Cipher triple_des_cipher = null;
        ObjectInputStream o_is = new ObjectInputStream(inputStream);
        int toRead = o_is.available();
        int keyKenn = o_is.readInt();
        Integer userId = new Integer(keyKenn);
        if (!this.properties.containsUserId(userId)) {
            throw new GeneralSecurityException("TripleDESStreamDecrypter: Keine g\u00fcltige Crypt-UserId: " + userId);
        }
        int keyInKlartext = o_is.readInt();
        if (keyInKlartext != 0) {
            throw new GeneralSecurityException("TripleDESStreamDecrypter: 3DES-Schluessel liegt nicht im Klartext vor.");
        }
        triple_des_cipher = this.loadTripleDESKeyKlartext(o_is, encrypt, userId);
        return triple_des_cipher;
    }

    protected Cipher loadTripleDESKeyKlartext(ObjectInputStream inputStream, boolean encrypt, Integer userId) throws GeneralSecurityException, IOException {
        SecretKeySpec keySpec;
        IvParameterSpec iv;
        int keyLength = inputStream.readInt();
        byte[] key_enc = new byte[keyLength];
        inputStream.read(key_enc, 0, keyLength);
        int ivLength = inputStream.readInt();
        if (ivLength > 0) {
            byte[] iv_enc = new byte[ivLength];
            inputStream.read(iv_enc, 0, ivLength);
            iv = new IvParameterSpec(iv_enc);
        } else {
            iv = null;
        }
        SecretKeySpec triple_des_key = keySpec = new SecretKeySpec(key_enc, this.properties.getSymetricAlgorithm(userId));
        return this.initTripleDES(triple_des_key, iv, encrypt, userId);
    }

    protected Cipher initTripleDES(Key key, AlgorithmParameterSpec params, boolean encrypt, Integer userId) throws GeneralSecurityException {
        Cipher triple_des_cipher = null;
        this.lg.print(3, "Initialisiere den TripleDES-Algorithmus im CBC.");
        triple_des_cipher = Cipher.getInstance(this.properties.getSymetricAlgorithm(userId) + "/" + this.properties.getSymetricOpMode(userId) + "/" + this.properties.getSymetricPadding(userId), this.properties.getProviderName(userId));
        triple_des_cipher.init(encrypt ? 1 : 2, key, params);
        return triple_des_cipher;
    }
}

