/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.BadPasswordException;
import de.werum.sis.crypt.CipherExtractor;
import de.werum.sis.crypt.CipherPacker;
import de.werum.sis.crypt.CryptKeyPair;
import de.werum.sis.crypt.CryptProperties;
import de.werum.sis.trace.ConsoleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class HybridCipherExtractor
implements CipherExtractor {
    private ConsoleLogger lg = ConsoleLogger.getInstance();
    private CryptProperties properties;
    private String kennung_m = null;
    private String password_m = null;
    private char[] password;

    public HybridCipherExtractor(CryptProperties properties) {
        this.properties = properties;
    }

    public HybridCipherExtractor(CryptProperties _properties, String _kennung, String _password) {
        this.properties = _properties;
        this.kennung_m = _kennung;
        this.password_m = _password;
    }

    public HybridCipherExtractor(CryptProperties properties, char[] password) {
        this.properties = properties;
        if (this.properties == null) {
            throw new IllegalArgumentException("properties ist erforderlich");
        }
        this.password = password;
        if (this.password == null) {
            throw new IllegalArgumentException("password ist erforderlich");
        }
    }

    public HybridCipherExtractor(CryptProperties properties, String userKennung, String userPassword, char[] password) {
        this.properties = properties;
        if (this.properties == null) {
            throw new IllegalArgumentException("properties ist erforderlich");
        }
        this.kennung_m = userKennung;
        this.password_m = userPassword;
        this.password = password;
        if (this.password == null) {
            throw new IllegalArgumentException("password ist erforderlich");
        }
    }

    @Override
    public Cipher extractCipher(InputStream _is, boolean _encrypt) throws GeneralSecurityException, IOException {
        return this.loadPackedCipher(_is, _encrypt);
    }

    protected Cipher loadPackedCipher(InputStream _is, boolean _encrypt) throws GeneralSecurityException, IOException {
        Cipher extractedCipher;
        ObjectInputStream o_is = new ObjectInputStream(_is);
        int toRead = o_is.available();
        int keyKenn = o_is.readInt();
        Integer userId = new Integer(keyKenn);
        if (!this.properties.containsUserId(userId)) {
            throw new GeneralSecurityException("RSACipherExtractor: Keine g\u00fcltige Crypt-UserId: " + userId);
        }
        int keyIndicator = o_is.readInt();
        boolean usePrivateKey = true;
        if (keyIndicator == 0) {
            this.lg.print(4, "3DES-Schluessel im Klartext.");
            extractedCipher = this.loadTripleDESKeyKlartext(o_is, _encrypt, userId);
        } else if (keyIndicator == 1 || keyIndicator == 5) {
            this.lg.print(4, "3DES-Schluessel mit PrivateKey entschluesseln.");
            extractedCipher = this.loadTripleDESKeyRSA(o_is, _encrypt, usePrivateKey, false, false, userId);
        } else if (keyIndicator == 4) {
            this.lg.print(4, "3DES-Schluessel mit PublicKey entschluesseln.");
            extractedCipher = this.loadTripleDESKeyRSA(o_is, _encrypt, !usePrivateKey, false, false, userId);
        } else if (keyIndicator == 10) {
            this.lg.print(4, "3DES-Schluessel mit PrivateKey und kennung/passwort (XOR) entschluesseln.");
            extractedCipher = this.loadTripleDESKeyRSA(o_is, _encrypt, !usePrivateKey, true, false, userId);
        } else if (keyIndicator == 11) {
            this.lg.print(4, "3DES-Schluessel mit PublicKey und kennung/passwort (XOR) entschluesseln.");
            extractedCipher = this.loadTripleDESKeyRSA(o_is, _encrypt, usePrivateKey, true, false, userId);
        } else if (keyIndicator == 20) {
            this.lg.print(4, "3DES-Schluessel mit PrivateKey und kennung/passwort (SymKey) entschluesseln.");
            extractedCipher = this.loadTripleDESKeyRSA(o_is, _encrypt, !usePrivateKey, true, true, userId);
        } else if (keyIndicator == 21) {
            this.lg.print(4, "3DES-Schluessel mit PublicKey und kennung/passwort (SymKey) entschluesseln.");
            extractedCipher = this.loadTripleDESKeyRSA(o_is, _encrypt, usePrivateKey, true, true, userId);
        } else if (keyIndicator == 29) {
            this.lg.print(4, "3DES-Schluessel kennung/passwort (SymKey) entschluesseln.");
            extractedCipher = this.loadTripleDesPw(o_is, _encrypt, userId);
        } else if (40 == keyIndicator || 41 == keyIndicator) {
            extractedCipher = this.loadSymmetricCipherPBEHybrid(o_is, keyKenn, keyIndicator, _encrypt, userId);
        } else if (50 == keyIndicator || 51 == keyIndicator) {
            extractedCipher = this.loadSymmetricCipherHybrid(o_is, keyKenn, keyIndicator, _encrypt, userId);
        } else if (60 == keyIndicator) {
            extractedCipher = this.loadSymmetricCipherPBE(o_is, keyIndicator, _encrypt, userId);
        } else {
            throw new GeneralSecurityException("Ung\u00fcltiger Identifikator: " + keyIndicator + ".");
        }
        return extractedCipher;
    }

    protected Cipher loadTripleDESKeyRSA(ObjectInputStream inputStream, boolean encrypt, boolean usePrivateKey, boolean useAccountAndPasswort, boolean useAccountAndPasswortAsSymKey, Integer userId) throws GeneralSecurityException, IOException {
        SecretKeySpec keySpec;
        int keyLength = inputStream.readInt();
        this.lg.print(7, "keyLength:" + keyLength);
        byte[] key_enc = new byte[keyLength];
        inputStream.readFully(key_enc, 0, keyLength);
        this.lg.print(7, "real keyLength:" + key_enc.length);
        int ivLength = inputStream.readInt();
        this.lg.print(7, "ivLength:" + ivLength);
        byte[] iv_enc = new byte[ivLength];
        inputStream.readFully(iv_enc, 0, ivLength);
        this.lg.print(7, "real ivLength:" + iv_enc.length);
        byte[] iv_sym_key = null;
        if (useAccountAndPasswortAsSymKey) {
            int ivSymKeyLength = inputStream.readInt();
            this.lg.print(7, "ivSymKeyLength:" + ivLength);
            iv_sym_key = new byte[ivSymKeyLength];
            inputStream.readFully(iv_sym_key, 0, ivSymKeyLength);
            this.lg.print(7, "real ivSymKeyLength:" + iv_sym_key.length);
        }
        if (useAccountAndPasswort) {
            if (this.kennung_m == null || this.password_m == null || this.kennung_m.length() == 0 || this.password_m.length() == 0) {
                throw new GeneralSecurityException("HybridCipherExtractor: 3DES-Schluessel wurde mit kennung/passwort verpackt. Es wurde aber entweder keine Kennung oder kein Passwort fuer die Extrahierung uebergeben!");
            }
            byte[] accountBytes = (this.password_m + this.kennung_m + "_sis_2643_wer_hae_342yq32r").getBytes();
            if (useAccountAndPasswortAsSymKey) {
                byte[] accountDecryptedIv = this.getAccountDecryptedIv(iv_enc, accountBytes, iv_sym_key, userId);
                iv_enc = accountDecryptedIv;
            } else {
                byte[] accountDecodedIv = this.getAccountDecodedIv(iv_enc, accountBytes);
                iv_enc = accountDecodedIv;
            }
        }
        StringBuffer keyRef = new StringBuffer(inputStream.readUTF());
        this.lg.print(7, "keyRef:" + keyRef.toString());
        Cipher rsaCipher = null;
        CryptKeyPair keyPair = null;
        keyPair = new CryptKeyPair(this.properties, keyRef.toString(), !usePrivateKey, usePrivateKey);
        rsaCipher = usePrivateKey ? keyPair.privateCipher(false) : keyPair.publicCipher(false);
        IvParameterSpec iv = useAccountAndPasswortAsSymKey ? new IvParameterSpec(iv_enc) : new IvParameterSpec(rsaCipher.doFinal(iv_enc));
        SecretKeySpec triple_des_key = keySpec = new SecretKeySpec(rsaCipher.doFinal(key_enc), this.properties.getSymetricAlgorithm(userId));
        return this.initTripleDES(triple_des_key, iv, encrypt, userId);
    }

    protected Cipher loadTripleDesPw(ObjectInputStream inputStream, boolean encrypt, Integer userId) throws GeneralSecurityException, IOException {
        SecretKeySpec keySpec;
        byte[] accountDecryptedKey;
        int keyLength = inputStream.readInt();
        this.lg.print(7, "keyLength:" + keyLength);
        byte[] key_enc = new byte[keyLength];
        inputStream.readFully(key_enc, 0, keyLength);
        this.lg.print(7, "real keyLength:" + key_enc.length);
        int ivKeySymKeyLength = inputStream.readInt();
        this.lg.print(7, "ivSymKeyLength:" + ivKeySymKeyLength);
        byte[] iv_key_sym_key = new byte[ivKeySymKeyLength];
        inputStream.readFully(iv_key_sym_key, 0, ivKeySymKeyLength);
        this.lg.print(7, "real ivSymKeyLength:" + iv_key_sym_key.length);
        int ivLength = inputStream.readInt();
        this.lg.print(7, "ivLength:" + ivLength);
        byte[] iv_enc = new byte[ivLength];
        inputStream.readFully(iv_enc, 0, ivLength);
        this.lg.print(7, "real ivLength:" + iv_enc.length);
        int ivIVSymKeyLength = inputStream.readInt();
        this.lg.print(7, "ivSymKeyLength:" + ivIVSymKeyLength);
        byte[] iv_iv_sym_key = new byte[ivIVSymKeyLength];
        inputStream.readFully(iv_iv_sym_key, 0, ivIVSymKeyLength);
        this.lg.print(7, "real ivSymKeyLength:" + iv_iv_sym_key.length);
        if (this.kennung_m == null || this.password_m == null || this.kennung_m.length() == 0 || this.password_m.length() == 0) {
            throw new GeneralSecurityException("HybridCipherExtractor: 3DES-Schluessel wurde mit kennung/passwort verpackt. Es wurde aber entweder keine Kennung oder kein Passwort fuer die Extrahierung uebergeben!");
        }
        byte[] accountBytesKey = (this.password_m + this.kennung_m + "_sis_7634_wer_hae_9rf0eu5o").getBytes();
        byte[] key = accountDecryptedKey = this.getAccountDecryptedIv(key_enc, accountBytesKey, iv_key_sym_key, userId);
        byte[] accountBytesIv = (this.password_m + this.kennung_m + "_sis_4456_wer_hae_fz4e589d").getBytes();
        byte[] accountDecryptedIv = this.getAccountDecryptedIv(iv_enc, accountBytesIv, iv_iv_sym_key, userId);
        iv_enc = accountDecryptedIv;
        IvParameterSpec iv = new IvParameterSpec(iv_enc);
        SecretKeySpec triple_des_key = keySpec = new SecretKeySpec(key, this.properties.getSymetricAlgorithm(userId));
        return this.initTripleDES(triple_des_key, iv, encrypt, userId);
    }

    protected Cipher loadTripleDESKeyKlartext(ObjectInputStream inputStream, boolean encrypt, Integer userId) throws GeneralSecurityException, IOException {
        SecretKeySpec keySpec;
        IvParameterSpec iv;
        int keyLength = inputStream.readInt();
        byte[] key_enc = new byte[keyLength];
        inputStream.read(key_enc, 0, keyLength);
        int ivLength = inputStream.readInt();
        if (ivLength > 0) {
            byte[] iv_enc = new byte[ivLength];
            inputStream.read(iv_enc, 0, ivLength);
            iv = new IvParameterSpec(iv_enc);
        } else {
            iv = null;
        }
        SecretKeySpec triple_des_key = keySpec = new SecretKeySpec(key_enc, this.properties.getSymetricAlgorithm(userId));
        return this.initTripleDES(triple_des_key, iv, encrypt, userId);
    }

    protected Cipher initTripleDES(Key key, AlgorithmParameterSpec params, boolean encrypt, Integer userId) throws GeneralSecurityException {
        Cipher triple_des_cipher = null;
        this.lg.print(3, "Initialisiere den TripleDES-Algorithmus im CBC.");
        this.lg.print(4, "SymetricAlgorithm: " + this.properties.getSymetricAlgorithm(userId) + "/" + this.properties.getSymetricOpMode(userId) + "/" + this.properties.getSymetricPadding(userId));
        this.lg.print(4, "ProviderName: " + this.properties.getProviderName(userId));
        triple_des_cipher = Cipher.getInstance(this.properties.getSymetricAlgorithm(userId) + "/" + this.properties.getSymetricOpMode(userId) + "/" + this.properties.getSymetricPadding(userId), this.properties.getProviderName(userId));
        triple_des_cipher.init(encrypt ? 1 : 2, key, params);
        return triple_des_cipher;
    }

    private byte[] getAccountDecodedIv(byte[] _accountEncodedIv, byte[] _accountBytes) {
        int index;
        byte[] result = new byte[_accountEncodedIv.length];
        for (index = 0; index < _accountEncodedIv.length && index < _accountBytes.length; ++index) {
            result[index] = (byte)(_accountEncodedIv[index] ^ _accountBytes[index]);
        }
        if (index < _accountEncodedIv.length) {
            for (int i = index; i < _accountEncodedIv.length; ++i) {
                result[i] = _accountEncodedIv[i];
            }
        }
        return result;
    }

    public byte[] getAccountDecryptedIv(byte[] _encryptedIv, byte[] _accountBytes, byte[] _accountIV, Integer userId) throws GeneralSecurityException {
        SecretKeySpec keySpec;
        byte[] result = null;
        Cipher symetric_cipher = Cipher.getInstance(this.properties.getSymetricAlgorithm(userId) + "/" + this.properties.getSymetricOpMode(userId) + "/" + this.properties.getSymetricPadding(userId), this.properties.getProviderName(userId));
        if (_accountBytes.length != 24) {
            byte[] tmpBytes = new byte[24];
            System.arraycopy(_accountBytes, 0, tmpBytes, 0, 16);
            System.arraycopy(_accountBytes, 0, tmpBytes, 16, 8);
            _accountBytes = tmpBytes;
        }
        SecretKeySpec triple_des_key = keySpec = new SecretKeySpec(_accountBytes, this.properties.getSymetricAlgorithm(userId));
        IvParameterSpec ivSpec = new IvParameterSpec(_accountIV);
        symetric_cipher.init(2, (Key)triple_des_key, ivSpec);
        result = symetric_cipher.doFinal(_encryptedIv);
        return result;
    }

    public void setKennung(String string) {
        this.kennung_m = string;
    }

    public void setPassword(String string) {
        this.password_m = string;
    }

    private Cipher loadSymmetricCipherHybrid(ObjectInputStream o_is, int packKennung, int packTypeId, boolean encrypt, Integer userId) throws GeneralSecurityException, IOException {
        boolean usePrivateKey;
        if (packTypeId == 50) {
            usePrivateKey = false;
        } else if (packTypeId == 51) {
            usePrivateKey = true;
        } else {
            throw new GeneralSecurityException("Ung\u00fcltiger Identifikator: " + packTypeId + ".");
        }
        int symmetricCipherIvLength = o_is.readInt();
        int encryptedIvAndSymmetricKeyLength = o_is.readInt();
        byte[] encryptedIvAndSymmetricKey = new byte[encryptedIvAndSymmetricKeyLength];
        o_is.readFully(encryptedIvAndSymmetricKey, 0, encryptedIvAndSymmetricKeyLength);
        String keyRef = o_is.readUTF();
        CryptKeyPair keyPair = new CryptKeyPair(this.properties, keyRef, !usePrivateKey, usePrivateKey);
        Cipher hybridCipher = usePrivateKey ? keyPair.privateCipher(false) : keyPair.publicCipher(false);
        if (hybridCipher == null) {
            throw new IllegalStateException("Cipher f\u00fcr KeyRef '" + keyRef + "' ist null.");
        }
        byte[] ivAndSymmetricKey = hybridCipher.doFinal(encryptedIvAndSymmetricKey);
        byte[] symmetricCipherIv = new byte[symmetricCipherIvLength];
        for (int i = 0; i < symmetricCipherIvLength; ++i) {
            symmetricCipherIv[i] = ivAndSymmetricKey[i];
        }
        byte[] symmetricKeyEncodedBytes = new byte[ivAndSymmetricKey.length - symmetricCipherIvLength];
        int len = symmetricKeyEncodedBytes.length;
        for (int i = 0; i < len; ++i) {
            symmetricKeyEncodedBytes[i] = ivAndSymmetricKey[i + symmetricCipherIvLength];
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(symmetricCipherIv);
        SecretKeySpec secretKey = new SecretKeySpec(symmetricKeyEncodedBytes, this.properties.getSymetricAlgorithm(userId));
        Cipher symmetricCipher = Cipher.getInstance(this.properties.getSymetricAlgorithmComplete(userId), this.properties.getProviderName(userId));
        symmetricCipher.init(encrypt ? 1 : 2, (Key)secretKey, ivParameterSpec);
        return symmetricCipher;
    }

    private Cipher loadSymmetricCipherPBEHybrid(ObjectInputStream o_is, int packKennung, int packTypeId, boolean encrypt, Integer userId) throws BadPasswordException, GeneralSecurityException, IOException {
        byte[] checkStrDecryptedBytes;
        boolean usePrivateKey;
        if (packTypeId == 40) {
            usePrivateKey = false;
        } else if (packTypeId == 41) {
            usePrivateKey = true;
        } else {
            throw new GeneralSecurityException("Ung\u00fcltiger Identifikator: " + packTypeId + ".");
        }
        int symmetricCipherIvLength = o_is.readInt();
        int encryptedIvAndSaltLength = o_is.readInt();
        byte[] encryptedIvAndSalt = new byte[encryptedIvAndSaltLength];
        o_is.readFully(encryptedIvAndSalt, 0, encryptedIvAndSaltLength);
        int checkStrEncryptedLength = o_is.readInt();
        byte[] checkStrEncryptedBytes = new byte[checkStrEncryptedLength];
        o_is.readFully(checkStrEncryptedBytes, 0, checkStrEncryptedLength);
        String keyRef = o_is.readUTF();
        CryptKeyPair keyPair = new CryptKeyPair(this.properties, keyRef, !usePrivateKey, usePrivateKey);
        Cipher hybridCipher = usePrivateKey ? keyPair.privateCipher(false) : keyPair.publicCipher(false);
        if (hybridCipher == null) {
            throw new IllegalStateException("Cipher f\u00fcr KeyRef '" + keyRef + "' ist null.");
        }
        byte[] ivAndSalt = hybridCipher.doFinal(encryptedIvAndSalt);
        byte[] symmetricCipherIv = new byte[symmetricCipherIvLength];
        for (int i = 0; i < symmetricCipherIvLength; ++i) {
            symmetricCipherIv[i] = ivAndSalt[i];
        }
        byte[] pbeSalt = new byte[ivAndSalt.length - symmetricCipherIvLength];
        int len = pbeSalt.length;
        for (int i = 0; i < len; ++i) {
            pbeSalt[i] = ivAndSalt[i + symmetricCipherIvLength];
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(symmetricCipherIv);
        PBEKeySpec keySpec = new PBEKeySpec(this.password, pbeSalt, this.properties.getPbeIterations(userId));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.properties.getPbeAlgorithm(userId), this.properties.getProviderName(userId));
        SecretKey pbeKey = keyFactory.generateSecret(keySpec);
        SecretKeySpec secretKey = new SecretKeySpec(pbeKey.getEncoded(), this.properties.getSymetricAlgorithm(userId));
        Cipher symmetricCipher = Cipher.getInstance(this.properties.getSymetricAlgorithmComplete(userId), this.properties.getProviderName(userId));
        symmetricCipher.init(encrypt ? 1 : 2, (Key)secretKey, ivParameterSpec);
        try {
            checkStrDecryptedBytes = symmetricCipher.doFinal(checkStrEncryptedBytes);
        }
        catch (GeneralSecurityException e) {
            throw new BadPasswordException(e);
        }
        if (!Arrays.equals(CipherPacker.PBE_HYBRID_CHECK_STR_BYTES, checkStrDecryptedBytes)) {
            throw new BadPasswordException();
        }
        return symmetricCipher;
    }

    private Cipher loadSymmetricCipherPBE(ObjectInputStream o_is, int packTypeId, boolean encrypt, Integer userId) throws BadPasswordException, GeneralSecurityException, IOException {
        byte[] checkStrDecryptedBytes;
        if (packTypeId != 60) {
            throw new GeneralSecurityException("Ung\u00fcltiger Identifikator: " + packTypeId + ".");
        }
        int symmetricCipherIvLength = o_is.readInt();
        int ivAndSaltLength = o_is.readInt();
        byte[] ivAndSalt = new byte[ivAndSaltLength];
        o_is.readFully(ivAndSalt, 0, ivAndSaltLength);
        int checkStrEncryptedLength = o_is.readInt();
        byte[] checkStrEncryptedBytes = new byte[checkStrEncryptedLength];
        o_is.readFully(checkStrEncryptedBytes, 0, checkStrEncryptedLength);
        byte[] symmetricCipherIv = new byte[symmetricCipherIvLength];
        for (int i = 0; i < symmetricCipherIvLength; ++i) {
            symmetricCipherIv[i] = ivAndSalt[i];
        }
        byte[] pbeSalt = new byte[ivAndSalt.length - symmetricCipherIvLength];
        int len = pbeSalt.length;
        for (int i = 0; i < len; ++i) {
            pbeSalt[i] = ivAndSalt[i + symmetricCipherIvLength];
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(symmetricCipherIv);
        PBEKeySpec keySpec = new PBEKeySpec(this.password, pbeSalt, this.properties.getPbeIterations(userId));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.properties.getPbeAlgorithm(userId), this.properties.getProviderName(userId));
        SecretKey pbeKey = keyFactory.generateSecret(keySpec);
        SecretKeySpec secretKey = new SecretKeySpec(pbeKey.getEncoded(), this.properties.getSymetricAlgorithm(userId));
        Cipher symmetricCipher = Cipher.getInstance(this.properties.getSymetricAlgorithmComplete(userId), this.properties.getProviderName(userId));
        symmetricCipher.init(encrypt ? 1 : 2, (Key)secretKey, ivParameterSpec);
        try {
            checkStrDecryptedBytes = symmetricCipher.doFinal(checkStrEncryptedBytes);
        }
        catch (GeneralSecurityException e) {
            throw new BadPasswordException(e);
        }
        if (!Arrays.equals(CipherPacker.PBE_CHECK_STR_BYTES, checkStrDecryptedBytes)) {
            throw new BadPasswordException();
        }
        return symmetricCipher;
    }
}

