/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateArgument;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFDokumenterzeuger;
import de.statspez.sdf.generator.parser.LocalReference;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.TypesParser;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ArgumentParser
extends SubParser {
    private MetaCustomSDFTemplateArgument argument = null;
    private MetaSDFDokumenterzeuger dokumenterzeuger = null;
    private String executableId = null;

    public ArgumentParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    public void setDokumenterzeuger(MetaSDFDokumenterzeuger dokumenterzeuger) {
        this.dokumenterzeuger = dokumenterzeuger;
    }

    public void setExecutableId(String executableId) {
        this.executableId = executableId;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("argument".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new MetaParseException("Name von argument nicht definiert!");
            }
            name = SDFTags.dekodiereXMLName(name);
            this.argument.setName(name);
            this.resolver().registerForResolve((Reference)new LocalReference(this.argument, "PARAM", String.valueOf(this.executableId) + "." + name, this.dokumenterzeuger));
            String ref = atts.getValue("ref");
            if (ref != null) {
                this.argument.setReferenz(SDFTags.dekodiereXMLName(ref));
            }
            this.argument.setEscapingTyp(TypesParser.parseEscaping(atts.getValue("escaping")));
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("argument".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!"argument".equalsIgnoreCase(localName)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
        ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        this.superParser().charData().delete(0, this.superParser().charData().length());
        this.argument = new MetaCustomSDFTemplateArgument();
        this.enable();
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("argument".equalsIgnoreCase(localName)) {
            String wert = this.superParser().charData().toString();
            if (wert.length() > 0) {
                this.argument.setWert(wert);
            }
        } else {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
        this.disableAndNotify();
    }

    public MetaElementInterface object() {
        return this.argument;
    }
}

