/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.UnfailingPullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;

public class TreeWalker
implements UnfailingPullProvider,
Location {
    private final NodeInfo startNode;
    private NodeInfo currentNode;
    private PullProvider.Event currentEvent = PullProvider.Event.START_OF_INPUT;
    private final Stack<FocusIterator> iteratorStack = new Stack();
    private PipelineConfiguration pipe;
    private final NamespaceBinding[] nsBuffer = new NamespaceBinding[10];

    public static UnfailingPullProvider makeTreeWalker(NodeInfo startNode) {
        return new TreeWalker(startNode);
    }

    private TreeWalker(NodeInfo startNode) {
        this.startNode = startNode;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public PullProvider.Event next() throws XPathException {
        switch (this.currentEvent) {
            case START_OF_INPUT: {
                this.currentNode = this.startNode;
                switch (this.currentNode.getNodeKind()) {
                    case 9: {
                        this.currentEvent = PullProvider.Event.START_DOCUMENT;
                        return this.currentEvent;
                    }
                    case 1: {
                        this.currentEvent = PullProvider.Event.START_ELEMENT;
                        return this.currentEvent;
                    }
                    case 3: {
                        this.currentEvent = PullProvider.Event.TEXT;
                        return this.currentEvent;
                    }
                    case 8: {
                        this.currentEvent = PullProvider.Event.COMMENT;
                        return this.currentEvent;
                    }
                    case 7: {
                        this.currentEvent = PullProvider.Event.PROCESSING_INSTRUCTION;
                        return this.currentEvent;
                    }
                    case 2: {
                        this.currentEvent = PullProvider.Event.ATTRIBUTE;
                        return this.currentEvent;
                    }
                    case 13: {
                        this.currentEvent = PullProvider.Event.NAMESPACE;
                        return this.currentEvent;
                    }
                }
                throw new IllegalStateException();
            }
            case START_DOCUMENT: 
            case START_ELEMENT: {
                FocusTrackingIterator kids = new FocusTrackingIterator((SequenceIterator)this.currentNode.iterateAxis(3));
                this.iteratorStack.push((FocusIterator)kids);
                this.currentNode = (NodeInfo)kids.next();
                if (this.currentNode != null) {
                    this.currentEvent = this.mapChildNodeEvent();
                    return this.currentEvent;
                }
                this.iteratorStack.pop();
                if (this.iteratorStack.isEmpty()) {
                    this.currentNode = this.startNode;
                }
                if (this.currentEvent == PullProvider.Event.START_DOCUMENT) {
                    this.currentEvent = PullProvider.Event.END_DOCUMENT;
                    return this.currentEvent;
                }
                this.currentEvent = PullProvider.Event.END_ELEMENT;
                return this.currentEvent;
            }
            case TEXT: 
            case COMMENT: 
            case PROCESSING_INSTRUCTION: 
            case END_ELEMENT: {
                if (this.iteratorStack.isEmpty()) {
                    if (this.currentNode == this.startNode) {
                        this.currentNode = null;
                        this.currentEvent = PullProvider.Event.END_OF_INPUT;
                        return this.currentEvent;
                    }
                    this.currentNode = this.startNode;
                    if (this.currentNode.getNodeKind() == 1) {
                        this.currentEvent = PullProvider.Event.END_ELEMENT;
                        return this.currentEvent;
                    }
                    this.currentEvent = PullProvider.Event.END_DOCUMENT;
                    return this.currentEvent;
                }
                FocusIterator siblings = this.iteratorStack.peek();
                this.currentNode = (NodeInfo)siblings.next();
                if (this.currentNode == null) {
                    this.iteratorStack.pop();
                    if (this.iteratorStack.isEmpty()) {
                        this.currentNode = this.startNode;
                        if (this.currentNode.getNodeKind() == 1) {
                            this.currentEvent = PullProvider.Event.END_ELEMENT;
                            return this.currentEvent;
                        }
                        this.currentEvent = PullProvider.Event.END_DOCUMENT;
                        return this.currentEvent;
                    }
                    FocusIterator uncles = this.iteratorStack.peek();
                    this.currentNode = (NodeInfo)uncles.current();
                    if (this.currentNode.getNodeKind() == 9) {
                        this.currentEvent = PullProvider.Event.END_DOCUMENT;
                        return this.currentEvent;
                    }
                    this.currentEvent = PullProvider.Event.END_ELEMENT;
                    return this.currentEvent;
                }
                this.currentEvent = this.mapChildNodeEvent();
                return this.currentEvent;
            }
            case ATTRIBUTE: 
            case NAMESPACE: 
            case END_DOCUMENT: {
                this.currentEvent = PullProvider.Event.END_OF_INPUT;
                return this.currentEvent;
            }
            case END_OF_INPUT: {
                throw new IllegalStateException("Cannot call next() when input is exhausted");
            }
        }
        throw new IllegalStateException("Unrecognized event " + this.currentEvent);
    }

    private PullProvider.Event mapChildNodeEvent() {
        switch (this.currentNode.getNodeKind()) {
            case 1: {
                return PullProvider.Event.START_ELEMENT;
            }
            case 3: {
                return PullProvider.Event.TEXT;
            }
            case 8: {
                return PullProvider.Event.COMMENT;
            }
            case 7: {
                return PullProvider.Event.PROCESSING_INSTRUCTION;
            }
        }
        throw new IllegalStateException();
    }

    public PullProvider.Event current() {
        return this.currentEvent;
    }

    public AttributeMap getAttributes() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (this.currentNode.getNodeKind() == 1) {
            return this.currentNode.attributes();
        }
        throw new IllegalStateException("getAttributes() called when current event is not ELEMENT_START");
    }

    public NamespaceBinding[] getNamespaceDeclarations() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (this.currentNode.getNodeKind() == 1) {
            if (this.iteratorStack.isEmpty()) {
                Iterator iter = this.currentNode.getAllNamespaces().iterator();
                ArrayList list = new ArrayList();
                while (iter.hasNext()) {
                    list.add(iter.next());
                }
                return list.toArray(NamespaceBinding.EMPTY_ARRAY);
            }
            return this.currentNode.getDeclaredNamespaces(this.nsBuffer);
        }
        throw new IllegalStateException("getNamespaceDeclarations() called when current event is not ELEMENT_START");
    }

    public PullProvider.Event skipToMatchingEnd() {
        switch (this.currentEvent) {
            case START_DOCUMENT: {
                this.currentEvent = PullProvider.Event.END_DOCUMENT;
                return this.currentEvent;
            }
            case START_ELEMENT: {
                this.currentEvent = PullProvider.Event.END_ELEMENT;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public NodeName getNodeName() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        return NameOfNode.makeName((NodeInfo)this.currentNode);
    }

    public CharSequence getStringValue() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (this.currentNode.getNodeKind() == 1) {
            this.skipToMatchingEnd();
        }
        return this.currentNode.getStringValueCS();
    }

    public SchemaType getSchemaType() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        return this.currentNode.getSchemaType();
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public Location getSourceLocator() {
        return this;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.currentNode == null ? this.startNode.getSystemId() : this.currentNode.getSystemId();
    }

    public int getLineNumber() {
        return this.currentNode == null ? -1 : this.currentNode.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    public Location saveLocation() {
        return new Loc((SourceLocator)((Object)this));
    }

    public List<UnparsedEntity> getUnparsedEntities() {
        return null;
    }
}

