/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

public class PullTracer
extends PullFilter {
    private NamePool pool;

    public PullTracer(PullProvider base) {
        super(base);
    }

    public PullProvider.Event next() throws XPathException {
        this.currentEvent = super.next();
        this.traceEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void traceEvent(PullProvider.Event event) {
        if (this.pool == null) {
            this.pool = this.getPipelineConfiguration().getConfiguration().getNamePool();
        }
        PullProvider in = this.getUnderlyingProvider();
        switch (event) {
            case START_DOCUMENT: {
                System.err.println("START_DOCUMENT");
                break;
            }
            case START_ELEMENT: {
                System.err.println("START_ELEMENT " + in.getNodeName().getDisplayName());
                break;
            }
            case TEXT: {
                System.err.println("TEXT");
                try {
                    CharSequence cs = this.getStringValue();
                    FastStringBuffer sb = new FastStringBuffer(cs.length() * 5);
                    sb.cat('(');
                    for (int i = 0; i < cs.length(); ++i) {
                        sb.append(cs.charAt(i) + " ");
                    }
                    sb.cat(')');
                    System.err.println(sb);
                }
                catch (XPathException xPathException) {}
                break;
            }
            case COMMENT: {
                System.err.println("COMMENT");
                break;
            }
            case PROCESSING_INSTRUCTION: {
                System.err.println("PROCESSING_INSTRUCTION");
                break;
            }
            case END_ELEMENT: {
                System.err.println("END_ELEMENT " + (in.getNodeName() == null ? "" : in.getNodeName().getDisplayName()));
                break;
            }
            case END_DOCUMENT: {
                System.err.println("END_DOCUMENT");
                break;
            }
            case END_OF_INPUT: {
                System.err.println("END_OF_INPUT");
                break;
            }
            case ATOMIC_VALUE: {
                try {
                    System.err.println("ATOMIC VALUE: " + in.getStringValue());
                    break;
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
        }
    }
}

