/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Query;
import net.sf.saxon.functions.ResolveQName;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XmlProcessingError;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Step;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.testdriver.Environment;
import net.sf.saxon.testdriver.ErrorCollector;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.testdriver.TestOutcome;
import net.sf.saxon.testdriver.Xslt30TestReport;
import net.sf.saxon.trace.XSLTTraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class Xslt30TestSuiteDriverHE
extends TestDriver {
    protected Set<String> alwaysOn = new HashSet<String>();
    protected Set<String> needsEE = new HashSet<String>();
    protected Set<String> needsPE = new HashSet<String>();
    protected Set<String> alwaysOff = new HashSet<String>();

    public Xslt30TestSuiteDriverHE() {
        this.spec = Spec.XT30;
        this.setDependencyData();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            Xslt30TestSuiteDriverHE.usage();
        }
        new Xslt30TestSuiteDriverHE().go(args);
    }

    protected static void usage() {
        System.err.println("java com.saxonica.testdriver.Xslt30TestSuiteDriver[HE] testsuiteDir catalog [-o:resultsdir] [-s:testSetName] [-t:testNamePattern] [-bytecode:on|off|debug] [-export] [-tree] [-lang] [-save] [-streaming:off|std|ext] [-xt30:on] [-T] [-js] [-XX:compiler-location]");
    }

    @Override
    public String catalogNamespace() {
        return "http://www.w3.org/2012/10/xslt-test-catalog";
    }

    @Override
    public void processSpec(String specStr) {
        switch (specStr) {
            case "XT10": {
                this.spec = Spec.XT10;
                break;
            }
            case "XT20": {
                this.spec = Spec.XT20;
                break;
            }
            case "XT30": {
                this.spec = Spec.XT30;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown spec " + specStr);
            }
        }
        this.resultsDoc = new Xslt30TestReport(this, this.spec);
        if (this.reportFileName != null) {
            this.resultsDoc.setReportFilename(this.reportFileName);
        }
    }

    @Override
    protected void createGlobalEnvironments(XdmNode catalog, XPathCompiler xpc) throws SaxonApiException {
        for (XdmNode env : catalog.select(Steps.descendant((String)"environment")).asListOfNodes()) {
            Environment.processEnvironment(this, xpc, env, this.globalEnvironments, (Environment)this.localEnvironments.get("default"));
        }
    }

    protected boolean isSlow(String testName) {
        return testName.startsWith("regex-classes") || testName.equals("normalize-unicode-008") || testName.equals("function-1031") && this.driverProc.getSaxonEdition().equals("HE");
    }

    protected static Predicate<XdmItem> isTrue(String attName) {
        return element -> {
            String attVal;
            if (element instanceof XdmNode && (attVal = ((XdmNode)element).attribute(attName)) != null) {
                return "yes".equals(attVal = attVal.trim()) || "1".equals(attVal) || "true".equals(attVal);
            }
            return false;
        };
    }

    public boolean unavailableInXX(String type, String value) {
        if (type.equals("feature") && value.equals("higher_order_functions")) {
            return true;
        }
        if (type.equals("feature") && value.equals("streaming")) {
            return true;
        }
        return type.equals("year_component_values") && (value.equals("support year above 9999") || value.equals("support negative year") || value.equals("support year zero"));
    }

    @Override
    protected void runTestCase(XdmNode testCase, XPathCompiler xpath) throws SaxonApiException {
        Optional assertion;
        URI baseOut;
        String xsltLanguageVersion;
        TestOutcome outcome = new TestOutcome(this);
        String testName = testCase.attribute("name");
        String testSetName = testCase.getParent().attribute("name");
        for (String key : new String[]{testName, "$" + testSetName}) {
            if (!this.exceptionsMap.containsKey(key)) continue;
            ++this.notrun;
            XdmNode exceptionElement = (XdmNode)this.exceptionsMap.get(key);
            String report = exceptionElement.attribute("report");
            if (report == null) {
                report = "notRun";
            }
            Optional reason = exceptionElement.select(Steps.child((String)"reason")).findFirst();
            String reasonStr = reason.map(XdmItem::getStringValue).orElse(null);
            this.resultsDoc.writeTestcaseElement(testName, report, reasonStr);
            return;
        }
        Optional outputFile = testCase.select(Steps.path((String[])new String[]{"test", "output", "@file"})).asOptionalNode();
        if (outputFile.isPresent() && "#absent".equals(((XdmNode)outputFile.get()).getStringValue())) {
            ++this.notrun;
            this.resultsDoc.writeTestcaseElement(testName, "notRun", "requires absent base URI");
            return;
        }
        if (this.isSlow(testName)) {
            ++this.notrun;
            this.resultsDoc.writeTestcaseElement(testName, "tooBig", "requires excessive resources");
            return;
        }
        Step testSetDependencies = Steps.root().then(Steps.child((String)"test-set").then(Steps.child((String)"dependencies")));
        Step testCaseDependencies = Steps.child((String)"dependencies");
        XdmValue allDependencies = testCase.select(testSetDependencies.cat(testCaseDependencies)).asXdmValue();
        Optional lastSpecValue = allDependencies.select(Steps.path((String[])new String[]{"spec", "@value"})).last().asOptionalNode();
        String specAtt = lastSpecValue.isPresent() ? ((XdmNode)lastSpecValue.get()).getStringValue() : "XSLT10+";
        Environment env = this.getEnvironment(testCase, xpath);
        if (env == null) {
            this.resultsDoc.writeTestcaseElement(testName, "notRun", "test catalog error");
            ++this.notrun;
            return;
        }
        for (XdmNode dep : allDependencies.select(Steps.child((Predicate)Predicates.isElement())).asListOfNodes()) {
            if (this.ensureDependencySatisfied(dep, env)) continue;
            ++this.notrun;
            String type = dep.getNodeName().getLocalName();
            String value = dep.attribute("value");
            value = value == null ? type : type + ":" + value;
            if ("false".equals(dep.attribute("satisfied"))) {
                value = "!" + value;
            }
            String message = "dependency not satisfied: " + value;
            if (value.startsWith("feature:")) {
                message = "requires optional " + value;
            }
            this.resultsDoc.writeTestcaseElement(testName, "n/a", message);
            return;
        }
        if (env.failedToBuild) {
            this.resultsDoc.writeTestcaseElement(testName, "fail", "unable to build environment");
            this.noteFailure(testSetName, testName);
            return;
        }
        if (!env.usable) {
            this.resultsDoc.writeTestcaseElement(testName, "n/a", "environment dependencies not satisfied");
            ++this.notrun;
            return;
        }
        if (testName.contains("environment-variable")) {
            EnvironmentVariableResolver resolver = new EnvironmentVariableResolver(){

                public Set<String> getAvailableEnvironmentVariables() {
                    HashSet<String> strings = new HashSet<String>();
                    strings.add("QTTEST");
                    strings.add("QTTEST2");
                    strings.add("QTTESTEMPTY");
                    return strings;
                }

                public String getEnvironmentVariable(String name) {
                    switch (name) {
                        case "QTTEST": {
                            return "42";
                        }
                        case "QTTEST2": {
                            return "other";
                        }
                        case "QTTESTEMPTY": {
                            return "";
                        }
                    }
                    return null;
                }
            };
            env.processor.setConfigurationProperty(Feature.ENVIRONMENT_VARIABLE_RESOLVER, (Object)resolver);
        }
        if (testName.contains("load-xquery-module")) {
            env.processor.getUnderlyingConfiguration().setModuleURIResolver((moduleURI, baseURI, locations) -> {
                File file = (File)this.queryModules.get(moduleURI);
                if (file == null) {
                    return null;
                }
                try {
                    StreamSource ss = new StreamSource(new FileInputStream(file), baseURI);
                    return new StreamSource[]{ss};
                }
                catch (FileNotFoundException e) {
                    throw new XPathException((Throwable)e);
                }
            });
        }
        XdmNode testInput = testCase.select(Steps.child((String)"test")).asNode();
        Optional stylesheet = testInput.select(Steps.child((String)"stylesheet").where(Predicates.not((Predicate)Predicates.attributeEq((String)"role", (String)"secondary")))).asOptionalNode();
        Optional postureAndSweep = testInput.select(Steps.child((String)"posture-and-sweep")).asOptionalNode();
        Optional principalPackage = testInput.select(Steps.child((String)"package").where(Predicates.attributeEq((String)"role", (String)"principal"))).asOptionalNode();
        List usedPackages = testInput.select(Steps.child((String)"package").where(Predicates.attributeEq((String)"role", (String)"secondary"))).asList();
        XsltExecutable sheet = env.xsltExecutable;
        ErrorCollector collector = new ErrorCollector();
        if (this.quiet) {
            collector.setLogger(new Logger(){

                public void println(String message, int severity) {
                }

                public StreamResult asStreamResult() {
                    return null;
                }
            });
        }
        String string = xsltLanguageVersion = specAtt.contains("XSLT30") || specAtt.contains("XSLT20+") ? "3.0" : "2.0";
        if (postureAndSweep.isPresent()) {
            if (this.runPostureAndSweepTests) {
                this.runStreamabilityTests(xpath, testCase);
            }
            return;
        }
        boolean strictStreamability = testCase.select(Steps.child((String)"result").then(Steps.descendant((String)"error")).where(Predicates.attributeEq((String)"code", (String)"XTSE3430"))).exists();
        if (strictStreamability) {
            env.processor.setConfigurationProperty(Feature.STRICT_STREAMABILITY, (Object)true);
            env.resetActions.add(new Environment.ResetAction(){

                @Override
                public void reset(Environment env) {
                    env.processor.setConfigurationProperty(Feature.STRICT_STREAMABILITY, (Object)false);
                }
            });
        }
        Predicate<XdmItem> isStaticError = item -> item.getStringValue().startsWith("XTSE");
        boolean staticError = testCase.select(Steps.path((String[])new String[]{"result", "//", "error", "@code"}).where(isStaticError)).exists();
        if (staticError && this.jitFlag) {
            env.xsltCompiler.setJustInTimeCompilation(false);
            env.resetActions.add(new Environment.ResetAction(){

                @Override
                public void reset(Environment env) {
                    env.xsltCompiler.setJustInTimeCompilation(true);
                }
            });
        }
        if (stylesheet.isPresent()) {
            String fileName = ((XdmNode)stylesheet.get()).attribute("file");
            StreamSource styleSource = new StreamSource(testCase.getBaseURI().resolve(fileName).toString());
            XsltCompiler compiler = env.xsltCompiler;
            compiler.setErrorReporter((ErrorReporter)collector);
            this.initPatternOptimization(compiler);
            compiler.clearParameters();
            this.prepareForSQL(compiler.getProcessor());
            List params = testInput.select(Steps.child((String)"param").where(Xslt30TestSuiteDriverHE.isTrue("static"))).asListOfNodes();
            for (XdmNode param2 : params) {
                XdmValue value;
                String name = param2.attribute("name");
                String select = param2.attribute("select");
                try {
                    value = xpath.evaluate(select, null);
                }
                catch (SaxonApiException e) {
                    System.err.println("*** Error evaluating parameter " + name + ": " + e.getMessage());
                    throw e;
                }
                compiler.setParameter(new QName(name), value);
            }
            for (XdmNode pack : usedPackages) {
                String fileName2 = pack.attribute("file");
                StreamSource styleSource2 = new StreamSource(testCase.getBaseURI().resolve(fileName2).toString());
                XsltPackage xpack = compiler.compilePackage((Source)styleSource2);
                xpack = this.exportImportPackage(testName, testSetName, outcome, compiler, xpack, collector);
                compiler.importPackage(xpack);
                env.processor.getUnderlyingConfiguration().getDefaultXsltCompilerInfo().getPackageLibrary().addPackage(xpack.getUnderlyingPreparedPackage());
            }
            sheet = this.exportImport(testName, testSetName, outcome, compiler, sheet, collector, styleSource);
            String optimizationAssertion = (String)this.optimizationAssertions.get(testName);
            if (optimizationAssertion != null && sheet != null) {
                try {
                    boolean ok = this.assertOptimization(sheet, optimizationAssertion);
                    if (ok) {
                        System.err.println("Optimization OK: " + optimizationAssertion);
                    } else {
                        outcome.setComment("Optimization assertion failed");
                        if (this.strict) {
                            this.noteFailure(testSetName, testName);
                            this.resultsDoc.writeTestcaseElement(testName, "fail", outcome.getComment());
                        }
                    }
                    System.err.println("Optimization OK: " + optimizationAssertion);
                }
                catch (SaxonApiException e) {
                    System.err.println("Optimization assertion failed: " + optimizationAssertion);
                }
            }
        } else if (principalPackage.isPresent()) {
            XsltCompiler compiler = env.xsltCompiler;
            compiler.setErrorReporter((ErrorReporter)collector);
            compiler.clearParameters();
            testInput.select(Steps.child((String)"param").where(Xslt30TestSuiteDriverHE.isTrue("static"))).forEach(param -> {
                XdmValue value;
                String name = param.attribute("name");
                String select = param.attribute("select");
                try {
                    value = xpath.evaluate(select, null);
                }
                catch (SaxonApiException e) {
                    System.err.println("*** Error evaluating parameter " + name + ": " + e.getMessage());
                    throw new SaxonApiUncheckedException((Throwable)e);
                }
                compiler.setParameter(new QName(name), value);
            });
            for (XdmNode pack : usedPackages) {
                String fileName = pack.attribute("file");
                StreamSource styleSource = new StreamSource(testCase.getBaseURI().resolve(fileName).toString());
                XsltPackage xpack = compiler.compilePackage((Source)styleSource);
                compiler.importPackage(xpack);
            }
            String fileName = ((XdmNode)principalPackage.get()).attribute("file");
            StreamSource styleSource = new StreamSource(testCase.getBaseURI().resolve(fileName).toString());
            try {
                XsltPackage xpack = compiler.compilePackage((Source)styleSource);
                sheet = xpack.link();
            }
            catch (SaxonApiException err) {
                System.err.println(err.getMessage());
                outcome.setException(err.getErrorCode());
                outcome.setErrorsReported(collector.getErrorCodes());
            }
            catch (Exception err) {
                err.printStackTrace();
                System.err.println(err.getMessage());
                outcome.setException(new QName(err.getClass().getName()));
                outcome.setErrorsReported(collector.getErrorCodes());
            }
            sheet = this.exportImport(testName, testSetName, outcome, compiler, sheet, collector, styleSource);
        }
        if (this.runWithNodeJS && !outcome.isException()) {
            URI r = new File(this.resultsDir).toURI();
            if (env.exportedStylesheet != null) {
                URI s = env.exportedStylesheet.toURI();
                s = r.relativize(s);
                this.resultsDoc.writeTestcaseElement(testName, "deferred", s.toString());
            } else {
                this.resultsDoc.writeTestcaseElement(testName, "deferred", "export/" + testSetName + "/" + testName + ".sef.json");
            }
            return;
        }
        XdmValue initialMatchSelection = null;
        Optional initialMode = testInput.select(Steps.child((String)"initial-mode")).asOptionalNode();
        Optional initialFunction = testInput.select(Steps.child((String)"initial-function")).asOptionalNode();
        Optional initialTemplate = testInput.select(Steps.child((String)"initial-template")).asOptionalNode();
        QName initialModeName = null;
        if (initialMode.isPresent()) {
            initialModeName = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, (XdmNode)initialMode.get(), (Step<? extends XdmNode>)Steps.attribute((String)"name"));
            String select = ((XdmNode)initialMode.get()).attribute("select");
            if (select != null) {
                initialMatchSelection = env.xpathCompiler.evaluate(select, null);
                if (this.runWithJS) {
                    this.resultsDoc.writeTestcaseElement(testName, "n/a", "Test driver limitation: cannot set initial match selection");
                    ++this.notrun;
                    return;
                }
            }
        }
        QName initialTemplateName = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, testInput, (Step<? extends XdmNode>)Steps.path((String[])new String[]{"initial-template", "@name"}));
        QName initialFunctionName = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, testInput, (Step<? extends XdmNode>)Steps.path((String[])new String[]{"initial-function", "@name"}));
        if (this.runWithJS && !outcome.isException()) {
            Optional wellFormed = testInput.select(Steps.path((String[])new String[]{"output", "@well-formed"})).asOptionalString();
            if (wellFormed.equals(Optional.of("no"))) {
                outcome.getPrincipalResultDoc().wellFormed = false;
            }
            this.clearGlobalParameters();
            Map<QName, XdmValue> caseGlobalParams = this.getNamedParameters(xpath, testInput, false, false);
            for (Map.Entry<QName, XdmValue> entry : caseGlobalParams.entrySet()) {
                this.setGlobalParameter(entry.getKey(), entry.getValue());
            }
            if (initialFunctionName != null) {
                XdmValue[] args;
                this.clearInitialFunctionArguments();
                XdmNode iniFunc = testInput.select(Steps.child((String)"initial-function")).asNode();
                for (XdmValue val : args = this.getParameters(xpath, iniFunc)) {
                    this.addInitialFunctionArgument(val);
                }
            }
            baseOut = new File(this.resultsDir + "/results/output.xml").toURI();
            try {
                this.runJSTransform(env, outcome, initialTemplateName, initialModeName, initialFunctionName, baseOut);
            }
            catch (StackOverflowError e) {
                ++this.notrun;
                this.resultsDoc.writeTestcaseElement(testName, "tooBig", "Stack Overflow");
                return;
            }
            if ("*notJS*".equals(outcome.getComment())) {
                return;
            }
        }
        if (sheet != null && !this.runWithJS) {
            XdmItem contextItem = env.contextItem;
            Optional<String> outputUri = testInput.select(Steps.path((String[])new String[]{"output", "@file"})).asOptionalString();
            baseOut = new File(this.resultsDir + "/results/output.xml").toURI();
            String baseOutputURI = new File(this.resultsDir + "/results/output.xml").toURI().toString();
            if (outputUri.isPresent()) {
                if (((String)outputUri.get()).equals("")) {
                    String testSetUri = testCase.getBaseURI().toASCIIString();
                    int c = testSetUri.indexOf("/tests/");
                    outputUri = Optional.of(testSetUri.substring(c + 7));
                }
                baseOutputURI = baseOut.resolve((String)outputUri.get()).toString();
            }
            outcome.setBaseOutputUri(baseOutputURI);
            try {
                boolean failure = this.useXslt30Transformer ? this.runWithXslt30Transformer(testCase, xpath, outcome, testName, testSetName, env, testInput, sheet, collector, xsltLanguageVersion, contextItem, initialMode.orElse(null), initialFunction.orElse(null), initialTemplate.orElse(null), initialModeName, initialMatchSelection, initialTemplateName, baseOutputURI) : this.runWithXsltTransformer(xpath, outcome, testName, testSetName, env, testInput, sheet, collector, contextItem, initialMode.orElse(null), initialModeName, initialTemplateName, baseOutputURI);
                if (failure) {
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (Environment.ResetAction action : env.resetActions) {
            action.reset(env);
        }
        env.resetActions.clear();
        Optional earlyExit = testCase.select(Steps.path((Step[])new Step[]{Steps.child((String)"result"), Steps.attribute((String)"early-exit-possible")})).asOptionalString();
        boolean expectEarlyExit = earlyExit.equals(Optional.of("true"));
        if (expectEarlyExit != collector.isMadeEarlyExit()) {
            outcome.setComment(expectEarlyExit ? "Failed to make early exit" : "Unexpected early exit");
            if (this.strict) {
                this.noteFailure(testSetName, testName);
                this.resultsDoc.writeTestcaseElement(testName, "fail", outcome.getComment());
            }
        }
        if (!(assertion = testCase.select(Steps.path((Step[])new Step[]{Steps.child((String)"result"), Steps.child().where(Predicates.isElement())})).asOptionalNode()).isPresent()) {
            this.noteFailure(testSetName, testName);
            this.resultsDoc.writeTestcaseElement(testName, "fail", "No test assertions found");
            return;
        }
        XPathCompiler assertionXPath = env.processor.newXPathCompiler();
        assertionXPath.setSchemaAware(env.processor.isSchemaAware());
        assertionXPath.setBaseURI(((XdmNode)assertion.get()).getBaseURI());
        this.copySchemaNamespaces(env, assertionXPath);
        boolean success = outcome.testAssertion((XdmNode)assertion.get(), outcome, outcome.getPrincipalResultDoc(), assertionXPath, xpath, this.debug);
        if (success) {
            ++this.successes;
            this.resultsDoc.writeTestcaseElement(testName, "pass", outcome.getComment());
        } else if (outcome.getWrongErrorMessage() != null) {
            outcome.setComment(outcome.getWrongErrorMessage());
            if (this.strict) {
                this.resultsDoc.writeTestcaseElement(testName, "fail", outcome.getComment());
            } else {
                ++this.wrongErrorResults;
                ++this.successes;
                this.resultsDoc.writeTestcaseElement(testName, "wrongError", outcome.getComment());
            }
        } else {
            this.noteFailure(testSetName, testName);
            if (outcome.getException() != null && outcome.getComment() == null) {
                outcome.setComment(outcome.getException().toString());
            }
            this.resultsDoc.writeTestcaseElement(testName, "fail", outcome.getComment());
        }
    }

    public void runJSTransform(Environment env, TestOutcome outcome, QName initialTemplateName, QName initialModeName, QName initialFunctionName, URI baseOutputURI) {
    }

    private boolean runWithXsltTransformer(XPathCompiler xpath, TestOutcome outcome, String testName, String testSetName, Environment env, XdmNode testInput, XsltExecutable sheet, ErrorCollector collector, XdmItem contextItem, XdmNode initialMode, QName initialModeName, QName initialTemplateName, String baseOutputURI) {
        try {
            XsltTransformer transformer = sheet.load();
            transformer.setURIResolver((URIResolver)env);
            transformer.setBaseOutputURI(baseOutputURI);
            if (env.unparsedTextResolver != null) {
                transformer.getUnderlyingController().setUnparsedTextURIResolver(env.unparsedTextResolver);
            }
            if (initialTemplateName != null) {
                transformer.setInitialTemplate(initialTemplateName);
            }
            if (initialMode != null) {
                try {
                    transformer.setInitialMode(initialModeName);
                }
                catch (IllegalArgumentException e) {
                    if (e.getCause() instanceof XPathException) {
                        collector.report((XmlProcessingError)new XmlProcessingException((XPathException)e.getCause()));
                        throw new SaxonApiException(e.getCause());
                    }
                    throw e;
                }
            }
            testInput.select(Steps.child((String)"param").where(Predicates.not(Xslt30TestSuiteDriverHE.isTrue("static")))).forEach(param -> {
                XdmValue value;
                String name = param.attribute("name");
                String select = param.attribute("select");
                try {
                    value = xpath.evaluate(select, null);
                }
                catch (SaxonApiException e) {
                    System.err.println("*** Error evaluating parameter " + name + ": " + e.getMessage());
                    throw new SaxonApiUncheckedException((Throwable)e);
                }
                transformer.setParameter(new QName(name), value);
                this.setGlobalParameter(new QName(name), value);
            });
            if (contextItem != null) {
                transformer.setInitialContextNode((XdmNode)contextItem);
            }
            if (env.streamedFile != null) {
                transformer.setSource((Source)new StreamSource(env.streamedFile));
            } else if (env.streamedContent != null) {
                transformer.setSource((Source)new StreamSource(new StringReader(env.streamedContent), "inlineDoc"));
            }
            for (QName varName : env.params.keySet()) {
                transformer.setParameter(varName, env.params.get(varName));
                this.setGlobalParameter(varName, env.params.get(varName));
            }
            transformer.setErrorReporter((ErrorReporter)collector);
            transformer.setMessageListener((content, terminate, locator) -> {
                outcome.addXslMessage(content);
                System.err.println(content.getStringValue());
            });
            StringWriter sw = new StringWriter();
            Serializer serializer = env.processor.newSerializer((Writer)sw);
            transformer.setDestination((Destination)serializer);
            transformer.getUnderlyingController().setOutputURIResolver((OutputURIResolver)new OutputResolver(env.processor, outcome, true));
            transformer.transform();
            outcome.setPrincipalSerializedResult(sw.toString());
            if (this.saveResults) {
                this.saveResultsToFile(sw.toString(), new File(this.resultsDir + "/results/" + testSetName + "/" + testName + ".out"));
                Map<URI, TestOutcome.SingleResultDoc> xslResultDocuments = outcome.getSecondaryResultDocuments();
                for (Map.Entry<URI, TestOutcome.SingleResultDoc> entry : xslResultDocuments.entrySet()) {
                    URI key = entry.getKey();
                    if (key == null) continue;
                    String path = key.getPath();
                    String serialization = outcome.serialize(env.processor, entry.getValue());
                    this.saveResultsToFile(serialization, new File(path));
                }
            }
            if (env.streamedContent != null) {
                transformer.setSource((Source)new StreamSource(new StringReader(env.streamedContent), "inlineDoc"));
            }
            XdmDestination destination = new XdmDestination();
            destination.setTreeModel(this.treeModel);
            transformer.setDestination((Destination)destination);
            transformer.getUnderlyingController().setOutputURIResolver((OutputURIResolver)new OutputResolver(env.processor, outcome, false));
            transformer.transform();
            outcome.setPrincipalResult((XdmValue)destination.getXdmNode());
            outcome.setWarningsReported(collector.getFoundWarnings());
        }
        catch (SaxonApiException err) {
            outcome.setException(err.getErrorCode());
            if (collector.getErrorCodes().isEmpty()) {
                outcome.addReportedError(err.getErrorCode().getLocalName());
            } else {
                outcome.setErrorsReported(collector.getErrorCodes());
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            this.noteFailure(testSetName, testName);
            this.resultsDoc.writeTestcaseElement(testName, "fail", "*** crashed " + err.getClass() + ": " + err.getMessage());
            return true;
        }
        return false;
    }

    protected void clearGlobalParameters() {
    }

    protected void setGlobalParameter(QName qName, XdmValue value) {
    }

    protected void clearInitialFunctionArguments() {
    }

    protected void addInitialFunctionArgument(XdmValue value) {
    }

    protected boolean runWithXslt30Transformer(XdmNode testCase, XPathCompiler xpath, TestOutcome outcome, String testName, String testSetName, Environment env, XdmNode testInput, XsltExecutable sheet, ErrorCollector collector, String xsltLanguageVersion, XdmItem contextItem, XdmNode initialMode, XdmNode initialFunction, XdmNode initialTemplate, QName initialModeName, XdmValue initialMatchSelection, QName initialTemplateName, String baseOutputURI) {
        try {
            XdmValue[] params;
            boolean assertsSerial = testCase.select(Steps.path((Step[])new Step[]{Steps.child((String)"result"), Steps.descendant((String)"assert-serialization").cat(Steps.descendant((String)"assert-serialization-error")).cat(Steps.descendant((String)"serialization-matches"))})).exists();
            boolean resultAsTree = env.outputTree;
            boolean serializationDeclared = env.outputSerialize;
            Optional needsTree = testInput.select(Steps.path((String[])new String[]{"output", "@tree"})).asOptionalString();
            if (needsTree.isPresent()) {
                resultAsTree = ((String)needsTree.get()).equals("yes");
            }
            testInput.select(Steps.path((String[])new String[]{"output", "@result-var"})).forEach(att -> outcome.setResultVar(att.getStringValue()));
            Optional serializeAtt = testInput.select(Steps.path((String[])new String[]{"output", "@serialize"})).asOptionalString();
            if (serializeAtt.isPresent()) {
                serializationDeclared = serializeAtt.equals(Optional.of("yes"));
            }
            boolean resultSerialized = serializationDeclared || assertsSerial;
            Xslt30Transformer transformer = sheet.load30();
            transformer.setURIResolver((URIResolver)env);
            if (env.unparsedTextResolver != null) {
                transformer.getUnderlyingController().setUnparsedTextURIResolver(env.unparsedTextResolver);
            }
            if (this.tracing) {
                transformer.setTraceListener((TraceListener)new XSLTTraceListener());
            }
            Map<QName, XdmValue> caseGlobalParams = this.getNamedParameters(xpath, testInput, false, false);
            HashMap<QName, XdmValue> globalParams = new HashMap<QName, XdmValue>(env.params);
            globalParams.putAll(caseGlobalParams);
            transformer.setStylesheetParameters(globalParams);
            if (contextItem != null) {
                transformer.setGlobalContextItem(contextItem);
            }
            transformer.setErrorReporter((ErrorReporter)collector);
            transformer.setBaseOutputURI(baseOutputURI);
            transformer.setMessageListener((content, errorCode, terminate, locator) -> {
                outcome.addXslMessage(content);
                System.err.println(content.getStringValue());
            });
            XdmValue result = null;
            StringWriter sw = new StringWriter();
            Serializer serializer = env.processor.newSerializer((Writer)sw);
            XsltController controller = transformer.getUnderlyingController();
            Serializer dest = null;
            if (baseOutputURI != null) {
                if (resultAsTree && !resultSerialized) {
                    transformer.setResultDocumentHandler((Function)new ResultDocHandler(env.processor, outcome, baseOutputURI, false));
                    dest = new XdmDestination();
                    ((XdmDestination)dest).setTreeModel(this.treeModel);
                } else {
                    transformer.setResultDocumentHandler((Function)new ResultDocHandler(env.processor, outcome, baseOutputURI, true));
                }
            }
            if (resultSerialized) {
                dest = serializer;
            }
            Source src = null;
            if (env.streamedFile != null) {
                src = new StreamSource(env.streamedFile);
            } else if (env.streamedContent != null) {
                src = new StreamSource(new StringReader(env.streamedContent), "inlineDoc");
            } else if (initialTemplate == null && contextItem != null) {
                src = ((XdmNode)contextItem).getUnderlyingNode();
            }
            if (src != null && !"skip".equals(env.streamedInputValidation)) {
                Processor processor = sheet.getProcessor();
                SchemaValidator validator = processor.getSchemaManager().newSchemaValidator();
                src = validator.asSource(src);
            }
            if (src == null && initialFunction == null && initialTemplateName == null && initialModeName == null) {
                initialTemplateName = new QName("xsl", "http://www.w3.org/1999/XSL/Transform", "initial-template");
            }
            try {
                if (initialModeName != null) {
                    transformer.setInitialMode(initialModeName);
                } else {
                    controller.getInitialMode();
                }
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof XPathException) {
                    collector.report((XmlProcessingError)new XmlProcessingException((XPathException)e.getCause()));
                    throw new SaxonApiException(e.getCause());
                }
                throw e;
            }
            if (initialMode != null || initialTemplate != null) {
                XdmNode init = initialMode == null ? initialTemplate : initialMode;
                params = this.getNamedParameters(xpath, init, false, false);
                Map<QName, XdmValue> tunnelledParams = this.getNamedParameters(xpath, init, false, true);
                if (xsltLanguageVersion.equals("2.0")) {
                    if (!params.isEmpty() || !tunnelledParams.isEmpty()) {
                        System.err.println("*** Initial template parameters ignored for XSLT 2.0");
                    }
                } else {
                    transformer.setInitialTemplateParameters((Map)params, false);
                    transformer.setInitialTemplateParameters(tunnelledParams, true);
                }
            }
            if (initialTemplateName != null) {
                transformer.setGlobalContextItem(contextItem);
                if (dest == null) {
                    result = transformer.callTemplate(initialTemplateName);
                } else {
                    transformer.callTemplate(initialTemplateName, (Destination)dest);
                }
            } else if (initialFunction != null) {
                QName name = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, initialFunction, (Step<? extends XdmNode>)Steps.attribute((String)"name"));
                params = this.getParameters(xpath, initialFunction);
                if (dest == null) {
                    result = transformer.callFunction(name, params);
                } else {
                    transformer.callFunction(name, params, (Destination)dest);
                }
            } else if (initialMatchSelection != null) {
                if (dest == null) {
                    result = transformer.applyTemplates(initialMatchSelection);
                } else {
                    transformer.applyTemplates(initialMatchSelection, (Destination)dest);
                }
            } else if (dest == null) {
                result = transformer.applyTemplates(src);
            } else {
                transformer.applyTemplates(src, (Destination)dest);
            }
            outcome.setWarningsReported(collector.getFoundWarnings());
            if (resultAsTree && !resultSerialized) {
                result = ((XdmDestination)dest).getXdmNode();
            }
            if (resultSerialized && outcome.getPrincipalSerializedResult() == null) {
                outcome.setPrincipalSerializedResult(sw.toString());
            }
            if (outcome.getPrincipalResult() == null) {
                outcome.setPrincipalResult(result);
            }
            if (this.saveResults) {
                String s = sw.toString();
                if (!resultSerialized && result != null) {
                    StringWriter sw2 = new StringWriter();
                    Serializer se = env.processor.newSerializer((Writer)sw2);
                    se.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                    env.processor.writeXdmValue(result, (Destination)se);
                    se.close();
                    s = sw2.toString();
                }
                this.saveResultsToFile(s, new File(this.resultsDir + "/results/" + testSetName + "/" + testName + ".out"));
                Map<URI, TestOutcome.SingleResultDoc> xslResultDocuments = outcome.getSecondaryResultDocuments();
                for (Map.Entry<URI, TestOutcome.SingleResultDoc> entry : xslResultDocuments.entrySet()) {
                    URI key = entry.getKey();
                    String path = key.getPath();
                    String serialization = outcome.serialize(env.processor, entry.getValue());
                    this.saveResultsToFile(serialization, new File(path));
                }
            }
        }
        catch (SaxonApiException err) {
            if (err.getCause() instanceof XPathException && !((XPathException)err.getCause()).hasBeenReported()) {
                System.err.println("Thrown exception " + ((XPathException)err.getCause()).getErrorCodeLocalPart() + ": " + err.getCause().getMessage());
            }
            outcome.setException(err.getErrorCode());
            if (collector.getErrorCodes().isEmpty()) {
                if (err.getErrorCode() == null) {
                    outcome.addReportedError("Error_with_no_error_code");
                } else {
                    outcome.addReportedError(err.getErrorCode().getLocalName());
                }
            } else {
                outcome.setErrorsReported(collector.getErrorCodes());
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            this.noteFailure(testSetName, testName);
            this.resultsDoc.writeTestcaseElement(testName, "fail", "*** crashed " + err.getClass() + ": " + err.getMessage());
            return true;
        }
        return false;
    }

    protected void initPatternOptimization(XsltCompiler compiler) {
    }

    protected XsltExecutable exportImport(String testName, String testSetName, TestOutcome outcome, XsltCompiler compiler, XsltExecutable sheet, ErrorCollector collector, Source styleSource) {
        try {
            if (this.export && this.isExportable(testName)) {
                sheet = this.exportStylesheet(testName, testSetName, compiler, sheet, styleSource);
            } else if (sheet == null) {
                sheet = compiler.compile(styleSource);
            }
        }
        catch (SaxonApiException err) {
            outcome.setException(err.getErrorCode());
            if (err.getErrorCode() != null) {
                collector.getErrorCodes().add(err.getErrorCode().getLocalName());
            }
            outcome.setErrorsReported(collector.getErrorCodes());
        }
        catch (Exception err) {
            err.printStackTrace();
            System.err.println(err.getMessage());
            outcome.setException(new QName(err.getClass().getName()));
            outcome.setErrorsReported(collector.getErrorCodes());
        }
        return sheet;
    }

    private boolean isExportable(String testName) {
        return !testName.equals("load-xquery-module-004") && !testName.equals("transform-004");
    }

    protected XsltExecutable exportStylesheet(String testName, String testSetName, XsltCompiler compiler, XsltExecutable sheet, Source styleSource) throws SaxonApiException {
        try {
            File exportFile = new File(this.resultsDir + "/export/" + testSetName + "/" + testName + ".sef");
            if (this.xxCompilerLocation != null && !compiler.isSchemaAware()) {
                if (this.xxCompiler == null) {
                    XsltCompiler c = this.driverProc.newXsltCompiler();
                    c.setAssertionsEnabled(true);
                    c.setParameter(new QName("FAST_JAVA_XPATH"), (XdmValue)new XdmAtomicValue(true));
                    c.setFastCompilation(true);
                    this.xxCompiler = c.compile((Source)new StreamSource(new File(this.xxCompilerLocation)));
                }
                Xslt30Transformer transformer = this.xxCompiler.load30();
                transformer.setAssertionsEnabled(true);
                transformer.setInitialMode(new QName("compile-complete"));
                ParseOptions options = new ParseOptions();
                options.setLineNumbering(true);
                styleSource = new AugmentedSource(styleSource, options);
                Serializer serializer = this.driverProc.newSerializer(exportFile);
                transformer.applyTemplates(styleSource, (Destination)serializer);
            } else {
                XsltPackage compiledPack = compiler.compilePackage(styleSource);
                compiledPack.save(exportFile);
            }
            sheet = this.reloadExportedStylesheet(compiler, exportFile);
        }
        catch (SaxonApiException e) {
            compiler.getErrorReporter().report((XmlProcessingError)new XmlProcessingException(XPathException.makeXPathException((Exception)((Object)e))));
            throw e;
        }
        return sheet;
    }

    protected XsltExecutable reloadExportedStylesheet(XsltCompiler compiler, File exportFile) throws SaxonApiException {
        return compiler.loadExecutablePackage(exportFile.toURI());
    }

    private XsltPackage exportImportPackage(String testName, String testSetName, TestOutcome outcome, XsltCompiler compiler, XsltPackage pack, ErrorCollector collector) {
        try {
            if (this.export) {
                try {
                    File exportFile = new File(this.resultsDir + "/export/" + testSetName + "/" + testName + ".base.sef");
                    System.err.println("Exported package to " + exportFile.getAbsolutePath());
                    pack.save(exportFile);
                    return compiler.loadLibraryPackage(exportFile.toURI());
                }
                catch (SaxonApiException e) {
                    System.err.println(e.getMessage());
                    throw e;
                }
            }
            return pack;
        }
        catch (SaxonApiException err) {
            outcome.setException(err.getErrorCode());
            if (err.getErrorCode() != null) {
                collector.getErrorCodes().add(err.getErrorCode().getLocalName());
            }
            outcome.setErrorsReported(collector.getErrorCodes());
        }
        catch (Exception err) {
            err.printStackTrace();
            System.err.println(err.getMessage());
            outcome.setException(new QName(err.getClass().getName()));
            outcome.setErrorsReported(collector.getErrorCodes());
        }
        return pack;
    }

    public void runStreamabilityTests(XPathCompiler xpc, XdmNode testCase) {
    }

    protected Map<QName, XdmValue> getNamedParameters(XPathCompiler xpath, XdmNode node, boolean getStatic, boolean tunnel) throws SaxonApiException {
        HashMap<QName, XdmValue> params = new HashMap<QName, XdmValue>();
        int i = 1;
        Predicate staticTest = Xslt30TestSuiteDriverHE.isTrue("static");
        if (!getStatic) {
            staticTest = Predicates.not(staticTest);
        }
        List paramElements = node.select(Steps.child((String)"param").where(staticTest)).asListOfNodes();
        for (XdmNode param : paramElements) {
            XdmValue value;
            boolean required;
            QName name = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, param, (Step<? extends XdmNode>)Steps.attribute((String)"name"));
            String select = param.attribute("select");
            String tunnelled = param.attribute("tunnel");
            QName as = Xslt30TestSuiteDriverHE.getQNameAttribute(xpath, param, (Step<? extends XdmNode>)Steps.attribute((String)"as"));
            boolean bl = required = tunnel == (tunnelled != null && tunnelled.equals("yes"));
            if (name == null) {
                System.err.println("*** No name for parameter " + i + " in initial-template");
                throw new SaxonApiException("*** No name for parameter " + i + " in initial-template");
            }
            try {
                value = xpath.evaluate(select, null);
                ++i;
            }
            catch (SaxonApiException e) {
                System.err.println("*** Error evaluating parameter " + name + " in initial-template : " + e.getMessage());
                throw e;
            }
            if (as != null) {
                value = new XdmAtomicValue(((AtomicValue)value.getUnderlyingValue()).getStringValue(), new ItemTypeFactory(xpath.getProcessor()).getAtomicType(as));
            }
            if (!required) continue;
            params.put(name, value);
        }
        return params;
    }

    protected XdmValue[] getParameters(XPathCompiler xpath, XdmNode node) {
        ArrayList params = new ArrayList();
        node.select(Steps.child((String)"param").where(Predicates.not(Xslt30TestSuiteDriverHE.isTrue("static")))).forEach(param -> {
            XdmValue value;
            String select = param.attribute("select");
            try {
                value = xpath.evaluate(select, null);
            }
            catch (SaxonApiException e) {
                System.err.println("*** Error evaluating parameter " + params.size() + " in initial-function : " + e.getMessage());
                throw new SaxonApiUncheckedException((Throwable)e);
            }
            params.add(value);
        });
        return params.toArray(new XdmValue[0]);
    }

    protected void saveResultsToFile(String content, File file) {
        try {
            Query.createFileIfNecessary((File)file);
            FileWriter writer = new FileWriter(file);
            writer.append(content);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("*** Failed to save results to " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    protected boolean assertOptimization(XsltExecutable stylesheet, String assertion) throws SaxonApiException {
        XdmDestination builder = new XdmDestination();
        stylesheet.explain((Destination)builder);
        builder.close();
        XdmNode expressionTree = builder.getXdmNode();
        XPathCompiler xpe = stylesheet.getProcessor().newXPathCompiler();
        XPathSelector exp = xpe.compile(assertion).load();
        exp.setContextItem((XdmItem)expressionTree);
        XdmAtomicValue bv = (XdmAtomicValue)exp.evaluateSingle();
        if (bv == null || !bv.getBooleanValue()) {
            this.println("** Optimization assertion failed");
            this.println(expressionTree.toString());
        }
        return bv != null && bv.getBooleanValue();
    }

    protected void setDependencyData() {
        this.alwaysOn.add("feature/disabling_output_escaping");
        this.alwaysOn.add("feature/serialization");
        this.alwaysOn.add("feature/namespace_axis");
        this.alwaysOn.add("feature/dtd");
        this.alwaysOn.add("feature/built_in_derived_types");
        this.alwaysOn.add("feature/remote_http");
        this.alwaysOn.add("feature/xsl-stylesheet-processing-instruction");
        this.alwaysOn.add("feature/fn-transform-XSLT");
        this.alwaysOn.add("available_documents");
        this.alwaysOn.add("ordinal_scheme_name");
        this.alwaysOn.add("default_calendar_in_date_formatting_functions");
        this.alwaysOn.add("supported_calendars_in_date_formatting_functions");
        this.alwaysOn.add("maximum_number_of_decimal_digits");
        this.alwaysOn.add("default_output_encoding");
        this.alwaysOn.add("unparsed_text_encoding");
        this.alwaysOn.add("recognize_id_as_uri_fragment");
        this.alwaysOn.add("feature/XPath_3.1");
        this.alwaysOn.add("feature/backwards_compatibility");
        this.alwaysOn.add("feature/HTML4");
        this.alwaysOn.add("feature/HTML5");
        this.needsPE.add("feature/Saxon-PE");
        this.needsPE.add("feature/dynamic_evaluation");
        this.needsEE.add("languages_for_numbering");
        this.needsEE.add("feature/streaming");
        this.needsEE.add("feature/schema_aware");
        this.needsEE.add("feature/Saxon-EE");
        this.needsEE.add("feature/xquery_invocation");
        this.needsEE.add("feature/higher_order_functions");
        this.alwaysOn.add("detect_accumulator_cycles");
    }

    @Override
    public boolean ensureDependencySatisfied(XdmNode dependency, Environment env) {
        boolean needed;
        String type = dependency.getNodeName().getLocalName();
        String value = dependency.attribute("value");
        if (value == null) {
            value = "*";
        }
        String tv = type + "/" + value;
        boolean inverse = "false".equals(dependency.attribute("satisfied"));
        boolean bl = needed = !"false".equals(dependency.attribute("satisfied"));
        if (this.alwaysOn.contains(type) || this.alwaysOn.contains(tv)) {
            return needed;
        }
        if (this.alwaysOff.contains(type) || this.alwaysOff.contains(tv)) {
            return !needed;
        }
        String edition = env.processor.getSaxonEdition();
        if (this.needsPE.contains(type) || this.needsPE.contains(tv)) {
            return (edition.equals("PE") || edition.equals("EE")) == needed;
        }
        if (this.needsEE.contains(type) || this.needsEE.contains(tv)) {
            return edition.equals("EE") == needed;
        }
        switch (type) {
            case "spec": {
                boolean atLeast = value.endsWith("+");
                value = value.replace("+", "");
                String specName = this.spec.specAndVersion.replace("XT", "XSLT");
                int order = value.compareTo(specName);
                return atLeast ? order <= 0 : order == 0;
            }
            case "feature": {
                switch (value) {
                    case "XML_1.1": {
                        String requiredVersion = inverse ? "1.0" : "1.1";
                        final String oldVersion = env.processor.getXmlVersion();
                        env.resetActions.add(new Environment.ResetAction(){

                            @Override
                            public void reset(Environment env) {
                                env.processor.setXmlVersion(oldVersion);
                            }
                        });
                        env.processor.setXmlVersion(requiredVersion);
                        return true;
                    }
                    case "XSD_1.1": {
                        String requiredVersion = inverse ? "1.0" : "1.1";
                        final String oldVersion = (String)env.processor.getConfigurationProperty(Feature.XSD_VERSION);
                        if (!oldVersion.equals(requiredVersion)) {
                            env.processor.setConfigurationProperty(Feature.XSD_VERSION, (Object)requiredVersion);
                            env.resetActions.add(new Environment.ResetAction(){

                                @Override
                                public void reset(Environment env) {
                                    env.processor.setConfigurationProperty(Feature.XSD_VERSION, (Object)oldVersion);
                                }
                            });
                        }
                        return true;
                    }
                    case "higher_order_functions": {
                        return !inverse;
                    }
                    case "simple-uca-fallback": {
                        return !inverse;
                    }
                    case "advanced-uca-fallback": {
                        return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
                    }
                    case "streaming-fallback": {
                        boolean required = !inverse;
                        final boolean old = (Boolean)env.processor.getConfigurationProperty(Feature.STREAMING_FALLBACK);
                        if (old != required) {
                            env.processor.setConfigurationProperty(Feature.STREAMING_FALLBACK, (Object)required);
                            env.resetActions.add(new Environment.ResetAction(){

                                @Override
                                public void reset(Environment env) {
                                    env.processor.setConfigurationProperty(Feature.STREAMING_FALLBACK, (Object)old);
                                }
                            });
                        }
                        return true;
                    }
                }
                System.err.println("*** Unknown feature in HE: " + value);
                return env.processor.getSaxonEdition().equals("HE") ? Boolean.valueOf(false) : null;
            }
            case "default_language_for_numbering": {
                final String old = (String)env.processor.getConfigurationProperty(Feature.DEFAULT_LANGUAGE);
                if (!value.equals(old)) {
                    env.processor.setConfigurationProperty(Feature.DEFAULT_LANGUAGE, (Object)value);
                    env.resetActions.add(new Environment.ResetAction(){

                        @Override
                        public void reset(Environment env) {
                            env.processor.setConfigurationProperty(Feature.DEFAULT_LANGUAGE, (Object)old);
                        }
                    });
                }
                return true;
            }
            case "enable_assertions": {
                boolean on = !inverse;
                final boolean old = env.xsltCompiler.isAssertionsEnabled();
                env.xsltCompiler.setAssertionsEnabled(on);
                env.resetActions.add(new Environment.ResetAction(){

                    @Override
                    public void reset(Environment env) {
                        env.xsltCompiler.setAssertionsEnabled(old);
                    }
                });
                return true;
            }
            case "extension-function": {
                if (value.equals("Q{http://relaxng.org/ns/structure/1.0}schema-report#1")) {
                    try {
                        Configuration config = env.processor.getUnderlyingConfiguration();
                        Object sf = config.getInstance("net.cfoster.saxonjing.SchemaFunction", null);
                        env.processor.registerExtensionFunction((ExtensionFunctionDefinition)sf);
                        Object sfd = config.getInstance("net.cfoster.saxonjing.SchemaReportFunction", null);
                        env.processor.registerExtensionFunction((ExtensionFunctionDefinition)sfd);
                        return true;
                    }
                    catch (XPathException err) {
                        System.err.println("Failed to load Saxon-Jing extension functions");
                        return false;
                    }
                }
                return false;
            }
            case "year_component_values": {
                if ("support year zero".equals(value)) {
                    if (env != null) {
                        env.processor.setConfigurationProperty(Feature.XSD_VERSION, (Object)(inverse ? "1.0" : "1.1"));
                        return true;
                    }
                    return false;
                }
                return !inverse;
            }
            case "additional_normalization_form": {
                if ("support FULLY-NORMALIZED".equals(value)) {
                    return inverse;
                }
                return !inverse;
            }
            case "on-multiple-match": {
                throw new IllegalStateException("on-multiple-match is no longer recognized");
            }
            case "ignore_doc_failure": {
                return inverse;
            }
            case "combinations_for_numbering": {
                if (value.equals("COPTIC EPACT DIGIT ONE") || value.equals("SINHALA ARCHAIC DIGIT ONE") || value.equals("MENDE KIKAKUI DIGIT ONE")) {
                    return false;
                }
                return !inverse;
            }
            case "xsd-version": {
                return env.processor.getSaxonEdition().equals("HE") ? Boolean.valueOf(false) : null;
            }
            case "sweep_and_posture": {
                return env.processor.getSaxonEdition().equals("HE") ? Boolean.valueOf(inverse) : null;
            }
            case "unicode-version": {
                return value.equals("6.0");
            }
            case "default_html_version": {
                return value.equals("5");
            }
        }
        this.println("**** dependency not recognized for HE: " + type);
        return false;
    }

    protected static QName getQNameAttribute(XPathCompiler compiler, XdmNode contextItem, Step<? extends XdmNode> attributePath) {
        Optional att = contextItem.select(attributePath).asOptionalNode();
        if (att.isPresent()) {
            String val = ((XdmNode)att.get()).getStringValue().trim();
            if (val.equals("#unnamed")) {
                return new QName("http://www.w3.org/1999/XSL/Transform", "unnamed");
            }
            if (val.equals("#default")) {
                return new QName("http://www.w3.org/1999/XSL/Transform", "default");
            }
            if (val.startsWith("{")) {
                return new QName(StructuredQName.fromClarkName((String)val));
            }
            if (val.startsWith("Q{")) {
                return new QName(StructuredQName.fromEQName((CharSequence)val));
            }
            if (val.contains(":")) {
                try {
                    QNameValue qn = ResolveQName.resolveQName((CharSequence)val, (NodeInfo)((XdmNode)att.get()).getUnderlyingNode().getParent());
                    return new QName(qn.getStructuredQName());
                }
                catch (XPathException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return new QName(val);
        }
        return null;
    }

    protected static class OutputResolver
    implements OutputURIResolver {
        private Processor proc;
        private TestOutcome outcome;
        private Destination destination;
        private StringWriter stringWriter;
        boolean serialized;
        URI uri;

        public OutputResolver(Processor proc, TestOutcome outcome, boolean serialized) {
            this.proc = proc;
            this.outcome = outcome;
            this.serialized = serialized;
        }

        public OutputResolver newInstance() {
            return new OutputResolver(this.proc, this.outcome, this.serialized);
        }

        public Result resolve(String href, String base) throws XPathException {
            try {
                this.uri = ResolveURI.makeAbsolute((String)href, (String)base);
                if (this.serialized) {
                    this.stringWriter = new StringWriter();
                    StreamResult result = new StreamResult(this.stringWriter);
                    result.setSystemId(this.uri.toString());
                    return result;
                }
                this.destination = new XdmDestination();
                this.destination.setDestinationBaseURI(this.uri);
                return this.destination.getReceiver(null, null);
            }
            catch (URISyntaxException | SaxonApiException e) {
                throw new XPathException(e);
            }
        }

        public void close(Result result) throws XPathException {
            if (this.uri != null) {
                if (this.serialized) {
                    this.outcome.setSecondaryResult(this.uri, null, this.stringWriter == null ? "" : this.stringWriter.toString());
                } else {
                    XdmDestination xdm = (XdmDestination)this.destination;
                    if (xdm != null) {
                        this.outcome.setSecondaryResult(xdm.getDestinationBaseURI(), (XdmValue)xdm.getXdmNode(), null);
                    }
                }
            }
        }
    }

    protected static class ResultDocHandler
    implements Function<URI, Destination> {
        private Processor proc;
        private TestOutcome outcome;
        private URI baseOutputURI;
        boolean serialized;

        public ResultDocHandler(Processor proc, TestOutcome outcome, String baseOutputURI, boolean serialized) {
            this.proc = proc;
            this.outcome = outcome;
            try {
                this.baseOutputURI = new URI(baseOutputURI);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            this.serialized = serialized;
        }

        @Override
        public Destination apply(URI uri) {
            if (this.serialized) {
                StringWriter stringWriter = new StringWriter();
                Serializer destination = this.proc.newSerializer((Writer)stringWriter);
                destination.setDestinationBaseURI(uri);
                if (uri.equals(this.baseOutputURI)) {
                    destination.onClose(() -> this.outcome.setPrincipalSerializedResult(stringWriter.toString()));
                } else {
                    destination.onClose(() -> this.outcome.setSecondaryResult(uri, null, stringWriter.toString()));
                }
                return destination;
            }
            XdmDestination destination = new XdmDestination();
            destination.setBaseURI(uri);
            if (uri.equals(this.baseOutputURI)) {
                destination.onClose(() -> this.outcome.setPrincipalResult((XdmValue)destination.getXdmNode()));
            } else {
                destination.onClose(() -> this.outcome.setSecondaryResult(uri, (XdmValue)destination.getXdmNode(), null));
            }
            return destination;
        }
    }
}

