/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.function.IntPredicate;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;

final class DescendantIteratorSansText
implements AxisIterator {
    private final TinyTree tree;
    private int nextNodeNr;
    private final int startDepth;
    private final IntPredicate matcher;

    DescendantIteratorSansText(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest) {
        this.tree = doc;
        this.nextNodeNr = node.nodeNr;
        this.startDepth = doc.depth[this.nextNodeNr];
        this.matcher = nodeTest.getMatcher(doc);
    }

    @Override
    public NodeInfo next() {
        do {
            ++this.nextNodeNr;
            try {
                if (this.tree.depth[this.nextNodeNr] <= this.startDepth) {
                    this.nextNodeNr = -1;
                    return null;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.nextNodeNr = -1;
                return null;
            }
        } while (!this.matcher.test(this.nextNodeNr));
        return this.tree.getNode(this.nextNodeNr);
    }
}

