/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.saiku.web.svg.JpgConverter;
import org.saiku.web.svg.PdfConverter;
import org.saiku.web.svg.PngConverter;
import org.saiku.web.svg.SvgConverter;
import org.saiku.web.svg.TiffConverter;

public abstract class Converter {
    private final String contentType;
    private final String extension;

    public abstract void convert(InputStream var1, OutputStream var2, Integer var3) throws IOException, TranscoderException;

    protected Converter(String contentType, String extension) {
        this.contentType = contentType;
        this.extension = extension;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getExtension() {
        return this.extension;
    }

    public static Converter byType(String type) {
        if (type.equals("SVG")) {
            return new SvgConverter();
        }
        if (type.equals("PNG")) {
            return new PngConverter();
        }
        if (type.equals("TIFF")) {
            return new TiffConverter();
        }
        if (type.equals("JPG")) {
            return new JpgConverter();
        }
        if (type.equals("PDF")) {
            return new PdfConverter();
        }
        return null;
    }
}

