/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query;

import java.util.Map;
import java.util.Properties;
import mondrian.rolap.RolapConnection;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Scenario;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.mdx.parser.MdxParserFactory;
import org.olap4j.mdx.parser.MdxValidator;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Database;
import org.olap4j.metadata.Schema;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.type.CubeType;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuTag;
import org.saiku.olap.query.IQuery;
import org.saiku.olap.query.QuerySerializer;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdxQuery
implements IQuery {
    private static final Logger log = LoggerFactory.getLogger(MdxQuery.class);
    private Properties properties = new Properties();
    private String mdx;
    private SaikuCube cube;
    private OlapConnection connection;
    private String name;
    private Scenario scenario;
    private CellSet cellset;
    private OlapStatement statement;

    public MdxQuery(OlapConnection con, SaikuCube cube, String name, String mdx) {
        this.cube = cube;
        this.connection = con;
        this.name = name;
        this.mdx = mdx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SaikuCube getSaikuCube() {
        try {
            Cube c = this.getCube();
            SaikuCube sc = new SaikuCube(this.cube.getConnectionName(), c.getUniqueName(), c.getName(), c.getCaption(), this.cube.getCatalogName(), c.getSchema().getName());
            if (sc != null) {
                this.cube = sc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cube;
    }

    @Override
    public String getMdx() {
        return this.mdx;
    }

    @Override
    public void setMdx(String mdx) {
        this.mdx = mdx;
    }

    @Override
    public void resetQuery() {
        this.mdx = "";
    }

    @Override
    public void setProperties(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
    }

    @Override
    public Properties getProperties() {
        Properties props = this.properties;
        props.put("saiku.olap.query.drillthrough", this.isDrillThroughEnabled().toString());
        props.put("org.saiku.connection.scenario", Boolean.toString(false));
        try {
            props.put("org.saiku.query.explain", Boolean.toString(this.connection.isWrapperFor(RolapConnection.class)));
        }
        catch (Exception e) {
            props.put("org.saiku.query.explain", Boolean.toString(false));
        }
        return props;
    }

    @Override
    public String toXml() {
        QuerySerializer qs = new QuerySerializer(this);
        return qs.createXML();
    }

    @Override
    public Boolean isDrillThroughEnabled() {
        try {
            Cube cube = this.getCube();
            return cube != null && cube.isDrillThroughEnabled();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CellSet execute() throws Exception {
        try {
            CellSet cs;
            OlapStatement stmt;
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
            OlapConnection con = this.connection;
            con.setCatalog(this.getSaikuCube().getCatalogName());
            this.statement = stmt = con.createStatement();
            CellSet cellSet = cs = stmt.executeOlapQuery(this.mdx);
            return cellSet;
        }
        finally {
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
        }
    }

    @Override
    public IQuery.QueryType getType() {
        return IQuery.QueryType.MDX;
    }

    @Override
    public void swapAxes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Axis, QueryAxis> getAxes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryAxis getAxis(Axis axis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryAxis getAxis(String name) throws SaikuOlapException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cube getCube() {
        MdxParserFactory parserFactory = this.connection.getParserFactory();
        MdxParser mdxParser = parserFactory.createMdxParser(this.connection);
        MdxValidator mdxValidator = parserFactory.createMdxValidator(this.connection);
        String mdx = this.getMdx();
        try {
            if (mdx != null && mdx.length() > 0 && mdx.toUpperCase().contains("FROM")) {
                SelectNode select = mdxParser.parseSelect(this.getMdx());
                select = mdxValidator.validateSelect(select);
                CubeType cubeType = (CubeType)select.getFrom().getType();
                Cube cube = cubeType.getCube();
                return cube;
            }
        }
        catch (Exception e) {
            log.debug("Parsing MDX to get the Cube failed. Using fallback scenario.", (Throwable)e);
        }
        finally {
            mdxValidator = null;
        }
        try {
            if (this.connection != null && mdx != null && mdx.length() > 0) {
                for (Database db : this.connection.getOlapDatabases()) {
                    Catalog cat = (Catalog)db.getCatalogs().get(this.cube.getCatalogName());
                    if (cat == null) continue;
                    for (Schema schema : cat.getSchemas()) {
                        for (Cube cub : schema.getCubes()) {
                            if (!cub.getName().equals(this.cube.getName()) && !cub.getUniqueName().equals(this.cube.getName())) continue;
                            return cub;
                        }
                    }
                }
            }
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public QueryAxis getUnusedAxis() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveDimension(QueryDimension dimension, Axis axis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveDimension(QueryDimension dimension, Axis axis, int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryDimension getDimension(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetAxisSelections(QueryAxis axis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearAllQuerySelections() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearAxis(String axisName) throws SaikuOlapException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    @Override
    public Scenario getScenario() {
        return this.scenario;
    }

    @Override
    public void setTag(SaikuTag tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SaikuTag getTag() {
        return null;
    }

    @Override
    public void removeTag() {
    }

    @Override
    public void storeCellset(CellSet cs) {
        this.cellset = cs;
    }

    @Override
    public CellSet getCellset() {
        return this.cellset;
    }

    @Override
    public void setStatement(OlapStatement os) {
        this.statement = os;
    }

    @Override
    public OlapStatement getStatement() {
        return this.statement;
    }

    @Override
    public void cancel() throws Exception {
        if (this.statement != null && !this.statement.isClosed()) {
            this.statement.close();
        }
        this.statement = null;
    }
}

