/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples.formula;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;

public class CheckFunctionsSupported {
    private Workbook workbook;
    private FormulaEvaluator evaluator;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  CheckFunctionsSupported <filename>");
            return;
        }
        Workbook wb = WorkbookFactory.create((File)new File(args[0]));
        CheckFunctionsSupported check = new CheckFunctionsSupported(wb);
        ArrayList<FormulaEvaluationProblems> problems = new ArrayList<FormulaEvaluationProblems>();
        for (int sn = 0; sn < wb.getNumberOfSheets(); ++sn) {
            problems.add(check.getEvaluationProblems(sn));
        }
        TreeSet<String> unsupportedFunctions = new TreeSet<String>();
        for (FormulaEvaluationProblems p : problems) {
            unsupportedFunctions.addAll(p.unsupportedFunctions);
        }
        if (unsupportedFunctions.isEmpty()) {
            System.out.println("There are no unsupported formula functions used");
        } else {
            System.out.println("Unsupported formula functions:");
            for (String function : unsupportedFunctions) {
                System.out.println("  " + function);
            }
            System.out.println("Total unsupported functions = " + unsupportedFunctions.size());
        }
        for (int sn = 0; sn < wb.getNumberOfSheets(); ++sn) {
            String sheetName = wb.getSheetName(sn);
            FormulaEvaluationProblems probs = (FormulaEvaluationProblems)problems.get(sn);
            System.out.println();
            System.out.println("Sheet = " + sheetName);
            if (probs.unevaluatableCells.isEmpty()) {
                System.out.println(" All cells evaluated without error");
                continue;
            }
            for (CellReference cr : probs.unevaluatableCells.keySet()) {
                System.out.println(" " + cr.formatAsString() + " - " + probs.unevaluatableCells.get(cr));
            }
        }
    }

    public CheckFunctionsSupported(Workbook workbook) {
        this.workbook = workbook;
        this.evaluator = workbook.getCreationHelper().createFormulaEvaluator();
    }

    public Set<String> getUnsupportedFunctions(String sheetName) {
        return this.getUnsupportedFunctions(this.workbook.getSheet(sheetName));
    }

    public Set<String> getUnsupportedFunctions(int sheetIndex) {
        return this.getUnsupportedFunctions(this.workbook.getSheetAt(sheetIndex));
    }

    public Set<String> getUnsupportedFunctions(Sheet sheet) {
        FormulaEvaluationProblems problems = this.getEvaluationProblems(sheet);
        return problems.unsupportedFunctions;
    }

    public FormulaEvaluationProblems getEvaluationProblems(String sheetName) {
        return this.getEvaluationProblems(this.workbook.getSheet(sheetName));
    }

    public FormulaEvaluationProblems getEvaluationProblems(int sheetIndex) {
        return this.getEvaluationProblems(this.workbook.getSheetAt(sheetIndex));
    }

    public FormulaEvaluationProblems getEvaluationProblems(Sheet sheet) {
        HashSet<String> unsupportedFunctions = new HashSet<String>();
        HashMap<CellReference, Exception> unevaluatableCells = new HashMap<CellReference, Exception>();
        for (Row r : sheet) {
            for (Cell c : r) {
                try {
                    this.evaluator.evaluate(c);
                }
                catch (Exception e) {
                    if (e instanceof NotImplementedException && e.getCause() != null) {
                        e = (Exception)e.getCause();
                    }
                    if (e instanceof NotImplementedFunctionException) {
                        NotImplementedFunctionException nie = (NotImplementedFunctionException)e;
                        unsupportedFunctions.add(nie.getFunctionName());
                    }
                    unevaluatableCells.put(new CellReference(c), e);
                }
            }
        }
        return new FormulaEvaluationProblems(unsupportedFunctions, unevaluatableCells);
    }

    public static class FormulaEvaluationProblems {
        public Set<String> unsupportedFunctions;
        public Map<CellReference, Exception> unevaluatableCells;

        protected FormulaEvaluationProblems(Set<String> unsupportedFunctions, Map<CellReference, Exception> unevaluatableCells) {
            this.unsupportedFunctions = Collections.unmodifiableSet(unsupportedFunctions);
            this.unevaluatableCells = Collections.unmodifiableMap(unevaluatableCells);
        }
    }
}

