/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.TempFile;

public class CopyCompare {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        POIFSFileSystem cpfs;
        POIFSFileSystem opfs;
        block7: {
            String originalFileName = null;
            String copyFileName = null;
            if (args.length == 1) {
                originalFileName = args[0];
                File f = TempFile.createTempFile((String)"CopyOfPOIFileSystem-", (String)".ole2");
                f.deleteOnExit();
                copyFileName = f.getAbsolutePath();
            } else if (args.length == 2) {
                originalFileName = args[0];
                copyFileName = args[1];
            } else {
                System.err.println("Usage: " + CopyCompare.class.getName() + "originPOIFS [copyPOIFS]");
                System.exit(1);
            }
            POIFSReader r = new POIFSReader();
            CopyFile cf = new CopyFile(copyFileName);
            r.registerListener((POIFSReaderListener)cf);
            r.setNotifyEmptyDirectories(true);
            FileInputStream fis = new FileInputStream(originalFileName);
            r.read((InputStream)fis);
            fis.close();
            cf.close();
            opfs = null;
            cpfs = null;
            try {
                opfs = new POIFSFileSystem(new File(originalFileName));
                cpfs = new POIFSFileSystem(new File(copyFileName));
                DirectoryNode oRoot = opfs.getRoot();
                DirectoryNode cRoot = cpfs.getRoot();
                StringBuffer messages = new StringBuffer();
                if (CopyCompare.equal((DirectoryEntry)oRoot, (DirectoryEntry)cRoot, messages)) {
                    System.out.println("Equal");
                    break block7;
                }
                System.out.println("Not equal: " + messages);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(cpfs);
                IOUtils.closeQuietly(opfs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)cpfs);
        IOUtils.closeQuietly((Closeable)opfs);
    }

    private static boolean equal(DirectoryEntry d1, DirectoryEntry d2, StringBuffer msg) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        boolean equal = true;
        for (Entry e1 : d1) {
            String n1 = e1.getName();
            if (!d2.hasEntry(n1)) {
                msg.append("Document \"" + n1 + "\" exists only in the source.\n");
                equal = false;
                break;
            }
            Entry e2 = d2.getEntry(n1);
            if (e1.isDirectoryEntry() && e2.isDirectoryEntry()) {
                equal = CopyCompare.equal((DirectoryEntry)e1, (DirectoryEntry)e2, msg);
                continue;
            }
            if (e1.isDocumentEntry() && e2.isDocumentEntry()) {
                equal = CopyCompare.equal((DocumentEntry)e1, (DocumentEntry)e2, msg);
                continue;
            }
            msg.append("One of \"" + e1 + "\" and \"" + e2 + "\" is a " + "document while the other one is a directory.\n");
            equal = false;
        }
        for (Entry e2 : d2) {
            String n2 = e2.getName();
            Entry e1 = null;
            try {
                e1 = d1.getEntry(n2);
            }
            catch (FileNotFoundException ex) {
                msg.append("Document \"" + e2 + "\" exitsts, document \"" + e1 + "\" does not.\n");
                equal = false;
                break;
            }
        }
        return equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean equal(DocumentEntry d1, DocumentEntry d2, StringBuffer msg) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        DocumentInputStream dis1 = new DocumentInputStream(d1);
        DocumentInputStream dis2 = new DocumentInputStream(d2);
        try {
            if (PropertySet.isPropertySetStream((InputStream)dis1) && PropertySet.isPropertySetStream((InputStream)dis2)) {
                PropertySet ps2;
                PropertySet ps1 = PropertySetFactory.create((InputStream)dis1);
                if (!ps1.equals((Object)(ps2 = PropertySetFactory.create((InputStream)dis2)))) {
                    msg.append("Property sets are not equal.\n");
                    boolean bl = false;
                    return bl;
                }
            } else {
                int i1;
                do {
                    int i2;
                    if ((i1 = dis1.read()) == (i2 = dis2.read())) continue;
                    msg.append("Documents are not equal.\n");
                    boolean bl = false;
                    return bl;
                } while (i1 > -1);
            }
        }
        finally {
            dis2.close();
            dis1.close();
        }
        return true;
    }

    static class CopyFile
    implements POIFSReaderListener {
        private String dstName;
        private OutputStream out;
        private POIFSFileSystem poiFs;
        private final Map<String, DirectoryEntry> paths = new HashMap<String, DirectoryEntry>();

        public CopyFile(String dstName) {
            this.dstName = dstName;
            this.poiFs = new POIFSFileSystem();
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            Throwable t;
            String name;
            POIFSDocumentPath path;
            block8: {
                path = event.getPath();
                name = event.getName();
                DocumentInputStream stream = event.getStream();
                t = null;
                try {
                    if (stream != null && PropertySet.isPropertySetStream((InputStream)stream)) {
                        PropertySet ps = null;
                        try {
                            ps = PropertySetFactory.create((InputStream)stream);
                        }
                        catch (NoPropertySetStreamException ex) {
                            // empty catch block
                        }
                        this.copy(this.poiFs, path, name, ps);
                        break block8;
                    }
                    this.copy(this.poiFs, path, name, stream);
                }
                catch (MarkUnsupportedException ex) {
                    t = ex;
                }
                catch (IOException ex) {
                    t = ex;
                }
                catch (WritingNotSupportedException ex) {
                    t = ex;
                }
            }
            if (t != null) {
                throw new HPSFRuntimeException("Could not read file \"" + path + "/" + name, t);
            }
        }

        public void copy(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, PropertySet ps) throws WritingNotSupportedException, IOException {
            DirectoryEntry de = this.getPath(poiFs, path);
            MutablePropertySet mps = new MutablePropertySet(ps);
            de.createDocument(name, mps.toInputStream());
        }

        public void copy(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, DocumentInputStream stream) throws IOException {
            int c;
            DirectoryEntry de = this.getPath(poiFs, path);
            if (stream == null || name == null) {
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((c = stream.read()) != -1) {
                out.write(c);
            }
            stream.close();
            out.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            de.createDocument(name, (InputStream)in);
        }

        public void close() throws FileNotFoundException, IOException {
            this.out = new FileOutputStream(this.dstName);
            this.poiFs.writeFilesystem(this.out);
            this.out.close();
        }

        public DirectoryEntry getPath(POIFSFileSystem poiFs, POIFSDocumentPath path) {
            try {
                String s = path.toString();
                DirectoryEntry de = this.paths.get(s);
                if (de != null) {
                    return de;
                }
                int l = path.length();
                if (l == 0) {
                    de = poiFs.getRoot();
                } else {
                    de = this.getPath(poiFs, path.getParent());
                    de = de.createDirectory(path.getComponent(path.length() - 1));
                }
                this.paths.put(s, de);
                return de;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                throw new RuntimeException(ex.toString());
            }
        }
    }
}

