/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.structureditor;

import de.statspez.pleditor.generator.interpreter.GenericFieldDescriptor;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.plausi.ExtendedSatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.ui.structureditor.TreeColorRenderer;
import de.statspez.pleditor.ui.structureditor.TreeTable;
import de.statspez.pleditor.ui.structureditor.TreeTableModelAdapter;
import de.statspez.pleditor.ui.structureditor.data.Node;
import de.statspez.pleditor.ui.structureditor.data.NodeBuilder;
import de.statspez.pleditor.ui.structureditor.data.StructureTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;

public class ProgramVariableView
extends JPanel {
    private static final long serialVersionUID = -7132661284424996903L;
    private Node root;
    private JToolBar toolBar;
    private Action addAction;
    private RemoveValueAction removeAction;
    private TreeTable table;
    private JScrollPane scrollPane;
    private boolean withRootNode;
    private SatzInterface satz;
    private MetaThemenbereich topic;
    private SatzInterface lokalsatz;
    private List localVarible;
    private Map expandedPaths;
    protected TreePath selectedTreePath;
    private Map scrollPosition;

    public ProgramVariableView(MetaThemenbereich topic, SatzInterface satz) {
        this(topic, null, satz, null, null);
    }

    public ProgramVariableView(MetaThemenbereich topic, FeldDeskriptorImpl selectedThemenbereich, SatzInterface satz, List localVarible, SatzInterface lokalsatz) {
        this(topic, satz, null, null, true);
    }

    public ProgramVariableView(MetaThemenbereich topic, SatzInterface satz, List localVarible, SatzInterface lokalsatz, boolean withRootNode) {
        this.satz = satz;
        this.topic = topic;
        this.withRootNode = withRootNode;
        this.localVarible = localVarible;
        this.lokalsatz = lokalsatz;
        this.expandedPaths = new HashMap();
        this.scrollPosition = new HashMap();
        if (topic != null) {
            NodeBuilder nodeBuilder = new NodeBuilder();
            this.root = nodeBuilder.build(topic, satz, localVarible, lokalsatz);
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(MetaThemenbereich topic, SatzInterface satz, List localVarible, SatzInterface lokalsatz) {
        Point point;
        TreePath treePath;
        String key;
        StructureTreeModel structureTreeModel;
        String key2;
        JTree tree = this.table.getTree();
        TreePath pathForRow = tree.isRootVisible() ? this.table.getTree().getPathForRow(0) : (this.root != null ? new TreePath(new Node[]{this.root}) : null);
        Enumeration expandedDescendants = tree.getExpandedDescendants(pathForRow);
        if (this.topic != null && expandedDescendants != null && (key2 = this.topic.getName()) != null && key2.length() > 0) {
            this.expandedPaths.put(key2, expandedDescendants);
            Point position = this.scrollPane.getViewport().getViewPosition();
            this.scrollPosition.put(key2, position);
        }
        expandedDescendants = null;
        this.satz = satz;
        this.topic = topic;
        this.localVarible = localVarible;
        this.lokalsatz = lokalsatz;
        NodeBuilder nodeBuilder = new NodeBuilder();
        Node tmpRoot = nodeBuilder.build(topic, satz, localVarible, lokalsatz);
        StructureTreeModel structureTreeModel2 = structureTreeModel = (StructureTreeModel)((TreeTableModelAdapter)this.table.getModel()).getTreeTableModel();
        synchronized (structureTreeModel2) {
            this.root = tmpRoot;
            structureTreeModel.setRoot(this.root);
            this.table.getTree().updateUI();
            this.table.updateUI();
        }
        if (topic != null && (key = topic.getName()) != null && key.length() > 0) {
            expandedDescendants = (Enumeration)this.expandedPaths.get(key);
        }
        while (expandedDescendants != null && expandedDescendants.hasMoreElements()) {
            TreePath nextElement = expandedDescendants.nextElement();
            TreePath treePath2 = this.createNewTreePath(nextElement);
            if (treePath2 == null) continue;
            tree.expandPath(treePath2);
        }
        if (!this.withRootNode) {
            tree.expandPath(new TreePath(new Node[]{this.root}));
        }
        if (this.selectedTreePath != null && (treePath = this.createNewTreePath(this.selectedTreePath)) != null) {
            tree.setSelectionPath(treePath);
        }
        if (topic != null && (key = topic.getName()) != null && key.length() > 0 && (point = (Point)this.scrollPosition.get(key)) != null) {
            this.scrollPane.getViewport().setViewPosition(point);
        }
    }

    private synchronized TreePath createNewTreePath(TreePath path) {
        if (path == null) {
            return null;
        }
        ArrayList<Node> objects = new ArrayList<Node>();
        Node actualNode = this.root;
        int i = 0;
        while (i < path.getPathCount()) {
            if (path.getPathComponent(i) != null && actualNode.toString().equals(path.getPathComponent(i).toString())) {
                objects.add(actualNode);
            }
            if (actualNode.hasChild()) {
                int d = 0;
                while (d < actualNode.getChildCount()) {
                    Node child = actualNode.getChild(d);
                    if (child.toString().equals(path.getPathComponent(i).toString())) {
                        objects.add(child);
                        actualNode = child;
                        break;
                    }
                    ++d;
                }
            }
            ++i;
        }
        if (objects != null && objects.isEmpty()) {
            return null;
        }
        return new TreePath(objects.toArray(new Node[objects.size()]));
    }

    private void init() {
        this.createTable();
        GridBagConstraints gdc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setAlignmentX(1.0f);
        JPanel toolPanel = new JPanel(new BorderLayout());
        toolPanel.add((Component)this.toolBar, "East");
        this.addAction = new AddValueAction();
        this.toolBar.add(this.addAction);
        this.removeAction = new RemoveValueAction();
        this.toolBar.add(this.removeAction);
        gdc.fill = 2;
        gdc.weightx = 1.0;
        gdc.gridy = 0;
        gdc.gridx = 0;
        this.add((Component)toolPanel, gdc);
        gdc.fill = 1;
        gdc.anchor = 12;
        gdc.weightx = 1.0;
        ++gdc.gridy;
        gdc.weighty = 1.0;
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)this.scrollPane, gdc);
    }

    private void createTable() {
        this.table = new TreeTable(new StructureTreeModel(this.root));
        this.table.setSelectionMode(0);
        this.table.getTree().getSelectionModel().setSelectionMode(1);
        TreeColorRenderer treeColorRenderer = new TreeColorRenderer();
        this.table.setTreeCellRenderer(treeColorRenderer);
        this.table.setGridColor(SystemColor.control);
        this.table.setRowHeight(18);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.getTree().setRootVisible(this.withRootNode);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = ProgramVariableView.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    ProgramVariableView.this.selectedTreePath = ProgramVariableView.this.table.getTree().getSelectionPath();
                }
            }
        });
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public Node getSelectedNode() {
        Node returnValue = null;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow > 0) {
            TreeTableModelAdapter adapter = (TreeTableModelAdapter)this.table.getModel();
            returnValue = (Node)adapter.nodeForRow(selectedRow);
        }
        return returnValue;
    }

    private class AddValueAction
    extends AbstractAction {
        private static final long serialVersionUID = 4935853279687695697L;

        public AddValueAction() {
            this.putValue("ShortDescription", "Wert hinzuf\u00fcgen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/ui/structureditor/add.gif")));
            ProgramVariableView.this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent paramListSelectionEvent) {
                    TreeTableModelAdapter model;
                    Node node;
                    MetaElement element;
                    boolean result = false;
                    int selectedRow = ProgramVariableView.this.table.getSelectedRow();
                    if (selectedRow >= 0 && (element = (node = (Node)(model = (TreeTableModelAdapter)ProgramVariableView.this.table.getModel()).nodeForRow(selectedRow)).getElement()) instanceof MetaTBFeld) {
                        MetaTBFeld feld = (MetaTBFeld)element;
                        MetaCustomTBFeld metaFeld = (MetaCustomTBFeld)feld;
                        int[] dimensions = metaFeld.dimensions();
                        int currentIndize = 0;
                        if (node.getFeldDeskriptor().getIndizes() != null && node.getFeldDeskriptor().getIndizes().length > 0) {
                            currentIndize = node.getFeldDeskriptor().getIndizes().length - 1;
                        }
                        if (dimensions != null && dimensions.length > 0 && currentIndize >= 0 && currentIndize < dimensions.length && dimensions[currentIndize] == -1) {
                            result = node.isVirtual();
                        }
                    }
                    AddValueAction.this.setEnabled(result);
                }
            });
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaTBFeld feld;
            MetaCustomTBFeld metaFeld;
            int[] dimensions;
            int selectedRow = ProgramVariableView.this.table.getSelectedRow();
            TreeTableModelAdapter model = (TreeTableModelAdapter)ProgramVariableView.this.table.getModel();
            Node node = (Node)model.nodeForRow(selectedRow);
            MetaElement element = node.getElement();
            if (element instanceof MetaTBFeld && (dimensions = (metaFeld = (MetaCustomTBFeld)(feld = (MetaTBFeld)element)).dimensions()) != null && dimensions.length > 0) {
                int currentIndize = 0;
                if (node.getFeldDeskriptor().getIndizes() != null && node.getFeldDeskriptor().getIndizes().length > 0) {
                    currentIndize = node.getFeldDeskriptor().getIndizes().length - 1;
                }
                if (currentIndize >= 0 && currentIndize < dimensions.length && dimensions[currentIndize] == -1) {
                    FeldDeskriptorImpl deskriptor = node.getFeldDeskriptor();
                    try {
                        int size = ProgramVariableView.this.satz.getLaenge(deskriptor, null);
                        GenericFieldDescriptor newDescriptor = new GenericFieldDescriptor(deskriptor.getFeldDeskriptor(), new int[]{size}, (FeldDeskriptorImpl)deskriptor.getVorgaenger());
                        if (ProgramVariableView.this.satz instanceof ExtendedSatzInterface) {
                            ((ExtendedSatzInterface)ProgramVariableView.this.satz).appendSatz(newDescriptor);
                        } else if (metaFeld.getKlasse() instanceof MetaThemenbereich) {
                            ProgramVariableView.this.satz.getSubSatz(newDescriptor);
                        } else {
                            ProgramVariableView.this.satz.setLeerWert(newDescriptor);
                        }
                        ProgramVariableView.this.update(ProgramVariableView.this.topic, ProgramVariableView.this.satz, ProgramVariableView.this.localVarible, ProgramVariableView.this.lokalsatz);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private class RemoveValueAction
    extends AbstractAction {
        private static final long serialVersionUID = 4935853279687695697L;

        public RemoveValueAction() {
            this.putValue("ShortDescription", "Wert entfernen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/ui/structureditor/delete.gif")));
            ProgramVariableView.this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent paramListSelectionEvent) {
                    TreeTableModelAdapter model;
                    Node node;
                    MetaElement element;
                    boolean result = false;
                    int selectedRow = ProgramVariableView.this.table.getSelectedRow();
                    if (selectedRow >= 0 && (element = (node = (Node)(model = (TreeTableModelAdapter)ProgramVariableView.this.table.getModel()).nodeForRow(selectedRow)).getElement()) instanceof MetaTBFeld) {
                        MetaTBFeld feld = (MetaTBFeld)element;
                        MetaCustomTBFeld metaFeld = (MetaCustomTBFeld)feld;
                        int[] dimensions = metaFeld.dimensions();
                        int currentIndize = 0;
                        if (node.getFeldDeskriptor().getIndizes() != null && node.getFeldDeskriptor().getIndizes().length > 0) {
                            currentIndize = node.getFeldDeskriptor().getIndizes().length - 1;
                        }
                        if (dimensions != null && dimensions.length > 0 && currentIndize >= 0 && currentIndize < dimensions.length && dimensions[currentIndize] == -1) {
                            result = !node.isVirtual();
                        }
                    }
                    RemoveValueAction.this.setEnabled(result);
                }
            });
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaTBFeld feld;
            MetaCustomTBFeld metaFeld;
            int[] dimensions;
            int selectedRow = ProgramVariableView.this.table.getSelectedRow();
            TreeTableModelAdapter model = (TreeTableModelAdapter)ProgramVariableView.this.table.getModel();
            Node node = (Node)model.nodeForRow(selectedRow);
            MetaElement element = node.getElement();
            if (element instanceof MetaTBFeld && (dimensions = (metaFeld = (MetaCustomTBFeld)(feld = (MetaTBFeld)element)).dimensions()) != null && dimensions.length > 0) {
                int currentIndize = 0;
                if (node.getFeldDeskriptor().getIndizes() != null && node.getFeldDeskriptor().getIndizes().length > 0) {
                    currentIndize = node.getFeldDeskriptor().getIndizes().length - 1;
                }
                if (currentIndize >= 0 && currentIndize < dimensions.length && dimensions[currentIndize] == -1) {
                    FeldDeskriptorImpl deskriptor = node.getFeldDeskriptor();
                    try {
                        if (ProgramVariableView.this.satz instanceof ExtendedSatzInterface) {
                            ((ExtendedSatzInterface)ProgramVariableView.this.satz).removeSatz(deskriptor);
                        } else if (metaFeld.getKlasse() instanceof MetaThemenbereich) {
                            ProgramVariableView.this.satz.setLeerWert(deskriptor);
                        } else {
                            ProgramVariableView.this.satz.setString(deskriptor, null);
                        }
                        ProgramVariableView.this.update(ProgramVariableView.this.topic, ProgramVariableView.this.satz, ProgramVariableView.this.localVarible, ProgramVariableView.this.lokalsatz);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }
}

