/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.test.ExpectedPlausiError;
import de.statspez.pleditor.generator.runtime.test.FieldTestCase;
import de.statspez.pleditor.generator.runtime.test.FlowTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public abstract class PlausiTestCase {
    private String name = null;
    private List expectedErrors = new ArrayList();
    private Set context = new HashSet();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addExpectedError(ExpectedPlausiError error) {
        this.expectedErrors.add(error);
    }

    public Iterator getExpectedErrors() {
        return this.expectedErrors.iterator();
    }

    public Iterator getExpectedErrors(String context) {
        ArrayList<ExpectedPlausiError> result = new ArrayList<ExpectedPlausiError>();
        for (ExpectedPlausiError error : this.expectedErrors) {
            if (!error.inContext(context)) continue;
            result.add(error);
        }
        return result.iterator();
    }

    public int getExpectedErrorSize() {
        return this.expectedErrors.size();
    }

    public boolean inContext(String context) {
        return this.context.isEmpty() || this.context.contains(context);
    }

    public void setContext(String context) {
        this.context.clear();
        if (context != null) {
            this.context.addAll(Arrays.asList(context.split(" ")));
        }
    }

    public abstract void interprete(MetaCustomPlausibilisierung var1, PlausiTestResult var2);

    public abstract void execute(PlausiInterface var1, PlausiTestResult var2);

    public abstract void performJavaScript(MetaCustomPlausibilisierung var1, File var2, PlausiTestResult var3);

    protected MetaStatspezObjekt getMetaObject(MetaCustomPlausibilisierung plausi) {
        if (this instanceof FieldTestCase) {
            return this.getMerkmal(plausi.rootThemenbereich(), ((FieldTestCase)this).getField());
        }
        if (this instanceof FlowTestCase) {
            String compareString = ((FlowTestCase)this).getFlow();
            Iterator ablaufIterator = plausi.rootThemenbereich().getAblaeufe();
            while (ablaufIterator.hasNext()) {
                MetaCustomAblauf metaAblauf = (MetaCustomAblauf)ablaufIterator.next();
                if (!metaAblauf.getName().equals(compareString)) continue;
                return metaAblauf;
            }
        }
        return null;
    }

    protected MetaMerkmal getMerkmal(MetaThemenbereich topic, String field) {
        String structure;
        MetaMerkmal result = null;
        int indexOfDot = field.indexOf(46);
        if (indexOfDot >= 0) {
            structure = field.substring(0, indexOfDot);
            field = field.substring(indexOfDot + 1);
            int indexOfBrace = structure.indexOf(91);
            if (indexOfBrace >= 0) {
                structure = structure.substring(0, indexOfBrace);
            }
        } else {
            structure = null;
        }
        Iterator fields = topic.getFelder();
        while (fields.hasNext()) {
            MetaTBFeld currentField = (MetaTBFeld)fields.next();
            if (structure != null) {
                if (!currentField.getName().equals(structure)) continue;
                result = this.getMerkmal((MetaThemenbereich)currentField.getKlasse(), field);
                break;
            }
            if (!currentField.getName().equals(field)) continue;
            result = (MetaMerkmal)currentField.getKlasse();
            break;
        }
        return result;
    }

    protected ElementMessageContext getElementMessage(MetaStatspezObjekt metaStatspezObjekt) {
        ElementMessageContext elementMessage = null;
        if (metaStatspezObjekt != null) {
            String name = metaStatspezObjekt.getName();
            String id = metaStatspezObjekt.getId();
            int typ = 0;
            if (metaStatspezObjekt instanceof MetaCustomMerkmal) {
                typ = 5;
            } else if (metaStatspezObjekt instanceof MetaCustomFunktion) {
                int functionType = ((MetaCustomFunktion)metaStatspezObjekt).getFunctionType();
                if (functionType == 1) {
                    typ = 3;
                }
                if (functionType == 0) {
                    typ = 4;
                }
            }
            if (metaStatspezObjekt instanceof MetaCustomAblauf) {
                typ = 2;
            }
            if (metaStatspezObjekt instanceof MetaCustomPruefung) {
                typ = 1;
            }
            elementMessage = new ElementMessageContext(typ, id, name);
        }
        return elementMessage;
    }

    protected String getProgramCode(MetaStatspezObjekt metaStatspezObjekt) {
        String code = metaStatspezObjekt instanceof MetaCustomMerkmal ? ((MetaCustomMerkmal)metaStatspezObjekt).getPLSpezifikation() : (metaStatspezObjekt instanceof MetaPLFunktion ? ((MetaPLFunktion)metaStatspezObjekt).getAnweisungen() : (metaStatspezObjekt instanceof MetaCustomPruefung ? ((MetaCustomPruefung)metaStatspezObjekt).getPLSpezifikation() : (metaStatspezObjekt instanceof MetaPLAblauf ? ((MetaPLAblauf)metaStatspezObjekt).getSpezifikation() : null)));
        return code;
    }

    protected PlausiFehler[] performJavaScriptPlausi(ScriptEngine scriptEngine, String statement) throws ScriptException {
        ArrayList<PlausiFehler> errors = new ArrayList<PlausiFehler>();
        scriptEngine.eval("var errors = " + statement + ";\n");
        Number numOfErrors = (Number)scriptEngine.eval("errors != null ? errors.length : 0");
        int i = 0;
        while (i < numOfErrors.intValue()) {
            PlausiFehler error = new PlausiFehler();
            error.setFehlerId((String)scriptEngine.eval("errors[" + i + "].id"));
            error.setFehlerInfoTyp(((Number)scriptEngine.eval("errors[" + i + "].infoType")).intValue());
            error.setFehlertextKurz((String)scriptEngine.eval("errors[" + i + "].message"));
            error.setFehlertextLang((String)scriptEngine.eval("errors[" + i + "].description"));
            error.setFehlerKorrekturhinweis((String)scriptEngine.eval("errors[" + i + "].correctionAdvice"));
            error.setReferenzFeld(this.createFieldDescriptor((String)scriptEngine.eval("errors[" + i + "].field")));
            ArrayList<FeldDeskriptorInterface> referencedFields = new ArrayList<FeldDeskriptorInterface>();
            Number numOfReferencedFields = (Number)scriptEngine.eval("errors[" + i + "].referencedFields != null ? errors[" + i + "].referencedFields.length : 0");
            int j = 0;
            while (j < numOfReferencedFields.intValue()) {
                referencedFields.add(this.createFieldDescriptor((String)scriptEngine.eval("errors[" + i + "].referencedFields[" + j + "]")));
                ++j;
            }
            error.setFelder(referencedFields.toArray(new FeldDeskriptorInterface[referencedFields.size()]));
            errors.add(error);
            ++i;
        }
        return errors.toArray(new PlausiFehler[errors.size()]);
    }

    protected FeldDeskriptorInterface createFieldDescriptor(String field) {
        if (field == null || field.length() == 0) {
            return null;
        }
        String[] fields = field.split("\\.");
        SimpleFieldDescriptor fieldDescriptor = null;
        int i = 0;
        while (i < fields.length) {
            int[] indices;
            String[] fieldAndIndices = fields[i].split("\\[");
            String fieldName = fieldAndIndices[0];
            int[] nArray = indices = fieldAndIndices.length > 1 ? new int[fieldAndIndices.length - 1] : null;
            if (indices != null) {
                int j = 0;
                while (j < indices.length) {
                    indices[j] = Integer.parseInt(fieldAndIndices[j + 1].substring(0, fieldAndIndices[j + 1].length() - 1));
                    ++j;
                }
            }
            fieldDescriptor = new SimpleFieldDescriptor(fieldDescriptor, fieldName, indices);
            ++i;
        }
        return fieldDescriptor;
    }

    private static final class SimpleFieldDescriptor
    implements FeldDeskriptorInterface {
        private final FeldDeskriptorInterface parent;
        private final String fieldName;
        private final int[] indices;

        public SimpleFieldDescriptor(FeldDeskriptorInterface parent, String fieldName, int[] indices) {
            this.parent = parent;
            this.fieldName = fieldName;
            this.indices = indices;
        }

        @Override
        public String getFeldNameDSB() {
            return null;
        }

        @Override
        public String getFeldNameTB() {
            return this.fieldName;
        }

        @Override
        public void setFeldNameDSB(String feldNameDSB) {
        }

        @Override
        public void setFeldNameTB(String feldNameTB) {
        }

        @Override
        public void setVorgaenger(FeldDeskriptorInterface vorgaenger) {
        }

        @Override
        public FeldDeskriptorInterface getVorgaenger() {
            return this.parent;
        }

        @Override
        public void setIndizes(int[] indizes) {
        }

        @Override
        public int[] getIndizes() {
            return this.indices;
        }

        @Override
        public void setMaske(String maske) {
        }

        @Override
        public String getMaske() {
            return null;
        }
    }
}

