/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Array;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;

public class SubArray
extends Array {
    private Array array;
    private int[] indizes;

    public SubArray(Array array, int[] indizes) {
        super(SubArray.getSubDimension(array.getDimension(), indizes));
        this.array = array;
        this.indizes = indizes;
    }

    @Override
    public int getLengthOfDimension(PlausiRuntimeContext context, int[] indizes) {
        return this.array.getLengthOfDimension(context, this.getSuperIndizes(indizes));
    }

    @Override
    public void setElement(PlausiRuntimeContext context, int[] indizes, Object object) {
        this.array.setElement(context, this.getSuperIndizes(indizes), object);
    }

    @Override
    public Object getElement(PlausiRuntimeContext context, int[] indizes) {
        return this.array.getElement(context, this.getSuperIndizes(indizes));
    }

    @Override
    protected int getLengthOfDimensionImpl(PlausiRuntimeContext context, int[] indizes) {
        return this.array.getLengthOfDimensionImpl(context, indizes);
    }

    @Override
    protected Object getElementImpl(PlausiRuntimeContext context, int[] indizes) {
        return this.array.getElementImpl(context, indizes);
    }

    private static int[] getSubDimension(int[] dimension, int[] indizes) {
        int[] subDimension = null;
        if (dimension != null) {
            if (indizes == null) {
                subDimension = dimension;
            } else {
                subDimension = new int[dimension.length - indizes.length];
                int i = indizes.length;
                int index = 0;
                while (i < dimension.length) {
                    subDimension[index] = dimension[i];
                    ++i;
                    ++index;
                }
            }
        }
        return subDimension;
    }

    private int[] getSuperIndizes(int[] indizes) {
        int[] superIndizes = null;
        if (this.indizes == null || this.indizes.length == 0) {
            superIndizes = indizes;
        } else if (indizes == null || indizes.length == 0) {
            superIndizes = this.indizes;
        } else {
            superIndizes = new int[this.indizes.length + indizes.length];
            int index = 0;
            int i = 0;
            while (i < this.indizes.length) {
                superIndizes[index] = this.indizes[i];
                ++i;
                ++index;
            }
            i = 0;
            while (i < indizes.length) {
                superIndizes[index] = indizes[i];
                ++i;
                ++index;
            }
        }
        return superIndizes;
    }
}

