/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.masken.DatumMaske;
import de.statspez.pleditor.generator.runtime.Array;
import de.statspez.pleditor.generator.runtime.DateValue;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Range;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.Variable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Vector;

public class FunctionLib {
    public static Value EXPONENT(PlausiRuntimeContext context, Value x, Value y) {
        return ValueFactory.instance().valueFor(Math.pow(x.asDouble(), y.asDouble()));
    }

    public static Value MODULO(PlausiRuntimeContext context, Value x, Value y) {
        if (y == null || !y.isValid() || y == NilValue.instance()) {
            String fehler = "MODULO: Division durch Null-Wert.";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (y.eq(ValueFactory.instance().valueFor(0.0))) {
            String fehler = "MODULO: Division durch Null (" + y + ").";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (x == null || !x.isValid() || x == NilValue.instance()) {
            return InvalidValue.instance();
        }
        return ValueFactory.instance().valueFor(x.asDouble() % y.asDouble());
    }

    public static Value ZUFALLSZAHL_AUS_LISTE(PlausiRuntimeContext context, Array liste) {
        Value result;
        int length = liste.getLengthOfDimension(context, null);
        if (length > 0) {
            Random random = context.getRandom();
            result = ((Variable)liste.getElement(context, new int[]{random.nextInt(liste.getLengthOfDimension(context, null))})).get(context);
        } else {
            result = InvalidValue.instance();
        }
        return result;
    }

    public static Value ZUFALLSZAHL_AUS_REIHE(PlausiRuntimeContext context, Value reihe) {
        Value result;
        if (!(reihe instanceof Range)) {
            throw new ValueConversionException("Der Wert ist keine Reihe oder Sequenz");
        }
        Vector<Value> v = new Vector<Value>();
        PlausiRuntimeIterator it = ((Range)reihe).iterator();
        while (it.hasNext()) {
            v.add((Value)it.next());
        }
        if (v.isEmpty()) {
            result = InvalidValue.instance();
        } else {
            Random r = context.getRandom();
            result = (Value)v.elementAt(r.nextInt(v.size()));
        }
        return result;
    }

    public static Value JAHR(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0) {
                if (dateValue.getFormat().indexOf("JJJJ") >= 0) {
                    SimpleDateFormat formatter = DatumMaske.createSimpleDateFormat("yyyy");
                    Double d_jahr = new Double(formatter.format(((DateValue)value).date()));
                    return ValueFactory.instance().valueFor(d_jahr);
                }
                if (dateValue.getFormat().indexOf("JJ") >= 0) {
                    SimpleDateFormat formatter = DatumMaske.createSimpleDateFormat("yy");
                    Double d_jahr = new Double(formatter.format(((DateValue)value).date()));
                    return ValueFactory.instance().valueFor(d_jahr);
                }
            }
            throw new ValueConversionException("Jahrwert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Jahrwert kann nur aus Datumswert berechnet werden.");
    }

    public static Value JAHR_ALS_ZEICHENKETTE(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0) {
                if (dateValue.getFormat().indexOf("JJJJ") >= 0) {
                    SimpleDateFormat formatter = DatumMaske.createSimpleDateFormat("yyyy");
                    return ValueFactory.instance().valueFor(formatter.format(((DateValue)value).date()));
                }
                if (dateValue.getFormat().indexOf("JJ") >= 0) {
                    SimpleDateFormat formatter = DatumMaske.createSimpleDateFormat("yy");
                    return ValueFactory.instance().valueFor(formatter.format(((DateValue)value).date()));
                }
            }
            throw new ValueConversionException("Jahrwert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Jahrwert kann nur aus Datumswert berechnet werden.");
    }

    public static Value MONAT(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0 && dateValue.getFormat().indexOf("MM") >= 0) {
                SimpleDateFormat formatter = DatumMaske.createSimpleDateFormat("MM");
                Double d_jahr = new Double(formatter.format(((DateValue)value).date()));
                return ValueFactory.instance().valueFor(d_jahr);
            }
            throw new ValueConversionException("Monatswert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Monatswert kann nur aus Datumswert berechnet werden.");
    }

    public static Value MONAT_ALS_ZEICHENKETTE(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0 && dateValue.getFormat().indexOf("MM") >= 0) {
                SimpleDateFormat formatter = DatumMaske.createSimpleDateFormat("MM");
                return ValueFactory.instance().valueFor(formatter.format(((DateValue)value).date()));
            }
            throw new ValueConversionException("Monatswert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Monatswert kann nur aus Datumswert berechnet werden.");
    }

    public static Value TAG(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0 && dateValue.getFormat().indexOf("TT") >= 0) {
                SimpleDateFormat formatter = DatumMaske.createSimpleDateFormat("dd");
                Double d_jahr = new Double(formatter.format(((DateValue)value).date()));
                return ValueFactory.instance().valueFor(d_jahr);
            }
            throw new ValueConversionException("Tageswert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Tageswert kann nur aus Datumswert berechnet werden.");
    }

    public static Value TAG_ALS_ZEICHENKETTE(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0 && dateValue.getFormat().indexOf("TT") >= 0) {
                SimpleDateFormat formatter = DatumMaske.createSimpleDateFormat("dd");
                return ValueFactory.instance().valueFor(formatter.format(((DateValue)value).date()));
            }
            throw new ValueConversionException("Tageswert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Tageswert kann nur aus Datumswert berechnet werden.");
    }

    public static Value HEUTE(PlausiRuntimeContext context) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new DateValue(cal.getTime(), "TT.MM.JJJJ");
    }

    public static Value DATUM_VERSCHIEBEN(PlausiRuntimeContext context, Value datum, Value delta, Value einheit) {
        int field;
        if (datum == null || !(datum instanceof DateValue)) {
            throw new ValueConversionException("Datumsverschiebung kann nur bei Datumswert berechnet werden.");
        }
        if (delta == null || delta.asLong() > Integer.MAX_VALUE) {
            throw new ValueConversionException("Das Delta der Datumsverschiebung ist ungueltig: " + delta);
        }
        if (einheit == null || einheit.asString() == null) {
            throw new ValueConversionException("Die Einheit der Datumsverschiebung ist ungueltig: " + einheit);
        }
        String fieldStr = einheit.asString();
        if (fieldStr.equals("J")) {
            field = 1;
        } else if (fieldStr.equals("M")) {
            field = 2;
        } else if (fieldStr.equals("W")) {
            field = 6;
        } else if (fieldStr.equals("T")) {
            field = 6;
        } else if (fieldStr.equals("A")) {
            field = 6;
        } else {
            throw new ValueConversionException("Die Einheit der Datumsverschiebung ist ungueltig: " + einheit);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(((DateValue)datum).date());
        int amount = (int)delta.asLong();
        if (fieldStr.equals("A")) {
            int amountUnit = amount > 0 ? 1 : -1;
            while (amount != 0) {
                cal.add(field, amountUnit);
                if (cal.get(7) == 7 || cal.get(7) == 1) continue;
                amount -= amountUnit;
            }
        } else {
            if (fieldStr.equals("W")) {
                amount *= 7;
            }
            cal.add(field, amount);
        }
        return new DateValue(cal.getTime(), ((DateValue)datum).getFormat());
    }

    public static Value DATUM_DIFFERENZ(PlausiRuntimeContext context, Value datum1, Value datum2, Value einheit) {
        if (datum1 == null || !(datum1 instanceof DateValue) || datum2 == null || !(datum2 instanceof DateValue)) {
            throw new ValueConversionException("Datumsdifferenz kann nur bei Datumswerten berechnet werden.");
        }
        if (einheit == null || einheit.asString() == null) {
            throw new ValueConversionException("Die Berechnungseinheit der Datumsdifferenz ist ungueltig: " + einheit);
        }
        Date date1 = ((DateValue)datum1).date();
        Date date2 = ((DateValue)datum2).date();
        String fieldStr = einheit.asString();
        if (fieldStr.equals("J")) {
            int diff = 0;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            if (date1.compareTo(date2) <= 0) {
                cal1.setTime(date1);
                cal2.setTime(date2);
            } else {
                cal1.setTime(date2);
                cal2.setTime(date1);
            }
            while (cal1.before(cal2)) {
                cal1.add(1, 1);
                if (cal1.after(cal2)) continue;
                ++diff;
            }
            return ValueFactory.instance().valueFor(diff * (date1.compareTo(date2) <= 0 ? 1 : -1));
        }
        if (fieldStr.equals("W")) {
            return ValueFactory.instance().valueFor((int)((date2.getTime() - date1.getTime()) / 1000L / 60L / 60L / 24L / 7L));
        }
        if (fieldStr.equals("T")) {
            return ValueFactory.instance().valueFor((int)((date2.getTime() - date1.getTime()) / 1000L / 60L / 60L / 24L));
        }
        throw new ValueConversionException("Die Berechnungseinheit der Datumsdifferenz ist ungueltig: " + einheit);
    }

    public static Value TEIL(PlausiRuntimeContext context, Value value, Value start, Value laenge) {
        if (value != null) {
            if (start == null || start.asLong() > Integer.MAX_VALUE) {
                throw new ValueConversionException("Der Startindex ist ungueltig: " + start);
            }
            if (laenge == null || laenge.asLong() > Integer.MAX_VALUE) {
                throw new ValueConversionException("Der Laenge des Teilstrings ist ungueltig: " + laenge);
            }
            String str_value = value.asString();
            String erg = "";
            int startIndex = (int)start.asLong() - 1;
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (str_value != null && startIndex < str_value.length()) {
                int endIndex = startIndex + (int)laenge.asLong();
                erg = laenge.asLong() > 0L && endIndex < str_value.length() ? str_value.substring(startIndex, endIndex) : str_value.substring(startIndex);
            }
            return ValueFactory.instance().valueFor(erg);
        }
        throw new ValueConversionException("Die Zeichenkette kann nur aus einer Zeichenkette ausgelesen werden.");
    }

    public static Value KONKATENIEREN(PlausiRuntimeContext context, Value start, Value end) {
        String startStr = "";
        String endStr = "";
        if (start != null && start.isValid() && start != NilValue.instance()) {
            startStr = start.asString();
        }
        if (end != null && end.isValid() && end != NilValue.instance()) {
            endStr = end.asString();
        }
        return ValueFactory.instance().valueFor(String.valueOf(startStr) + endStr);
    }

    public static Value ERSETZEN(PlausiRuntimeContext context, Value text, Value zeichenfolge, Value neueZeichenfolge) {
        String s = "";
        String m = "";
        String r = "";
        if (text != null && text.isValid() && text != NilValue.instance()) {
            s = text.asString();
        }
        if (zeichenfolge != null && zeichenfolge.isValid() && zeichenfolge != NilValue.instance()) {
            m = zeichenfolge.asString();
        }
        if (neueZeichenfolge != null && neueZeichenfolge.isValid() && neueZeichenfolge != NilValue.instance()) {
            r = neueZeichenfolge.asString();
        }
        if (s.length() > 0 && m.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < s.length()) {
                if (s.substring(i).startsWith(m)) {
                    buffer.append(r);
                    i += m.length() - 1;
                } else {
                    buffer.append(s.charAt(i));
                }
                ++i;
            }
            s = buffer.toString();
        }
        return ValueFactory.instance().valueFor(s);
    }

    public static Value WERTLAENGE(PlausiRuntimeContext context, Value wert) {
        int erg = 0;
        String wertStr = "";
        if (wert != null) {
            wertStr = wert.asString();
        }
        if (wertStr != null) {
            erg = wertStr.length();
        }
        return ValueFactory.instance().valueFor(erg);
    }

    public static Value ENDET_AUF(PlausiRuntimeContext context, Value wert, Value suffix) {
        boolean erg = false;
        if (wert != null) {
            erg = suffix != null ? wert.asString().endsWith(suffix.asString()) : true;
        }
        return ValueFactory.instance().valueFor(erg);
    }

    public static Value BEGINNT_MIT(PlausiRuntimeContext context, Value wert, Value prefix) {
        boolean erg = false;
        if (wert != null) {
            erg = prefix != null ? wert.asString().startsWith(prefix.asString()) : true;
        }
        return ValueFactory.instance().valueFor(erg);
    }

    public static Value GROSSBUCHSTABEN(PlausiRuntimeContext context, Value wert) {
        if (wert == null || !wert.isValid() || wert == NilValue.instance()) {
            return wert;
        }
        return ValueFactory.instance().valueFor(wert.asString().toUpperCase());
    }

    public static Value KLEINBUCHSTABEN(PlausiRuntimeContext context, Value wert) {
        if (wert == null || !wert.isValid() || wert == NilValue.instance()) {
            return wert;
        }
        return ValueFactory.instance().valueFor(wert.asString().toLowerCase());
    }

    public static Value NUMERISCH(PlausiRuntimeContext context, Value wert) {
        String wertStr = "";
        if (wert != null) {
            wertStr = wert.asString();
        }
        boolean erg = true;
        char[] chars = wertStr.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isDigit(chars[i])) {
                erg = false;
                break;
            }
            ++i;
        }
        return ValueFactory.instance().valueFor(erg);
    }

    public static Value HAT_FORMAT(PlausiRuntimeContext context, Value format, Value wert) {
        String formatStr = "";
        if (format != null) {
            formatStr = format.asString();
        }
        String wertStr = "";
        if (wert != null) {
            wertStr = wert.asString();
        }
        return ValueFactory.instance().valueFor(wertStr.matches(formatStr));
    }

    public static Value RUNDEN(PlausiRuntimeContext context, Value wert, Value nachkommastellen) throws ValueConversionException {
        if (wert == null || !wert.isValid() || wert == NilValue.instance()) {
            return wert;
        }
        double doubleValue = 0.0;
        try {
            doubleValue = wert.asDouble();
        }
        catch (ValueConversionException e) {
            throw new ValueConversionException("Nur Zahlen d\u00fcrfen gerundet werden. " + e.getMessage());
        }
        double faktor = 1.0;
        if (nachkommastellen != null) {
            faktor = Math.pow(10.0, nachkommastellen.asLong());
        }
        double rounder = 0.5;
        if (doubleValue < 0.0) {
            rounder = -0.5;
        }
        long ganzzahl = (long)(doubleValue * faktor + rounder);
        return ValueFactory.instance().valueFor((double)ganzzahl / faktor);
    }

    public static Value ALS_GANZZAHL(PlausiRuntimeContext context, Value wert) {
        Value wertNeu = wert;
        if (wertNeu != null && wertNeu.isValid() && wertNeu != NilValue.instance()) {
            wertNeu = FunctionLib.RUNDEN(context, wert, ValueFactory.instance().valueFor(0.0));
        }
        return wertNeu;
    }

    public static Value ALS_GANZZAHL_OHNE_RUNDUNG(PlausiRuntimeContext context, Value wert) {
        Value wertNeu = wert;
        if (wertNeu != null && wertNeu.isValid() && wertNeu != NilValue.instance()) {
            wertNeu = ValueFactory.instance().valueFor(wert.asLong());
        }
        return wertNeu;
    }

    public static Value ALS_KOMMAZAHL(PlausiRuntimeContext context, Value wert) {
        Value wertNeu = wert;
        if (wertNeu != null && wertNeu.isValid() && wertNeu != NilValue.instance()) {
            wertNeu = ValueFactory.instance().valueFor(wert.asDouble());
        }
        return wertNeu;
    }

    public static Value ALS_ZEICHENKETTE(PlausiRuntimeContext context, Value wert) {
        Value wertNeu = wert;
        if (wertNeu != null && wertNeu.isValid() && wertNeu != NilValue.instance()) {
            wertNeu = ValueFactory.instance().valueFor(wert.asString());
        }
        return wertNeu;
    }

    public static Value ABSOLUTWERT(PlausiRuntimeContext context, Value wert) {
        if (wert == null || !wert.isValid() || wert == NilValue.instance()) {
            return wert;
        }
        double doubleValue = 0.0;
        try {
            doubleValue = wert.asDouble();
        }
        catch (ValueConversionException e) {
            throw new ValueConversionException("Der Absolutwert kann nur bei Zahlen berechnet werden. " + e.getMessage());
        }
        double abs = Math.abs(doubleValue);
        return new NumberValue(abs);
    }

    public static Value LOGARITHMUS(PlausiRuntimeContext context, Value wert, Value basis) {
        if (wert == null || !wert.isValid() || wert == NilValue.instance()) {
            return wert;
        }
        if (basis == null || !basis.isValid() || basis == NilValue.instance()) {
            return wert;
        }
        double doubleValue = 0.0;
        double logBasis = 0.0;
        try {
            doubleValue = wert.asDouble();
        }
        catch (ValueConversionException e) {
            throw new ValueConversionException("Der Logarithmus kann nur bei Zahlen berechnet werden. " + e.getMessage());
        }
        try {
            logBasis = basis.asDouble();
        }
        catch (ValueConversionException e) {
            throw new ValueConversionException("Der Logarithmus kann nur bei Zahlen berechnet werden. " + e.getMessage());
        }
        if (doubleValue <= 0.0) {
            throw new ValueConversionException("Der Logarithmus kann nur f\u00fcr Zahlen gr\u00f6\u00dfer 0 berechnet werden.");
        }
        if (logBasis <= 0.0) {
            throw new ValueConversionException("Die Basis muss gr\u00f6\u00dfer 0 sein.");
        }
        return new NumberValue(Math.log(doubleValue) / Math.log(logBasis));
    }

    public static Value NATUERLICHER_LOGARITHMUS(PlausiRuntimeContext context, Value wert) {
        if (wert == null || !wert.isValid() || wert == NilValue.instance()) {
            return wert;
        }
        double doubleValue = 0.0;
        try {
            doubleValue = wert.asDouble();
        }
        catch (ValueConversionException e) {
            throw new ValueConversionException("Der nat\u00fcrliche Logarithmus kann nur bei Zahlen berechnet werden. " + e.getMessage());
        }
        if (doubleValue <= 0.0) {
            throw new ValueConversionException("Der nat\u00fcrliche Logarithmus kann nur f\u00fcr Zahlen gr\u00f6\u00dfer 0 berechnet werden.");
        }
        return new NumberValue(Math.log(doubleValue));
    }

    public static Value MAXIMUM_AUS_LISTE(PlausiRuntimeContext context, Array liste) {
        Value result;
        int lengthOfDimension = liste.getLengthOfDimension(context, null);
        if (lengthOfDimension > 0) {
            Variable element = (Variable)liste.getElement(context, new int[1]);
            Value value = element.get(context);
            try {
                double max = value.asDouble();
                int i = 1;
                while (i < lengthOfDimension) {
                    int[] nArray = new int[]{i};
                    element = (Variable)liste.getElement(context, nArray);
                    value = element.get(context);
                    double newMax = value.asDouble();
                    if (newMax > max) {
                        max = newMax;
                    }
                    ++i;
                }
                result = new NumberValue(max);
            }
            catch (ValueConversionException e) {
                throw new ValueConversionException("Maximum kann nur von Zahlen berechnet werden. " + e.getMessage());
            }
        } else {
            result = InvalidValue.instance();
        }
        return result;
    }

    public static Value MAXIMUM_AUS_REIHE(PlausiRuntimeContext context, Value reihe) {
        Value result;
        if (!(reihe instanceof Range)) {
            throw new ValueConversionException("Der Wert ist keine Reihe oder Sequenz");
        }
        PlausiRuntimeIterator it = ((Range)reihe).iterator();
        if (it.hasNext()) {
            Value value = (Value)it.next();
            try {
                double max = value.asDouble();
                while (it.hasNext()) {
                    value = (Value)it.next();
                    double newMax = value.asDouble();
                    if (!(newMax > max)) continue;
                    max = newMax;
                }
                result = new NumberValue(max);
            }
            catch (ValueConversionException e) {
                throw new ValueConversionException("Maximum kann nur von Zahlen berechnet werden. " + e.getMessage());
            }
        } else {
            result = InvalidValue.instance();
        }
        return result;
    }

    public static Value ZUFALLSZAHL(PlausiRuntimeContext context) {
        return new NumberValue(context.getRandom().nextDouble());
    }

    public static Value NORMALVERTEILTE_ZUFALLSZAHL(PlausiRuntimeContext context, Value mean, Value variance) {
        Random random = context.getRandom();
        return new NumberValue(mean.asDouble() + random.nextGaussian() * Math.sqrt(Math.abs(variance.asDouble())));
    }
}

