/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.SurveyParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MaterialParser
extends SubParser
implements SuperParser {
    private MetaCustomPLMaterial currentMaterial = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser = null;
    private ObjectContextParser objectContextParser = null;
    private SurveyParser surveyParser = null;

    public MaterialParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
        this.surveyParser = new SurveyParser(this, resolver);
        this.parserChain.addParser(this.surveyParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "materialDefinition".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("materialDefinition".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentMaterial = new MetaCustomPLMaterial();
            this.propertiesParser.setCurrentElement(this.currentMaterial);
            this.surveyParser.setCurrentElement(this.currentMaterial);
            this.objectContextParser.setCurrentElement(this.currentMaterial);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("materialDefinition".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentMaterial;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("materialDefinition".equalsIgnoreCase(localName)) {
            String state;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer das PLMaterial ist kein Name definiert!");
            }
            this.currentMaterial.setName(name.trim());
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentMaterial.setId(str.trim());
            } else {
                this.currentMaterial.setId(name);
            }
            String identifikation = atts.getValue("survey-id");
            if (identifikation != null && identifikation.trim().length() > 0) {
                this.currentMaterial.setIdentifikation(identifikation.trim());
            }
            String tbName = atts.getValue("tb-name");
            String id = atts.getValue("tb-id");
            String key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (tbName != null && tbName.trim().length() > 0) {
                key = tbName;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), tbName, MetaCustomThemenbereich.class, Resolver.USAGE_KONTEXT_PL, true);
            }
            tbName = atts.getValue("core-tb-name");
            id = atts.getValue("core-tb-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (tbName != null && tbName.trim().length() > 0) {
                key = tbName;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), tbName, MetaCustomThemenbereich.class, Resolver.USAGE_KONTEXT_CORE, true);
            }
            tbName = atts.getValue("idev-tb-name");
            id = atts.getValue("idev-tb-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (tbName != null && tbName.trim().length() > 0) {
                key = tbName;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), tbName, MetaCustomThemenbereich.class, Resolver.USAGE_KONTEXT_IDEV, true);
            }
            name = atts.getValue("mapping-name");
            id = atts.getValue("mapping-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (name != null && name.trim().length() > 0) {
                key = name;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaCustomMapping.class);
            }
            name = atts.getValue("dsb-name");
            id = atts.getValue("dsb-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (name != null && name.trim().length() > 0) {
                key = name;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaDsbObjekt.class, Resolver.USAGE_KONTEXT_PL, true);
            }
            name = atts.getValue("core-idev-dsb-name");
            id = atts.getValue("core-idev-dsb-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (name != null && name.trim().length() > 0) {
                key = name;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaDsbObjekt.class, Resolver.USAGE_KONTEXT_IDEV, true);
            }
            if ((state = atts.getValue("state")) != null && state.trim().equals("approved")) {
                this.currentMaterial.setFreigabeStatus((short)1);
            }
            name = atts.getValue("raw-set-name");
            id = atts.getValue("raw-set-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (name != null && name.trim().length() > 0) {
                key = name.trim();
            }
            if (key != null && key.length() > 0) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaRawDataSet.class);
            }
            name = atts.getValue("raw-mapping-name");
            id = atts.getValue("raw-mapping-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (name != null && name.trim().length() > 0) {
                key = name.trim();
            }
            if (key != null && key.length() > 0) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaCustomMapping.class, Resolver.USAGE_RAW_MAPPING, true);
            }
            name = atts.getValue("core-raw-mapping-name");
            id = atts.getValue("core-raw-mapping-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (name != null && name.trim().length() > 0) {
                key = name;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaCustomMapping.class, Resolver.USAGE_RAW_MAPPING_CORE, true);
            }
            name = atts.getValue("idev-raw-mapping-name");
            id = atts.getValue("idev-raw-mapping-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (name != null && name.trim().length() > 0) {
                key = name;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaCustomMapping.class, Resolver.USAGE_RAW_MAPPING_IDEV, true);
            }
            name = atts.getValue("core-flow");
            id = atts.getValue("core-flow-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (name != null && name.trim().length() > 0) {
                key = name;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaCustomAblauf.class, Resolver.USAGE_KONTEXT_CORE, true);
            }
            if ((name = atts.getValue("core-error-weight")) != null && name.length() > 0) {
                try {
                    this.currentMaterial.setCoreFehlergewicht(Integer.parseInt(name.trim()));
                }
                catch (NumberFormatException e) {
                    this.currentMaterial.setCoreFehlergewicht(1);
                    e.printStackTrace();
                }
            }
            String[] ids = null;
            String[] namen = null;
            String tmp = atts.getValue("pl-flows-ids");
            if (tmp != null && tmp.trim().length() > 0) {
                ids = tmp.indexOf(46) != -1 ? tmp.trim().split("\\.") : new String[]{tmp};
            }
            if ((tmp = atts.getValue("pl-flows")) != null && tmp.trim().length() > 0) {
                namen = tmp.indexOf(46) != -1 ? tmp.trim().split("\\.") : new String[]{tmp};
            }
            int i = 0;
            while (namen != null && i < namen.length) {
                id = ids != null ? ids[i] : null;
                name = namen != null ? namen[i] : null;
                key = null;
                if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                    key = id;
                } else if (name != null && name.trim().length() > 0) {
                    key = name;
                }
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaCustomAblauf.class, Resolver.USAGE_KONTEXT_PL, true);
                ++i;
            }
            ids = null;
            namen = null;
            tmp = atts.getValue("idev-flows");
            if (tmp != null && tmp.trim().length() > 0) {
                namen = tmp.indexOf(46) != -1 ? tmp.trim().split("\\.") : new String[]{tmp};
            }
            if ((tmp = atts.getValue("idev-flows-ids")) != null && tmp.trim().length() > 0) {
                ids = tmp.indexOf(46) != -1 ? tmp.trim().split("\\.") : new String[]{tmp};
            }
            i = 0;
            while (namen != null && i < namen.length) {
                id = ids != null ? ids[i] : null;
                name = namen != null ? namen[i] : null;
                key = null;
                if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                    key = id;
                } else if (name != null && name.trim().length() > 0) {
                    key = name;
                }
                this.resolver().registerForResolve(this.currentMaterial, key.trim(), name, MetaCustomAblauf.class, Resolver.USAGE_KONTEXT_IDEV, true);
                ++i;
            }
        }
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

