/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.plausi.ExtendedSatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimpleDataset
implements ExtendedSatzInterface {
    public static final String DEFAULT_NAME_SEPARATOR = ".";
    public static final String DEFAULT_INDICES_PREFIX = "#";
    public static final String DEFAULT_INDICES_SUFFIX = "";
    public static final String DEFAULT_NUMBER_OF_SUFFIX = "#anzahl";
    public static final String DEFAULT_DECIMAL_POINT = ",";
    public static final String DEFAULT_THOUSEND_POINT = ".";
    private Map values;
    private String nameSeparator;
    private String indicesPrefix;
    private String indicesSuffix;
    private String numberOfSuffix;
    private String decimalPoint;
    private String thousandPoint;
    private Set plVariables;

    public SimpleDataset(Map values) {
        this.values = values;
        this.nameSeparator = ".";
        this.indicesPrefix = DEFAULT_INDICES_PREFIX;
        this.indicesSuffix = DEFAULT_INDICES_SUFFIX;
        this.numberOfSuffix = DEFAULT_NUMBER_OF_SUFFIX;
        this.decimalPoint = DEFAULT_DECIMAL_POINT;
        this.thousandPoint = ".";
        this.plVariables = new HashSet();
    }

    public String getNameSeparator() {
        return this.nameSeparator;
    }

    public void setNameSeparator(String nameSeparator) {
        this.nameSeparator = nameSeparator;
    }

    public String getIndicesPrefix() {
        return this.indicesPrefix;
    }

    public void setIndicesPrefix(String indicesPrefix) {
        this.indicesPrefix = indicesPrefix;
    }

    public String getIndicesSuffix() {
        return this.indicesSuffix;
    }

    public void setIndicesSuffix(String indicesSuffix) {
        this.indicesSuffix = indicesSuffix;
    }

    public String getNumberOfSuffix() {
        return this.numberOfSuffix;
    }

    public void setNumberOfSuffix(String numberOfSuffix) {
        this.numberOfSuffix = numberOfSuffix;
    }

    public String getDecimalPoint() {
        return this.decimalPoint;
    }

    public void setDecimalPoint(String decimalPoint) {
        if (decimalPoint == null || decimalPoint.length() == 0) {
            throw new IllegalArgumentException("Dezimaltrenner muss angegeben werden.");
        }
        this.decimalPoint = decimalPoint;
    }

    public String getThousandPoint() {
        return this.thousandPoint;
    }

    public void setThousandPoint(String thousendPoint) {
        this.thousandPoint = thousendPoint;
    }

    public Set getPlVariables() {
        return this.plVariables;
    }

    private String createKey(FeldDeskriptorInterface feldDeskriptor) {
        FeldDeskriptorExt feldDeskriptorExt;
        FeldDeskriptorImpl feldDeskriptorImpl;
        StringBuffer key = new StringBuffer();
        FeldDeskriptorInterface field = feldDeskriptor;
        while (field != null) {
            if (field.getIndizes() != null) {
                int i = field.getIndizes().length - 1;
                while (i >= 0) {
                    key.insert(0, this.getIndicesSuffix());
                    key.insert(0, field.getIndizes()[i]);
                    key.insert(0, this.getIndicesPrefix());
                    --i;
                }
            }
            key.insert(0, field.getFeldNameTB());
            if (field.getVorgaenger() != null) {
                key.insert(0, this.getNameSeparator());
            }
            field = field.getVorgaenger();
        }
        if (feldDeskriptor instanceof FeldDeskriptorImpl && (feldDeskriptorImpl = (FeldDeskriptorImpl)feldDeskriptor).getFeldDeskriptor() instanceof FeldDeskriptorExt && (feldDeskriptorExt = (FeldDeskriptorExt)feldDeskriptorImpl.getFeldDeskriptor()).getFeldBezeichnung() != null && feldDeskriptorExt.getFeldBezeichnung().equals("###PL-VARIABLE###")) {
            this.plVariables.add(key.toString());
        }
        return key.toString();
    }

    private String getThousandPointEscaped() {
        String thousandPointEscaped = this.getThousandPoint() == null ? null : (this.getThousandPoint().equals(".") ? "\\." : this.getThousandPoint());
        return thousandPointEscaped;
    }

    @Override
    public int getLaenge(FeldDeskriptorInterface feldDeskriptor, int[] indizes) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        int laenge;
        StringBuffer key = new StringBuffer(this.createKey(feldDeskriptor));
        if (indizes != null) {
            int i = 0;
            while (i < indizes.length) {
                key.append(this.getIndicesPrefix());
                key.append(indizes[i]);
                key.append(this.getIndicesSuffix());
                ++i;
            }
        }
        key.append(this.numberOfSuffix);
        Object objectValue = this.values.get(key.toString());
        if (objectValue == null) {
            laenge = 0;
        } else if (objectValue instanceof Integer) {
            laenge = (Integer)objectValue;
        } else if (objectValue instanceof String) {
            try {
                laenge = Integer.parseInt((String)objectValue);
            }
            catch (Exception e) {
                laenge = 0;
            }
        } else {
            laenge = 0;
        }
        return laenge;
    }

    @Override
    public boolean hatWert(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this.values.get(this.createKey(feldDeskriptor)) != null;
    }

    @Override
    public String getString(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        String value;
        String key = this.createKey(feldDeskriptor);
        Object objectValue = this.values.get(key);
        if (objectValue == null) {
            value = DEFAULT_INDICES_SUFFIX;
        } else if (objectValue instanceof String) {
            value = (String)objectValue;
        } else {
            throw new WertNichtTypgerechtException(key);
        }
        return value;
    }

    @Override
    public void setString(FeldDeskriptorInterface feldDeskriptor, String neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptor), neuerWert);
    }

    @Override
    public long getLong(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        long value;
        String key = this.createKey(feldDeskriptor);
        Object objectValue = this.values.get(key);
        if (objectValue == null) {
            value = 0L;
        } else if (objectValue instanceof Long) {
            value = (Long)objectValue;
        } else if (objectValue instanceof String) {
            try {
                String stringValue = (String)objectValue;
                NumberValue numberValue = new NumberValue(stringValue);
                if (stringValue.indexOf(44) >= 0) {
                    throw new WertNichtTypgerechtException(key);
                }
                value = numberValue.asLong();
            }
            catch (Exception e) {
                throw new WertNichtTypgerechtException(key);
            }
        } else {
            throw new WertNichtTypgerechtException(key);
        }
        return value;
    }

    @Override
    public void setLong(FeldDeskriptorInterface feldDeskriptor, long neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptor), new Long(neuerWert));
    }

    @Override
    public double getDouble(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        double value;
        String key = this.createKey(feldDeskriptor);
        Object objectValue = this.values.get(key);
        if (objectValue == null) {
            value = 0.0;
        } else if (objectValue instanceof Double) {
            value = (Double)objectValue;
        } else if (objectValue instanceof String) {
            try {
                String stringValue = (String)objectValue;
                NumberValue numberValue = new NumberValue(stringValue);
                value = numberValue.asDouble();
            }
            catch (Exception e) {
                throw new WertNichtTypgerechtException(key);
            }
        } else {
            throw new WertNichtTypgerechtException(key);
        }
        return value;
    }

    @Override
    public void setDouble(FeldDeskriptorInterface feldDeskriptor, double neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptor), new Double(neuerWert));
    }

    @Override
    public boolean getBool(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        boolean value;
        String key = this.createKey(feldDeskriptor);
        Object objectValue = this.values.get(key);
        if (objectValue == null) {
            value = false;
        } else if (objectValue instanceof Boolean) {
            value = (Boolean)objectValue;
        } else if (objectValue instanceof String) {
            try {
                value = new Boolean((String)objectValue);
            }
            catch (Exception e) {
                throw new WertNichtTypgerechtException(key);
            }
        } else {
            throw new WertNichtTypgerechtException(key);
        }
        return value;
    }

    @Override
    public void setBool(FeldDeskriptorInterface feldDeskriptor, boolean neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptor), new Boolean(neuerWert));
    }

    @Override
    public void setLeerWert(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.remove(this.createKey(feldDeskriptor));
    }

    @Override
    public SatzInterface getSubSatz(FeldDeskriptorInterface satzFeldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this;
    }

    @Override
    public void appendSatz(FeldDeskriptorInterface satzFeldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        String anzahl = String.valueOf(this.createKey(satzFeldDeskriptor)) + this.getNumberOfSuffix();
        int incrementAnzahl = this.getLaenge(satzFeldDeskriptor, null) + 1;
        this.values.put(anzahl, String.valueOf(incrementAnzahl));
    }

    @Override
    public void removeSatz(FeldDeskriptorInterface satzFeldDeskriptor) throws ArrayIndexOutOfBoundsException, NoSuchFieldException {
        Set keySet = this.values.keySet();
        String fieldKey = this.createKey(satzFeldDeskriptor);
        Object[] keySetAttay = keySet.toArray();
        int lastIndexOf = fieldKey.lastIndexOf(this.getIndicesPrefix());
        String anzahlKey = String.valueOf(fieldKey.substring(0, lastIndexOf)) + this.getNumberOfSuffix();
        String anzahlValue = (String)this.values.get(anzahlKey);
        int fieldsize = Integer.parseInt(anzahlValue);
        int closingPosition = fieldKey.lastIndexOf(this.getIndicesSuffix());
        if (closingPosition == -1) {
            closingPosition = fieldKey.length();
        }
        int indice = Integer.parseInt(fieldKey.substring(lastIndexOf + 1, closingPosition));
        if (fieldsize == 0 || indice >= fieldsize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int i = 0;
        while (i < keySetAttay.length) {
            String key = (String)keySetAttay[i];
            if (key.startsWith(fieldKey)) {
                this.values.remove(key);
            }
            ++i;
        }
        keySet = this.values.keySet();
        fieldKey = fieldKey.substring(0, lastIndexOf);
        keySetAttay = keySet.toArray();
        ArrayList<String> valuesToRemove = new ArrayList<String>();
        HashMap valuesToAdd = new HashMap();
        int i2 = 0;
        while (i2 < keySetAttay.length) {
            String key = (String)keySetAttay[i2];
            if (key.startsWith(String.valueOf(fieldKey) + this.getIndicesPrefix()) && !key.startsWith(String.valueOf(fieldKey) + this.getNumberOfSuffix())) {
                String stringAsNumber;
                int parseInt;
                int ending = key.indexOf(this.getIndicesSuffix());
                if (ending == -1 || this.getIndicesSuffix().length() == 0) {
                    ending = key.indexOf(this.getIndicesPrefix());
                }
                if (ending == fieldKey.length()) {
                    ending = key.indexOf(".");
                }
                if ((parseInt = Integer.parseInt(stringAsNumber = key.substring(fieldKey.length() + 1, ending))) > indice) {
                    String newKey = String.valueOf(fieldKey) + this.getIndicesPrefix() + --parseInt + this.getIndicesSuffix() + key.substring(ending + 1, key.length());
                    Object myValue = this.values.get(key);
                    valuesToRemove.add(key);
                    valuesToAdd.put(newKey, myValue);
                }
            } else if (key.startsWith(String.valueOf(fieldKey) + this.getNumberOfSuffix())) {
                anzahlValue = (String)this.values.get(key);
                this.values.put(key, new StringBuffer().append(Integer.parseInt(anzahlValue) - 1).toString());
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < valuesToRemove.size()) {
            this.values.remove(valuesToRemove.get(i2));
            ++i2;
        }
        Set keySetToRemove = valuesToAdd.keySet();
        for (String newKey : keySetToRemove) {
            this.values.put(newKey, valuesToAdd.get(newKey));
        }
    }

    public void printDebug() {
        Set keySet = this.values.keySet();
        for (String key : keySet) {
            System.out.print(String.valueOf(key) + " : ");
            System.out.println(this.values.get(key));
        }
    }
}

