/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.AbstractCodeGenerator;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;

public class JavaCodeGenerator
extends AbstractCodeGenerator {
    protected void startNewSection(MessageContextInterface context) {
        String section = "??";
        if (context != null) {
            section = context.toString();
        }
        this.indentNewLine();
        if (this.isPruefContext(context)) {
            this.out.print("context.startNewPruefSection(\"" + section + "\");");
        } else {
            this.out.print("context.startNewSection(\"" + section + "\");");
        }
    }

    protected boolean isPruefContext(MessageContextInterface context) {
        ElementMessageContext elementContext;
        boolean erg = false;
        if (context != null && context instanceof ElementMessageContext && ((elementContext = (ElementMessageContext)context).getElementType() == 1 || elementContext.getElementType() == 5)) {
            erg = true;
        }
        return erg;
    }

    protected void leaveCurrentSection() {
        this.indentNewLine();
        this.out.print("context.leaveCurrentSection();");
    }

    protected void openBlock() {
        this.indentNewLine();
        this.out.print("{");
        this.increaseIndentLevel();
    }

    protected void closeBlock() {
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("}");
    }

    protected void defineMethod(String scope, String rtype, String method, String params) {
        this.indentNewLine();
        this.out.print(scope);
        if (rtype != null && rtype.length() > 0) {
            this.out.print(" ");
            this.out.print(rtype);
        }
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(method));
        this.out.print("(");
        this.out.print(params);
        this.out.print(")");
        this.openBlock();
    }

    protected void endMethodDefinition() {
        this.closeBlock();
    }

    protected void defineClass(String classname, String scope, String baseclass) {
        this.indentNewLine();
        this.out.print(scope);
        this.out.print(" class ");
        this.out.print(classname);
        if (baseclass != null) {
            this.out.print(" extends ");
            this.out.print(baseclass);
        }
        this.openBlock();
    }

    protected void endClassDefinition() {
        this.closeBlock();
    }

    protected void createArrayDimensions(int[] dimensions) {
        this.out.print("new int[]{");
        int i = 0;
        while (i < dimensions.length) {
            this.out.print(Integer.toString(dimensions[i]));
            if (i < dimensions.length - 1) {
                this.out.print(", ");
            }
            ++i;
        }
        this.out.print("}");
    }

    protected void iterateArray(String template, int[] dimensions) {
        int i;
        StringBuffer elementIndex = new StringBuffer("");
        char loopIndex = '`';
        int i2 = 0;
        while (i2 < dimensions.length) {
            this.indentNewLine();
            loopIndex = (char)(loopIndex + 1);
            this.out.print("for (int ");
            this.out.print(loopIndex);
            this.out.print(" = 0; ");
            this.out.print(loopIndex);
            this.out.print(" < ");
            this.out.print(Integer.toString(dimensions[i2]));
            this.out.print("; ");
            this.out.print(loopIndex);
            this.out.print("++)");
            this.openBlock();
            elementIndex.append("[");
            elementIndex.append(loopIndex);
            elementIndex.append("]");
            ++i2;
        }
        String processedTemplate = template;
        if (template.indexOf("@@indexarray") != -1) {
            this.indentNewLine();
            this.out.print("int indexArray[] = {");
            i = 0;
            while (i < dimensions.length) {
                if (i > 0) {
                    this.out.print(",");
                }
                this.out.print((char)(97 + i));
                ++i;
            }
            this.out.print("};");
            processedTemplate = processedTemplate.replaceAll("@@indexarray", "indexArray");
        }
        processedTemplate = processedTemplate.replaceAll("@@index", elementIndex.toString());
        this.indentNewLine();
        this.out.print(processedTemplate);
        i = 0;
        while (i < dimensions.length) {
            this.closeBlock();
            ++i;
        }
    }
}

