/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.AbstractStat;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class MerkmalStat
extends AbstractStat {
    private HashSet keinFormulartext = new HashSet();
    private HashSet keineFehlertexte = new HashSet();
    private HashSet inDSB = new HashSet();
    private HashSet referencedByChecks = new HashSet();
    private Hashtable topicReferences = new Hashtable();
    private ArrayList inDSBList = null;
    private ArrayList notInDSBList = null;
    private ArrayList keinFormulartextList = null;
    private ArrayList keineFehlertexteList = null;
    private ArrayList neverCheckedList = null;
    private Hashtable feldMerkmalHash = new Hashtable();
    private Hashtable merkmalFeldReferenzen = new Hashtable();

    @Override
    public void add(MetaStatspezObjekt statVar) {
        MetaCustomMerkmal m = (MetaCustomMerkmal)statVar;
        assert (!this.idElementTable.containsKey(m.getId())) : "Das Merkmal mit der ID" + m.getId() + " ist doppelt vorhanden.";
        if (!this.idElementTable.containsKey(m.getId())) {
            DokuElement de = new DokuElement(m.getId(), m.getName());
            de.setElement(m);
            this.idElementTable.put(m.getId(), de);
            if (m.getKommentar() != null && m.getKommentar().trim().length() > 0) {
                this.addToWithAnnotation(m.getId());
            }
            if (!(m.getWertebereich() != null && m.getWertebereich().trim().length() != 0 || m.getKlasseWertebereich() != null || m.getLeer())) {
                this.addToNoChecks(m.getId());
            }
            if (m.getFrage() == null || m.getFrage().trim().length() == 0 || m.getBezeichnung() == null || m.getBezeichnung().trim().length() == 0) {
                this.addToKeinFormulartext(m.getId());
            }
            if (m.getFehlertextKurz() == null || m.getFehlertextKurz().trim().length() == 0 || m.getKorrekturhinweis() == null || m.getKorrekturhinweis().trim().length() == 0) {
                this.addToKeineFehlertexte(m.getId());
            }
            if (m.getFreigabeStatus() == 0) {
                this.addToLocked(m.getId());
            }
            this.topicReferences.put(m.getId(), new HashSet());
            this.merkmalFeldReferenzen.put(m.getId(), new HashSet());
            if (!m.istKompilierbar()) {
                this.fehlerHafteElemente.add(de);
                de.setZusatz("fehlerhaft");
            }
        }
    }

    public void resolveAndAddReferencedByChecksFields(HashSet fieldContexts) {
        this.referencedByChecks.addAll(this.resolveFields(fieldContexts));
    }

    public boolean addToInDSB(String id) {
        assert (this.idElementTable.containsKey(id)) : "Das Merkmal mit der ID" + id + " ist nicht noch nicht erfasst worden.";
        return this.inDSB.add(id);
    }

    public boolean addToKeineFehlertexte(String id) {
        assert (this.idElementTable.containsKey(id)) : "Das Merkmal mit der ID" + id + " ist nicht noch nicht erfasst worden.";
        return this.keineFehlertexte.add(id);
    }

    public int getKeinFehlertextCount() {
        return this.keineFehlertexte.size();
    }

    public boolean addToKeinFormulartext(String id) {
        assert (this.idElementTable.containsKey(id)) : "Das Merkmal mit der ID" + id + " ist nicht noch nicht erfasst worden.";
        return this.keinFormulartext.add(id);
    }

    public int getKeinFormulartextCount() {
        return this.keinFormulartext.size();
    }

    public int getInDSBCount() {
        return this.inDSB.size();
    }

    public int getNotInDSBCount() {
        return this.idElementTable.size() - this.inDSB.size();
    }

    public HashSet getInDSB() {
        return this.inDSB;
    }

    public HashSet getNotInDSB() {
        HashSet<String> notInDSB = new HashSet<String>();
        for (String iD : this.idElementTable.keySet()) {
            if (this.inDSB.contains(iD)) continue;
            notInDSB.add(iD);
        }
        return notInDSB;
    }

    public HashSet getNotVerifiedByChecks() {
        HashSet<String> notVerifiedByChecks = new HashSet<String>();
        for (String iD : this.idElementTable.keySet()) {
            if (this.referencedByChecks.contains(iD)) continue;
            notVerifiedByChecks.add(iD);
        }
        return notVerifiedByChecks;
    }

    public HashSet getNeverChecked() {
        HashSet tmpSet = new HashSet();
        tmpSet.addAll(this.getNotVerifiedByChecks());
        tmpSet.retainAll(this.getNoChecks());
        return tmpSet;
    }

    public int getNeverCheckedCount() {
        return this.getNeverChecked().size();
    }

    public ArrayList getNeverCheckedList() {
        if (this.neverCheckedList == null) {
            return this.resolveIds(this.getNeverChecked());
        }
        return this.neverCheckedList;
    }

    public List getKeinFehlertextList() {
        if (this.keineFehlertexteList == null) {
            Iterator it = this.keineFehlertexte.iterator();
            ArrayList<DokuElement> tmpList = new ArrayList<DokuElement>();
            while (it.hasNext()) {
                tmpList.add(this.getElement((String)it.next()));
            }
            return tmpList;
        }
        return this.keineFehlertexteList;
    }

    public HashSet getKeinFehlertext() {
        return this.keinFormulartext;
    }

    public HashSet getKeinFormulartext() {
        return this.keinFormulartext;
    }

    public List getKeinFormulartextList() {
        if (this.keinFormulartextList == null) {
            Iterator it = this.keinFormulartext.iterator();
            ArrayList<DokuElement> tmpList = new ArrayList<DokuElement>();
            while (it.hasNext()) {
                tmpList.add(this.getElement((String)it.next()));
            }
            return tmpList;
        }
        return this.keinFormulartextList;
    }

    public List getInDSBList() {
        if (this.inDSBList == null) {
            return this.resolveIds(this.inDSB);
        }
        return this.inDSBList;
    }

    public List getNotInDSBList() {
        if (this.notInDSBList == null) {
            return this.resolveIds(this.getNotInDSB());
        }
        return this.notInDSBList;
    }

    @Override
    public void initializeLists() {
        this.initializeLists(false);
    }

    @Override
    public void initializeLists(boolean force) {
        super.initializeLists(force);
        if (this.keineFehlertexteList == null || force) {
            this.keineFehlertexteList = new ArrayList();
            this.keineFehlertexteList.addAll(this.resolveIds(this.keineFehlertexte));
        }
        if (this.keinFormulartextList == null || force) {
            this.keinFormulartextList = new ArrayList();
            this.keinFormulartextList.addAll(this.resolveIds(this.keinFormulartext));
        }
        if (this.inDSBList == null || force) {
            this.inDSBList = new ArrayList();
            this.inDSBList.addAll(this.resolveIds(this.inDSB));
        }
        if (this.notInDSBList == null || force) {
            this.notInDSBList = new ArrayList();
            this.notInDSBList.addAll(this.resolveIds(this.getNotInDSB()));
        }
        if (this.neverCheckedList == null || force) {
            HashSet tmpSet = new HashSet();
            tmpSet.addAll(this.noChecks);
            tmpSet.retainAll(this.getNotVerifiedByChecks());
            this.neverCheckedList = new ArrayList();
            this.neverCheckedList.addAll(this.resolveIds(tmpSet));
        }
    }

    @Override
    public void sortLists() {
        this.initializeLists();
        Collections.sort(this.keineFehlertexteList);
        Collections.sort(this.keinFormulartextList);
        Collections.sort(this.notInDSBList);
        Collections.sort(this.inDSBList);
        Collections.sort(this.neverCheckedList);
        super.sortListsOnly();
    }

    public DokuElement getElementFromFieldContext(String fieldContext) {
        return (DokuElement)this.idElementTable.get(this.getIdFromFieldContext(fieldContext));
    }

    public HashSet getFeldReferenzen(String merkmalID) {
        return (HashSet)this.merkmalFeldReferenzen.get(merkmalID);
    }

    public String getIdFromFieldContext(String fieldContext) {
        return (String)this.feldMerkmalHash.get(fieldContext);
    }

    public DokuElement getElementFromField(MetaCustomTBFeld feld) {
        String feldKontext = String.valueOf(feld.getThemenbereich().getId()) + "." + feld.getName();
        String merkmalId = (String)this.feldMerkmalHash.get(feldKontext);
        if (merkmalId != null) {
            return this.getElement(merkmalId);
        }
        return null;
    }

    public Collection resolveFields(Collection feldHierarchien) {
        Iterator it = feldHierarchien.iterator();
        ArrayList<String> tmpSet = new ArrayList<String>();
        while (it.hasNext()) {
            String s = (String)it.next();
            tmpSet.add(this.getIdFromFieldContext(s));
        }
        return tmpSet;
    }

    public void addReference(MetaCustomTBFeld feld) {
        if (feld.getKlasse() instanceof MetaMerkmal) {
            String feldKontext = String.valueOf(feld.getThemenbereich().getId()) + "." + feld.getName();
            this.feldMerkmalHash.put(feldKontext, feld.getKlasse().getId());
            HashSet tbrSet = (HashSet)this.topicReferences.get(feld.getKlasse().getId());
            tbrSet.add(feld.getThemenbereich().getId());
            HashSet frSet = (HashSet)this.merkmalFeldReferenzen.get(feld.getKlasse().getId());
            frSet.add(feld.getId());
        }
    }

    @Override
    public void deleteLists() {
        this.keinFormulartextList = null;
        super.deleteLists();
    }

    public ArrayList getTopicReferences(String merkmalId) {
        ArrayList list = new ArrayList((HashSet)this.topicReferences.get(merkmalId));
        return list;
    }
}

