/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Calendar;
import mondrian.util.DateSchedule;
import mondrian.util.ScheduleUtil;

class MonthlyByDayDateSchedule
implements DateSchedule {
    int period;
    int beginMonth;
    int daysOfMonthBitmap;

    MonthlyByDayDateSchedule(Calendar begin, int period, int daysOfMonthBitmap) {
        this.period = period;
        ScheduleUtil.assertTrue(period > 0, "period must be positive");
        this.beginMonth = begin == null ? 0 : MonthlyByDayDateSchedule.monthOrdinal(begin);
        this.daysOfMonthBitmap = daysOfMonthBitmap;
        ScheduleUtil.assertTrue((daysOfMonthBitmap & 0xEFFFFFFF) != 0, "monthly day schedule must have at least one day set");
        ScheduleUtil.assertTrue((daysOfMonthBitmap & 0xEFFFFFFF) == daysOfMonthBitmap, "monthly schedule has bad bits set: " + daysOfMonthBitmap);
    }

    @Override
    public Calendar nextOccurrence(Calendar earliest, boolean strict) {
        earliest = (Calendar)earliest.clone();
        if (strict) {
            earliest.add(5, 1);
        }
        int i = 31 + this.period;
        while (i-- > 0) {
            int month = MonthlyByDayDateSchedule.monthOrdinal(earliest);
            if ((month - this.beginMonth) % this.period != 0) {
                earliest.set(5, 1);
                earliest.add(2, 1);
                continue;
            }
            int dayOfMonth = earliest.get(5);
            if ((this.daysOfMonthBitmap & 1 << dayOfMonth) != 0) {
                return earliest;
            }
            earliest.add(5, 1);
            if ((this.daysOfMonthBitmap & 1) == 0 || earliest.get(5) != 1) continue;
            earliest.add(5, -1);
            return earliest;
        }
        throw ScheduleUtil.newInternal("monthly-by-day date schedule is looping -- maybe the bitmap is empty: " + this.daysOfMonthBitmap);
    }

    private static int monthOrdinal(Calendar earliest) {
        return earliest.get(1) * 12 + earliest.get(2);
    }
}

