/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CompletedFuture<V>
implements Future<V> {
    private final V value;
    private final ExecutionException exception;

    public CompletedFuture(V value, ExecutionException exception) {
        if (value != null && exception != null) {
            throw new IllegalArgumentException("Value and exception must not both be specified");
        }
        this.value = value;
        this.exception = exception;
    }

    public static <T> CompletedFuture<T> success(T t) {
        return new CompletedFuture<T>(t, null);
    }

    public static <T> CompletedFuture<T> fail(Throwable e) {
        return new CompletedFuture<Object>(null, new ExecutionException(e));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public V get() throws ExecutionException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws ExecutionException {
        return this.get();
    }
}

