/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import mondrian.olap.MondrianServer;
import mondrian.rolap.RolapConnection;
import mondrian.server.Execution;
import mondrian.server.Statement;
import mondrian.util.ArrayStack;

public class Locus {
    public final Execution execution;
    public final String message;
    public final String component;
    private static final ThreadLocal<ArrayStack<Locus>> THREAD_LOCAL = new ThreadLocal<ArrayStack<Locus>>(){

        @Override
        protected ArrayStack<Locus> initialValue() {
            return new ArrayStack<Locus>();
        }
    };

    public Locus(Execution execution, String component, String message) {
        assert (execution != null);
        this.execution = execution;
        this.component = component;
        this.message = message;
    }

    public static void pop(Locus locus) {
        Locus pop = THREAD_LOCAL.get().pop();
        assert (locus == pop);
    }

    public static void push(Locus locus) {
        THREAD_LOCAL.get().push(locus);
    }

    public static Locus peek() {
        return THREAD_LOCAL.get().peek();
    }

    public static <T> T execute(RolapConnection connection, String component, Action<T> action) {
        Statement statement = connection.getInternalStatement();
        Execution execution = new Execution(statement, 0L);
        return Locus.execute(execution, component, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(Execution execution, String component, Action<T> action) {
        Locus locus = new Locus(execution, component, null);
        Locus.push(locus);
        try {
            T t = action.execute();
            return t;
        }
        finally {
            Locus.pop(locus);
        }
    }

    public final MondrianServer getServer() {
        return this.execution.statement.getMondrianConnection().getServer();
    }

    public static interface Action<T> {
        public T execute();
    }
}

