/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import mondrian.olap.MondrianProperties;
import mondrian.recorder.ListRecorder;
import mondrian.recorder.MessageRecorder;
import mondrian.recorder.RecorderException;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.DefaultDef;
import mondrian.rolap.aggmatcher.DefaultRecognizer;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.aggmatcher.Recognizer;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public class DefaultRules {
    private static final Logger LOGGER = Logger.getLogger(DefaultRules.class);
    private static final MondrianResource mres = MondrianResource.instance();
    private static DefaultRules instance = null;
    private final DefaultDef.AggRules rules;
    private final Map<String, Recognizer.Matcher> factToPattern;
    private final Map<String, Recognizer.Matcher> foreignKeyMatcherMap;
    private Recognizer.Matcher ignoreMatcherMap;
    private Recognizer.Matcher factCountMatcher;
    private String tag;

    public static synchronized DefaultRules getInstance() {
        if (instance == null) {
            String tag;
            DefaultDef.AggRule aggrule;
            InputStream inStream = DefaultRules.getAggRuleInputStream();
            if (inStream == null) {
                return null;
            }
            DefaultDef.AggRules defs = DefaultRules.makeAggRules(inStream);
            ListRecorder reclists = new ListRecorder();
            try {
                defs.validate(reclists);
            }
            catch (RecorderException e) {
                // empty catch block
            }
            reclists.logWarningMessage(LOGGER);
            reclists.logErrorMessage(LOGGER);
            if (reclists.hasErrors()) {
                reclists.throwRTException();
            }
            if ((aggrule = defs.getAggRule(tag = MondrianProperties.instance().AggregateRuleTag.get())) == null) {
                throw DefaultRules.mres.MissingDefaultAggRule.ex(tag);
            }
            DefaultRules rules = new DefaultRules(defs);
            rules.setTag(tag);
            instance = rules;
        }
        return instance;
    }

    private static InputStream getAggRuleInputStream() {
        String aggRules = MondrianProperties.instance().AggregateRules.get();
        InputStream inStream = DefaultRules.class.getResourceAsStream(aggRules);
        if (inStream == null) {
            try {
                URL url = new URL(aggRules);
                inStream = url.openStream();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inStream == null) {
            LOGGER.warn((Object)DefaultRules.mres.CouldNotLoadDefaultAggregateRules.str(aggRules));
        }
        return inStream;
    }

    protected static DefaultDef.AggRules makeAggRules(File file) {
        DOMWrapper def = DefaultRules.makeDOMWrapper(file);
        try {
            DefaultDef.AggRules rules = new DefaultDef.AggRules(def);
            return rules;
        }
        catch (XOMException e) {
            throw DefaultRules.mres.AggRuleParse.ex(file.getName(), e);
        }
    }

    protected static DefaultDef.AggRules makeAggRules(URL url) {
        DOMWrapper def = DefaultRules.makeDOMWrapper(url);
        try {
            DefaultDef.AggRules rules = new DefaultDef.AggRules(def);
            return rules;
        }
        catch (XOMException e) {
            throw DefaultRules.mres.AggRuleParse.ex(url.toString(), e);
        }
    }

    protected static DefaultDef.AggRules makeAggRules(InputStream inStream) {
        DOMWrapper def = DefaultRules.makeDOMWrapper(inStream);
        try {
            DefaultDef.AggRules rules = new DefaultDef.AggRules(def);
            return rules;
        }
        catch (XOMException e) {
            throw DefaultRules.mres.AggRuleParse.ex("InputStream", e);
        }
    }

    protected static DefaultDef.AggRules makeAggRules(String text, String name) {
        DOMWrapper def = DefaultRules.makeDOMWrapper(text, name);
        try {
            DefaultDef.AggRules rules = new DefaultDef.AggRules(def);
            return rules;
        }
        catch (XOMException e) {
            throw DefaultRules.mres.AggRuleParse.ex(name, e);
        }
    }

    protected static DOMWrapper makeDOMWrapper(File file) {
        try {
            return DefaultRules.makeDOMWrapper(file.toURL());
        }
        catch (MalformedURLException e) {
            throw DefaultRules.mres.AggRuleParse.ex(file.getName(), e);
        }
    }

    protected static DOMWrapper makeDOMWrapper(URL url) {
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(url);
            return def;
        }
        catch (XOMException e) {
            throw DefaultRules.mres.AggRuleParse.ex(url.toString(), e);
        }
    }

    protected static DOMWrapper makeDOMWrapper(InputStream inStream) {
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(inStream);
            return def;
        }
        catch (XOMException e) {
            throw DefaultRules.mres.AggRuleParse.ex("InputStream", e);
        }
    }

    protected static DOMWrapper makeDOMWrapper(String text, String name) {
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(text);
            return def;
        }
        catch (XOMException e) {
            throw DefaultRules.mres.AggRuleParse.ex(name, e);
        }
    }

    private DefaultRules(DefaultDef.AggRules rules) {
        this.rules = rules;
        this.factToPattern = new HashMap<String, Recognizer.Matcher>();
        this.foreignKeyMatcherMap = new HashMap<String, Recognizer.Matcher>();
        this.tag = MondrianProperties.instance().AggregateRuleTag.getDefaultValue();
    }

    public void validate(MessageRecorder msgRecorder) {
        this.rules.validate(msgRecorder);
    }

    private void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public DefaultDef.AggRule getAggRule() {
        return this.getAggRule(this.getTag());
    }

    public DefaultDef.AggRule getAggRule(String tag) {
        return this.rules.getAggRule(tag);
    }

    public Recognizer.Matcher getTableMatcher(String tableName) {
        Recognizer.Matcher matcher = this.factToPattern.get(tableName);
        if (matcher == null) {
            DefaultDef.AggRule rule = this.getAggRule();
            DefaultDef.TableMatch tableMatch = rule.getTableMatch();
            matcher = tableMatch.getMatcher(tableName);
            this.factToPattern.put(tableName, matcher);
        }
        return matcher;
    }

    public Recognizer.Matcher getIgnoreMatcher() {
        if (this.ignoreMatcherMap == null) {
            DefaultDef.AggRule rule = this.getAggRule();
            DefaultDef.IgnoreMap ignoreMatch = rule.getIgnoreMap();
            this.ignoreMatcherMap = ignoreMatch == null ? new Recognizer.Matcher(){

                @Override
                public boolean matches(String name) {
                    return false;
                }
            } : ignoreMatch.getMatcher();
        }
        return this.ignoreMatcherMap;
    }

    public Recognizer.Matcher getFactCountMatcher() {
        if (this.factCountMatcher == null) {
            DefaultDef.AggRule rule = this.getAggRule();
            DefaultDef.FactCountMatch factCountMatch = rule.getFactCountMatch();
            this.factCountMatcher = factCountMatch.getMatcher();
        }
        return this.factCountMatcher;
    }

    public Recognizer.Matcher getForeignKeyMatcher(String foreignKeyName) {
        Recognizer.Matcher matcher = this.foreignKeyMatcherMap.get(foreignKeyName);
        if (matcher == null) {
            DefaultDef.AggRule rule = this.getAggRule();
            DefaultDef.ForeignKeyMatch foreignKeyMatch = rule.getForeignKeyMatch();
            matcher = foreignKeyMatch.getMatcher(foreignKeyName);
            this.foreignKeyMatcherMap.put(foreignKeyName, matcher);
        }
        return matcher;
    }

    public boolean matchesTableName(String factTableName, String name) {
        Recognizer.Matcher matcher = this.getTableMatcher(factTableName);
        return matcher.matches(name);
    }

    public Recognizer.Matcher getMeasureMatcher(String measureName, String measureColumnName, String aggregateName) {
        DefaultDef.AggRule rule = this.getAggRule();
        Recognizer.Matcher matcher = rule.getMeasureMap().getMatcher(measureName, measureColumnName, aggregateName);
        return matcher;
    }

    public Recognizer.Matcher getLevelMatcher(String usagePrefix, String hierarchyName, String levelName, String levelColumnName) {
        DefaultDef.AggRule rule = this.getAggRule();
        Recognizer.Matcher matcher = rule.getLevelMap().getMatcher(usagePrefix, hierarchyName, levelName, levelColumnName);
        return matcher;
    }

    public boolean columnsOK(RolapStar star, JdbcSchema.Table dbFactTable, JdbcSchema.Table aggTable, MessageRecorder msgRecorder) {
        DefaultRecognizer cb = new DefaultRecognizer(this, star, dbFactTable, aggTable, msgRecorder);
        return cb.check();
    }

    static {
        Trigger trigger = new Trigger(){

            public boolean isPersistent() {
                return true;
            }

            public int phase() {
                return 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Property property, String value) {
                Class<DefaultRules> clazz = DefaultRules.class;
                synchronized (DefaultRules.class) {
                    DefaultRules oldInstance = instance;
                    instance = null;
                    DefaultRules newInstance = null;
                    Exception ex = null;
                    try {
                        newInstance = DefaultRules.getInstance();
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                    if (ex != null) {
                        instance = oldInstance;
                        throw new Trigger.VetoRT(ex);
                    }
                    if (newInstance == null) {
                        instance = oldInstance;
                        String msg = mres.FailedCreateNewDefaultAggregateRules.str(property.getPath(), value);
                        throw new Trigger.VetoRT(msg);
                    }
                    instance = newInstance;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        MondrianProperties properties = MondrianProperties.instance();
        properties.AggregateRules.addTrigger(trigger);
        properties.AggregateRuleTag.addTrigger(trigger);
    }
}

