/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentDataset;

final class GroupingSetsList {
    private final List<RolapStar.Column> rollupColumns;
    private final List<RolapStar.Column[]> groupingSetsColumns;
    private final boolean useGroupingSet;
    private final List<BitKey> rollupColumnsBitKeyList;
    private final int[] columnIndexToGroupingIndexMap;
    private final List<GroupingSet> groupingSets;
    private final int groupingBitKeyIndex;

    public GroupingSetsList(List<GroupingSet> groupingSets) {
        this.groupingSets = groupingSets;
        boolean bl = this.useGroupingSet = groupingSets.size() > 1;
        if (this.useGroupingSet) {
            this.groupingSetsColumns = this.getGroupingColumnsList(groupingSets);
            this.rollupColumns = this.findRollupColumns();
            int arity = this.getDefaultColumns().length;
            int segmentLength = this.getDefaultSegments().size();
            this.groupingBitKeyIndex = arity + segmentLength;
        } else {
            this.groupingSetsColumns = Collections.emptyList();
            this.rollupColumns = Collections.emptyList();
            this.groupingBitKeyIndex = -1;
        }
        this.columnIndexToGroupingIndexMap = this.loadRollupIndex();
        this.rollupColumnsBitKeyList = this.loadGroupingColumnBitKeys();
    }

    List<RolapStar.Column[]> getGroupingColumnsList(List<GroupingSet> groupingSets) {
        ArrayList<RolapStar.Column[]> groupingColumns = new ArrayList<RolapStar.Column[]>();
        for (GroupingSet aggBatchDetail : groupingSets) {
            groupingColumns.add(aggBatchDetail.segment0.getColumns());
        }
        return groupingColumns;
    }

    public int getGroupingBitKeyIndex() {
        return this.groupingBitKeyIndex;
    }

    public List<RolapStar.Column> getRollupColumns() {
        return this.rollupColumns;
    }

    public List<RolapStar.Column[]> getGroupingSetsColumns() {
        return this.groupingSetsColumns;
    }

    public List<BitKey> getRollupColumnsBitKeyList() {
        return this.rollupColumnsBitKeyList;
    }

    private List<BitKey> loadGroupingColumnBitKeys() {
        if (!this.useGroupingSet) {
            return Collections.singletonList(BitKey.EMPTY);
        }
        ArrayList<BitKey> rollupColumnsBitKeyList = new ArrayList<BitKey>();
        int bitKeyLength = this.getDefaultColumns().length;
        for (RolapStar.Column[] groupingSetColumns : this.groupingSetsColumns) {
            BitKey groupingColumnsBitKey = BitKey.Factory.makeBitKey(bitKeyLength);
            HashSet<RolapStar.Column> columns = new HashSet<RolapStar.Column>(Arrays.asList(groupingSetColumns));
            int bitPosition = 0;
            for (RolapStar.Column rollupColumn : this.rollupColumns) {
                if (!columns.contains(rollupColumn)) {
                    groupingColumnsBitKey.set(bitPosition);
                }
                ++bitPosition;
            }
            rollupColumnsBitKeyList.add(groupingColumnsBitKey);
        }
        return rollupColumnsBitKeyList;
    }

    private int[] loadRollupIndex() {
        if (!this.useGroupingSet) {
            return new int[0];
        }
        RolapStar.Column[] detailedColumns = this.getDefaultColumns();
        int[] columnIndexToGroupingIndexMap = new int[detailedColumns.length];
        for (int columnIndex = 0; columnIndex < detailedColumns.length; ++columnIndex) {
            int rollupIndex;
            columnIndexToGroupingIndexMap[columnIndex] = rollupIndex = this.rollupColumns.indexOf(detailedColumns[columnIndex]);
        }
        return columnIndexToGroupingIndexMap;
    }

    private List<RolapStar.Column> findRollupColumns() {
        TreeSet<RolapStar.Column> rollupSet = new TreeSet<RolapStar.Column>(RolapStar.ColumnComparator.instance);
        for (RolapStar.Column[] groupingSetColumn : this.groupingSetsColumns) {
            HashSet<RolapStar.Column> summaryColumns = new HashSet<RolapStar.Column>(Arrays.asList(groupingSetColumn));
            for (RolapStar.Column column : this.getDefaultColumns()) {
                if (summaryColumns.contains(column)) continue;
                rollupSet.add(column);
            }
        }
        return new ArrayList<RolapStar.Column>(rollupSet);
    }

    public boolean useGroupingSets() {
        return this.useGroupingSet;
    }

    public int findGroupingFunctionIndex(int columnIndex) {
        return this.columnIndexToGroupingIndexMap[columnIndex];
    }

    public SegmentAxis[] getDefaultAxes() {
        return this.getDefaultGroupingSet().getAxes();
    }

    public StarColumnPredicate[] getDefaultPredicates() {
        return this.getDefaultGroupingSet().getPredicates();
    }

    protected GroupingSet getDefaultGroupingSet() {
        return this.groupingSets.get(0);
    }

    public RolapStar.Column[] getDefaultColumns() {
        return this.getDefaultGroupingSet().segment0.getColumns();
    }

    public List<Segment> getDefaultSegments() {
        return this.getDefaultGroupingSet().getSegments();
    }

    public BitKey getDefaultLevelBitKey() {
        return this.getDefaultGroupingSet().getLevelBitKey();
    }

    public BitKey getDefaultMeasureBitKey() {
        return this.getDefaultGroupingSet().getMeasureBitKey();
    }

    public RolapStar getStar() {
        return this.getDefaultGroupingSet().segment0.getStar();
    }

    public List<GroupingSet> getGroupingSets() {
        return this.groupingSets;
    }

    public List<GroupingSet> getRollupGroupingSets() {
        return this.groupingSets.subList(1, this.groupingSets.size());
    }

    static class Cohort {
        final List<SegmentDataset> segmentDatasetList;
        final SegmentAxis[] axes;
        final int[] pos;

        Cohort(List<SegmentDataset> segmentDatasetList, SegmentAxis[] axes) {
            this.segmentDatasetList = segmentDatasetList;
            this.axes = axes;
            this.pos = new int[axes.length];
        }
    }
}

