/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import mondrian.calc.ExpCompiler;
import mondrian.olap.Evaluator;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluationUnsupportedException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapDependencyTestingEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProfilingEvaluator;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.spi.Dialect;
import mondrian.util.ClassResolver;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.StringProperty;

public class RolapUtil {
    public static final Logger MDX_LOGGER = Logger.getLogger((String)"mondrian.mdx");
    public static final Logger SQL_LOGGER = Logger.getLogger((String)"mondrian.sql");
    public static final Logger MONITOR_LOGGER = Logger.getLogger((String)"mondrian.server.monitor");
    public static final Logger PROFILE_LOGGER = Logger.getLogger((String)"mondrian.profile");
    static final Logger LOGGER = Logger.getLogger(RolapUtil.class);
    public static final Object valueNotReadyException = new Double(0.0);
    private static ExecuteQueryHook queryHook = null;
    public static final Comparable<?> sqlNullValue = RolapUtilComparable.INSTANCE;
    public static final Comparator ROLAP_COMPARATOR = new RolapUtilComparator();
    private static String mdxNullLiteral = null;
    public static final String sqlNullLiteral = "null";
    private static final Set<String> loadedDrivers = new HashSet<String>();

    public static SchemaReader locusSchemaReader(RolapConnection connection, final SchemaReader schemaReader) {
        mondrian.server.Statement statement = connection.getInternalStatement();
        Execution execution = new Execution(statement, 0L);
        final Locus locus = new Locus(execution, "Schema reader", null);
        return (SchemaReader)Proxy.newProxyInstance(SchemaReader.class.getClassLoader(), new Class[]{SchemaReader.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Locus.push(locus);
                try {
                    Object object = method.invoke((Object)schemaReader, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                finally {
                    Locus.pop(locus);
                }
            }
        });
    }

    public static synchronized ExecuteQueryHook getHook() {
        return queryHook;
    }

    public static synchronized void setHook(ExecuteQueryHook hook) {
        queryHook = hook;
    }

    public static String mdxNullLiteral() {
        if (mdxNullLiteral == null) {
            RolapUtil.reloadNullLiteral();
        }
        return mdxNullLiteral;
    }

    public static void reloadNullLiteral() {
        mdxNullLiteral = MondrianProperties.instance().NullMemberRepresentation.get();
    }

    static RolapMember[] toArray(List<RolapMember> v) {
        return v.isEmpty() ? new RolapMember[]{} : v.toArray(new RolapMember[v.size()]);
    }

    static RolapMember lookupMember(MemberReader reader, List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        RolapMember rootMember;
        RolapMember member = RolapUtil.lookupMemberInternal(uniqueNameParts, null, reader, failIfNotFound);
        if (member != null) {
            return member;
        }
        List<RolapMember> rootMembers = reader.getRootMembers();
        if (rootMembers.size() == 1 && (rootMember = rootMembers.get(0)).isAll()) {
            member = RolapUtil.lookupMemberInternal(uniqueNameParts, rootMember, reader, failIfNotFound);
        }
        return member;
    }

    private static RolapMember lookupMemberInternal(List<Id.Segment> segments, RolapMember member, MemberReader reader, boolean failIfNotFound) {
        for (Id.Segment segment : segments) {
            List<RolapMember> children;
            if (!(segment instanceof Id.NameSegment)) break;
            Id.NameSegment nameSegment = (Id.NameSegment)segment;
            if (member == null) {
                children = reader.getRootMembers();
            } else {
                children = new ArrayList<RolapMember>();
                reader.getMemberChildren(member, children);
                member = null;
            }
            for (RolapMember child : children) {
                if (!child.getName().equals(nameSegment.name)) continue;
                member = child;
                break;
            }
            if (member != null) continue;
            break;
        }
        if (member == null && failIfNotFound) {
            throw MondrianResource.instance().MdxCantFindMember.ex(Util.implode(segments));
        }
        return member;
    }

    public static SqlStatement executeQuery(DataSource dataSource, String sql, Locus locus) {
        return RolapUtil.executeQuery(dataSource, sql, null, 0, 0, locus, -1, -1, null);
    }

    public static SqlStatement executeQuery(DataSource dataSource, String sql, List<SqlStatement.Type> types, int maxRowCount, int firstRowOrdinal, Locus locus, int resultSetType, int resultSetConcurrency, Util.Functor1<Void, Statement> callback) {
        SqlStatement stmt = new SqlStatement(dataSource, sql, types, maxRowCount, firstRowOrdinal, locus, resultSetType, resultSetConcurrency, callback);
        stmt.execute();
        return stmt;
    }

    public static void alertNonNative(String functionName, String reason) throws NativeEvaluationUnsupportedException {
        String alertMsg = "Unable to use native SQL evaluation for '" + functionName + "'; reason:  " + reason;
        StringProperty alertProperty = MondrianProperties.instance().AlertNativeEvaluationUnsupported;
        String alertValue = alertProperty.get();
        if (alertValue.equalsIgnoreCase(Level.WARN.toString())) {
            LOGGER.warn((Object)alertMsg);
        } else if (alertValue.equalsIgnoreCase(Level.ERROR.toString())) {
            LOGGER.error((Object)alertMsg);
            throw MondrianResource.instance().NativeEvaluationUnsupported.ex(functionName);
        }
    }

    public static synchronized void loadDrivers(String jdbcDrivers) {
        StringTokenizer tok = new StringTokenizer(jdbcDrivers, ",");
        while (tok.hasMoreTokens()) {
            String jdbcDriver = tok.nextToken();
            if (!loadedDrivers.add(jdbcDriver)) continue;
            try {
                ClassResolver.INSTANCE.forName(jdbcDriver, true);
                LOGGER.info((Object)("Mondrian: JDBC driver " + jdbcDriver + " loaded successfully"));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn((Object)("Mondrian: Warning: JDBC driver " + jdbcDriver + " not found"));
            }
        }
    }

    public static ExpCompiler createDependencyTestingCompiler(ExpCompiler compiler) {
        return new RolapDependencyTestingEvaluator.DteCompiler(compiler);
    }

    public static Member findBestMemberMatch(List<? extends Member> members, RolapMember parent, RolapLevel level, Id.Segment searchName, MatchType matchType) {
        if (!(searchName instanceof Id.NameSegment)) {
            return null;
        }
        Id.NameSegment nameSegment = (Id.NameSegment)searchName;
        switch (matchType) {
            case FIRST: {
                return members.get(0);
            }
            case LAST: {
                return members.get(members.size() - 1);
            }
        }
        Member searchMember = level.getHierarchy().createMember(parent, level, nameSegment.name, null);
        Member bestMatch = null;
        for (Member member : members) {
            if (searchName.quoting == Id.Quoting.KEY && member instanceof RolapMember && ((RolapMember)member).getKey().toString().equals(nameSegment.name)) {
                return member;
            }
            int rc = matchType.isExact() ? Util.compareName(member.getName(), nameSegment.name) : FunUtil.compareSiblingMembers(member, searchMember);
            if (rc == 0) {
                return member;
            }
            if (matchType == MatchType.BEFORE) {
                if (rc >= 0 || bestMatch != null && FunUtil.compareSiblingMembers(member, bestMatch) <= 0) continue;
                bestMatch = member;
                continue;
            }
            if (matchType != MatchType.AFTER || rc <= 0 || bestMatch != null && FunUtil.compareSiblingMembers(member, bestMatch) >= 0) continue;
            bestMatch = member;
        }
        if (matchType.isExact()) {
            return null;
        }
        return bestMatch;
    }

    public static MondrianDef.Relation convertInlineTableToRelation(MondrianDef.InlineTable inlineTable, Dialect dialect) {
        MondrianDef.View view = new MondrianDef.View();
        view.alias = inlineTable.alias;
        int columnCount = inlineTable.columnDefs.array.length;
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> columnTypes = new ArrayList<String>();
        for (int i = 0; i < columnCount; ++i) {
            columnNames.add(inlineTable.columnDefs.array[i].name);
            columnTypes.add(inlineTable.columnDefs.array[i].type);
        }
        ArrayList<String[]> valueList = new ArrayList<String[]>();
        for (MondrianDef.Row row : inlineTable.rows.array) {
            String[] values = new String[columnCount];
            for (MondrianDef.Value value : row.values) {
                int columnOrdinal = columnNames.indexOf(value.column);
                if (columnOrdinal < 0) {
                    throw Util.newError("Unknown column '" + value.column + "'");
                }
                values[columnOrdinal] = value.cdata;
            }
            valueList.add(values);
        }
        view.addCode("generic", dialect.generateInline(columnNames, columnTypes, valueList));
        return view;
    }

    public static RolapMember strip(RolapMember member) {
        if (member instanceof RolapCubeMember) {
            return ((RolapCubeMember)member).getRolapMember();
        }
        return member;
    }

    public static ExpCompiler createProfilingCompiler(ExpCompiler compiler) {
        return new RolapProfilingEvaluator.ProfilingEvaluatorCompiler(compiler);
    }

    public static Evaluator createEvaluator(mondrian.server.Statement statement) {
        Execution dummyExecution = new Execution(statement, 0L);
        RolapResult result = new RolapResult(dummyExecution, false);
        return result.getRootEvaluator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void constraintBitkeyForLimitedMembers(Evaluator evaluator, Member[] members, RolapCube cube, BitKey levelBitKey) {
        block3: for (Member curMember : members) {
            if (!(curMember instanceof RolapHierarchy.LimitedRollupMember)) continue;
            int savepoint = evaluator.savepoint();
            try {
                evaluator.setNonEmpty(false);
                List<Member> lowestMembers = ((RolapHierarchy)curMember.getHierarchy()).getLowestMembersForAccess(evaluator, ((RolapHierarchy.LimitedRollupMember)curMember).hierarchyAccess, FunUtil.getNonEmptyMemberChildrenWithDetails(evaluator, curMember));
                assert (lowestMembers.size() > 0);
                Member lowMember = lowestMembers.get(0);
                do {
                    RolapStar.Column curColumn;
                    if ((curColumn = ((RolapCubeLevel)lowMember.getLevel()).getBaseStarKeyColumn(cube)) != null) {
                        levelBitKey.set(curColumn.getBitPosition());
                    }
                    if (((RolapCubeLevel)lowMember.getLevel()).isUnique()) continue block3;
                } while (!(lowMember = lowMember.getParentMember()).isAll());
            }
            finally {
                evaluator.restore(savepoint);
            }
        }
    }

    static interface ExecuteQueryHook {
        public void onExecuteQuery(String var1);
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class TeeWriter
    extends FilterWriter {
        StringWriter buf = new StringWriter();

        public TeeWriter(Writer out) {
            super(out);
        }

        public String toString() {
            return this.buf.toString();
        }

        public Writer getWriter() {
            return this.out;
        }

        @Override
        public void write(int c) throws IOException {
            super.write(c);
            this.buf.write(c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            super.write(cbuf);
            this.buf.write(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            super.write(cbuf, off, len);
            this.buf.write(cbuf, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            super.write(str);
            this.buf.write(str);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            super.write(str, off, len);
            this.buf.write(str, off, len);
        }
    }

    private static final class RolapUtilComparator<T extends Comparable<T>>
    implements Comparator<T> {
        private RolapUtilComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            try {
                return o1.compareTo(o2);
            }
            catch (ClassCastException cce) {
                if (o2 == RolapUtilComparable.INSTANCE) {
                    return 1;
                }
                throw new MondrianException(cce);
            }
        }
    }

    private static final class RolapUtilComparable
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -2595758291465179116L;
        public static final RolapUtilComparable INSTANCE = new RolapUtilComparable();

        private RolapUtilComparable() {
        }

        public String toString() {
            return "#null";
        }

        public int compareTo(Object o) {
            return o == this ? 0 : -1;
        }
    }
}

