/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.IterCalc;
import mondrian.calc.ParameterSlot;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.Parameter;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.ResultBase;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.DelegatingRolapMember;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.Modulos;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapDependencyTestingEvaluator;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNamedSetEvaluator;
import mondrian.rolap.RolapProfilingEvaluator;
import mondrian.rolap.RolapSetEvaluator;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequestQuantumExceededException;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.spi.CellFormatter;
import mondrian.util.ConcatenableList;
import mondrian.util.Format;
import mondrian.util.ObjectPool;
import org.apache.log4j.Logger;

public class RolapResult
extends ResultBase {
    static final Logger LOGGER = Logger.getLogger(ResultBase.class);
    private RolapEvaluator evaluator;
    RolapEvaluator slicerEvaluator;
    private final CellKey point;
    private CellInfoContainer cellInfos;
    private FastBatchingCellReader batchingReader;
    private final CellReader aggregatingReader;
    private Modulos modulos = null;
    private final int maxEvalDepth;
    private final Map<Integer, Boolean> positionsHighCardinality;
    private final Map<Integer, TupleCursor> positionsIterators;
    private final Map<Integer, Integer> positionsIndexes;
    private final Map<Integer, List<List<Member>>> positionsCurrent;
    protected static final Map<Locale, ValueFormatter> formatValueFormatters = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RolapResult(Execution execution, boolean execute) {
        super(execution, null);
        this.maxEvalDepth = MondrianProperties.instance().MaxEvalDepth.get();
        this.positionsHighCardinality = new HashMap<Integer, Boolean>();
        this.positionsIterators = new HashMap<Integer, TupleCursor>();
        this.positionsIndexes = new HashMap<Integer, Integer>();
        this.positionsCurrent = new HashMap<Integer, List<List<Member>>>();
        this.point = CellKey.Generator.newCellKey(this.axes.length);
        AggregationManager aggMgr = execution.getMondrianStatement().getMondrianConnection().getServer().getAggregationManager();
        this.aggregatingReader = aggMgr.getCacheCellReader();
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            this.evaluator = new RolapDependencyTestingEvaluator(this, expDeps);
        } else {
            RolapResultEvaluatorRoot root = new RolapResultEvaluatorRoot(this);
            this.evaluator = this.statement.getProfileHandler() != null ? new RolapProfilingEvaluator(root) : new RolapEvaluator(root);
        }
        RolapCube cube = (RolapCube)this.query.getCube();
        this.batchingReader = new FastBatchingCellReader(execution, cube, aggMgr);
        CellInfoContainer cellInfoContainer = this.cellInfos = this.query.axes.length > 4 ? new CellInfoMap(this.point) : new CellInfoPool(this.query.axes.length);
        if (!execute) {
            return;
        }
        boolean normalExecution = true;
        try {
            Calc calc;
            RolapEvaluator slicerEvaluator;
            Axis savedSlicerAxis;
            cube.clearCachedAggregations();
            AxisMemberList axisMembers = new AxisMemberList();
            ArrayList<Member> nonDefaultAllMembers = new ArrayList<Member>();
            ArrayList<List<Member>> nonAllMembers = new ArrayList<List<Member>>();
            ArrayList<Member> measureMembers = new ArrayList<Member>();
            this.loadSpecialMembers(nonDefaultAllMembers, nonAllMembers, measureMembers);
            this.query.clearEvalCache();
            this.query.putEvalCache("ALL_MEMBER_LIST", nonDefaultAllMembers);
            List<List<Member>> emptyNonAllMembers = Collections.emptyList();
            this.slicerEvaluator = this.evaluator.push();
            axisMembers.setSlicer(true);
            this.loadMembers(emptyNonAllMembers, this.evaluator, this.query.getSlicerAxis(), this.query.slicerCalc, axisMembers);
            axisMembers.setSlicer(false);
            RolapEvaluator savedEvaluator = this.evaluator.push();
            if (!axisMembers.isEmpty()) {
                for (Member m : axisMembers) {
                    if (m == null) break;
                    this.evaluator.setSlicerContext(m);
                    if (!m.isMeasure()) continue;
                    measureMembers.clear();
                }
                this.replaceNonAllMembers(nonAllMembers, axisMembers);
                axisMembers.clearMembers();
            }
            this.slicerEvaluator = this.evaluator.push();
            boolean changed = false;
            axisMembers.clearTotalCellCount();
            for (int i = 0; i < this.axes.length; ++i) {
                QueryAxis axis = this.query.axes[i];
                Calc calc2 = this.query.axisCalcs[i];
                this.loadMembers(emptyNonAllMembers, this.evaluator, axis, calc2, axisMembers);
            }
            if (!axisMembers.isEmpty()) {
                for (Member m : axisMembers) {
                    if (!m.isMeasure()) continue;
                    measureMembers.clear();
                }
                changed = this.replaceNonAllMembers(nonAllMembers, axisMembers);
                axisMembers.clearMembers();
            }
            if (changed) {
                axisMembers.countOnly(true);
                axisMembers.clearTotalCellCount();
                int savepoint = this.evaluator.savepoint();
                try {
                    for (int i = 0; i < this.axes.length; ++i) {
                        QueryAxis axis = this.query.axes[i];
                        Calc calc3 = this.query.axisCalcs[i];
                        this.loadMembers(nonAllMembers, this.evaluator, axis, calc3, axisMembers);
                        this.evaluator.restore(savepoint);
                    }
                }
                finally {
                    this.evaluator.restore(savepoint);
                }
            }
            axisMembers.checkLimit();
            do {
                TupleIterable tupleIterable = this.evalExecute(nonAllMembers, nonAllMembers.size() - 1, savedEvaluator, this.query.getSlicerAxis(), this.query.slicerCalc);
                TupleList tupleList = TupleCollections.materialize(tupleIterable, true);
                savedSlicerAxis = this.slicerAxis = new RolapAxis(tupleList);
                slicerEvaluator = this.evaluator;
                if (tupleList.size() <= 1) continue;
                tupleList = AggregateFunDef.AggregateCalc.optimizeTupleList(slicerEvaluator, tupleList, false);
                final ValueCalc valueCalc = new ValueCalc(new DummyExp(new ScalarType()));
                final TupleList tupleList1 = tupleList;
                calc = new GenericCalc(new DummyExp(this.query.slicerCalc.getType())){

                    @Override
                    public Object evaluate(Evaluator evaluator) {
                        return AggregateFunDef.AggregateCalc.aggregate(valueCalc, evaluator, tupleList1);
                    }
                };
                AbstractList<RolapHierarchy> hierarchyList = new AbstractList<RolapHierarchy>(){
                    final List<Member> pos0;
                    {
                        this.pos0 = (List)tupleList1.get(0);
                    }

                    @Override
                    public RolapHierarchy get(int index) {
                        return ((RolapMember)this.pos0.get(index)).getHierarchy();
                    }

                    @Override
                    public int size() {
                        return this.pos0.size();
                    }
                };
                Member placeholder = this.setPlaceholderSlicerAxis((RolapMember)((List)tupleList.get(0)).get(0), calc);
                this.evaluator.setContext(placeholder);
            } while (this.phase());
            int savepoint = this.evaluator.savepoint();
            do {
                try {
                    boolean redo;
                    do {
                        this.evaluator.restore(savepoint);
                        redo = false;
                        for (int i = 0; i < this.axes.length; ++i) {
                            TupleIterator tupleIterator;
                            QueryAxis axis = this.query.axes[i];
                            calc = this.query.axisCalcs[i];
                            TupleIterable tupleIterable = this.evalExecute(nonAllMembers, nonAllMembers.size() - 1, this.evaluator, axis, calc);
                            if (!nonAllMembers.isEmpty() && (tupleIterator = tupleIterable.tupleIterator()).hasNext()) {
                                List tuple0 = (List)tupleIterator.next();
                                for (Member m : tuple0) {
                                    if (!m.isCalculated()) continue;
                                    CalculatedMeasureVisitor visitor = new CalculatedMeasureVisitor();
                                    m.getExpression().accept(visitor);
                                    Dimension dimension = visitor.dimension;
                                    if (!this.removeDimension(dimension, nonAllMembers)) continue;
                                    redo = true;
                                }
                            }
                            this.axes[i] = new RolapAxis(TupleCollections.materialize(tupleIterable, false));
                        }
                    } while (redo);
                }
                catch (CellRequestQuantumExceededException e) {
                    // empty catch block
                }
            } while (this.phase());
            this.evaluator.restore(savepoint);
            Locus locus = new Locus(execution, null, "Loading cells");
            Locus.push(locus);
            try {
                this.executeBody(slicerEvaluator, this.query, new int[this.axes.length]);
            }
            finally {
                Locus.pop(locus);
            }
            if (this.cellInfos.size() > 10000) {
                this.cellInfos.trimToSize();
            }
            this.slicerAxis = savedSlicerAxis;
        }
        catch (ResultLimitExceededException ex) {
            normalExecution = false;
            this.evaluator = null;
            this.slicerEvaluator = null;
            this.cellInfos = null;
            this.batchingReader = null;
            for (int i = 0; i < this.axes.length; ++i) {
                this.axes[i] = null;
            }
            this.slicerAxis = null;
            this.query.clearEvalCache();
            throw ex;
        }
        finally {
            if (normalExecution) {
                this.evaluator.clearExpResultCache(true);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("RolapResult<init>: " + Util.printMemory()));
            }
        }
    }

    private Member setPlaceholderSlicerAxis(RolapMember member, Calc calc) {
        ValueFormatter formatter = member.getDimension().isMeasures() ? ((RolapMeasure)((Object)member)).getFormatter() : null;
        CompoundSlicerRolapMember placeholderMember = new CompoundSlicerRolapMember((RolapMember)member.getHierarchy().getNullMember(), calc, formatter);
        placeholderMember.setProperty(Property.FORMAT_STRING.getName(), member.getPropertyValue(Property.FORMAT_STRING.getName()));
        placeholderMember.setProperty(Property.FORMAT_EXP_PARSED.getName(), member.getPropertyValue(Property.FORMAT_EXP_PARSED.getName()));
        TupleList dummyList = TupleCollections.createList(1);
        dummyList.addTuple(placeholderMember);
        this.slicerAxis = new RolapAxis(dummyList);
        return placeholderMember;
    }

    private boolean phase() {
        if (this.batchingReader.isDirty()) {
            this.execution.tracePhase(this.batchingReader.getHitCount(), this.batchingReader.getMissCount(), this.batchingReader.getPendingCount());
            return this.batchingReader.loadAggregations();
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
    }

    protected boolean removeDimension(Dimension dimension, List<List<Member>> memberLists) {
        for (int i = 0; i < memberLists.size(); ++i) {
            List<Member> memberList = memberLists.get(i);
            if (!memberList.get(0).getDimension().equals(dimension)) continue;
            memberLists.remove(i);
            return true;
        }
        return false;
    }

    public final Execution getExecution() {
        return this.execution;
    }

    protected boolean replaceNonAllMembers(List<List<Member>> nonAllMembers, AxisMemberList axisMembers) {
        boolean changed = false;
        ArrayList<Member> mList = new ArrayList<Member>();
        ListIterator<List<Member>> it = nonAllMembers.listIterator();
        while (it.hasNext()) {
            List<Member> ms = it.next();
            Hierarchy h = ms.get(0).getHierarchy();
            mList.clear();
            for (Member m : axisMembers) {
                if (!m.getHierarchy().equals(h)) continue;
                mList.add(m);
            }
            if (mList.isEmpty()) continue;
            changed = true;
            it.set(new ArrayList(mList));
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMembers(List<List<Member>> nonAllMembers, RolapEvaluator evaluator, QueryAxis axis, Calc calc, AxisMemberList axisMembers) {
        block7: {
            int attempt = 0;
            evaluator.setCellReader(this.batchingReader);
            do {
                axisMembers.clearAxisCount();
                int savepoint = evaluator.savepoint();
                try {
                    this.evalLoad(nonAllMembers, nonAllMembers.size() - 1, evaluator, axis, calc, axisMembers);
                }
                catch (CellRequestQuantumExceededException e) {
                    --attempt;
                }
                finally {
                    evaluator.restore(savepoint);
                }
                if (!this.phase()) break block7;
                evaluator.clearExpResultCache(false);
            } while (attempt++ <= this.maxEvalDepth);
            throw Util.newInternal("Failed to load all aggregations after " + this.maxEvalDepth + " passes; there's probably a cycle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalLoad(List<List<Member>> nonAllMembers, int cnt, Evaluator evaluator, QueryAxis axis, Calc calc, AxisMemberList axisMembers) {
        int savepoint = evaluator.savepoint();
        try {
            if (cnt < 0) {
                this.executeAxis(evaluator, axis, calc, false, axisMembers);
            } else {
                for (Member m : nonAllMembers.get(cnt)) {
                    evaluator.setContext(m);
                    this.evalLoad(nonAllMembers, cnt - 1, evaluator, axis, calc, axisMembers);
                }
            }
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TupleIterable evalExecute(List<List<Member>> nonAllMembers, int cnt, RolapEvaluator evaluator, QueryAxis queryAxis, Calc calc) {
        int arity;
        int savepoint = evaluator.savepoint();
        int n = arity = calc == null ? 0 : calc.getType().getArity();
        if (cnt < 0) {
            try {
                TupleIterable axis;
                TupleIterable tupleIterable = axis = this.executeAxis(evaluator, queryAxis, calc, true, null);
                return tupleIterable;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }
        try {
            TupleList axisResult = TupleCollections.emptyList(arity);
            for (Member m : nonAllMembers.get(cnt)) {
                evaluator.setContext(m);
                TupleIterable axis = this.evalExecute(nonAllMembers, cnt - 1, evaluator, queryAxis, calc);
                boolean ordered = false;
                if (queryAxis != null) {
                    ordered = queryAxis.isOrdered();
                }
                axisResult = RolapResult.mergeAxes(axisResult, axis, ordered);
            }
            TupleList tupleList = axisResult;
            return tupleList;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    protected void loadSpecialMembers(List<Member> nonDefaultAllMembers, List<List<Member>> nonAllMembers, List<Member> measureMembers) {
        Member[] evalMembers;
        SchemaReader schemaReader = this.evaluator.getSchemaReader();
        block0: for (Member em : evalMembers = this.evaluator.getMembers()) {
            Hierarchy h;
            Dimension d;
            if (em.isCalculated() || (d = (h = em.getHierarchy()).getDimension()).getDimensionType() == DimensionType.TimeDimension || em.isAll()) continue;
            List<Member> rootMembers = schemaReader.getHierarchyRootMembers(h);
            if (em.isMeasure()) {
                for (Member mm : rootMembers) {
                    measureMembers.add(mm);
                }
                continue;
            }
            if (h.hasAll()) {
                for (Member m : rootMembers) {
                    if (!m.isAll()) continue;
                    nonDefaultAllMembers.add(m);
                    continue block0;
                }
                continue;
            }
            nonAllMembers.add(rootMembers);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public final RolapCube getCube() {
        return this.evaluator.getCube();
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cell getCell(int[] pos) {
        if (pos.length != this.point.size()) {
            throw Util.newError("coordinates should have dimension " + this.point.size());
        }
        for (int i = 0; i < pos.length; ++i) {
            if (!this.positionsHighCardinality.get(i).booleanValue()) continue;
            Locus locus = new Locus(this.execution, null, "Loading cells");
            Locus.push(locus);
            try {
                this.executeBody(this.evaluator, this.statement.getQuery(), pos);
                break;
            }
            finally {
                Locus.pop(locus);
            }
        }
        CellInfo ci = this.cellInfos.lookup(pos);
        if (ci.value == null) {
            for (int i = 0; i < pos.length; ++i) {
                int po = pos[i];
                if (po >= 0 && po < this.axes[i].getPositions().size()) continue;
                throw Util.newError("coordinates out of range");
            }
            ci.value = Util.nullValue;
        }
        return new RolapCell(this, (int[])pos.clone(), ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TupleIterable executeAxis(Evaluator evaluator, QueryAxis queryAxis, Calc axisCalc, boolean construct, AxisMemberList axisMembers) {
        if (queryAxis == null) {
            return new DelegatingTupleList(0, Collections.singletonList(Collections.emptyList()));
        }
        int savepoint = evaluator.savepoint();
        try {
            evaluator.setNonEmpty(queryAxis.isNonEmpty());
            evaluator.setEvalAxes(true);
            TupleIterable iterable = ((IterCalc)axisCalc).evaluateIterable(evaluator);
            if (axisCalc.getClass().getName().indexOf("OrderFunDef") != -1) {
                queryAxis.setOrdered(true);
            }
            if (iterable instanceof TupleList) {
                TupleList list = (TupleList)iterable;
                if (!construct && axisMembers != null) {
                    axisMembers.mergeTupleList(list);
                }
            } else {
                TupleCursor cursor = iterable.tupleCursor();
                if (!construct && axisMembers != null) {
                    axisMembers.mergeTupleIter(cursor);
                }
            }
            TupleIterable tupleIterable = iterable;
            return tupleIterable;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    private void executeBody(RolapEvaluator evaluator, Query query, int[] pos) {
        int count = 0;
        int savepoint = evaluator.savepoint();
        while (true) {
            evaluator.setCellReader(this.batchingReader);
            try {
                this.executeStripe(query.axes.length - 1, evaluator, pos);
            }
            catch (CellRequestQuantumExceededException e) {
                --count;
            }
            evaluator.restore(savepoint);
            if (!this.phase()) {
                return;
            }
            evaluator.clearExpResultCache(false);
            if (count++ > this.maxEvalDepth) {
                if (evaluator instanceof RolapDependencyTestingEvaluator) {
                    ((RolapDependencyTestingEvaluator.DteRoot)evaluator.root).disabled = true;
                    if (count > this.maxEvalDepth * 2) {
                        throw Util.newInternal("Query required more than " + count + " iterations");
                    }
                } else {
                    throw Util.newInternal("Query required more than " + count + " iterations");
                }
            }
            this.cellInfos.clear();
        }
    }

    boolean isDirty() {
        return this.batchingReader.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object evaluateExp(Calc calc, RolapEvaluator slicerEvaluator, Evaluator contextEvaluator) {
        int attempt = 0;
        RolapEvaluator evaluator = slicerEvaluator.push();
        if (contextEvaluator != null && contextEvaluator.isEvalAxes()) {
            evaluator.setEvalAxes(true);
            evaluator.setContext(contextEvaluator.getMembers());
        }
        int savepoint = evaluator.savepoint();
        boolean dirty = this.batchingReader.isDirty();
        try {
            Object o;
            block8: {
                do {
                    evaluator.restore(savepoint);
                    evaluator.setCellReader(this.batchingReader);
                    Object preliminaryValue = calc.evaluate(evaluator);
                    if (preliminaryValue instanceof TupleIterable) {
                        TupleIterable iterable = (TupleIterable)preliminaryValue;
                        TupleCursor cursor = iterable.tupleCursor();
                        while (cursor.forward()) {
                        }
                    }
                    if (!this.phase()) break block8;
                    evaluator.clearExpResultCache(false);
                } while (attempt++ <= this.maxEvalDepth);
                throw Util.newInternal("Failed to load all aggregations after " + this.maxEvalDepth + "passes; there's probably a cycle");
            }
            if (dirty) {
                this.batchingReader.setDirty(true);
            }
            evaluator.restore(savepoint);
            evaluator.setCellReader(this.aggregatingReader);
            Object object = o = calc.evaluate(evaluator);
            return object;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStripe(int axisOrdinal, RolapEvaluator revaluator, int[] pos) {
        block35: {
            block34: {
                Object o;
                if (axisOrdinal >= 0) break block34;
                RolapAxis axis = (RolapAxis)this.slicerAxis;
                TupleList tupleList = axis.getTupleList();
                Iterator tupleIterator = tupleList.iterator();
                if (!tupleIterator.hasNext()) break block35;
                List members = (List)tupleIterator.next();
                this.execution.checkCancelOrTimeout();
                int savepoint = revaluator.savepoint();
                revaluator.setContext(members);
                try {
                    o = revaluator.evaluateCurrent();
                }
                catch (MondrianEvaluationException e) {
                    LOGGER.warn((Object)"Mondrian: exception in executeStripe.", (Throwable)e);
                    o = e;
                }
                finally {
                    revaluator.restore(savepoint);
                }
                CellInfo ci = null;
                try {
                    ci = this.cellInfos.create(this.point.getOrdinals());
                    String cachedFormatString = null;
                    RolapCube cube = this.getCube();
                    Hierarchy measuresHierarchy = cube.getMeasuresHierarchy();
                    RolapMeasure m = (RolapMeasure)((Object)revaluator.getContext(measuresHierarchy));
                    ValueFormatter valueFormatter = m.getFormatter();
                    if (valueFormatter == null) {
                        cachedFormatString = revaluator.getFormatString();
                        Locale locale = this.statement.getMondrianConnection().getLocale();
                        valueFormatter = formatValueFormatters.get(locale);
                        if (valueFormatter == null) {
                            valueFormatter = new FormatValueFormatter(locale);
                            formatValueFormatters.put(locale, valueFormatter);
                        }
                    }
                    ci.formatString = cachedFormatString;
                    ci.valueFormatter = valueFormatter;
                }
                catch (ResultLimitExceededException e) {
                    throw e;
                }
                catch (CellRequestQuantumExceededException e) {
                    throw e;
                }
                catch (MondrianEvaluationException e) {
                    LOGGER.warn((Object)"Mondrian: exception in executeStripe.", (Throwable)e);
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOGGER.warn((Object)"Mondrian: exception in executeStripe.", e);
                    Util.discard((Object)e);
                }
                if (o == RolapUtil.valueNotReadyException) break block35;
                ci.value = o;
                break block35;
            }
            RolapAxis axis = (RolapAxis)this.axes[axisOrdinal];
            TupleList tupleList = axis.getTupleList();
            Util.discard((int)tupleList.size());
            if (this.isAxisHighCardinality(axisOrdinal, tupleList)) {
                int pi;
                TupleCursor tupleCursor;
                int limit = MondrianProperties.instance().HighCardChunkSize.get();
                if (this.positionsIterators.get(axisOrdinal) == null) {
                    tupleCursor = tupleList.tupleCursor();
                    this.positionsIterators.put(axisOrdinal, tupleCursor);
                    this.positionsIndexes.put(axisOrdinal, 0);
                    ArrayList<List<Member>> subPositions = new ArrayList<List<Member>>();
                    for (int i = 0; i < limit && tupleCursor.forward(); ++i) {
                        subPositions.add(tupleCursor.current());
                    }
                    this.positionsCurrent.put(axisOrdinal, subPositions);
                }
                tupleCursor = this.positionsIterators.get(axisOrdinal);
                int positionIndex = this.positionsIndexes.get(axisOrdinal);
                List<List<Member>> subTuples = this.positionsCurrent.get(axisOrdinal);
                if (subTuples == null) {
                    return;
                }
                if (pos[axisOrdinal] > positionIndex + subTuples.size() - 1 && subTuples.size() == limit) {
                    pi = positionIndex + subTuples.size();
                    this.positionsIndexes.put(axisOrdinal, positionIndex + subTuples.size());
                    subTuples.subList(0, subTuples.size()).clear();
                    for (int i = 0; i < limit && tupleCursor.forward(); ++i) {
                        subTuples.add(tupleCursor.current());
                    }
                    this.positionsCurrent.put(axisOrdinal, subTuples);
                } else {
                    pi = positionIndex;
                }
                for (List<Member> tuple : subTuples) {
                    this.point.setAxis(axisOrdinal, pi);
                    int savepoint = revaluator.savepoint();
                    try {
                        revaluator.setContext(tuple);
                        this.execution.checkCancelOrTimeout();
                        this.executeStripe(axisOrdinal - 1, revaluator, pos);
                    }
                    finally {
                        revaluator.restore(savepoint);
                    }
                    ++pi;
                }
            } else {
                for (List tuple : tupleList) {
                    ArrayList<Member> measures = new ArrayList<Member>(this.statement.getQuery().getMeasuresMembers());
                    for (Member measure : measures) {
                        RolapBaseCubeMeasure baseCubeMeasure;
                        if (!(measure instanceof RolapBaseCubeMeasure) || (baseCubeMeasure = (RolapBaseCubeMeasure)measure).getAggregator() != RolapAggregator.DistinctCount) continue;
                        this.processDistinctMeasureExpr(tuple, baseCubeMeasure);
                    }
                }
                int tupleIndex = 0;
                for (List tuple : tupleList) {
                    this.point.setAxis(axisOrdinal, tupleIndex);
                    int savepoint = revaluator.savepoint();
                    try {
                        revaluator.setContext(tuple);
                        this.execution.checkCancelOrTimeout();
                        this.executeStripe(axisOrdinal - 1, revaluator, pos);
                    }
                    finally {
                        revaluator.restore(savepoint);
                    }
                    ++tupleIndex;
                }
            }
        }
    }

    private boolean isAxisHighCardinality(int axisOrdinal, TupleList tupleList) {
        Boolean highCardinality = this.positionsHighCardinality.get(axisOrdinal);
        if (highCardinality == null) {
            List tuple;
            highCardinality = false;
            Iterator i$ = tupleList.iterator();
            if (i$.hasNext() && !(tuple = (List)i$.next()).isEmpty()) {
                highCardinality = ((Member)tuple.get(0)).getDimension().isHighCardinality();
            }
            this.positionsHighCardinality.put(axisOrdinal, highCardinality);
        }
        return highCardinality;
    }

    private List<Member> processDistinctMeasureExpr(List<Member> tuple, RolapBaseCubeMeasure measure) {
        for (Member member : tuple) {
            if (!(member instanceof VisualTotalsFunDef.VisualTotalMember)) continue;
            this.evaluator.setContext(measure);
            ArrayList<Member> exprMembers = new ArrayList<Member>();
            RolapResult.processMemberExpr(member, exprMembers);
            ((VisualTotalsFunDef.VisualTotalMember)member).setExpression(this.evaluator, exprMembers);
        }
        return tuple;
    }

    private static void processMemberExpr(Object o, List<Member> exprMembers) {
        if (o instanceof Member && o instanceof RolapCubeMember) {
            exprMembers.add((Member)o);
        } else if (o instanceof VisualTotalsFunDef.VisualTotalMember) {
            VisualTotalsFunDef.VisualTotalMember member = (VisualTotalsFunDef.VisualTotalMember)o;
            Exp exp = member.getExpression();
            RolapResult.processMemberExpr(exp, exprMembers);
        } else if (o instanceof Exp && !(o instanceof MemberExpr)) {
            Exp exp = (Exp)o;
            ResolvedFunCall funCall = (ResolvedFunCall)exp;
            Exp[] exps = funCall.getArgs();
            RolapResult.processMemberExpr(exps, exprMembers);
        } else if (o instanceof Exp[]) {
            Exp[] exps;
            for (Exp exp : exps = (Exp[])o) {
                RolapResult.processMemberExpr(exp, exprMembers);
            }
        } else if (o instanceof MemberExpr) {
            MemberExpr memberExp = (MemberExpr)o;
            Member member = memberExp.getMember();
            RolapResult.processMemberExpr(member, exprMembers);
        }
    }

    int getCellOrdinal(int[] pos) {
        if (this.modulos == null) {
            this.makeModulos();
        }
        return this.modulos.getCellOrdinal(pos);
    }

    protected void makeModulos() {
        this.modulos = Modulos.Generator.create(this.axes);
    }

    RolapMember[] getCellMembers(int[] pos) {
        RolapMember[] members = (RolapMember[])this.evaluator.getMembers().clone();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].getPositions().get(pos[i]);
            for (Member member : position) {
                RolapMember m = (RolapMember)member;
                int ordinal = m.getHierarchy().getOrdinalInCube();
                members[ordinal] = m;
            }
        }
        return members;
    }

    Evaluator getRootEvaluator() {
        return this.evaluator;
    }

    Evaluator getEvaluator(int[] pos) {
        RolapEvaluator cellEvaluator = this.evaluator.push();
        this.populateEvaluator(cellEvaluator, pos);
        return cellEvaluator;
    }

    void populateEvaluator(Evaluator evaluator, int[] pos) {
        for (int i = -1; i < this.axes.length; ++i) {
            int index;
            Axis axis;
            if (i < 0) {
                axis = this.slicerAxis;
                if (axis.getPositions().isEmpty()) continue;
                index = 0;
            } else {
                axis = this.axes[i];
                index = pos[i];
            }
            Position position = axis.getPositions().get(index);
            evaluator.setContext(position);
        }
    }

    static TupleList mergeAxes(TupleList axis1, TupleIterable axis2, boolean ordered) {
        if (axis1.isEmpty() && axis2 instanceof TupleList) {
            return (TupleList)axis2;
        }
        HashSet<List> set = new HashSet<List>();
        TupleList list = TupleCollections.createList(axis2.getArity());
        for (List tuple : axis1) {
            if (!set.add(tuple)) continue;
            list.add(tuple);
        }
        int halfWay = list.size();
        for (List tuple : axis2) {
            if (!set.add(tuple)) continue;
            list.add(tuple);
        }
        if (halfWay > 0 && halfWay < list.size() && !ordered) {
            list = FunUtil.hierarchizeTupleList(list, false);
        }
        return list;
    }

    private class CompoundSlicerRolapMember
    extends DelegatingRolapMember
    implements RolapMeasure {
        private final Calc calc;
        private final ValueFormatter valueFormatter;

        public CompoundSlicerRolapMember(RolapMember placeholderMember, Calc calc, ValueFormatter formatter) {
            super(placeholderMember);
            this.calc = calc;
            this.valueFormatter = formatter;
        }

        @Override
        public boolean isEvaluated() {
            return true;
        }

        @Override
        public Exp getExpression() {
            return new DummyExp(this.calc.getType());
        }

        @Override
        public Calc getCompiledExpression(RolapEvaluatorRoot root) {
            return this.calc;
        }

        @Override
        public int getSolveOrder() {
            return 0;
        }

        @Override
        public ValueFormatter getFormatter() {
            return this.valueFormatter;
        }
    }

    static class CellInfoPool
    implements CellInfoContainer {
        protected static final long MAX_AXIS_SIZE_2 = Integer.MAX_VALUE;
        protected static final long MAX_AXIS_SIZE_3 = 2000000L;
        protected static final long MAX_AXIS_SIZE_4 = 50000L;
        private final ObjectPool<CellInfo> cellInfoPool;
        private final CellKeyMaker cellKeyMaker;

        CellInfoPool(int axisLength) {
            this.cellInfoPool = new ObjectPool();
            this.cellKeyMaker = CellInfoPool.createCellKeyMaker(axisLength);
        }

        CellInfoPool(int axisLength, int initialSize) {
            this.cellInfoPool = new ObjectPool(initialSize);
            this.cellKeyMaker = CellInfoPool.createCellKeyMaker(axisLength);
        }

        private static CellKeyMaker createCellKeyMaker(int axisLength) {
            switch (axisLength) {
                case 0: {
                    return new Zero();
                }
                case 1: {
                    return new One();
                }
                case 2: {
                    return new Two();
                }
                case 3: {
                    return new Three();
                }
                case 4: {
                    return new Four();
                }
            }
            throw new RuntimeException("Creating CellInfoPool with axisLength=" + axisLength);
        }

        @Override
        public int size() {
            return this.cellInfoPool.size();
        }

        @Override
        public void trimToSize() {
            this.cellInfoPool.trimToSize();
        }

        @Override
        public void clear() {
            this.cellInfoPool.clear();
        }

        @Override
        public CellInfo create(int[] pos) {
            long key = this.cellKeyMaker.generate(pos);
            return this.cellInfoPool.add(new CellInfo(key));
        }

        @Override
        public CellInfo lookup(int[] pos) {
            long key = this.cellKeyMaker.generate(pos);
            return this.cellInfoPool.add(new CellInfo(key));
        }

        static class Four
        implements CellKeyMaker {
            Four() {
            }

            @Override
            public long generate(int[] pos) {
                long l = pos[0];
                l += 50000L * (long)pos[1];
                l += 2500000000L * (long)pos[2];
                return l += 125000000000000L * (long)pos[3];
            }
        }

        static class Three
        implements CellKeyMaker {
            Three() {
            }

            @Override
            public long generate(int[] pos) {
                long l = pos[0];
                l += 2000000L * (long)pos[1];
                return l += 4000000000000L * (long)pos[2];
            }
        }

        static class Two
        implements CellKeyMaker {
            Two() {
            }

            @Override
            public long generate(int[] pos) {
                long l = pos[0];
                return l += Integer.MAX_VALUE * (long)pos[1];
            }
        }

        static class One
        implements CellKeyMaker {
            One() {
            }

            @Override
            public long generate(int[] pos) {
                return pos[0];
            }
        }

        static class Zero
        implements CellKeyMaker {
            Zero() {
            }

            @Override
            public long generate(int[] pos) {
                return 0L;
            }
        }

        static interface CellKeyMaker {
            public long generate(int[] var1);
        }
    }

    static class CellInfoMap
    implements CellInfoContainer {
        private final Map<CellKey, CellInfo> cellInfoMap;
        private final CellKey point;

        CellInfoMap(CellKey point) {
            this.point = point;
            this.cellInfoMap = new HashMap<CellKey, CellInfo>();
        }

        @Override
        public int size() {
            return this.cellInfoMap.size();
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void clear() {
            this.cellInfoMap.clear();
        }

        @Override
        public CellInfo create(int[] pos) {
            CellKey key = this.point.copy();
            CellInfo ci = this.cellInfoMap.get(key);
            if (ci == null) {
                ci = new CellInfo(0L);
                this.cellInfoMap.put(key, ci);
            }
            return ci;
        }

        @Override
        public CellInfo lookup(int[] pos) {
            CellKey key = CellKey.Generator.newCellKey(pos);
            return this.cellInfoMap.get(key);
        }
    }

    static interface CellInfoContainer {
        public int size();

        public void trimToSize();

        public void clear();

        public CellInfo create(int[] var1);

        public CellInfo lookup(int[] var1);
    }

    static class CellInfo {
        Object value;
        String formatString;
        ValueFormatter valueFormatter;
        long key;

        CellInfo(long key) {
            this(key, null, null, ValueFormatter.EMPTY);
        }

        CellInfo(long key, Object value, String formatString, ValueFormatter valueFormatter) {
            this.key = key;
            this.value = value;
            this.formatString = formatString;
            this.valueFormatter = valueFormatter;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 11 ^ this.key >>> 24);
        }

        public boolean equals(Object o) {
            if (o instanceof CellInfo) {
                CellInfo that = (CellInfo)o;
                return that.key == this.key;
            }
            return false;
        }

        String getFormatValue() {
            return this.valueFormatter.format(this.value, this.formatString);
        }
    }

    static class FormatValueFormatter
    implements ValueFormatter {
        final Locale locale;

        FormatValueFormatter(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String format(Object value, String formatString) {
            if (value == Util.nullValue) {
                value = null;
            }
            if (value instanceof Throwable) {
                return "#ERR: " + value.toString();
            }
            Format format = this.getFormat(formatString);
            return format.format(value);
        }

        private Format getFormat(String formatString) {
            return Format.get(formatString, this.locale);
        }
    }

    static class CellFormatterValueFormatter
    implements ValueFormatter {
        final CellFormatter cf;

        CellFormatterValueFormatter(CellFormatter cf) {
            this.cf = cf;
        }

        @Override
        public String format(Object value, String formatString) {
            return this.cf.formatCell(value);
        }
    }

    static interface ValueFormatter {
        public static final ValueFormatter EMPTY = new ValueFormatter(){

            @Override
            public String format(Object value, String formatString) {
                return "";
            }
        };

        public String format(Object var1, String var2);
    }

    protected static class RolapResultEvaluatorRoot
    extends RolapEvaluatorRoot {
        private final Map<String, RolapSetEvaluator> setEvaluators = new HashMap<String, RolapSetEvaluator>();
        private final Map<String, RolapNamedSetEvaluator> namedSetEvaluators = new HashMap<String, RolapNamedSetEvaluator>();
        final RolapResult result;
        private static final Object CycleSentinel = new Object();
        private static final Object NullSentinel = new Object();

        public RolapResultEvaluatorRoot(RolapResult result) {
            super(result.execution);
            this.result = result;
        }

        @Override
        protected Evaluator.NamedSetEvaluator evaluateNamedSet(NamedSet namedSet, boolean create) {
            String name = namedSet.getNameUniqueWithinQuery();
            RolapNamedSetEvaluator value = namedSet.isDynamic() && !create ? null : this.namedSetEvaluators.get(name);
            if (value == null) {
                value = new RolapNamedSetEvaluator(this, namedSet);
                this.namedSetEvaluators.put(name, value);
            }
            return value;
        }

        @Override
        protected Evaluator.SetEvaluator evaluateSet(Exp exp, boolean create) {
            if (!(exp.getType() instanceof SetType)) {
                throw Util.newInternal("Trying to evaluate set but expression does not return a set");
            }
            String name = exp.toString();
            RolapSetEvaluator value = !create ? null : this.setEvaluators.get(name);
            if (value == null) {
                value = new RolapSetEvaluator(this, exp);
                this.setEvaluators.put(name, value);
            }
            return value;
        }

        @Override
        public Object getParameterValue(ParameterSlot slot) {
            if (slot.isParameterSet()) {
                return slot.getParameterValue();
            }
            Parameter.Scope scope = slot.getParameter().getScope();
            switch (scope) {
                case System: 
                case Schema: 
                case Connection: 
                case Statement: {
                    break;
                }
                default: {
                    throw Util.badValue(scope);
                }
            }
            Object liftedValue = slot.getCachedDefaultValue();
            if (liftedValue != null) {
                if (liftedValue == CycleSentinel) {
                    throw MondrianResource.instance().CycleDuringParameterEvaluation.ex(slot.getParameter().getName());
                }
                Object value = liftedValue == NullSentinel ? null : liftedValue;
                return value;
            }
            slot.setCachedDefaultValue(CycleSentinel);
            Object value = this.result.evaluateExp(slot.getDefaultValueCalc(), this.result.slicerEvaluator, null);
            liftedValue = value == null ? NullSentinel : value;
            slot.setCachedDefaultValue(liftedValue);
            return value;
        }
    }

    private static class AxisMemberList
    implements Iterable<Member> {
        private final List<Member> members = new ConcatenableList<Member>();
        private final int limit;
        private boolean isSlicer;
        private int totalCellCount = 1;
        private int axisCount = 0;
        private boolean countOnly = false;

        AxisMemberList() {
            this.limit = MondrianProperties.instance().ResultLimit.get();
        }

        @Override
        public Iterator<Member> iterator() {
            return this.members.iterator();
        }

        void setSlicer(boolean isSlicer) {
            this.isSlicer = isSlicer;
        }

        boolean isEmpty() {
            return this.members.isEmpty();
        }

        void countOnly(boolean countOnly) {
            this.countOnly = countOnly;
        }

        void checkLimit() {
            if (this.limit > 0) {
                this.totalCellCount *= this.axisCount;
                if (this.totalCellCount > this.limit) {
                    throw MondrianResource.instance().TotalMembersLimitExceeded.ex(this.totalCellCount, this.limit);
                }
                this.axisCount = 0;
            }
        }

        void clearAxisCount() {
            this.axisCount = 0;
        }

        void clearTotalCellCount() {
            this.totalCellCount = 1;
        }

        void clearMembers() {
            this.members.clear();
            this.axisCount = 0;
            this.totalCellCount = 1;
        }

        void mergeTupleList(TupleList list) {
            this.mergeTupleIter(list.tupleCursor());
        }

        private void mergeTupleIter(TupleCursor cursor) {
            while (cursor.forward()) {
                this.mergeTuple(cursor);
            }
        }

        private Member getTopParent(Member m) {
            Member parent;
            while ((parent = m.getParentMember()) != null) {
                m = parent;
            }
            return m;
        }

        private void mergeTuple(TupleCursor cursor) {
            int arity = cursor.getArity();
            for (int i = 0; i < arity; ++i) {
                this.mergeMember(cursor.member(i));
            }
        }

        private void mergeMember(Member member) {
            ++this.axisCount;
            if (!this.countOnly) {
                if (this.isSlicer) {
                    if (!this.members.contains(member)) {
                        this.members.add(member);
                    }
                } else {
                    if (member.isNull()) {
                        return;
                    }
                    if (member.isMeasure()) {
                        return;
                    }
                    if (member.isCalculated()) {
                        return;
                    }
                    if (member.isAll()) {
                        return;
                    }
                    Member topParent = this.getTopParent(member);
                    if (!this.members.contains(topParent)) {
                        this.members.add(topParent);
                    }
                }
            }
        }
    }

    private static class CalculatedMeasureVisitor
    extends MdxVisitorImpl {
        Dimension dimension;

        CalculatedMeasureVisitor() {
        }

        @Override
        public Object visit(DimensionExpr dimensionExpr) {
            this.dimension = dimensionExpr.getDimension();
            return null;
        }

        @Override
        public Object visit(HierarchyExpr hierarchyExpr) {
            Hierarchy hierarchy = hierarchyExpr.getHierarchy();
            this.dimension = hierarchy.getDimension();
            return null;
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            this.dimension = member.getHierarchy().getDimension();
            return null;
        }
    }
}

