/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.ListTupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.spi.UserDefinedFunction;

public class UdfResolver
implements Resolver {
    private final UdfFactory factory;
    private final UserDefinedFunction udf;
    private static final String[] emptyStringArray = new String[0];

    public UdfResolver(UdfFactory factory) {
        this.factory = factory;
        this.udf = factory.create();
    }

    @Override
    public String getName() {
        return this.udf.getName();
    }

    @Override
    public String getDescription() {
        return this.udf.getDescription();
    }

    @Override
    public String getSignature() {
        Type[] parameterTypes = this.udf.getParameterTypes();
        int[] parameterCategories = new int[parameterTypes.length];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = TypeUtil.typeToCategory(parameterTypes[i]);
        }
        Type returnType = this.udf.getReturnType(parameterTypes);
        int returnCategory = TypeUtil.typeToCategory(returnType);
        return this.getSyntax().getSignature(this.getName(), returnCategory, parameterCategories);
    }

    @Override
    public Syntax getSyntax() {
        return this.udf.getSyntax();
    }

    @Override
    public FunDef getFunDef() {
        Type[] parameterTypes = this.udf.getParameterTypes();
        int[] parameterCategories = new int[parameterTypes.length];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = TypeUtil.typeToCategory(parameterTypes[i]);
        }
        Type returnType = this.udf.getReturnType(parameterTypes);
        return new UdfFunDef(parameterCategories, returnType);
    }

    @Override
    public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
        Type[] parameterTypes = this.udf.getParameterTypes();
        if (args.length != parameterTypes.length) {
            return null;
        }
        int[] parameterCategories = new int[parameterTypes.length];
        Type[] castArgTypes = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            Exp arg = args[i];
            Type argType = arg.getType();
            int parameterCategory = TypeUtil.typeToCategory(parameterType);
            if (!validator.canConvert(i, arg, parameterCategory, conversions)) {
                return null;
            }
            parameterCategories[i] = parameterCategory;
            if (parameterType.equals(argType)) continue;
            castArgTypes[i] = FunDefBase.castType(argType, parameterCategory);
        }
        Type returnType = this.udf.getReturnType(castArgTypes);
        return new UdfFunDef(parameterCategories, returnType);
    }

    @Override
    public boolean requiresExpression(int k) {
        return false;
    }

    @Override
    public String[] getReservedWords() {
        String[] reservedWords = this.udf.getReservedWords();
        return reservedWords == null ? emptyStringArray : reservedWords;
    }

    public static class ClassUdfFactory
    implements UdfFactory {
        private final Class<? extends UserDefinedFunction> clazz;
        private final String name;

        public ClassUdfFactory(Class<? extends UserDefinedFunction> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
            assert (clazz != null);
        }

        @Override
        public UserDefinedFunction create() {
            return Util.createUdf(this.clazz, this.name);
        }
    }

    public static interface UdfFactory {
        public UserDefinedFunction create();
    }

    private static class CalcExp
    implements UserDefinedFunction.Argument {
        private final Calc calc;
        private final Calc scalarCalc;
        private final IterCalc iterCalc;
        private final ListCalc listCalc;

        public CalcExp(Calc calc, Calc scalarCalc, ListCalc listCalc, IterCalc iterCalc) {
            this.calc = calc;
            this.scalarCalc = scalarCalc;
            this.listCalc = listCalc;
            this.iterCalc = iterCalc;
        }

        @Override
        public Type getType() {
            return this.calc.getType();
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            return this.adapt(this.calc.evaluate(evaluator));
        }

        @Override
        public Object evaluateScalar(Evaluator evaluator) {
            return this.scalarCalc.evaluate(evaluator);
        }

        @Override
        public List evaluateList(Evaluator eval) {
            if (this.listCalc == null) {
                throw new RuntimeException("Expression is not a set");
            }
            return this.adaptList(this.listCalc.evaluateList(eval));
        }

        @Override
        public Iterable evaluateIterable(Evaluator eval) {
            if (this.iterCalc == null) {
                throw new RuntimeException("Expression is not a set");
            }
            return this.adaptIterable(this.iterCalc.evaluateIterable(eval));
        }

        private Object adapt(Object o) {
            if (o instanceof TupleIterable) {
                return this.adaptIterable((TupleIterable)o);
            }
            return o;
        }

        private List adaptList(TupleList tupleList) {
            if (tupleList.getArity() == 1) {
                return new ArrayList<Member>(tupleList.slice(0));
            }
            return new ArrayList<Member[]>(TupleCollections.asMemberArrayList(tupleList));
        }

        private Iterable adaptIterable(TupleIterable tupleIterable) {
            if (tupleIterable instanceof TupleList) {
                return this.adaptList((TupleList)tupleIterable);
            }
            if (tupleIterable.getArity() == 1) {
                return tupleIterable.slice(0);
            }
            return TupleCollections.asMemberArrayIterable(tupleIterable);
        }
    }

    private static class ListCalcImpl
    extends AbstractListCalc {
        private final UserDefinedFunction udf;
        private final UserDefinedFunction.Argument[] args;

        public ListCalcImpl(ResolvedFunCall call, Calc[] calcs, UserDefinedFunction udf, UserDefinedFunction.Argument[] args) {
            super(call, calcs);
            this.udf = udf;
            this.args = args;
        }

        @Override
        public TupleList evaluateList(Evaluator evaluator) {
            List list = (List)this.udf.execute(evaluator, this.args);
            if (this.getType().getArity() == 1) {
                return new UnaryTupleList(list);
            }
            final int arity = this.getType().getArity();
            final List memberArrayList = list;
            return new ListTupleList(arity, (List<Member>)new AbstractList<Member>(){

                @Override
                public Member get(int index) {
                    return ((Member[])memberArrayList.get(index / arity))[index % arity];
                }

                @Override
                public int size() {
                    return memberArrayList.size() * arity;
                }
            });
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return true;
        }
    }

    private static class ScalarCalcImpl
    extends GenericCalc {
        private final Calc[] calcs;
        private final UserDefinedFunction udf;
        private final UserDefinedFunction.Argument[] args;

        public ScalarCalcImpl(ResolvedFunCall call, Calc[] calcs, UserDefinedFunction udf, UserDefinedFunction.Argument[] args) {
            super(call);
            this.calcs = calcs;
            this.udf = udf;
            this.args = args;
        }

        @Override
        public Calc[] getCalcs() {
            return this.calcs;
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            try {
                return this.udf.execute(evaluator, this.args);
            }
            catch (Exception e) {
                return FunUtil.newEvalException("Exception while executing function " + this.udf.getName(), e);
            }
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return true;
        }
    }

    private class UdfFunDef
    extends FunDefBase {
        private Type returnType;

        public UdfFunDef(int[] parameterCategories, Type returnType) {
            super(UdfResolver.this, TypeUtil.typeToCategory(returnType), parameterCategories);
            this.returnType = returnType;
        }

        @Override
        public Type getResultType(Validator validator, Exp[] args) {
            return this.returnType;
        }

        @Override
        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            Exp[] args = call.getArgs();
            Calc[] calcs = new Calc[args.length];
            UserDefinedFunction.Argument[] expCalcs = new UserDefinedFunction.Argument[args.length];
            for (int i = 0; i < args.length; ++i) {
                IterCalc iterCalc;
                ListCalc listCalc;
                Calc calc;
                Exp arg = args[i];
                calcs[i] = calc = (calcs[i] = compiler.compileAs(arg, UdfFunDef.castType(arg.getType(), this.parameterCategories[i]), ResultStyle.ANY_LIST));
                Calc scalarCalc = compiler.compileScalar(arg, true);
                if (arg.getType() instanceof SetType) {
                    listCalc = compiler.compileList(arg, true);
                    iterCalc = compiler.compileIter(arg);
                } else {
                    listCalc = null;
                    iterCalc = null;
                }
                expCalcs[i] = new CalcExp(calc, scalarCalc, listCalc, iterCalc);
            }
            UserDefinedFunction udf2 = UdfResolver.this.factory.create();
            if (call.getType() instanceof SetType) {
                return new ListCalcImpl(call, calcs, udf2, expCalcs);
            }
            return new ScalarCalcImpl(call, calcs, udf2, expCalcs);
        }
    }
}

