/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;

class PeriodsToDateFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("PeriodsToDate", "PeriodsToDate([<Level>[, <Member>]])", "Returns a set of periods (members) from a specified level starting with the first period and ending with a specified member.", new String[]{"fx", "fxl", "fxlm"}, PeriodsToDateFunDef.class);

    public PeriodsToDateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            RolapHierarchy defaultTimeHierarchy = ((RolapCube)validator.getQuery().getCube()).getTimeHierarchy(this.getName());
            return new SetType(MemberType.forHierarchy(defaultTimeHierarchy));
        }
        if (args.length >= 2) {
            Type hierarchyType = args[0].getType();
            MemberType memberType = (MemberType)args[1].getType();
            if (memberType.getHierarchy() != null && hierarchyType.getHierarchy() != null && memberType.getHierarchy() != hierarchyType.getHierarchy()) {
                throw Util.newError("Type mismatch: member must belong to hierarchy " + hierarchyType.getHierarchy().getUniqueName());
            }
        }
        return super.getResultType(validator, args);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final LevelCalc levelCalc = call.getArgCount() > 0 ? compiler.compileLevel(call.getArg(0)) : null;
        final MemberCalc memberCalc = call.getArgCount() > 1 ? compiler.compileMember(call.getArg(1)) : null;
        final RolapHierarchy timeHierarchy = levelCalc == null ? ((RolapCube)compiler.getEvaluator().getCube()).getTimeHierarchy(this.getName()) : null;
        return new AbstractListCalc(call, new Calc[]{levelCalc, memberCalc}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                Level level;
                Member member;
                if (levelCalc == null) {
                    member = evaluator.getContext(timeHierarchy);
                    level = member.getLevel().getParentLevel();
                } else {
                    level = levelCalc.evaluateLevel(evaluator);
                    member = memberCalc == null ? evaluator.getContext(level.getHierarchy()) : memberCalc.evaluateMember(evaluator);
                }
                return new UnaryTupleList(FunUtil.periodsToDate(evaluator, level, member));
            }

            @Override
            public boolean dependsOn(Hierarchy hierarchy) {
                if (super.dependsOn(hierarchy)) {
                    return true;
                }
                if (memberCalc != null) {
                    return false;
                }
                if (levelCalc != null) {
                    return levelCalc.getType().usesHierarchy(hierarchy, true);
                }
                return hierarchy == timeHierarchy;
            }
        };
    }
}

