/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.ArrayTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;

class ExceptFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Except", "Except(<Set1>, <Set2>[, ALL])", "Finds the difference between two sets, optionally retaining duplicates.", new String[]{"fxxx", "fxxxy"}, ExceptFunDef.class);

    public ExceptFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc0 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc1 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc0, listCalc1}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                TupleList list0 = listCalc0.evaluateList(evaluator);
                if (list0.isEmpty()) {
                    return list0;
                }
                TupleList list1 = listCalc1.evaluateList(evaluator);
                if (list1.isEmpty()) {
                    return list0;
                }
                HashSet<List<Member>> set1 = new HashSet<List<Member>>(list1);
                ArrayTupleList result = new ArrayTupleList(list0.getArity(), list0.size());
                for (List tuple1 : list0) {
                    if (set1.contains(tuple1)) continue;
                    result.add(tuple1);
                }
                return result;
            }
        };
    }
}

