/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.Type;

class AncestorsFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Ancestors", "Ancestors(<Member>, {<Level>|<Numeric Expression>})", "Returns the set of all ancestors of a specified member at a specified level or at a specified distance from the member", new String[]{"fxml", "fxmn"}, AncestorsFunDef.class);

    public AncestorsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public int getReturnCategory() {
        return 8;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        Type type1 = call.getArg(1).getType();
        if (type1 instanceof LevelType) {
            final LevelCalc levelCalc = compiler.compileLevel(call.getArg(1));
            return new AbstractListCalc(call, new Calc[]{memberCalc, levelCalc}){

                @Override
                public TupleList evaluateList(Evaluator evaluator) {
                    Level level = levelCalc.evaluateLevel(evaluator);
                    Member member = memberCalc.evaluateMember(evaluator);
                    int distance = member.getDepth() - level.getDepth();
                    ArrayList<Member> ancestors = new ArrayList<Member>();
                    for (int curDist = 1; curDist <= distance; ++curDist) {
                        ancestors.add(FunUtil.ancestor(evaluator, member, curDist, null));
                    }
                    return TupleCollections.asTupleList(ancestors);
                }
            };
        }
        final IntegerCalc distanceCalc = compiler.compileInteger(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{memberCalc, distanceCalc}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                Member member = memberCalc.evaluateMember(evaluator);
                int distance = distanceCalc.evaluateInteger(evaluator);
                ArrayList<Member> ancestors = new ArrayList<Member>();
                for (int curDist = 1; curDist <= distance; ++curDist) {
                    ancestors.add(FunUtil.ancestor(evaluator, member, curDist, null));
                }
                return TupleCollections.asTupleList(ancestors);
            }
        };
    }
}

